// python wrapper for ttkPersistenceDiagram
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkPersistenceDiagram.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkPersistenceDiagram(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkPersistenceDiagram_ClassNew(); }


static PyObject *
PyttkPersistenceDiagram_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkPersistenceDiagram::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPersistenceDiagram_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPersistenceDiagram *op = static_cast<ttkPersistenceDiagram *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkPersistenceDiagram::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPersistenceDiagram_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkPersistenceDiagram *tempr = ttkPersistenceDiagram::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPersistenceDiagram_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPersistenceDiagram *op = static_cast<ttkPersistenceDiagram *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkPersistenceDiagram *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkPersistenceDiagram::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPersistenceDiagram_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkPersistenceDiagram::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPersistenceDiagram_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPersistenceDiagram *op = static_cast<ttkPersistenceDiagram *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkPersistenceDiagram::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPersistenceDiagram_SetForceInputOffsetScalarField(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetForceInputOffsetScalarField");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPersistenceDiagram *op = static_cast<ttkPersistenceDiagram *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetForceInputOffsetScalarField(temp0);
    }
    else
    {
      op->ttkPersistenceDiagram::SetForceInputOffsetScalarField(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkPersistenceDiagram_GetForceInputOffsetScalarField(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetForceInputOffsetScalarField");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPersistenceDiagram *op = static_cast<ttkPersistenceDiagram *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetForceInputOffsetScalarField() :
      op->ttkPersistenceDiagram::GetForceInputOffsetScalarField());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPersistenceDiagram_SetShowInsideDomain(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetShowInsideDomain");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPersistenceDiagram *op = static_cast<ttkPersistenceDiagram *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetShowInsideDomain(temp0);
    }
    else
    {
      op->ttkPersistenceDiagram::SetShowInsideDomain(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkPersistenceDiagram_GetShowInsideDomain(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetShowInsideDomain");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPersistenceDiagram *op = static_cast<ttkPersistenceDiagram *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetShowInsideDomain() :
      op->ttkPersistenceDiagram::GetShowInsideDomain());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPersistenceDiagram_SetBackEnd(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBackEnd");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPersistenceDiagram *op = static_cast<ttkPersistenceDiagram *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBackEnd(temp0);
    }
    else
    {
      op->ttkPersistenceDiagram::SetBackEnd(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkPersistenceDiagram_GetStartingResolutionLevel(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetStartingResolutionLevel");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPersistenceDiagram *op = static_cast<ttkPersistenceDiagram *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetStartingResolutionLevel() :
      op->ttkPersistenceDiagram::GetStartingResolutionLevel());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPersistenceDiagram_SetStartingResolutionLevel(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetStartingResolutionLevel");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPersistenceDiagram *op = static_cast<ttkPersistenceDiagram *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetStartingResolutionLevel(temp0);
    }
    else
    {
      op->ttkPersistenceDiagram::SetStartingResolutionLevel(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkPersistenceDiagram_GetStoppingResolutionLevel(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetStoppingResolutionLevel");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPersistenceDiagram *op = static_cast<ttkPersistenceDiagram *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetStoppingResolutionLevel() :
      op->ttkPersistenceDiagram::GetStoppingResolutionLevel());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPersistenceDiagram_SetStoppingResolutionLevel(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetStoppingResolutionLevel");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPersistenceDiagram *op = static_cast<ttkPersistenceDiagram *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetStoppingResolutionLevel(temp0);
    }
    else
    {
      op->ttkPersistenceDiagram::SetStoppingResolutionLevel(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkPersistenceDiagram_GetIsResumable(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetIsResumable");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPersistenceDiagram *op = static_cast<ttkPersistenceDiagram *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetIsResumable() :
      op->ttkPersistenceDiagram::GetIsResumable());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPersistenceDiagram_SetIsResumable(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetIsResumable");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPersistenceDiagram *op = static_cast<ttkPersistenceDiagram *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetIsResumable(temp0);
    }
    else
    {
      op->ttkPersistenceDiagram::SetIsResumable(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkPersistenceDiagram_GetTimeLimit(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTimeLimit");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPersistenceDiagram *op = static_cast<ttkPersistenceDiagram *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetTimeLimit() :
      op->ttkPersistenceDiagram::GetTimeLimit());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPersistenceDiagram_SetTimeLimit(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTimeLimit");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPersistenceDiagram *op = static_cast<ttkPersistenceDiagram *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTimeLimit(temp0);
    }
    else
    {
      op->ttkPersistenceDiagram::SetTimeLimit(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkPersistenceDiagram_GetEpsilon(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEpsilon");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPersistenceDiagram *op = static_cast<ttkPersistenceDiagram *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetEpsilon() :
      op->ttkPersistenceDiagram::GetEpsilon());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPersistenceDiagram_SetEpsilon(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEpsilon");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPersistenceDiagram *op = static_cast<ttkPersistenceDiagram *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEpsilon(temp0);
    }
    else
    {
      op->ttkPersistenceDiagram::SetEpsilon(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkPersistenceDiagram_SetIgnoreBoundary(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetIgnoreBoundary");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPersistenceDiagram *op = static_cast<ttkPersistenceDiagram *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetIgnoreBoundary(temp0);
    }
    else
    {
      op->ttkPersistenceDiagram::SetIgnoreBoundary(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkPersistenceDiagram_GetIgnoreBoundary(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetIgnoreBoundary");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPersistenceDiagram *op = static_cast<ttkPersistenceDiagram *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetIgnoreBoundary() :
      op->ttkPersistenceDiagram::GetIgnoreBoundary());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkPersistenceDiagram_SetComputeMinSad(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetComputeMinSad");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPersistenceDiagram *op = static_cast<ttkPersistenceDiagram *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetComputeMinSad(temp0);
    }
    else
    {
      op->ttkPersistenceDiagram::SetComputeMinSad(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkPersistenceDiagram_SetComputeSadSad(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetComputeSadSad");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPersistenceDiagram *op = static_cast<ttkPersistenceDiagram *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetComputeSadSad(temp0);
    }
    else
    {
      op->ttkPersistenceDiagram::SetComputeSadSad(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkPersistenceDiagram_SetComputeSadMax(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetComputeSadMax");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPersistenceDiagram *op = static_cast<ttkPersistenceDiagram *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetComputeSadMax(temp0);
    }
    else
    {
      op->ttkPersistenceDiagram::SetComputeSadMax(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkPersistenceDiagram_SetDMSDimensions(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDMSDimensions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPersistenceDiagram *op = static_cast<ttkPersistenceDiagram *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDMSDimensions(temp0);
    }
    else
    {
      op->ttkPersistenceDiagram::SetDMSDimensions(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkPersistenceDiagram_SetClearDGCache(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetClearDGCache");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPersistenceDiagram *op = static_cast<ttkPersistenceDiagram *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetClearDGCache(temp0);
    }
    else
    {
      op->ttkPersistenceDiagram::SetClearDGCache(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkPersistenceDiagram_GetClearDGCache(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetClearDGCache");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkPersistenceDiagram *op = static_cast<ttkPersistenceDiagram *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetClearDGCache() :
      op->ttkPersistenceDiagram::GetClearDGCache());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyttkPersistenceDiagram_Methods[] = {
  {"IsTypeOf", PyttkPersistenceDiagram_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkPersistenceDiagram_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkPersistenceDiagram_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> ttkPersistenceDiagram\nC++: static ttkPersistenceDiagram *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkPersistenceDiagram_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkPersistenceDiagram\nC++: ttkPersistenceDiagram *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkPersistenceDiagram_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkPersistenceDiagram_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetForceInputOffsetScalarField", PyttkPersistenceDiagram_SetForceInputOffsetScalarField, METH_VARARGS,
   "SetForceInputOffsetScalarField(self, _arg:bool) -> None\nC++: virtual void SetForceInputOffsetScalarField(bool _arg)\n\n"},
  {"GetForceInputOffsetScalarField", PyttkPersistenceDiagram_GetForceInputOffsetScalarField, METH_VARARGS,
   "GetForceInputOffsetScalarField(self) -> bool\nC++: virtual bool GetForceInputOffsetScalarField()\n\n"},
  {"SetShowInsideDomain", PyttkPersistenceDiagram_SetShowInsideDomain, METH_VARARGS,
   "SetShowInsideDomain(self, _arg:bool) -> None\nC++: virtual void SetShowInsideDomain(bool _arg)\n\n"},
  {"GetShowInsideDomain", PyttkPersistenceDiagram_GetShowInsideDomain, METH_VARARGS,
   "GetShowInsideDomain(self) -> bool\nC++: virtual bool GetShowInsideDomain()\n\n"},
  {"SetBackEnd", PyttkPersistenceDiagram_SetBackEnd, METH_VARARGS,
   "SetBackEnd(self, _arg:int) -> None\nC++: virtual void SetBackEnd(int _arg)\n\n"},
  {"GetStartingResolutionLevel", PyttkPersistenceDiagram_GetStartingResolutionLevel, METH_VARARGS,
   "GetStartingResolutionLevel(self) -> int\nC++: virtual int GetStartingResolutionLevel()\n\n"},
  {"SetStartingResolutionLevel", PyttkPersistenceDiagram_SetStartingResolutionLevel, METH_VARARGS,
   "SetStartingResolutionLevel(self, _arg:int) -> None\nC++: virtual void SetStartingResolutionLevel(int _arg)\n\n"},
  {"GetStoppingResolutionLevel", PyttkPersistenceDiagram_GetStoppingResolutionLevel, METH_VARARGS,
   "GetStoppingResolutionLevel(self) -> int\nC++: virtual int GetStoppingResolutionLevel()\n\n"},
  {"SetStoppingResolutionLevel", PyttkPersistenceDiagram_SetStoppingResolutionLevel, METH_VARARGS,
   "SetStoppingResolutionLevel(self, _arg:int) -> None\nC++: virtual void SetStoppingResolutionLevel(int _arg)\n\n"},
  {"GetIsResumable", PyttkPersistenceDiagram_GetIsResumable, METH_VARARGS,
   "GetIsResumable(self) -> bool\nC++: virtual bool GetIsResumable()\n\n"},
  {"SetIsResumable", PyttkPersistenceDiagram_SetIsResumable, METH_VARARGS,
   "SetIsResumable(self, _arg:bool) -> None\nC++: virtual void SetIsResumable(bool _arg)\n\n"},
  {"GetTimeLimit", PyttkPersistenceDiagram_GetTimeLimit, METH_VARARGS,
   "GetTimeLimit(self) -> float\nC++: virtual double GetTimeLimit()\n\n"},
  {"SetTimeLimit", PyttkPersistenceDiagram_SetTimeLimit, METH_VARARGS,
   "SetTimeLimit(self, _arg:float) -> None\nC++: virtual void SetTimeLimit(double _arg)\n\n"},
  {"GetEpsilon", PyttkPersistenceDiagram_GetEpsilon, METH_VARARGS,
   "GetEpsilon(self) -> float\nC++: virtual double GetEpsilon()\n\n"},
  {"SetEpsilon", PyttkPersistenceDiagram_SetEpsilon, METH_VARARGS,
   "SetEpsilon(self, _arg:float) -> None\nC++: virtual void SetEpsilon(double _arg)\n\n"},
  {"SetIgnoreBoundary", PyttkPersistenceDiagram_SetIgnoreBoundary, METH_VARARGS,
   "SetIgnoreBoundary(self, _arg:bool) -> None\nC++: virtual void SetIgnoreBoundary(bool _arg)\n\n"},
  {"GetIgnoreBoundary", PyttkPersistenceDiagram_GetIgnoreBoundary, METH_VARARGS,
   "GetIgnoreBoundary(self) -> bool\nC++: virtual bool GetIgnoreBoundary()\n\n"},
  {"SetComputeMinSad", PyttkPersistenceDiagram_SetComputeMinSad, METH_VARARGS,
   "SetComputeMinSad(self, data:bool) -> None\nC++: void SetComputeMinSad(const bool data)\n\n"},
  {"SetComputeSadSad", PyttkPersistenceDiagram_SetComputeSadSad, METH_VARARGS,
   "SetComputeSadSad(self, data:bool) -> None\nC++: void SetComputeSadSad(const bool data)\n\n"},
  {"SetComputeSadMax", PyttkPersistenceDiagram_SetComputeSadMax, METH_VARARGS,
   "SetComputeSadMax(self, data:bool) -> None\nC++: void SetComputeSadMax(const bool data)\n\n"},
  {"SetDMSDimensions", PyttkPersistenceDiagram_SetDMSDimensions, METH_VARARGS,
   "SetDMSDimensions(self, data:int) -> None\nC++: void SetDMSDimensions(const int data)\n\n"},
  {"SetClearDGCache", PyttkPersistenceDiagram_SetClearDGCache, METH_VARARGS,
   "SetClearDGCache(self, _arg:bool) -> None\nC++: virtual void SetClearDGCache(bool _arg)\n\n"},
  {"GetClearDGCache", PyttkPersistenceDiagram_GetClearDGCache, METH_VARARGS,
   "GetClearDGCache(self) -> bool\nC++: virtual bool GetClearDGCache()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkPersistenceDiagram_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("force_input_offset_scalar_field"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkPersistenceDiagram_GetForceInputOffsetScalarField(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkPersistenceDiagram_SetForceInputOffsetScalarField(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkPersistenceDiagram_SetForceInputOffsetScalarField(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetForceInputOffsetScalarField/SetForceInputOffsetScalarField\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("show_inside_domain"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkPersistenceDiagram_GetShowInsideDomain(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkPersistenceDiagram_SetShowInsideDomain(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkPersistenceDiagram_SetShowInsideDomain(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetShowInsideDomain/SetShowInsideDomain\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("back_end"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkPersistenceDiagram_SetBackEnd(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkPersistenceDiagram_SetBackEnd(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBackEnd\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("starting_resolution_level"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkPersistenceDiagram_GetStartingResolutionLevel(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkPersistenceDiagram_SetStartingResolutionLevel(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkPersistenceDiagram_SetStartingResolutionLevel(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetStartingResolutionLevel/SetStartingResolutionLevel\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("stopping_resolution_level"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkPersistenceDiagram_GetStoppingResolutionLevel(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkPersistenceDiagram_SetStoppingResolutionLevel(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkPersistenceDiagram_SetStoppingResolutionLevel(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetStoppingResolutionLevel/SetStoppingResolutionLevel\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("is_resumable"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkPersistenceDiagram_GetIsResumable(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkPersistenceDiagram_SetIsResumable(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkPersistenceDiagram_SetIsResumable(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetIsResumable/SetIsResumable\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("time_limit"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkPersistenceDiagram_GetTimeLimit(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkPersistenceDiagram_SetTimeLimit(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkPersistenceDiagram_SetTimeLimit(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTimeLimit/SetTimeLimit\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("epsilon"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkPersistenceDiagram_GetEpsilon(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkPersistenceDiagram_SetEpsilon(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkPersistenceDiagram_SetEpsilon(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetEpsilon/SetEpsilon\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("ignore_boundary"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkPersistenceDiagram_GetIgnoreBoundary(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkPersistenceDiagram_SetIgnoreBoundary(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkPersistenceDiagram_SetIgnoreBoundary(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetIgnoreBoundary/SetIgnoreBoundary\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("compute_min_sad"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkPersistenceDiagram_SetComputeMinSad(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkPersistenceDiagram_SetComputeMinSad(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetComputeMinSad\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("compute_sad_sad"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkPersistenceDiagram_SetComputeSadSad(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkPersistenceDiagram_SetComputeSadSad(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetComputeSadSad\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("compute_sad_max"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkPersistenceDiagram_SetComputeSadMax(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkPersistenceDiagram_SetComputeSadMax(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetComputeSadMax\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("dms_dimensions"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkPersistenceDiagram_SetDMSDimensions(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkPersistenceDiagram_SetDMSDimensions(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetDMSDimensions\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("clear_dg_cache"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkPersistenceDiagram_GetClearDGCache(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkPersistenceDiagram_SetClearDGCache(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkPersistenceDiagram_SetClearDGCache(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetClearDGCache/SetClearDGCache\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkPersistenceDiagram_Doc =
  "ttkPersistenceDiagram - \\ingroup vtk\n\n"
  "Superclass: ttkAlgorithm\n\n"
  "\\author Guillaume Favelier <guillaume.favelier@lip6.fr>\\author Julien\n"
  "Tierny <julien.tierny@lip6.fr>\\date September 2016.\n\n"
  "TTK VTK-filter for the computation of persistence diagrams.\n\n"
  "This filter computes the persistence diagram of the extremum-saddle\n"
  "pairs of an input scalar field. The X-coordinate of each pair\n"
  "corresponds to its birth, while its smallest and highest\n"
  "Y-coordinates correspond to its birth and death respectively.\n\n"
  "In practice, the diagram is represented by a vtkUnstructuredGrid.\n"
  "Each vertex of this mesh represent a critical point of the input\n"
  "data. It is associated with point data (vertexId, critical type).\n"
  "Each vertical edge of this mesh represent a persistence pair. It is\n"
  "associated with cell data (persistence of the pair, critical index of\n"
  "the extremum of the pair).\n\n"
  "Persistence diagrams are useful and stable concise representations of\n"
  "the topological features of a data-set. It is useful to fine-tune\n"
  "persistence thresholds for topological simplification or for fast\n"
  "similarity estimations for instance.\n\n"
  "\\param Input Input scalar field, either 2D or 3D, regular grid or\n"
  "triangulation (vtkDataSet)\n"
  "\\param Output Output persistence diagram (vtkUnstructuredGrid)\n\n"
  "This filter can be used as any other VTK filter (for instance, by\n"
  "using the sequence of calls SetInputData(), Update(), GetOutput()).\n\n"
  "See the related ParaView example state files for usage examples\n"
  "within a VTK pipeline.\n\n"
  "Related publication\n\n"
  "\"Computational Topology: An Introduction\"\n\n"
  "Herbert Edelsbrunner and John Harer\n\n"
  "American Mathematical Society, 2010\n\n"
  "Five backends are available for the computation:\n\n"
  "1) FTM\n\n"
  "Related publication\n\n"
  "\"Task-based Augmented Contour Trees with Fibonacci Heaps\" Charles\n"
  "Gueunet, Pierre Fortin, Julien Jomier, Julien Tierny IEEE\n"
  "Transactions on Parallel and Distributed Systems, 2019\n\n"
  "2) Progressive Approach\n\n"
  "Related publication\n\n"
  "\"A Progressive Approach to Scalar Field Topology\"\n\n"
  "Jules Vidal, Pierre Guillou, Julien Tierny\n\n"
  "IEEE Transactions on Visualization and Computer Graphics, 2021\n\n"
  "3) Discrete Morse Sandwich (default)\n\n"
  "Related publication\n\n"
  "\"Discrete Morse Sandwich: Fast Computation of Persistence Diagrams\n"
  "for Scalar Data -- An Algorithm and A Benchmark\"\n\n"
  "Pierre Guillou, Jules Vidal, Julien Tierny\n\n"
  "IEEE Transactions on Visualization and Computer Graphics, 2023.\n\n"
  "arXiv:2206.13932, 2023.\n\n"
  "Fast and versatile algorithm for persistence diagram computation.\n\n"
  "4) Approximate Approach\n\n"
  "Related publication\n\n"
  "\"Fast Approximation of Persistence Diagrams with Guarantees\"\n\n"
  "Jules Vidal, Julien Tierny\n\n"
  "IEEE Symposium on Large Data Visualization and Analysis (LDAV), 2021\n\n"
  "5) Persistent Simplex\n\n"
  "This is a textbook (and very slow) algorithm, described in \"Algorithm\n"
  "and Theory of Computation Handbook (Second Edition)\n"
  "- Special Topics and Techniques\" by Atallah and Blanton on page 97.\n\n"
  "\\sa ttkMergeTreePP\n"
  "\\sa ttkPersistenceCurve\n"
  "\\sa ttkScalarFieldCriticalPoints\n"
  "\\sa ttkTopologicalSimplification\n"
  "\\sa ttk::PersistenceDiagram\n\n"
  "Online examples:\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/1manifoldLearning/\"\n"
  "  >1-Manifold Learning example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/1manifoldLearningCircles/\"\n"
  "  >1-Manifold Learning Circles example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/2manifoldLearning/\"\n"
  "  > 2-Manifold Learning example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/BuiltInExample1/\"\n"
  "  >BuiltInExample1 \\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/clusteringKelvinHelmholtzInstabilities/\"\n"
  "  > Clustering Kelvin Helmholtz Instabilities example\\n\n"
  "- <a href=\"https://topology-tool-kit.github.io/examples/ctBones/\">CT\n"
  "  Bones example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/dragon/\">Dragon\n"
  "  example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/harmonicSkeleton/\"\n"
  "  > Harmonic Skeleton example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/imageProcessing/\"\n"
  "  >Image Processing example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/interactionSites/\"\n"
  "  > Interaction sites\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/karhunenLoveDigits64Dimensions/\"\n"
  "  >Karhunen-Love Digits 64-Dimensions example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/morsePersistence/\"\n"
  "  >Morse Persistence example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/morseSmaleQuadrangulation/\"\n"
  "  >Morse-Smale Quadrangulation example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/persistenceClustering0/\"\n"
  "  >Persistence clustering 0 example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/persistenceClustering0/\"\n"
  "  >Persistence clustering 1 example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/persistenceClustering0/\"\n"
  "  >Persistence clustering 2 example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/persistenceClustering0/\"\n"
  "  >Persistence clustering 3 example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/persistenceClustering0/\"\n"
  "  >Persistence clustering 4 example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/persistenceDiagramClustering/\"\n"
  "  >Persistence Diagram Clustering example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/persistenceDiagramDistance/\"\n"
  "  >Persistence Diagram Distance example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/persistenceDiagramPGA/\"\n"
  "  >Persistence Diagram Principal Geodesic Analysis example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/tectonicPuzzle/\">\n"
  "  Tectonic Puzzle example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/topologicalOptimization_darkSky/\"\n"
  "  >Topological Optimization DarkSky example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/topologicalOptimization_pegasus/\"\n"
  "  >Topological Optimization for Pegasus Genus Repair example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/topologicalOptimization_torus/\"\n"
  "  >Topological Optimization for Torus Repair example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/tribute/\">Tribute\n"
  "   example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/uncertainStartingVortex/\"\n"
  "  > Uncertain Starting Vortex example\\n\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkPersistenceDiagram_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkPersistenceDiagram.ttkPersistenceDiagram", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkPersistenceDiagram_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkPersistenceDiagram_StaticNew()
{
  return ttkPersistenceDiagram::New();
}

PyObject *PyttkPersistenceDiagram_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkPersistenceDiagram_Type, PyttkPersistenceDiagram_Methods,
    "ttkPersistenceDiagram",
 &PyttkPersistenceDiagram_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("ttkAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkPersistenceDiagram_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkPersistenceDiagram(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkPersistenceDiagram_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkPersistenceDiagram", o) != 0)
  {
    Py_DECREF(o);
  }

}

