// python wrapper for vtkOCCTReader
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkOCCTReader.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkOCCTReader(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkOCCTReader_ClassNew(); }

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkOCCTReader_Format_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkIOOCCT.vtkOCCTReader.Format", // tp_name
  sizeof(PyLongObject), // tp_basicsize
  0, // tp_itemsize
  nullptr, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  nullptr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  nullptr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT
#if PY_VERSION_HEX >= 0x030A0000
    | Py_TPFLAGS_DISALLOW_INSTANTIATION
#endif
  , // tp_flags
  nullptr, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  &PyLong_Type, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  nullptr, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

template<class T>
static PyObject *PyvtkOCCTReader_Format_FromEnum(T val)
{
  return PyVTKEnum_New(&PyvtkOCCTReader_Format_Type, static_cast<int>(val));
}


static PyObject *
PyvtkOCCTReader_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkOCCTReader::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOCCTReader_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOCCTReader *op = static_cast<vtkOCCTReader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkOCCTReader::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOCCTReader_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkOCCTReader *tempr = vtkOCCTReader::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOCCTReader_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOCCTReader *op = static_cast<vtkOCCTReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkOCCTReader *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkOCCTReader::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOCCTReader_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkOCCTReader::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOCCTReader_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOCCTReader *op = static_cast<vtkOCCTReader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkOCCTReader::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOCCTReader_SetFileFormat(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFileFormat");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOCCTReader *op = static_cast<vtkOCCTReader *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFileFormat(temp0);
    }
    else
    {
      op->vtkOCCTReader::SetFileFormat(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOCCTReader_GetFileFormatMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFileFormatMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOCCTReader *op = static_cast<vtkOCCTReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned int tempr = (ap.IsBound() ?
      op->GetFileFormatMinValue() :
      op->vtkOCCTReader::GetFileFormatMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOCCTReader_GetFileFormatMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFileFormatMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOCCTReader *op = static_cast<vtkOCCTReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned int tempr = (ap.IsBound() ?
      op->GetFileFormatMaxValue() :
      op->vtkOCCTReader::GetFileFormatMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOCCTReader_GetLinearDeflection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLinearDeflection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOCCTReader *op = static_cast<vtkOCCTReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetLinearDeflection() :
      op->vtkOCCTReader::GetLinearDeflection());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOCCTReader_SetLinearDeflection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLinearDeflection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOCCTReader *op = static_cast<vtkOCCTReader *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLinearDeflection(temp0);
    }
    else
    {
      op->vtkOCCTReader::SetLinearDeflection(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOCCTReader_GetAngularDeflection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAngularDeflection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOCCTReader *op = static_cast<vtkOCCTReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetAngularDeflection() :
      op->vtkOCCTReader::GetAngularDeflection());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOCCTReader_SetAngularDeflection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAngularDeflection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOCCTReader *op = static_cast<vtkOCCTReader *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAngularDeflection(temp0);
    }
    else
    {
      op->vtkOCCTReader::SetAngularDeflection(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOCCTReader_GetRelativeDeflection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRelativeDeflection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOCCTReader *op = static_cast<vtkOCCTReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetRelativeDeflection() :
      op->vtkOCCTReader::GetRelativeDeflection());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOCCTReader_SetRelativeDeflection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRelativeDeflection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOCCTReader *op = static_cast<vtkOCCTReader *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRelativeDeflection(temp0);
    }
    else
    {
      op->vtkOCCTReader::SetRelativeDeflection(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOCCTReader_RelativeDeflectionOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RelativeDeflectionOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOCCTReader *op = static_cast<vtkOCCTReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->RelativeDeflectionOn();
    }
    else
    {
      op->vtkOCCTReader::RelativeDeflectionOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOCCTReader_RelativeDeflectionOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RelativeDeflectionOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOCCTReader *op = static_cast<vtkOCCTReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->RelativeDeflectionOff();
    }
    else
    {
      op->vtkOCCTReader::RelativeDeflectionOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOCCTReader_GetReadWire(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetReadWire");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOCCTReader *op = static_cast<vtkOCCTReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetReadWire() :
      op->vtkOCCTReader::GetReadWire());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkOCCTReader_SetReadWire(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetReadWire");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOCCTReader *op = static_cast<vtkOCCTReader *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetReadWire(temp0);
    }
    else
    {
      op->vtkOCCTReader::SetReadWire(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOCCTReader_ReadWireOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ReadWireOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOCCTReader *op = static_cast<vtkOCCTReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ReadWireOn();
    }
    else
    {
      op->vtkOCCTReader::ReadWireOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOCCTReader_ReadWireOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ReadWireOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOCCTReader *op = static_cast<vtkOCCTReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ReadWireOff();
    }
    else
    {
      op->vtkOCCTReader::ReadWireOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOCCTReader_SetFileName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFileName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOCCTReader *op = static_cast<vtkOCCTReader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetFilePath(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFileName(temp0);
    }
    else
    {
      op->vtkOCCTReader::SetFileName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkOCCTReader_GetFileName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFileName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkOCCTReader *op = static_cast<vtkOCCTReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetFileName() :
      op->vtkOCCTReader::GetFileName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkOCCTReader_Methods[] = {
  {"IsTypeOf", PyvtkOCCTReader_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkOCCTReader_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkOCCTReader_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkOCCTReader\nC++: static vtkOCCTReader *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkOCCTReader_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkOCCTReader\nC++: vtkOCCTReader *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkOCCTReader_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkOCCTReader_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetFileFormat", PyvtkOCCTReader_SetFileFormat, METH_VARARGS,
   "SetFileFormat(self, _arg:int) -> None\nC++: virtual void SetFileFormat(unsigned int _arg)\n\nSet the file format to read. It can be either STEP or IGES.\nDefault is FILE_FORMAT::STEP\n"},
  {"GetFileFormatMinValue", PyvtkOCCTReader_GetFileFormatMinValue, METH_VARARGS,
   "GetFileFormatMinValue(self) -> int\nC++: virtual unsigned int GetFileFormatMinValue()\n\n"},
  {"GetFileFormatMaxValue", PyvtkOCCTReader_GetFileFormatMaxValue, METH_VARARGS,
   "GetFileFormatMaxValue(self) -> int\nC++: virtual unsigned int GetFileFormatMaxValue()\n\n"},
  {"GetLinearDeflection", PyvtkOCCTReader_GetLinearDeflection, METH_VARARGS,
   "GetLinearDeflection(self) -> float\nC++: virtual double GetLinearDeflection()\n\nSet/Get the linear deflection. This value limits the distance\nbetween a curve and the resulting tessellation. Default is 0.1\n"},
  {"SetLinearDeflection", PyvtkOCCTReader_SetLinearDeflection, METH_VARARGS,
   "SetLinearDeflection(self, _arg:float) -> None\nC++: virtual void SetLinearDeflection(double _arg)\n\n"},
  {"GetAngularDeflection", PyvtkOCCTReader_GetAngularDeflection, METH_VARARGS,
   "GetAngularDeflection(self) -> float\nC++: virtual double GetAngularDeflection()\n\nSet/Get the angular deflection. This value limits the angle\nbetween two subsequent segments. Default is 0.5\n"},
  {"SetAngularDeflection", PyvtkOCCTReader_SetAngularDeflection, METH_VARARGS,
   "SetAngularDeflection(self, _arg:float) -> None\nC++: virtual void SetAngularDeflection(double _arg)\n\n"},
  {"GetRelativeDeflection", PyvtkOCCTReader_GetRelativeDeflection, METH_VARARGS,
   "GetRelativeDeflection(self) -> bool\nC++: virtual bool GetRelativeDeflection()\n\nSet/Get relative deflection. Determine if the deflection values\nare relative to object size. Default is false\n"},
  {"SetRelativeDeflection", PyvtkOCCTReader_SetRelativeDeflection, METH_VARARGS,
   "SetRelativeDeflection(self, _arg:bool) -> None\nC++: virtual void SetRelativeDeflection(bool _arg)\n\n"},
  {"RelativeDeflectionOn", PyvtkOCCTReader_RelativeDeflectionOn, METH_VARARGS,
   "RelativeDeflectionOn(self) -> None\nC++: virtual void RelativeDeflectionOn()\n\n"},
  {"RelativeDeflectionOff", PyvtkOCCTReader_RelativeDeflectionOff, METH_VARARGS,
   "RelativeDeflectionOff(self) -> None\nC++: virtual void RelativeDeflectionOff()\n\n"},
  {"GetReadWire", PyvtkOCCTReader_GetReadWire, METH_VARARGS,
   "GetReadWire(self) -> bool\nC++: virtual bool GetReadWire()\n\nEnable/Disable 1D cells read. If enabled, surface boundaries are\nread. Default is false\n"},
  {"SetReadWire", PyvtkOCCTReader_SetReadWire, METH_VARARGS,
   "SetReadWire(self, _arg:bool) -> None\nC++: virtual void SetReadWire(bool _arg)\n\n"},
  {"ReadWireOn", PyvtkOCCTReader_ReadWireOn, METH_VARARGS,
   "ReadWireOn(self) -> None\nC++: virtual void ReadWireOn()\n\n"},
  {"ReadWireOff", PyvtkOCCTReader_ReadWireOff, METH_VARARGS,
   "ReadWireOff(self) -> None\nC++: virtual void ReadWireOff()\n\n"},
  {"SetFileName", PyvtkOCCTReader_SetFileName, METH_VARARGS,
   "SetFileName(self, _arg:str) -> None\nC++: virtual void SetFileName(const char *_arg)\n\nGet/Set the file name.\n"},
  {"GetFileName", PyvtkOCCTReader_GetFileName, METH_VARARGS,
   "GetFileName(self) -> str\nC++: virtual char *GetFileName()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkOCCTReader_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("file_format"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkOCCTReader_SetFileFormat(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkOCCTReader_SetFileFormat(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetFileFormat\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("linear_deflection"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkOCCTReader_GetLinearDeflection(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkOCCTReader_SetLinearDeflection(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkOCCTReader_SetLinearDeflection(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetLinearDeflection/SetLinearDeflection\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("angular_deflection"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkOCCTReader_GetAngularDeflection(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkOCCTReader_SetAngularDeflection(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkOCCTReader_SetAngularDeflection(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetAngularDeflection/SetAngularDeflection\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("relative_deflection"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkOCCTReader_GetRelativeDeflection(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkOCCTReader_SetRelativeDeflection(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkOCCTReader_SetRelativeDeflection(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetRelativeDeflection/SetRelativeDeflection\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("read_wire"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkOCCTReader_GetReadWire(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkOCCTReader_SetReadWire(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkOCCTReader_SetReadWire(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetReadWire/SetReadWire\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("file_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkOCCTReader_GetFileName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkOCCTReader_SetFileName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkOCCTReader_SetFileName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFileName/SetFileName\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkOCCTReader_Doc =
  "vtkOCCTReader - VTK Reader for STEP and IGES files using OpenCASCADE\n\n"
  "Superclass: vtkMultiBlockDataSetAlgorithm\n\n"
  "This reader is based on OpenCASCADE and use XCAF toolkits (TKXDESTEP\n"
  "and TKXDEIGES) if available to read the names and the colors. If not\n"
  "available, TKSTEP and TKIGES are used but no names or colors are\n"
  "read. The quality of the generated mesh is configured using\n"
  "RelativeDeflection, LinearDeflection, and LinearDeflection. Reading\n"
  "1D cells (wires) is optional.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkOCCTReader_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkIOOCCT.vtkOCCTReader", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkOCCTReader_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkOCCTReader_StaticNew()
{
  return vtkOCCTReader::New();
}

PyObject *PyvtkOCCTReader_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkOCCTReader_Type, PyvtkOCCTReader_Methods,
    "vtkOCCTReader",
 &PyvtkOCCTReader_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkMultiBlockDataSetAlgorithm");

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  PyType_Ready(&PyvtkOCCTReader_Format_Type);
  PyVTKEnum_Add(&PyvtkOCCTReader_Format_Type, "vtkOCCTReader.Format");

  o = (PyObject *)&PyvtkOCCTReader_Format_Type;
  if (PyDict_SetItemString(d, "Format", o) != 0)
  {
    Py_DECREF(o);
  }

  for (int c = 0; c < 2; c++)
  {
    typedef vtkOCCTReader::Format cxx_enum_type;

    static const struct { const char *name; cxx_enum_type value; }
      constants[2] = {
        { "STEP", vtkOCCTReader::STEP },
        { "IGES", vtkOCCTReader::IGES },
      };

    o = PyvtkOCCTReader_Format_FromEnum(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkOCCTReader_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkOCCTReader(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkOCCTReader_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkOCCTReader", o) != 0)
  {
    Py_DECREF(o);
  }

}

