// python wrapper for vtkParallelTimer
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkParallelTimer.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkParallelTimer(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkParallelTimer_ClassNew(); }


static PyObject *
PyvtkParallelTimer_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkParallelTimer::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelTimer_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelTimer *op = static_cast<vtkParallelTimer *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkParallelTimer::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelTimer_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkParallelTimer *tempr = vtkParallelTimer::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelTimer_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelTimer *op = static_cast<vtkParallelTimer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkParallelTimer *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkParallelTimer::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelTimer_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkParallelTimer::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelTimer_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelTimer *op = static_cast<vtkParallelTimer *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkParallelTimer::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelTimer_SetWriterRank(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetWriterRank");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelTimer *op = static_cast<vtkParallelTimer *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetWriterRank(temp0);
    }
    else
    {
      op->vtkParallelTimer::SetWriterRank(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelTimer_GetWriterRank(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetWriterRank");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelTimer *op = static_cast<vtkParallelTimer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetWriterRank() :
      op->vtkParallelTimer::GetWriterRank());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelTimer_GetFileName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFileName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelTimer *op = static_cast<vtkParallelTimer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetFileName() :
      op->vtkParallelTimer::GetFileName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelTimer_SetFileName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFileName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelTimer *op = static_cast<vtkParallelTimer *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetFilePath(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFileName(temp0);
    }
    else
    {
      op->vtkParallelTimer::SetFileName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelTimer_StartEvent_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "StartEvent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelTimer *op = static_cast<vtkParallelTimer *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->StartEvent(temp0);
    }
    else
    {
      op->vtkParallelTimer::StartEvent(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkParallelTimer_StartEvent_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "StartEvent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelTimer *op = static_cast<vtkParallelTimer *>(vp);

  int temp0;
  const char *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->StartEvent(temp0, temp1);
    }
    else
    {
      op->vtkParallelTimer::StartEvent(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkParallelTimer_StartEvent(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkParallelTimer_StartEvent_s1(self, args);
    case 2:
      return PyvtkParallelTimer_StartEvent_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "StartEvent");
  return nullptr;
}


static PyObject *
PyvtkParallelTimer_EndEvent_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "EndEvent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelTimer *op = static_cast<vtkParallelTimer *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->EndEvent(temp0);
    }
    else
    {
      op->vtkParallelTimer::EndEvent(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkParallelTimer_EndEvent_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "EndEvent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelTimer *op = static_cast<vtkParallelTimer *>(vp);

  int temp0;
  const char *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->EndEvent(temp0, temp1);
    }
    else
    {
      op->vtkParallelTimer::EndEvent(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkParallelTimer_EndEvent(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkParallelTimer_EndEvent_s1(self, args);
    case 2:
      return PyvtkParallelTimer_EndEvent_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "EndEvent");
  return nullptr;
}


static PyObject *
PyvtkParallelTimer_EndEventSynch_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "EndEventSynch");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelTimer *op = static_cast<vtkParallelTimer *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->EndEventSynch(temp0);
    }
    else
    {
      op->vtkParallelTimer::EndEventSynch(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkParallelTimer_EndEventSynch_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "EndEventSynch");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelTimer *op = static_cast<vtkParallelTimer *>(vp);

  int temp0;
  const char *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->EndEventSynch(temp0, temp1);
    }
    else
    {
      op->vtkParallelTimer::EndEventSynch(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkParallelTimer_EndEventSynch(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkParallelTimer_EndEventSynch_s1(self, args);
    case 2:
      return PyvtkParallelTimer_EndEventSynch_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "EndEventSynch");
  return nullptr;
}


static PyObject *
PyvtkParallelTimer_Clear(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Clear");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelTimer *op = static_cast<vtkParallelTimer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Clear();
    }
    else
    {
      op->vtkParallelTimer::Clear();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelTimer_Update(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Update");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelTimer *op = static_cast<vtkParallelTimer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Update();
    }
    else
    {
      op->vtkParallelTimer::Update();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelTimer_Write(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Write");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelTimer *op = static_cast<vtkParallelTimer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->Write() :
      op->vtkParallelTimer::Write());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelTimer_GetGlobalInstance(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetGlobalInstance");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkParallelTimer *tempr = vtkParallelTimer::GetGlobalInstance();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelTimer_DeleteGlobalInstance(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "DeleteGlobalInstance");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkParallelTimer::DeleteGlobalInstance();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelTimer_SetWriteOnClose(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetWriteOnClose");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelTimer *op = static_cast<vtkParallelTimer *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetWriteOnClose(temp0);
    }
    else
    {
      op->vtkParallelTimer::SetWriteOnClose(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelTimer_GetWriteOnClose(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetWriteOnClose");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelTimer *op = static_cast<vtkParallelTimer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetWriteOnClose() :
      op->vtkParallelTimer::GetWriteOnClose());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkParallelTimer_SetGlobalLevel(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGlobalLevel");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelTimer *op = static_cast<vtkParallelTimer *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetGlobalLevel(temp0);
    }
    else
    {
      op->vtkParallelTimer::SetGlobalLevel(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkParallelTimer_GetGlobalLevel(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGlobalLevel");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkParallelTimer *op = static_cast<vtkParallelTimer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetGlobalLevel() :
      op->vtkParallelTimer::GetGlobalLevel());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkParallelTimer_Methods[] = {
  {"IsTypeOf", PyvtkParallelTimer_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkParallelTimer_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkParallelTimer_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkParallelTimer\nC++: static vtkParallelTimer *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkParallelTimer_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkParallelTimer\nC++: vtkParallelTimer *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkParallelTimer_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkParallelTimer_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetWriterRank", PyvtkParallelTimer_SetWriterRank, METH_VARARGS,
   "SetWriterRank(self, _arg:int) -> None\nC++: virtual void SetWriterRank(int _arg)\n\nSet the rank who writes.\n"},
  {"GetWriterRank", PyvtkParallelTimer_GetWriterRank, METH_VARARGS,
   "GetWriterRank(self) -> int\nC++: virtual int GetWriterRank()\n\n"},
  {"GetFileName", PyvtkParallelTimer_GetFileName, METH_VARARGS,
   "GetFileName(self) -> str\nC++: virtual char *GetFileName()\n\n"},
  {"SetFileName", PyvtkParallelTimer_SetFileName, METH_VARARGS,
   "SetFileName(self, fileName:str) -> None\nC++: void SetFileName(const std::string &fileName)\n\n"},
  {"StartEvent", PyvtkParallelTimer_StartEvent, METH_VARARGS,
   "StartEvent(self, event:str) -> None\nC++: void StartEvent(const char *event)\nStartEvent(self, rank:int, event:str) -> None\nC++: void StartEvent(int rank, const char *event)\n\nThe log works as an event stack. EventStart pushes the event\nidentifier and its start time onto the stack. EventEnd pops the\nmost recent event time and identifier computes the elapsed time\nand adds an entry to the log recording the event, it's start and\nend times, and its elapsed time. EndEventSynch includes a barrier\nbefore the measurement.\n"},
  {"EndEvent", PyvtkParallelTimer_EndEvent, METH_VARARGS,
   "EndEvent(self, event:str) -> None\nC++: void EndEvent(const char *event)\nEndEvent(self, rank:int, event:str) -> None\nC++: void EndEvent(int rank, const char *event)\n\n"},
  {"EndEventSynch", PyvtkParallelTimer_EndEventSynch, METH_VARARGS,
   "EndEventSynch(self, event:str) -> None\nC++: void EndEventSynch(const char *event)\nEndEventSynch(self, rank:int, event:str) -> None\nC++: void EndEventSynch(int rank, const char *event)\n\n"},
  {"Clear", PyvtkParallelTimer_Clear, METH_VARARGS,
   "Clear(self) -> None\nC++: void Clear()\n\nClear the log.\n"},
  {"Update", PyvtkParallelTimer_Update, METH_VARARGS,
   "Update(self) -> None\nC++: void Update()\n\nWhen an object is finished writing data to the log object it must\ncall Update to send the data to the writer rank. This ensures\nthat all data is transferred to the root before MPI_Finalize is\ncalled while allowing the write to occur after Mpi_finalize.\nNote: This is a collective call.\n"},
  {"Write", PyvtkParallelTimer_Write, METH_VARARGS,
   "Write(self) -> int\nC++: int Write()\n\nWrite the log contents to a file.\n"},
  {"GetGlobalInstance", PyvtkParallelTimer_GetGlobalInstance, METH_VARARGS,
   "GetGlobalInstance() -> vtkParallelTimer\nC++: static vtkParallelTimer *GetGlobalInstance()\n\nThe log class implements the singleton pattern so that it may be\nshared across class boundaries. If the log instance doesn't exist\nthen one is created. It will be automatically destroyed at exit\nby the singleton destructor. It can be destroyed explicitly by\ncalling DeleteGlobalInstance.\n"},
  {"DeleteGlobalInstance", PyvtkParallelTimer_DeleteGlobalInstance, METH_VARARGS,
   "DeleteGlobalInstance() -> None\nC++: static void DeleteGlobalInstance()\n\nExplicitly delete the singleton.\n"},
  {"SetWriteOnClose", PyvtkParallelTimer_SetWriteOnClose, METH_VARARGS,
   "SetWriteOnClose(self, _arg:int) -> None\nC++: virtual void SetWriteOnClose(int _arg)\n\nIf enabled and used as a singleton the log will write it's\ncontents to disk during program termination.\n"},
  {"GetWriteOnClose", PyvtkParallelTimer_GetWriteOnClose, METH_VARARGS,
   "GetWriteOnClose(self) -> int\nC++: virtual int GetWriteOnClose()\n\n"},
  {"SetGlobalLevel", PyvtkParallelTimer_SetGlobalLevel, METH_VARARGS,
   "SetGlobalLevel(self, _arg:int) -> None\nC++: virtual void SetGlobalLevel(int _arg)\n\nSet/Get the global log level. Applications can set this to the\ndesired level so that all pipeline objects will log data.\n"},
  {"GetGlobalLevel", PyvtkParallelTimer_GetGlobalLevel, METH_VARARGS,
   "GetGlobalLevel(self) -> int\nC++: virtual int GetGlobalLevel()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkParallelTimer_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("writer_rank"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkParallelTimer_GetWriterRank(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkParallelTimer_SetWriterRank(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkParallelTimer_SetWriterRank(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetWriterRank/SetWriterRank\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("file_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkParallelTimer_GetFileName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkParallelTimer_SetFileName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkParallelTimer_SetFileName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFileName/SetFileName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("file_name"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkParallelTimer_SetFileName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkParallelTimer_SetFileName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetFileName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("write_on_close"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkParallelTimer_GetWriteOnClose(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkParallelTimer_SetWriteOnClose(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkParallelTimer_SetWriteOnClose(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetWriteOnClose/SetWriteOnClose\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("global_level"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkParallelTimer_GetGlobalLevel(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkParallelTimer_SetGlobalLevel(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkParallelTimer_SetGlobalLevel(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetGlobalLevel/SetGlobalLevel\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("global_instance"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkParallelTimer_GetGlobalInstance(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetGlobalInstance\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkParallelTimer_Doc =
  "vtkParallelTimer -  Provides distributed log functionality.\n\n"
  "Superclass: vtkObject\n\n"
  "When the file is\n"
  " written each process data is collected by rank 0 who\n"
  " writes the data to a single file in rank order.\n\n\n"
  " The log works as an event stack. EventStart pushes the\n"
  " event identifier and its start time onto the stack. EventEnd\n"
  " pops the most recent event time and identifier computes the\n"
  " elapsed time and adds an entry to the log recording the\n"
  " event, it's start and end times, and its elapsed time.\n"
  " EndEventSynch includes a barrier before the measurement.\n\n\n"
  " The log class implements the singleton pattern so that it\n"
  " may be shared across class boundaries. If the log instance\n"
  " doesn't exist then one is created. It will be automatically\n"
  " destroyed at exit by the singleton destructor. It can be\n"
  " destroyed explicitly by calling DeleteGlobalInstance.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkParallelTimer_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRenderingParallelLIC.vtkParallelTimer", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkParallelTimer_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkParallelTimer_StaticNew()
{
  return vtkParallelTimer::New();
}

PyObject *PyvtkParallelTimer_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkParallelTimer_Type, PyvtkParallelTimer_Methods,
    "vtkParallelTimer",
 &PyvtkParallelTimer_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkObject");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkParallelTimer_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkParallelTimer(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkParallelTimer_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkParallelTimer", o) != 0)
  {
    Py_DECREF(o);
  }

}

