// python wrapper for vtkVRInteractorStyle
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkEventData.h"
#include "vtkCommand.h"
#include "vtkVRInteractorStyle.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkVRInteractorStyle(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkVRInteractorStyle_ClassNew(); }

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkVRInteractorStyle_MovementStyle_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRenderingVR.vtkVRInteractorStyle.MovementStyle", // tp_name
  sizeof(PyLongObject), // tp_basicsize
  0, // tp_itemsize
  nullptr, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  nullptr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  nullptr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT
#if PY_VERSION_HEX >= 0x030A0000
    | Py_TPFLAGS_DISALLOW_INSTANTIATION
#endif
  , // tp_flags
  nullptr, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  &PyLong_Type, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  nullptr, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

template<class T>
static PyObject *PyvtkVRInteractorStyle_MovementStyle_FromEnum(T val)
{
  return PyVTKEnum_New(&PyvtkVRInteractorStyle_MovementStyle_Type, static_cast<int>(val));
}


static PyObject *
PyvtkVRInteractorStyle_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkVRInteractorStyle::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkVRInteractorStyle::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkVRInteractorStyle *tempr = vtkVRInteractorStyle::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkVRInteractorStyle *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkVRInteractorStyle::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkVRInteractorStyle::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkVRInteractorStyle::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_OnSelect3D(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "OnSelect3D");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  vtkEventData *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkEventData"))
  {
    if (ap.IsBound())
    {
      op->OnSelect3D(temp0);
    }
    else
    {
      op->vtkVRInteractorStyle::OnSelect3D(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_OnNextPose3D(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "OnNextPose3D");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  vtkEventData *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkEventData"))
  {
    if (ap.IsBound())
    {
      op->OnNextPose3D(temp0);
    }
    else
    {
      op->vtkVRInteractorStyle::OnNextPose3D(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_OnViewerMovement3D(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "OnViewerMovement3D");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  vtkEventData *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkEventData"))
  {
    if (ap.IsBound())
    {
      op->OnViewerMovement3D(temp0);
    }
    else
    {
      op->vtkVRInteractorStyle::OnViewerMovement3D(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_OnMove3D(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "OnMove3D");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  vtkEventData *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkEventData"))
  {
    if (ap.IsBound())
    {
      op->OnMove3D(temp0);
    }
    else
    {
      op->vtkVRInteractorStyle::OnMove3D(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_OnMenu3D(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "OnMenu3D");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  vtkEventData *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkEventData"))
  {
    if (ap.IsBound())
    {
      op->OnMenu3D(temp0);
    }
    else
    {
      op->vtkVRInteractorStyle::OnMenu3D(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_OnElevation3D(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "OnElevation3D");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  vtkEventData *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkEventData"))
  {
    if (ap.IsBound())
    {
      op->OnElevation3D(temp0);
    }
    else
    {
      op->vtkVRInteractorStyle::OnElevation3D(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_StartPick(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "StartPick");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  vtkEventDataDevice3D *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkEventDataDevice3D"))
  {
    if (ap.IsBound())
    {
      op->StartPick(temp0);
    }
    else
    {
      op->vtkVRInteractorStyle::StartPick(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_EndPick(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "EndPick");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  vtkEventDataDevice3D *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkEventDataDevice3D"))
  {
    if (ap.IsBound())
    {
      op->EndPick(temp0);
    }
    else
    {
      op->vtkVRInteractorStyle::EndPick(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_StartLoadCamPose(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "StartLoadCamPose");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  vtkEventDataDevice3D *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkEventDataDevice3D"))
  {
    if (ap.IsBound())
    {
      op->StartLoadCamPose(temp0);
    }
    else
    {
      op->vtkVRInteractorStyle::StartLoadCamPose(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_EndLoadCamPose(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "EndLoadCamPose");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  vtkEventDataDevice3D *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkEventDataDevice3D"))
  {
    if (ap.IsBound())
    {
      op->EndLoadCamPose(temp0);
    }
    else
    {
      op->vtkVRInteractorStyle::EndLoadCamPose(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_StartPositionProp(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "StartPositionProp");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  vtkEventDataDevice3D *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkEventDataDevice3D"))
  {
    if (ap.IsBound())
    {
      op->StartPositionProp(temp0);
    }
    else
    {
      op->vtkVRInteractorStyle::StartPositionProp(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_EndPositionProp(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "EndPositionProp");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  vtkEventDataDevice3D *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkEventDataDevice3D"))
  {
    if (ap.IsBound())
    {
      op->EndPositionProp(temp0);
    }
    else
    {
      op->vtkVRInteractorStyle::EndPositionProp(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_StartClip(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "StartClip");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  vtkEventDataDevice3D *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkEventDataDevice3D"))
  {
    if (ap.IsBound())
    {
      op->StartClip(temp0);
    }
    else
    {
      op->vtkVRInteractorStyle::StartClip(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_EndClip(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "EndClip");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  vtkEventDataDevice3D *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkEventDataDevice3D"))
  {
    if (ap.IsBound())
    {
      op->EndClip(temp0);
    }
    else
    {
      op->vtkVRInteractorStyle::EndClip(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_StartMovement3D(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "StartMovement3D");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  int temp0;
  vtkEventDataDevice3D *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkEventDataDevice3D"))
  {
    if (ap.IsBound())
    {
      op->StartMovement3D(temp0, temp1);
    }
    else
    {
      op->vtkVRInteractorStyle::StartMovement3D(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_EndMovement3D(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "EndMovement3D");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  vtkEventDataDevice3D *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkEventDataDevice3D"))
  {
    if (ap.IsBound())
    {
      op->EndMovement3D(temp0);
    }
    else
    {
      op->vtkVRInteractorStyle::EndMovement3D(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_OnPan(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "OnPan");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->OnPan();
    }
    else
    {
      op->vtkVRInteractorStyle::OnPan();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_OnPinch(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "OnPinch");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->OnPinch();
    }
    else
    {
      op->vtkVRInteractorStyle::OnPinch();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_OnRotate(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "OnRotate");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->OnRotate();
    }
    else
    {
      op->vtkVRInteractorStyle::OnRotate();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_ProbeData(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ProbeData");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  vtkEventDataDevice temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetEnumValue(temp0, "vtkEventDataDevice"))
  {
    if (ap.IsBound())
    {
      op->ProbeData(temp0);
    }
    else
    {
      op->vtkVRInteractorStyle::ProbeData(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_PositionProp(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "PositionProp");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  vtkEventData *temp0 = nullptr;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<double> store1(2*size1);
  double *temp1 = store1.Data();
  double *save1 = (size1 == 0 ? nullptr : temp1 + size1);
  size_t size2 = ap.GetArgSize(2);
  vtkPythonArgs::Array<double> store2(2*size2);
  double *temp2 = store2.Data();
  double *save2 = (size2 == 0 ? nullptr : temp2 + size2);
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1, 3) &&
      ap.GetVTKObject(temp0, "vtkEventData") &&
      (ap.NoArgsLeft() || ap.GetArray(temp1, size1)) &&
      (ap.NoArgsLeft() || ap.GetArray(temp2, size2)))
  {
    vtkPythonArgs::Save(temp1, save1, size1);
    vtkPythonArgs::Save(temp2, save2, size2);

    if (ap.IsBound())
    {
      op->PositionProp(temp0, temp1, temp2);
    }
    else
    {
      op->vtkVRInteractorStyle::PositionProp(temp0, temp1, temp2);
    }

    if (vtkPythonArgs::HasChanged(temp1, save1, size1) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(1, temp1, size1);
    }

    if (vtkPythonArgs::HasChanged(temp2, save2, size2) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(2, temp2, size2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_Clip(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Clip");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  vtkEventDataDevice3D *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkEventDataDevice3D"))
  {
    if (ap.IsBound())
    {
      op->Clip(temp0);
    }
    else
    {
      op->vtkVRInteractorStyle::Clip(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_LoadNextCameraPose(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LoadNextCameraPose");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  PyObject *result = nullptr;

  if (op && !ap.IsPureVirtual() && ap.CheckArgCount(0))
  {
    op->LoadNextCameraPose();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_GroundMovement3D(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GroundMovement3D");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  vtkEventDataDevice3D *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkEventDataDevice3D"))
  {
    if (ap.IsBound())
    {
      op->GroundMovement3D(temp0);
    }
    else
    {
      op->vtkVRInteractorStyle::GroundMovement3D(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_Elevation3D(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Elevation3D");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  vtkEventDataDevice3D *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkEventDataDevice3D"))
  {
    if (ap.IsBound())
    {
      op->Elevation3D(temp0);
    }
    else
    {
      op->vtkVRInteractorStyle::Elevation3D(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_Teleportation3D(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Teleportation3D");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  vtkEventDataDevice3D *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkEventDataDevice3D"))
  {
    if (ap.IsBound())
    {
      op->Teleportation3D(temp0);
    }
    else
    {
      op->vtkVRInteractorStyle::Teleportation3D(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_MapInputToAction_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "MapInputToAction");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  vtkCommand::EventIds temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetEnumValue(temp0, "vtkCommand.EventIds") &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->MapInputToAction(temp0, temp1);
    }
    else
    {
      op->vtkVRInteractorStyle::MapInputToAction(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkVRInteractorStyle_MapInputToAction_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "MapInputToAction");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  vtkCommand::EventIds temp0;
  vtkEventDataAction temp1;
  int temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetEnumValue(temp0, "vtkCommand.EventIds") &&
      ap.GetEnumValue(temp1, "vtkEventDataAction") &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->MapInputToAction(temp0, temp1, temp2);
    }
    else
    {
      op->vtkVRInteractorStyle::MapInputToAction(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkVRInteractorStyle_MapInputToAction(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkVRInteractorStyle_MapInputToAction_s1(self, args);
    case 3:
      return PyvtkVRInteractorStyle_MapInputToAction_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "MapInputToAction");
  return nullptr;
}


static PyObject *
PyvtkVRInteractorStyle_GetMappedAction(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMappedAction");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  vtkCommand::EventIds temp0;
  vtkEventDataAction temp1 = vtkEventDataAction::Press;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1, 2) &&
      ap.GetEnumValue(temp0, "vtkCommand.EventIds") &&
      (ap.NoArgsLeft() || ap.GetEnumValue(temp1, "vtkEventDataAction")))
  {
    int tempr = (ap.IsBound() ?
      op->GetMappedAction(temp0, temp1) :
      op->vtkVRInteractorStyle::GetMappedAction(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_AddTooltipForInput(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddTooltipForInput");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  vtkEventDataDevice temp0;
  vtkEventDataDeviceInput temp1;
  std::string temp2 = { };
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2, 3) &&
      ap.GetEnumValue(temp0, "vtkEventDataDevice") &&
      ap.GetEnumValue(temp1, "vtkEventDataDeviceInput") &&
      (ap.NoArgsLeft() || ap.GetValue(temp2)))
  {
    if (ap.IsBound())
    {
      op->AddTooltipForInput(temp0, temp1, temp2);
    }
    else
    {
      op->vtkVRInteractorStyle::AddTooltipForInput(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_MakeControlsHelper(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "MakeControlsHelper");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  PyObject *result = nullptr;

  if (op && !ap.IsPureVirtual() && ap.CheckArgCount(0))
  {
    vtkVRControlsHelper *tempr = op->MakeControlsHelper();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_SetHoverPick(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetHoverPick");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetHoverPick(temp0);
    }
    else
    {
      op->vtkVRInteractorStyle::SetHoverPick(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_GetHoverPick(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetHoverPick");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetHoverPick() :
      op->vtkVRInteractorStyle::GetHoverPick());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_HoverPickOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "HoverPickOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->HoverPickOn();
    }
    else
    {
      op->vtkVRInteractorStyle::HoverPickOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_HoverPickOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "HoverPickOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->HoverPickOff();
    }
    else
    {
      op->vtkVRInteractorStyle::HoverPickOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_SetGrabWithRay(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGrabWithRay");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetGrabWithRay(temp0);
    }
    else
    {
      op->vtkVRInteractorStyle::SetGrabWithRay(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_GetGrabWithRay(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGrabWithRay");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetGrabWithRay() :
      op->vtkVRInteractorStyle::GetGrabWithRay());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_GrabWithRayOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GrabWithRayOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->GrabWithRayOn();
    }
    else
    {
      op->vtkVRInteractorStyle::GrabWithRayOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_GrabWithRayOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GrabWithRayOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->GrabWithRayOff();
    }
    else
    {
      op->vtkVRInteractorStyle::GrabWithRayOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_SetStyle(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetStyle");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  typedef vtkVRInteractorStyle::MovementStyle temp0_type;
  temp0_type temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetEnumValue(temp0, "vtkVRInteractorStyle.MovementStyle"))
  {
    if (ap.IsBound())
    {
      op->SetStyle(temp0);
    }
    else
    {
      op->vtkVRInteractorStyle::SetStyle(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_GetStyle(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetStyle");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    typedef vtkVRInteractorStyle::MovementStyle tempr_type;
  tempr_type tempr = (ap.IsBound() ?
      op->GetStyle() :
      op->vtkVRInteractorStyle::GetStyle());

    if (!ap.ErrorOccurred())
    {
      result = PyvtkVRInteractorStyle_MovementStyle_FromEnum(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_GetInteractionState(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetInteractionState");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  vtkEventDataDevice temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetEnumValue(temp0, "vtkEventDataDevice"))
  {
    int tempr = (ap.IsBound() ?
      op->GetInteractionState(temp0) :
      op->vtkVRInteractorStyle::GetInteractionState(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_SetInteractionState(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInteractionState");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  vtkEventDataDevice temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetEnumValue(temp0, "vtkEventDataDevice") &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetInteractionState(temp0, temp1);
    }
    else
    {
      op->vtkVRInteractorStyle::SetInteractionState(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_ShowRay(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ShowRay");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  vtkEventDataDevice temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetEnumValue(temp0, "vtkEventDataDevice"))
  {
    if (ap.IsBound())
    {
      op->ShowRay(temp0);
    }
    else
    {
      op->vtkVRInteractorStyle::ShowRay(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_HideRay(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "HideRay");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  vtkEventDataDevice temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetEnumValue(temp0, "vtkEventDataDevice"))
  {
    if (ap.IsBound())
    {
      op->HideRay(temp0);
    }
    else
    {
      op->vtkVRInteractorStyle::HideRay(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_ShowBillboard(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ShowBillboard");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->ShowBillboard(temp0);
    }
    else
    {
      op->vtkVRInteractorStyle::ShowBillboard(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_HideBillboard(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "HideBillboard");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->HideBillboard();
    }
    else
    {
      op->vtkVRInteractorStyle::HideBillboard();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_ShowPickSphere(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ShowPickSphere");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  size_t size0 = ap.GetArgSize(0);
  vtkPythonArgs::Array<double> store0(2*size0);
  double *temp0 = store0.Data();
  double *save0 = (size0 == 0 ? nullptr : temp0 + size0);
  double temp1;
  vtkProp3D *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetArray(temp0, size0) &&
      ap.GetValue(temp1) &&
      ap.GetVTKObject(temp2, "vtkProp3D"))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->ShowPickSphere(temp0, temp1, temp2);
    }
    else
    {
      op->vtkVRInteractorStyle::ShowPickSphere(temp0, temp1, temp2);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_ShowPickCell(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ShowPickCell");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  vtkCell *temp0 = nullptr;
  vtkProp3D *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkCell") &&
      ap.GetVTKObject(temp1, "vtkProp3D"))
  {
    if (ap.IsBound())
    {
      op->ShowPickCell(temp0, temp1);
    }
    else
    {
      op->vtkVRInteractorStyle::ShowPickCell(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_HidePickActor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "HidePickActor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->HidePickActor();
    }
    else
    {
      op->vtkVRInteractorStyle::HidePickActor();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_ToggleDrawControls(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ToggleDrawControls");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ToggleDrawControls();
    }
    else
    {
      op->vtkVRInteractorStyle::ToggleDrawControls();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_SetDrawControls(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDrawControls");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDrawControls(temp0);
    }
    else
    {
      op->vtkVRInteractorStyle::SetDrawControls(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_SetInteractor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetInteractor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  vtkRenderWindowInteractor *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkRenderWindowInteractor"))
  {
    if (ap.IsBound())
    {
      op->SetInteractor(temp0);
    }
    else
    {
      op->vtkVRInteractorStyle::SetInteractor(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_SetupActions(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetupActions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  vtkRenderWindowInteractor *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && !ap.IsPureVirtual() && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkRenderWindowInteractor"))
  {
    op->SetupActions(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRInteractorStyle_GetMenu(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMenu");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRInteractorStyle *op = static_cast<vtkVRInteractorStyle *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkVRMenuWidget *tempr = (ap.IsBound() ?
      op->GetMenu() :
      op->vtkVRInteractorStyle::GetMenu());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkVRInteractorStyle_Methods[] = {
  {"IsTypeOf", PyvtkVRInteractorStyle_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkVRInteractorStyle_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkVRInteractorStyle_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkVRInteractorStyle\nC++: static vtkVRInteractorStyle *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkVRInteractorStyle_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkVRInteractorStyle\nC++: vtkVRInteractorStyle *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkVRInteractorStyle_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkVRInteractorStyle_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"OnSelect3D", PyvtkVRInteractorStyle_OnSelect3D, METH_VARARGS,
   "OnSelect3D(self, edata:vtkEventData) -> None\nC++: void OnSelect3D(vtkEventData *edata) override;\n\nOverride generic event bindings to call the corresponding action.\n"},
  {"OnNextPose3D", PyvtkVRInteractorStyle_OnNextPose3D, METH_VARARGS,
   "OnNextPose3D(self, edata:vtkEventData) -> None\nC++: void OnNextPose3D(vtkEventData *edata) override;\n\n"},
  {"OnViewerMovement3D", PyvtkVRInteractorStyle_OnViewerMovement3D, METH_VARARGS,
   "OnViewerMovement3D(self, edata:vtkEventData) -> None\nC++: void OnViewerMovement3D(vtkEventData *edata) override;\n\n"},
  {"OnMove3D", PyvtkVRInteractorStyle_OnMove3D, METH_VARARGS,
   "OnMove3D(self, edata:vtkEventData) -> None\nC++: void OnMove3D(vtkEventData *edata) override;\n\nGeneric 3D event bindings can be overridden in subclasses\n"},
  {"OnMenu3D", PyvtkVRInteractorStyle_OnMenu3D, METH_VARARGS,
   "OnMenu3D(self, edata:vtkEventData) -> None\nC++: void OnMenu3D(vtkEventData *edata) override;\n\n"},
  {"OnElevation3D", PyvtkVRInteractorStyle_OnElevation3D, METH_VARARGS,
   "OnElevation3D(self, edata:vtkEventData) -> None\nC++: void OnElevation3D(vtkEventData *edata) override;\n\n"},
  {"StartPick", PyvtkVRInteractorStyle_StartPick, METH_VARARGS,
   "StartPick(self, __a:vtkEventDataDevice3D) -> None\nC++: virtual void StartPick(vtkEventDataDevice3D *)\n\nInteraction mode entry points.\n"},
  {"EndPick", PyvtkVRInteractorStyle_EndPick, METH_VARARGS,
   "EndPick(self, __a:vtkEventDataDevice3D) -> None\nC++: virtual void EndPick(vtkEventDataDevice3D *)\n\n"},
  {"StartLoadCamPose", PyvtkVRInteractorStyle_StartLoadCamPose, METH_VARARGS,
   "StartLoadCamPose(self, __a:vtkEventDataDevice3D) -> None\nC++: virtual void StartLoadCamPose(vtkEventDataDevice3D *)\n\n"},
  {"EndLoadCamPose", PyvtkVRInteractorStyle_EndLoadCamPose, METH_VARARGS,
   "EndLoadCamPose(self, __a:vtkEventDataDevice3D) -> None\nC++: virtual void EndLoadCamPose(vtkEventDataDevice3D *)\n\n"},
  {"StartPositionProp", PyvtkVRInteractorStyle_StartPositionProp, METH_VARARGS,
   "StartPositionProp(self, __a:vtkEventDataDevice3D) -> None\nC++: virtual void StartPositionProp(vtkEventDataDevice3D *)\n\n"},
  {"EndPositionProp", PyvtkVRInteractorStyle_EndPositionProp, METH_VARARGS,
   "EndPositionProp(self, __a:vtkEventDataDevice3D) -> None\nC++: virtual void EndPositionProp(vtkEventDataDevice3D *)\n\n"},
  {"StartClip", PyvtkVRInteractorStyle_StartClip, METH_VARARGS,
   "StartClip(self, __a:vtkEventDataDevice3D) -> None\nC++: virtual void StartClip(vtkEventDataDevice3D *)\n\n"},
  {"EndClip", PyvtkVRInteractorStyle_EndClip, METH_VARARGS,
   "EndClip(self, __a:vtkEventDataDevice3D) -> None\nC++: virtual void EndClip(vtkEventDataDevice3D *)\n\n"},
  {"StartMovement3D", PyvtkVRInteractorStyle_StartMovement3D, METH_VARARGS,
   "StartMovement3D(self, interactionState:int,\n    __b:vtkEventDataDevice3D) -> None\nC++: virtual void StartMovement3D(int interactionState,\n    vtkEventDataDevice3D *)\n\n"},
  {"EndMovement3D", PyvtkVRInteractorStyle_EndMovement3D, METH_VARARGS,
   "EndMovement3D(self, __a:vtkEventDataDevice3D) -> None\nC++: virtual void EndMovement3D(vtkEventDataDevice3D *)\n\n"},
  {"OnPan", PyvtkVRInteractorStyle_OnPan, METH_VARARGS,
   "OnPan(self) -> None\nC++: void OnPan() override;\n\nComplex gesture events binding.\n"},
  {"OnPinch", PyvtkVRInteractorStyle_OnPinch, METH_VARARGS,
   "OnPinch(self) -> None\nC++: void OnPinch() override;\n\n"},
  {"OnRotate", PyvtkVRInteractorStyle_OnRotate, METH_VARARGS,
   "OnRotate(self) -> None\nC++: void OnRotate() override;\n\n"},
  {"ProbeData", PyvtkVRInteractorStyle_ProbeData, METH_VARARGS,
   "ProbeData(self, controller:vtkEventDataDevice) -> None\nC++: void ProbeData(vtkEventDataDevice controller)\n\nMethods for interaction.\n"},
  {"PositionProp", PyvtkVRInteractorStyle_PositionProp, METH_VARARGS,
   "PositionProp(self, __a:vtkEventData, lwpos:[float, ...]=...,\n    lwori:[float, ...]=...) -> None\nC++: void PositionProp(vtkEventData *, double *lwpos=nullptr,\n    double *lwori=nullptr) override;\n\n"},
  {"Clip", PyvtkVRInteractorStyle_Clip, METH_VARARGS,
   "Clip(self, __a:vtkEventDataDevice3D) -> None\nC++: void Clip(vtkEventDataDevice3D *)\n\n"},
  {"LoadNextCameraPose", PyvtkVRInteractorStyle_LoadNextCameraPose, METH_VARARGS,
   "LoadNextCameraPose(self) -> None\nC++: virtual void LoadNextCameraPose()\n\n"},
  {"GroundMovement3D", PyvtkVRInteractorStyle_GroundMovement3D, METH_VARARGS,
   "GroundMovement3D(self, __a:vtkEventDataDevice3D) -> None\nC++: void GroundMovement3D(vtkEventDataDevice3D *)\n\nMove the camera on the \"XY\" plan (ground) using the\nthumbstick/trackpad position (up/down and left/right), according\nto the headset view direction.\n"},
  {"Elevation3D", PyvtkVRInteractorStyle_Elevation3D, METH_VARARGS,
   "Elevation3D(self, __a:vtkEventDataDevice3D) -> None\nC++: void Elevation3D(vtkEventDataDevice3D *)\n\nMove the camera following the \"Z\" axis (elevation) using the\nthumbstick/trackpad position (up/down).\n"},
  {"Teleportation3D", PyvtkVRInteractorStyle_Teleportation3D, METH_VARARGS,
   "Teleportation3D(self, edd:vtkEventDataDevice3D) -> None\nC++: void Teleportation3D(vtkEventDataDevice3D *edd)\n\nInstant movement to the picked point\n"},
  {"MapInputToAction", PyvtkVRInteractorStyle_MapInputToAction, METH_VARARGS,
   "MapInputToAction(self, eid:vtkCommand.EventIds, state:int) -> None\nC++: void MapInputToAction(vtkCommand::EventIds eid, int state)\nMapInputToAction(self, eid:vtkCommand.EventIds,\n    action:vtkEventDataAction, state:int) -> None\nC++: void MapInputToAction(vtkCommand::EventIds eid,\n    vtkEventDataAction action, int state)\n\nMap controller inputs to actions. Actions are defined by a\nVTKIS_*STATE*, interaction entry points, and the corresponding\nmethod for interaction.\n"},
  {"GetMappedAction", PyvtkVRInteractorStyle_GetMappedAction, METH_VARARGS,
   "GetMappedAction(self, eid:vtkCommand.EventIds,\n    action:vtkEventDataAction=...) -> int\nC++: int GetMappedAction(vtkCommand::EventIds eid,\n    vtkEventDataAction action=vtkEventDataAction::Press)\n\n"},
  {"AddTooltipForInput", PyvtkVRInteractorStyle_AddTooltipForInput, METH_VARARGS,
   "AddTooltipForInput(self, device:vtkEventDataDevice,\n    input:vtkEventDataDeviceInput, text:str=...) -> None\nC++: void AddTooltipForInput(vtkEventDataDevice device,\n    vtkEventDataDeviceInput input, const std::string &text={ })\n\nDefine the helper text that goes with an input.\n"},
  {"MakeControlsHelper", PyvtkVRInteractorStyle_MakeControlsHelper, METH_VARARGS,
   "MakeControlsHelper(self) -> vtkVRControlsHelper\nC++: virtual vtkVRControlsHelper *MakeControlsHelper()\n\nCreates a new ControlsHelper suitable for use with the child\nclass.\n"},
  {"SetHoverPick", PyvtkVRInteractorStyle_SetHoverPick, METH_VARARGS,
   "SetHoverPick(self, _arg:bool) -> None\nC++: virtual void SetHoverPick(bool _arg)\n\nIndicates if picking should be updated every frame. If so, the\ninteraction picker will try to pick a prop and rays will be\nupdated accordingly. Default is set to off.\n"},
  {"GetHoverPick", PyvtkVRInteractorStyle_GetHoverPick, METH_VARARGS,
   "GetHoverPick(self) -> bool\nC++: virtual bool GetHoverPick()\n\n"},
  {"HoverPickOn", PyvtkVRInteractorStyle_HoverPickOn, METH_VARARGS,
   "HoverPickOn(self) -> None\nC++: virtual void HoverPickOn()\n\n"},
  {"HoverPickOff", PyvtkVRInteractorStyle_HoverPickOff, METH_VARARGS,
   "HoverPickOff(self) -> None\nC++: virtual void HoverPickOff()\n\n"},
  {"SetGrabWithRay", PyvtkVRInteractorStyle_SetGrabWithRay, METH_VARARGS,
   "SetGrabWithRay(self, _arg:bool) -> None\nC++: virtual void SetGrabWithRay(bool _arg)\n\nSpecify if the grab mode uses the ray to grab distant objects.\nDefault is set to on.\n"},
  {"GetGrabWithRay", PyvtkVRInteractorStyle_GetGrabWithRay, METH_VARARGS,
   "GetGrabWithRay(self) -> bool\nC++: virtual bool GetGrabWithRay()\n\n"},
  {"GrabWithRayOn", PyvtkVRInteractorStyle_GrabWithRayOn, METH_VARARGS,
   "GrabWithRayOn(self) -> None\nC++: virtual void GrabWithRayOn()\n\n"},
  {"GrabWithRayOff", PyvtkVRInteractorStyle_GrabWithRayOff, METH_VARARGS,
   "GrabWithRayOff(self) -> None\nC++: virtual void GrabWithRayOff()\n\n"},
  {"SetStyle", PyvtkVRInteractorStyle_SetStyle, METH_VARARGS,
   "SetStyle(self, _arg:MovementStyle) -> None\nC++: virtual void SetStyle(MovementStyle _arg)\n\nSpecify the movement style between 'Flying\" and \"Grounded\".\nDefault is Flying.\n"},
  {"GetStyle", PyvtkVRInteractorStyle_GetStyle, METH_VARARGS,
   "GetStyle(self) -> MovementStyle\nC++: virtual MovementStyle GetStyle()\n\n"},
  {"GetInteractionState", PyvtkVRInteractorStyle_GetInteractionState, METH_VARARGS,
   "GetInteractionState(self, device:vtkEventDataDevice) -> int\nC++: int GetInteractionState(vtkEventDataDevice device)\n\nReturn interaction state for the specified device (dolly, pick,\nnone, etc...).\n\n\\sa SetInteractionState()\n"},
  {"SetInteractionState", PyvtkVRInteractorStyle_SetInteractionState, METH_VARARGS,
   "SetInteractionState(self, device:vtkEventDataDevice, state:int)\n    -> None\nC++: void SetInteractionState(vtkEventDataDevice device,\n    int state)\n\nSet interaction state for the specified device (dolly, pick,\nnone, etc...).\n\nThis method **does not** call `this->Modified()`.\n\n\\sa GetInteractionState()\n"},
  {"ShowRay", PyvtkVRInteractorStyle_ShowRay, METH_VARARGS,
   "ShowRay(self, controller:vtkEventDataDevice) -> None\nC++: void ShowRay(vtkEventDataDevice controller)\n\nShow/hide the ray for the specified controller.\n"},
  {"HideRay", PyvtkVRInteractorStyle_HideRay, METH_VARARGS,
   "HideRay(self, controller:vtkEventDataDevice) -> None\nC++: void HideRay(vtkEventDataDevice controller)\n\n"},
  {"ShowBillboard", PyvtkVRInteractorStyle_ShowBillboard, METH_VARARGS,
   "ShowBillboard(self, text:str) -> None\nC++: void ShowBillboard(const std::string &text)\n\nShow/hide billboard with given text string.\n"},
  {"HideBillboard", PyvtkVRInteractorStyle_HideBillboard, METH_VARARGS,
   "HideBillboard(self) -> None\nC++: void HideBillboard()\n\n"},
  {"ShowPickSphere", PyvtkVRInteractorStyle_ShowPickSphere, METH_VARARGS,
   "ShowPickSphere(self, pos:[float, ...], radius:float,\n    __c:vtkProp3D) -> None\nC++: void ShowPickSphere(double *pos, double radius, vtkProp3D *)\n\nMake the pick actor a sphere of given radius centered at given\nposition, and show it.\n"},
  {"ShowPickCell", PyvtkVRInteractorStyle_ShowPickCell, METH_VARARGS,
   "ShowPickCell(self, cell:vtkCell, __b:vtkProp3D) -> None\nC++: void ShowPickCell(vtkCell *cell, vtkProp3D *)\n\nMake the pick actor a polydata built from the points and edges of\nthe given cell, and show it.\n"},
  {"HidePickActor", PyvtkVRInteractorStyle_HidePickActor, METH_VARARGS,
   "HidePickActor(self) -> None\nC++: void HidePickActor()\n\nHide the pick actor (sphere or polydata).\n"},
  {"ToggleDrawControls", PyvtkVRInteractorStyle_ToggleDrawControls, METH_VARARGS,
   "ToggleDrawControls(self) -> None\nC++: void ToggleDrawControls()\n\nControl visibility of descriptive tooltips for controller/HMD\nmodels.\n"},
  {"SetDrawControls", PyvtkVRInteractorStyle_SetDrawControls, METH_VARARGS,
   "SetDrawControls(self, __a:bool) -> None\nC++: void SetDrawControls(bool)\n\n"},
  {"SetInteractor", PyvtkVRInteractorStyle_SetInteractor, METH_VARARGS,
   "SetInteractor(self, iren:vtkRenderWindowInteractor) -> None\nC++: void SetInteractor(vtkRenderWindowInteractor *iren) override;\n\nSet the Interactor wrapper being controlled by this object.\n"},
  {"SetupActions", PyvtkVRInteractorStyle_SetupActions, METH_VARARGS,
   "SetupActions(self, iren:vtkRenderWindowInteractor) -> None\nC++: virtual void SetupActions(vtkRenderWindowInteractor *iren)\n\nSetup default actions defined with an action path and a\ncorresponding command.\n"},
  {"GetMenu", PyvtkVRInteractorStyle_GetMenu, METH_VARARGS,
   "GetMenu(self) -> vtkVRMenuWidget\nC++: vtkVRMenuWidget *GetMenu()\n\nReturn the menu to allow the user to add options to it.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkVRInteractorStyle_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("hover_pick"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkVRInteractorStyle_GetHoverPick(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkVRInteractorStyle_SetHoverPick(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkVRInteractorStyle_SetHoverPick(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetHoverPick/SetHoverPick\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("grab_with_ray"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkVRInteractorStyle_GetGrabWithRay(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkVRInteractorStyle_SetGrabWithRay(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkVRInteractorStyle_SetGrabWithRay(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetGrabWithRay/SetGrabWithRay\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("style"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkVRInteractorStyle_GetStyle(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkVRInteractorStyle_SetStyle(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkVRInteractorStyle_SetStyle(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetStyle/SetStyle\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("draw_controls"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkVRInteractorStyle_SetDrawControls(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkVRInteractorStyle_SetDrawControls(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetDrawControls\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("interactor"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkVRInteractorStyle_SetInteractor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkVRInteractorStyle_SetInteractor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetInteractor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("menu"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkVRInteractorStyle_GetMenu(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetMenu\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkVRInteractorStyle_Doc =
  "vtkVRInteractorStyle - Extended from vtkInteractorStyle3D to override\ncommand methods.\n\n"
  "Superclass: vtkInteractorStyle3D\n\n"
  "This abstract class defines an interactor style in a virtual reality\n"
  "context.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkVRInteractorStyle_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRenderingVR.vtkVRInteractorStyle", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkVRInteractorStyle_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

PyObject *PyvtkVRInteractorStyle_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkVRInteractorStyle_Type, PyvtkVRInteractorStyle_Methods,
    "vtkVRInteractorStyle",
 nullptr);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkInteractorStyle3D");

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  PyType_Ready(&PyvtkVRInteractorStyle_MovementStyle_Type);
  PyVTKEnum_Add(&PyvtkVRInteractorStyle_MovementStyle_Type, "vtkVRInteractorStyle.MovementStyle");

  o = (PyObject *)&PyvtkVRInteractorStyle_MovementStyle_Type;
  if (PyDict_SetItemString(d, "MovementStyle", o) != 0)
  {
    Py_DECREF(o);
  }

  for (int c = 0; c < 2; c++)
  {
    typedef vtkVRInteractorStyle::MovementStyle cxx_enum_type;

    static const struct { const char *name; cxx_enum_type value; }
      constants[2] = {
        { "FLY_STYLE", vtkVRInteractorStyle::FLY_STYLE },
        { "GROUNDED_STYLE", vtkVRInteractorStyle::GROUNDED_STYLE },
      };

    o = PyvtkVRInteractorStyle_MovementStyle_FromEnum(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkVRInteractorStyle_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkVRInteractorStyle(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkVRInteractorStyle_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkVRInteractorStyle", o) != 0)
  {
    Py_DECREF(o);
  }

}

