// python wrapper for vtkVRRenderWindowInteractor
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkEventData.h"
#include "vtkVRRenderWindowInteractor.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkVRRenderWindowInteractor(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkVRRenderWindowInteractor_ClassNew(); }


static PyObject *
PyvtkVRRenderWindowInteractor_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkVRRenderWindowInteractor::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindowInteractor_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindowInteractor *op = static_cast<vtkVRRenderWindowInteractor *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkVRRenderWindowInteractor::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindowInteractor_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkVRRenderWindowInteractor *tempr = vtkVRRenderWindowInteractor::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindowInteractor_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindowInteractor *op = static_cast<vtkVRRenderWindowInteractor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkVRRenderWindowInteractor *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkVRRenderWindowInteractor::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindowInteractor_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkVRRenderWindowInteractor::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindowInteractor_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindowInteractor *op = static_cast<vtkVRRenderWindowInteractor *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkVRRenderWindowInteractor::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindowInteractor_Initialize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Initialize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindowInteractor *op = static_cast<vtkVRRenderWindowInteractor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Initialize();
    }
    else
    {
      op->vtkVRRenderWindowInteractor::Initialize();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindowInteractor_ProcessEvents(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ProcessEvents");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindowInteractor *op = static_cast<vtkVRRenderWindowInteractor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ProcessEvents();
    }
    else
    {
      op->vtkVRRenderWindowInteractor::ProcessEvents();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindowInteractor_DoOneEvent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DoOneEvent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindowInteractor *op = static_cast<vtkVRRenderWindowInteractor *>(vp);

  vtkVRRenderWindow *temp0 = nullptr;
  vtkRenderer *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && !ap.IsPureVirtual() && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkVRRenderWindow") &&
      ap.GetVTKObject(temp1, "vtkRenderer"))
  {
    op->DoOneEvent(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindowInteractor_SetClassExitMethod(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetClassExitMethod");

  PyObject *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetFunction(temp0))
  {
    vtkVRRenderWindowInteractor::SetClassExitMethod(
        (temp0 == Py_None ? nullptr : vtkPythonVoidFunc),
        (temp0 == Py_None ? nullptr : temp0));
      if (temp0 != Py_None)
      {
        Py_INCREF(temp0);
      }
      vtkVRRenderWindowInteractor::SetClassExitMethodArgDelete(
        (temp0 == Py_None ? nullptr : vtkPythonVoidFuncArgDelete));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindowInteractor_ExitCallback(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ExitCallback");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindowInteractor *op = static_cast<vtkVRRenderWindowInteractor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ExitCallback();
    }
    else
    {
      op->vtkVRRenderWindowInteractor::ExitCallback();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindowInteractor_SetPhysicalViewDirection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPhysicalViewDirection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindowInteractor *op = static_cast<vtkVRRenderWindowInteractor *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetPhysicalViewDirection(temp0, temp1, temp2);
    }
    else
    {
      op->vtkVRRenderWindowInteractor::SetPhysicalViewDirection(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindowInteractor_GetPhysicalViewDirection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPhysicalViewDirection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindowInteractor *op = static_cast<vtkVRRenderWindowInteractor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetPhysicalViewDirection() :
      op->vtkVRRenderWindowInteractor::GetPhysicalViewDirection());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindowInteractor_SetPhysicalViewUp(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPhysicalViewUp");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindowInteractor *op = static_cast<vtkVRRenderWindowInteractor *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetPhysicalViewUp(temp0, temp1, temp2);
    }
    else
    {
      op->vtkVRRenderWindowInteractor::SetPhysicalViewUp(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindowInteractor_GetPhysicalViewUp(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPhysicalViewUp");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindowInteractor *op = static_cast<vtkVRRenderWindowInteractor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetPhysicalViewUp() :
      op->vtkVRRenderWindowInteractor::GetPhysicalViewUp());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindowInteractor_SetPhysicalTranslation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPhysicalTranslation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindowInteractor *op = static_cast<vtkVRRenderWindowInteractor *>(vp);

  vtkCamera *temp0 = nullptr;
  double temp1;
  double temp2;
  double temp3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetVTKObject(temp0, "vtkCamera") &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    if (ap.IsBound())
    {
      op->SetPhysicalTranslation(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkVRRenderWindowInteractor::SetPhysicalTranslation(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindowInteractor_GetPhysicalTranslation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPhysicalTranslation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindowInteractor *op = static_cast<vtkVRRenderWindowInteractor *>(vp);

  vtkCamera *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkCamera"))
  {
    double *tempr = (ap.IsBound() ?
      op->GetPhysicalTranslation(temp0) :
      op->vtkVRRenderWindowInteractor::GetPhysicalTranslation(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindowInteractor_SetPhysicalScale(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPhysicalScale");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindowInteractor *op = static_cast<vtkVRRenderWindowInteractor *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPhysicalScale(temp0);
    }
    else
    {
      op->vtkVRRenderWindowInteractor::SetPhysicalScale(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindowInteractor_GetPhysicalScale(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPhysicalScale");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindowInteractor *op = static_cast<vtkVRRenderWindowInteractor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetPhysicalScale() :
      op->vtkVRRenderWindowInteractor::GetPhysicalScale());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindowInteractor_GetPointerDevice(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPointerDevice");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindowInteractor *op = static_cast<vtkVRRenderWindowInteractor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkEventDataDevice tempr = (ap.IsBound() ?
      op->GetPointerDevice() :
      op->vtkVRRenderWindowInteractor::GetPointerDevice());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildEnumValue(tempr, "vtkEventDataDevice");
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindowInteractor_ConvertPoseToWorldCoordinates(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ConvertPoseToWorldCoordinates");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindowInteractor *op = static_cast<vtkVRRenderWindowInteractor *>(vp);

  vtkMatrix4x4 *temp0 = nullptr;
  const size_t size1 = 3;
  double temp1[3];
  double save1[3];
  const size_t size2 = 4;
  double temp2[4];
  double save2[4];
  const size_t size3 = 3;
  double temp3[3];
  double save3[3];
  const size_t size4 = 3;
  double temp4[3];
  double save4[3];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(5) &&
      ap.GetVTKObject(temp0, "vtkMatrix4x4") &&
      ap.GetArray(temp1, size1) &&
      ap.GetArray(temp2, size2) &&
      ap.GetArray(temp3, size3) &&
      ap.GetArray(temp4, size4))
  {
    vtkPythonArgs::Save(temp1, save1, size1);
    vtkPythonArgs::Save(temp2, save2, size2);
    vtkPythonArgs::Save(temp3, save3, size3);
    vtkPythonArgs::Save(temp4, save4, size4);

    if (ap.IsBound())
    {
      op->ConvertPoseToWorldCoordinates(temp0, temp1, temp2, temp3, temp4);
    }
    else
    {
      op->vtkVRRenderWindowInteractor::ConvertPoseToWorldCoordinates(temp0, temp1, temp2, temp3, temp4);
    }

    if (vtkPythonArgs::HasChanged(temp1, save1, size1) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(1, temp1, size1);
    }

    if (vtkPythonArgs::HasChanged(temp2, save2, size2) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(2, temp2, size2);
    }

    if (vtkPythonArgs::HasChanged(temp3, save3, size3) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(3, temp3, size3);
    }

    if (vtkPythonArgs::HasChanged(temp4, save4, size4) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(4, temp4, size4);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindowInteractor_AddAction(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddAction");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindowInteractor *op = static_cast<vtkVRRenderWindowInteractor *>(vp);

  std::string temp0;
  vtkCommand::EventIds temp1;
  bool temp2 = false;
  PyObject *result = nullptr;

  if (op && !ap.IsPureVirtual() && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetEnumValue(temp1, "vtkCommand.EventIds") &&
      ap.GetValue(temp2))
  {
    op->AddAction(temp0, temp1, temp2);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindowInteractor_GetActionManifestFileName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetActionManifestFileName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindowInteractor *op = static_cast<vtkVRRenderWindowInteractor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetActionManifestFileName() :
      op->vtkVRRenderWindowInteractor::GetActionManifestFileName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindowInteractor_SetActionManifestFileName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetActionManifestFileName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindowInteractor *op = static_cast<vtkVRRenderWindowInteractor *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetFilePath(temp0))
  {
    if (ap.IsBound())
    {
      op->SetActionManifestFileName(temp0);
    }
    else
    {
      op->vtkVRRenderWindowInteractor::SetActionManifestFileName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindowInteractor_GetActionManifestDirectory(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetActionManifestDirectory");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindowInteractor *op = static_cast<vtkVRRenderWindowInteractor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetActionManifestDirectory() :
      op->vtkVRRenderWindowInteractor::GetActionManifestDirectory());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindowInteractor_SetActionManifestDirectory(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetActionManifestDirectory");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindowInteractor *op = static_cast<vtkVRRenderWindowInteractor *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetActionManifestDirectory(temp0);
    }
    else
    {
      op->vtkVRRenderWindowInteractor::SetActionManifestDirectory(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindowInteractor_GetActionSetName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetActionSetName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindowInteractor *op = static_cast<vtkVRRenderWindowInteractor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetActionSetName() :
      op->vtkVRRenderWindowInteractor::GetActionSetName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindowInteractor_SetActionSetName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetActionSetName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindowInteractor *op = static_cast<vtkVRRenderWindowInteractor *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetActionSetName(temp0);
    }
    else
    {
      op->vtkVRRenderWindowInteractor::SetActionSetName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindowInteractor_HandleComplexGestureEvents(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "HandleComplexGestureEvents");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindowInteractor *op = static_cast<vtkVRRenderWindowInteractor *>(vp);

  vtkEventData *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkEventData"))
  {
    if (ap.IsBound())
    {
      op->HandleComplexGestureEvents(temp0);
    }
    else
    {
      op->vtkVRRenderWindowInteractor::HandleComplexGestureEvents(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindowInteractor_RecognizeComplexGesture(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RecognizeComplexGesture");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindowInteractor *op = static_cast<vtkVRRenderWindowInteractor *>(vp);

  vtkEventDataDevice3D *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkEventDataDevice3D"))
  {
    if (ap.IsBound())
    {
      op->RecognizeComplexGesture(temp0);
    }
    else
    {
      op->vtkVRRenderWindowInteractor::RecognizeComplexGesture(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindowInteractor_GetDeviceInputDownCount(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDeviceInputDownCount");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindowInteractor *op = static_cast<vtkVRRenderWindowInteractor *>(vp);

  vtkEventDataDevice temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetEnumValue(temp0, "vtkEventDataDevice"))
  {
    int tempr = (ap.IsBound() ?
      op->GetDeviceInputDownCount(temp0) :
      op->vtkVRRenderWindowInteractor::GetDeviceInputDownCount(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderWindowInteractor_SetDeviceInputDownCount(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDeviceInputDownCount");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderWindowInteractor *op = static_cast<vtkVRRenderWindowInteractor *>(vp);

  vtkEventDataDevice temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetEnumValue(temp0, "vtkEventDataDevice") &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetDeviceInputDownCount(temp0, temp1);
    }
    else
    {
      op->vtkVRRenderWindowInteractor::SetDeviceInputDownCount(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkVRRenderWindowInteractor_Methods[] = {
  {"IsTypeOf", PyvtkVRRenderWindowInteractor_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkVRRenderWindowInteractor_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkVRRenderWindowInteractor_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkVRRenderWindowInteractor\nC++: static vtkVRRenderWindowInteractor *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkVRRenderWindowInteractor_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkVRRenderWindowInteractor\nC++: vtkVRRenderWindowInteractor *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkVRRenderWindowInteractor_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkVRRenderWindowInteractor_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"Initialize", PyvtkVRRenderWindowInteractor_Initialize, METH_VARARGS,
   "Initialize(self) -> None\nC++: void Initialize() override;\n\nInitialize the event handler.\n"},
  {"ProcessEvents", PyvtkVRRenderWindowInteractor_ProcessEvents, METH_VARARGS,
   "ProcessEvents(self) -> None\nC++: void ProcessEvents() override;\n\nRun the event loop and return. This is provided so that you can\nimplement your own event loop but yet use the VTK event handling\nas well.\n"},
  {"DoOneEvent", PyvtkVRRenderWindowInteractor_DoOneEvent, METH_VARARGS,
   "DoOneEvent(self, renWin:vtkVRRenderWindow, ren:vtkRenderer)\n    -> None\nC++: virtual void DoOneEvent(vtkVRRenderWindow *renWin,\n    vtkRenderer *ren)\n\nImplements the event loop.\n"},
  {"SetClassExitMethod", PyvtkVRRenderWindowInteractor_SetClassExitMethod, METH_VARARGS,
   "SetClassExitMethod(f:Callback) -> None\nC++: static void SetClassExitMethod(void (*f)(void *), void *arg)\n\nMethods to set the default exit method for the class. These\nmethods are only used if no instance level ExitMethod has been\ndefined. They are provided as a means to control how an\ninteractor is exited given the various language bindings (Win32,\netc.).\n"},
  {"ExitCallback", PyvtkVRRenderWindowInteractor_ExitCallback, METH_VARARGS,
   "ExitCallback(self) -> None\nC++: void ExitCallback() override;\n\nThis method corresponds to the Exit callback, allowing for the\nstyle to invoke it.\n"},
  {"SetPhysicalViewDirection", PyvtkVRRenderWindowInteractor_SetPhysicalViewDirection, METH_VARARGS,
   "SetPhysicalViewDirection(self, __a:float, __b:float, __c:float)\n    -> None\nC++: void SetPhysicalViewDirection(double, double, double)\n    override;\n\nSet/get the direction of the physical coordinate system -Z axis\nin world coordinates.\n"},
  {"GetPhysicalViewDirection", PyvtkVRRenderWindowInteractor_GetPhysicalViewDirection, METH_VARARGS,
   "GetPhysicalViewDirection(self) -> Pointer\nC++: double *GetPhysicalViewDirection() override;\n\n"},
  {"SetPhysicalViewUp", PyvtkVRRenderWindowInteractor_SetPhysicalViewUp, METH_VARARGS,
   "SetPhysicalViewUp(self, __a:float, __b:float, __c:float) -> None\nC++: void SetPhysicalViewUp(double, double, double) override;\n\nSet/get the direction of the physical coordinate system +Y axis\nin world coordinates.\n"},
  {"GetPhysicalViewUp", PyvtkVRRenderWindowInteractor_GetPhysicalViewUp, METH_VARARGS,
   "GetPhysicalViewUp(self) -> Pointer\nC++: double *GetPhysicalViewUp() override;\n\n"},
  {"SetPhysicalTranslation", PyvtkVRRenderWindowInteractor_SetPhysicalTranslation, METH_VARARGS,
   "SetPhysicalTranslation(self, __a:vtkCamera, __b:float, __c:float,\n    __d:float) -> None\nC++: void SetPhysicalTranslation(vtkCamera *, double, double,\n    double) override;\n\nSet/get position of the physical coordinate system origin in\nworld coordinates.\n"},
  {"GetPhysicalTranslation", PyvtkVRRenderWindowInteractor_GetPhysicalTranslation, METH_VARARGS,
   "GetPhysicalTranslation(self, __a:vtkCamera) -> Pointer\nC++: double *GetPhysicalTranslation(vtkCamera *) override;\n\n"},
  {"SetPhysicalScale", PyvtkVRRenderWindowInteractor_SetPhysicalScale, METH_VARARGS,
   "SetPhysicalScale(self, __a:float) -> None\nC++: void SetPhysicalScale(double) override;\n\nSet/get the physical scale (world / physical distance ratio)\n"},
  {"GetPhysicalScale", PyvtkVRRenderWindowInteractor_GetPhysicalScale, METH_VARARGS,
   "GetPhysicalScale(self) -> float\nC++: double GetPhysicalScale() override;\n\n"},
  {"GetPointerDevice", PyvtkVRRenderWindowInteractor_GetPointerDevice, METH_VARARGS,
   "GetPointerDevice(self) -> vtkEventDataDevice\nC++: vtkEventDataDevice GetPointerDevice()\n\n"},
  {"ConvertPoseToWorldCoordinates", PyvtkVRRenderWindowInteractor_ConvertPoseToWorldCoordinates, METH_VARARGS,
   "ConvertPoseToWorldCoordinates(self,\n    poseInTrackingCoordinates:vtkMatrix4x4, pos:[float, float,\n    float], wxyz:[float, float, float, float], ppos:[float, float,\n     float], wdir:[float, float, float]) -> None\nC++: void ConvertPoseToWorldCoordinates(\n    vtkMatrix4x4 *poseInTrackingCoordinates, double pos[3],\n    double wxyz[4], double ppos[3], double wdir[3])\n\n"},
  {"AddAction", PyvtkVRRenderWindowInteractor_AddAction, METH_VARARGS,
   "AddAction(self, path:str, __b:vtkCommand.EventIds, isAnalog:bool)\n    -> None\nC++: virtual void AddAction(const std::string &path,\n    const vtkCommand::EventIds &, bool isAnalog)\n\nAssign an event or std::function to an event path.\n\n\\sa vtkOpenVRRenderWindowInteractor::AddAction\n\\sa vtkOpenXRRenderWindowInteractor::AddAction\n"},
  {"GetActionManifestFileName", PyvtkVRRenderWindowInteractor_GetActionManifestFileName, METH_VARARGS,
   "GetActionManifestFileName(self) -> str\nC++: virtual std::string GetActionManifestFileName()\n\nSet/Get the .json filename describing action bindings for events.\nBased on\nhttps://github.com/ValveSoftware/openvr/wiki/Action-manifest\nDefault is empty.\n"},
  {"SetActionManifestFileName", PyvtkVRRenderWindowInteractor_SetActionManifestFileName, METH_VARARGS,
   "SetActionManifestFileName(self, _arg:str) -> None\nC++: virtual void SetActionManifestFileName(std::string _arg)\n\n"},
  {"GetActionManifestDirectory", PyvtkVRRenderWindowInteractor_GetActionManifestDirectory, METH_VARARGS,
   "GetActionManifestDirectory(self) -> str\nC++: virtual std::string GetActionManifestDirectory()\n\nSet/Get the path to the directory to search for the\nActionManifestFileName Default is empty.\n"},
  {"SetActionManifestDirectory", PyvtkVRRenderWindowInteractor_SetActionManifestDirectory, METH_VARARGS,
   "SetActionManifestDirectory(self, _arg:str) -> None\nC++: virtual void SetActionManifestDirectory(std::string _arg)\n\n"},
  {"GetActionSetName", PyvtkVRRenderWindowInteractor_GetActionSetName, METH_VARARGS,
   "GetActionSetName(self) -> str\nC++: virtual std::string GetActionSetName()\n\nSet/Get the name of the action set to use from the action\nmanifest\n"},
  {"SetActionSetName", PyvtkVRRenderWindowInteractor_SetActionSetName, METH_VARARGS,
   "SetActionSetName(self, _arg:str) -> None\nC++: virtual void SetActionSetName(std::string _arg)\n\n"},
  {"HandleComplexGestureEvents", PyvtkVRRenderWindowInteractor_HandleComplexGestureEvents, METH_VARARGS,
   "HandleComplexGestureEvents(self, ed:vtkEventData) -> None\nC++: virtual void HandleComplexGestureEvents(vtkEventData *ed)\n\nHandle complex gesture events. Complex gesture events recognition\nstarts when both buttons mapped to the ComplexGesture action are\npressed.\n\nTo differentiate the Rotate, Pinch and Pan gestures, the default\nimplementation is based on the following heuristic:\n- Pinch is a move to/from the center point.\n- Rotate is a move along the circumference.\n- Pan is a move of the center point.\n\nAfter computing the distance along each of these axes in meters,\nthe first to break the hard-coded threshold wins.\n\nOverriding both HandleComplexGestureEvents() and\nRecognizeComplexGesture() allows to define a different heuristic.\n\n\\sa GetCurrentGesture(), SetCurrentGesture()\n"},
  {"RecognizeComplexGesture", PyvtkVRRenderWindowInteractor_RecognizeComplexGesture, METH_VARARGS,
   "RecognizeComplexGesture(self, edata:vtkEventDataDevice3D) -> None\nC++: virtual void RecognizeComplexGesture(\n    vtkEventDataDevice3D *edata)\n\n"},
  {"GetDeviceInputDownCount", PyvtkVRRenderWindowInteractor_GetDeviceInputDownCount, METH_VARARGS,
   "GetDeviceInputDownCount(self, device:vtkEventDataDevice) -> int\nC++: int GetDeviceInputDownCount(vtkEventDataDevice device)\n\nWhen handling complex gestures you can query this value to\ndetermine how many input device are down for the gesture.\n\nSupported device values are vtkEventDataDevice::LeftController\nand vtkEventDataDevice::RightController.\n\n\\sa SetDeviceInputDownCount()\n\\sa HandleComplexGestureEvents(), RecognizeComplexGesture()\n"},
  {"SetDeviceInputDownCount", PyvtkVRRenderWindowInteractor_SetDeviceInputDownCount, METH_VARARGS,
   "SetDeviceInputDownCount(self, device:vtkEventDataDevice,\n    count:int) -> None\nC++: void SetDeviceInputDownCount(vtkEventDataDevice device,\n    int count)\n\nYou can set this value when defining a custom heuristic for\nrecognizing complex gestures,\n\nSupported device values are vtkEventDataDevice::LeftController\nand vtkEventDataDevice::RightController.\n\n\\sa GetDeviceInputDownCount()\n\\sa HandleComplexGestureEvents(), RecognizeComplexGesture()\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkVRRenderWindowInteractor_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("physical_view_direction"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkVRRenderWindowInteractor_SetPhysicalViewDirection(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkVRRenderWindowInteractor_SetPhysicalViewDirection(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPhysicalViewDirection\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("physical_view_up"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkVRRenderWindowInteractor_SetPhysicalViewUp(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkVRRenderWindowInteractor_SetPhysicalViewUp(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPhysicalViewUp\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("physical_scale"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkVRRenderWindowInteractor_GetPhysicalScale(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkVRRenderWindowInteractor_SetPhysicalScale(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkVRRenderWindowInteractor_SetPhysicalScale(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPhysicalScale/SetPhysicalScale\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("action_manifest_file_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkVRRenderWindowInteractor_GetActionManifestFileName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkVRRenderWindowInteractor_SetActionManifestFileName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkVRRenderWindowInteractor_SetActionManifestFileName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetActionManifestFileName/SetActionManifestFileName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("action_manifest_directory"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkVRRenderWindowInteractor_GetActionManifestDirectory(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkVRRenderWindowInteractor_SetActionManifestDirectory(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkVRRenderWindowInteractor_SetActionManifestDirectory(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetActionManifestDirectory/SetActionManifestDirectory\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("action_set_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkVRRenderWindowInteractor_GetActionSetName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkVRRenderWindowInteractor_SetActionSetName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkVRRenderWindowInteractor_SetActionSetName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetActionSetName/SetActionSetName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("physical_view_direction"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkVRRenderWindowInteractor_GetPhysicalViewDirection(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetPhysicalViewDirection\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("physical_view_up"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkVRRenderWindowInteractor_GetPhysicalViewUp(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetPhysicalViewUp\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("pointer_device"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkVRRenderWindowInteractor_GetPointerDevice(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetPointerDevice\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkVRRenderWindowInteractor_Doc =
  "vtkVRRenderWindowInteractor - Implements VR specific functions\nrequired by vtkRenderWindowInteractor.\n\n"
  "Superclass: vtkRenderWindowInteractor3D\n\n"
;

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkVRRenderWindowInteractor_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRenderingVR.vtkVRRenderWindowInteractor", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkVRRenderWindowInteractor_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

PyObject *PyvtkVRRenderWindowInteractor_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkVRRenderWindowInteractor_Type, PyvtkVRRenderWindowInteractor_Methods,
    "vtkVRRenderWindowInteractor",
 nullptr);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkRenderWindowInteractor3D");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkVRRenderWindowInteractor_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkVRRenderWindowInteractor(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkVRRenderWindowInteractor_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkVRRenderWindowInteractor", o) != 0)
  {
    Py_DECREF(o);
  }

}

