// python wrapper for vtkVRRenderer
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkVRRenderer.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkVRRenderer(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkVRRenderer_ClassNew(); }


static PyObject *
PyvtkVRRenderer_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkVRRenderer::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderer_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderer *op = static_cast<vtkVRRenderer *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkVRRenderer::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderer_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkVRRenderer *tempr = vtkVRRenderer::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderer_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderer *op = static_cast<vtkVRRenderer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkVRRenderer *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkVRRenderer::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderer_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkVRRenderer::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderer_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderer *op = static_cast<vtkVRRenderer *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkVRRenderer::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderer_ResetCamera_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ResetCamera");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderer *op = static_cast<vtkVRRenderer *>(vp);

  const size_t size0 = 6;
  double temp0[6];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->ResetCamera(temp0);
    }
    else
    {
      op->vtkVRRenderer::ResetCamera(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkVRRenderer_ResetCamera_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ResetCamera");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderer *op = static_cast<vtkVRRenderer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ResetCamera();
    }
    else
    {
      op->vtkVRRenderer::ResetCamera();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkVRRenderer_ResetCamera_s3(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ResetCamera");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderer *op = static_cast<vtkVRRenderer *>(vp);

  double temp0;
  double temp1;
  double temp2;
  double temp3;
  double temp4;
  double temp5;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(6) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      ap.GetValue(temp4) &&
      ap.GetValue(temp5))
  {
    if (ap.IsBound())
    {
      op->ResetCamera(temp0, temp1, temp2, temp3, temp4, temp5);
    }
    else
    {
      op->vtkVRRenderer::ResetCamera(temp0, temp1, temp2, temp3, temp4, temp5);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkVRRenderer_ResetCamera(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkVRRenderer_ResetCamera_s1(self, args);
    case 0:
      return PyvtkVRRenderer_ResetCamera_s2(self, args);
    case 6:
      return PyvtkVRRenderer_ResetCamera_s3(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "ResetCamera");
  return nullptr;
}


static PyObject *
PyvtkVRRenderer_ResetCameraClippingRange_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ResetCameraClippingRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderer *op = static_cast<vtkVRRenderer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ResetCameraClippingRange();
    }
    else
    {
      op->vtkVRRenderer::ResetCameraClippingRange();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkVRRenderer_ResetCameraClippingRange_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ResetCameraClippingRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderer *op = static_cast<vtkVRRenderer *>(vp);

  const size_t size0 = 6;
  double temp0[6];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->ResetCameraClippingRange(temp0);
    }
    else
    {
      op->vtkVRRenderer::ResetCameraClippingRange(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkVRRenderer_ResetCameraClippingRange_s3(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ResetCameraClippingRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderer *op = static_cast<vtkVRRenderer *>(vp);

  double temp0;
  double temp1;
  double temp2;
  double temp3;
  double temp4;
  double temp5;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(6) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      ap.GetValue(temp4) &&
      ap.GetValue(temp5))
  {
    if (ap.IsBound())
    {
      op->ResetCameraClippingRange(temp0, temp1, temp2, temp3, temp4, temp5);
    }
    else
    {
      op->vtkVRRenderer::ResetCameraClippingRange(temp0, temp1, temp2, temp3, temp4, temp5);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkVRRenderer_ResetCameraClippingRange(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 0:
      return PyvtkVRRenderer_ResetCameraClippingRange_s1(self, args);
    case 1:
      return PyvtkVRRenderer_ResetCameraClippingRange_s2(self, args);
    case 6:
      return PyvtkVRRenderer_ResetCameraClippingRange_s3(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "ResetCameraClippingRange");
  return nullptr;
}


static PyObject *
PyvtkVRRenderer_MakeCamera(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "MakeCamera");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderer *op = static_cast<vtkVRRenderer *>(vp);

  PyObject *result = nullptr;

  if (op && !ap.IsPureVirtual() && ap.CheckArgCount(0))
  {
    vtkCamera *tempr = op->MakeCamera();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderer_GetFloorTransform(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFloorTransform");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderer *op = static_cast<vtkVRRenderer *>(vp);

  vtkTransform *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkTransform"))
  {
    if (ap.IsBound())
    {
      op->GetFloorTransform(temp0);
    }
    else
    {
      op->vtkVRRenderer::GetFloorTransform(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderer_DeviceRender(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DeviceRender");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderer *op = static_cast<vtkVRRenderer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->DeviceRender();
    }
    else
    {
      op->vtkVRRenderer::DeviceRender();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderer_SetShowFloor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetShowFloor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderer *op = static_cast<vtkVRRenderer *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetShowFloor(temp0);
    }
    else
    {
      op->vtkVRRenderer::SetShowFloor(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderer_GetShowFloor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetShowFloor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderer *op = static_cast<vtkVRRenderer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetShowFloor() :
      op->vtkVRRenderer::GetShowFloor());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderer_SetShowLeftMarker(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetShowLeftMarker");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderer *op = static_cast<vtkVRRenderer *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetShowLeftMarker(temp0);
    }
    else
    {
      op->vtkVRRenderer::SetShowLeftMarker(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderer_GetShowLeftMarker(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetShowLeftMarker");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderer *op = static_cast<vtkVRRenderer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetShowLeftMarker() :
      op->vtkVRRenderer::GetShowLeftMarker());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderer_SetShowRightMarker(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetShowRightMarker");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderer *op = static_cast<vtkVRRenderer *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetShowRightMarker(temp0);
    }
    else
    {
      op->vtkVRRenderer::SetShowRightMarker(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkVRRenderer_GetShowRightMarker(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetShowRightMarker");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkVRRenderer *op = static_cast<vtkVRRenderer *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetShowRightMarker() :
      op->vtkVRRenderer::GetShowRightMarker());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkVRRenderer_Methods[] = {
  {"IsTypeOf", PyvtkVRRenderer_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkVRRenderer_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkVRRenderer_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkVRRenderer\nC++: static vtkVRRenderer *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkVRRenderer_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkVRRenderer\nC++: vtkVRRenderer *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkVRRenderer_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkVRRenderer_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"ResetCamera", PyvtkVRRenderer_ResetCamera, METH_VARARGS,
   "ResetCamera(self, bounds:(float, float, float, float, float,\n    float)) -> None\nC++: void ResetCamera(const double bounds[6]) override;\nResetCamera(self) -> None\nC++: virtual void ResetCamera()\nResetCamera(self, xmin:float, xmax:float, ymin:float, ymax:float,\n    zmin:float, zmax:float) -> None\nC++: virtual void ResetCamera(double xmin, double xmax,\n    double ymin, double ymax, double zmin, double zmax)\n\nAutomatically set up the camera based on a specified bounding box\n(xmin,xmax, ymin,ymax, zmin,zmax). Camera will reposition itself\nso that its focal point is the center of the bounding box, and\nadjust its distance and position to preserve its initial view\nplane normal (i.e., vector defined from camera position to focal\npoint). Note: if the view plane is parallel to the view up axis,\nthe view up axis will be reset to one of the three coordinate\naxes.\n"},
  {"ResetCameraClippingRange", PyvtkVRRenderer_ResetCameraClippingRange, METH_VARARGS,
   "ResetCameraClippingRange(self) -> None\nC++: void ResetCameraClippingRange() override;\nResetCameraClippingRange(self, bounds:(float, float, float, float,\n     float, float)) -> None\nC++: void ResetCameraClippingRange(const double bounds[6])\n    override;\nResetCameraClippingRange(self, xmin:float, xmax:float, ymin:float,\n     ymax:float, zmin:float, zmax:float) -> None\nC++: virtual void ResetCameraClippingRange(double xmin,\n    double xmax, double ymin, double ymax, double zmin,\n    double zmax)\n\nReset the camera clipping range based on a bounding box.\n"},
  {"MakeCamera", PyvtkVRRenderer_MakeCamera, METH_VARARGS,
   "MakeCamera(self) -> vtkCamera\nC++: vtkCamera *MakeCamera() override = 0;\n\nAbstract function that creates a new Camera suitable for use with\nthis type of Renderer.\n"},
  {"GetFloorTransform", PyvtkVRRenderer_GetFloorTransform, METH_VARARGS,
   "GetFloorTransform(self, transform:vtkTransform) -> None\nC++: virtual void GetFloorTransform(vtkTransform *transform)\n\nStore in transform the floor transform.\n"},
  {"DeviceRender", PyvtkVRRenderer_DeviceRender, METH_VARARGS,
   "DeviceRender(self) -> None\nC++: void DeviceRender() override;\n\nRender the floor using GetFloorTransform\n"},
  {"SetShowFloor", PyvtkVRRenderer_SetShowFloor, METH_VARARGS,
   "SetShowFloor(self, value:bool) -> None\nC++: virtual void SetShowFloor(bool value)\n\nSet/get whether to show a white floor corresponding to the\nphysical floor. Default is false.\n"},
  {"GetShowFloor", PyvtkVRRenderer_GetShowFloor, METH_VARARGS,
   "GetShowFloor(self) -> bool\nC++: virtual bool GetShowFloor()\n\n"},
  {"SetShowLeftMarker", PyvtkVRRenderer_SetShowLeftMarker, METH_VARARGS,
   "SetShowLeftMarker(self, value:bool) -> None\nC++: virtual void SetShowLeftMarker(bool value)\n\nSet/get whether to display a white cross marker at the tip of the\nleft controller. Default is false.\n"},
  {"GetShowLeftMarker", PyvtkVRRenderer_GetShowLeftMarker, METH_VARARGS,
   "GetShowLeftMarker(self) -> bool\nC++: virtual bool GetShowLeftMarker()\n\n"},
  {"SetShowRightMarker", PyvtkVRRenderer_SetShowRightMarker, METH_VARARGS,
   "SetShowRightMarker(self, value:bool) -> None\nC++: virtual void SetShowRightMarker(bool value)\n\nSet/get whether to display a white cross marker at the tip of the\nright controller. Default is false.\n"},
  {"GetShowRightMarker", PyvtkVRRenderer_GetShowRightMarker, METH_VARARGS,
   "GetShowRightMarker(self) -> bool\nC++: virtual bool GetShowRightMarker()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkVRRenderer_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("show_floor"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkVRRenderer_GetShowFloor(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkVRRenderer_SetShowFloor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkVRRenderer_SetShowFloor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetShowFloor/SetShowFloor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("show_left_marker"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkVRRenderer_GetShowLeftMarker(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkVRRenderer_SetShowLeftMarker(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkVRRenderer_SetShowLeftMarker(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetShowLeftMarker/SetShowLeftMarker\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("show_right_marker"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkVRRenderer_GetShowRightMarker(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkVRRenderer_SetShowRightMarker(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkVRRenderer_SetShowRightMarker(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetShowRightMarker/SetShowRightMarker\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkVRRenderer_Doc =
  "vtkVRRenderer - Renderer class for VR/AR context.\n\n"
  "Superclass: vtkOpenGLRenderer\n\n"
  "vtkVRRenderer is an abstract vtkRenderer class that is meant to be\n"
  "used in VR context. It defines a floor actor with a grid fading with\n"
  "the distance, as well as a cross-like marker that can be attached to\n"
  "the tip of a controller (can be used e.g. to help place points).\n\n"
  "Subclasses must define MakeCamera().\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkVRRenderer_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRenderingVR.vtkVRRenderer", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkVRRenderer_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

PyObject *PyvtkVRRenderer_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkVRRenderer_Type, PyvtkVRRenderer_Methods,
    "vtkVRRenderer",
 nullptr);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkOpenGLRenderer");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkVRRenderer_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkVRRenderer(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkVRRenderer_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkVRRenderer", o) != 0)
  {
    Py_DECREF(o);
  }

}

