// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
#include "Basis_HGrad_PyrC1Gradient.h"

const char *Basis_HGrad_PyrC1Gradient =
"// Be sure that the basis functions are defined when tt is very close to 1.\n"
"// Warning: the derivatives are discontinuous in (0, 0, 1).\n"
"if (abs(tt - 1.0) < eps)\n"
"{\n"
"  if (tt <= 1.0)\n"
"  {\n"
"    tt = 1.0 - eps;\n"
"  }\n"
"  else\n"
"  {\n"
"    tt = 1.0 + eps;\n"
"  }\n"
"}\n"
"\n"
"RealT ttTerm = 0.25 / (1.0 - tt);\n"
"RealT ttTerm2 = 4.0 * ttTerm * ttTerm;\n"
"\n"
"basisGradient[0] = (ss + tt - 1.0) * ttTerm;\n"
"basisGradient[1] = (rr + tt - 1.0) * ttTerm;\n"
"basisGradient[2] = rr * ss * ttTerm2 - 0.25;\n"
"\n"
"basisGradient[3] = (1.0 - ss - tt) * ttTerm;\n"
"basisGradient[4] = (tt - rr - 1.0) * ttTerm;\n"
"basisGradient[5] = rr * ss * ttTerm2 - 0.25;\n"
"\n"
"basisGradient[6] = (1.0 + ss - tt) * ttTerm;\n"
"basisGradient[7] = (1.0 + rr - tt) * ttTerm;\n"
"basisGradient[8] = rr * ss * ttTerm2 - 0.25;\n"
"\n"
"basisGradient[9] = (tt - ss - 1.0) * ttTerm;\n"
"basisGradient[10] = (1.0 - rr - tt) * ttTerm;\n"
"basisGradient[11] = rr * ss * ttTerm2 - 0.25;\n"
"\n"
"basisGradient[12] = 0.0;\n"
"basisGradient[13] = 0.0;\n"
"basisGradient[14] = 1.0;\n"
"";
