// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
#include "vtkCellGridShaderFragment.h"

const char *vtkCellGridShaderFragment =
"//VTK::System::Dec\n"
"// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen\n"
"// SPDX-License-Identifier: BSD-3-Clause\n"
"//VTK::Camera::Dec\n"
"\n"
"//VTK::Output::Dec\n"
"\n"
"// Position of vertex in view coordinates.\n"
"//VTK::PositionVC::Dec\n"
"\n"
"// The normal of the output primitive in view coordinates.\n"
"//VTK::Normal::Dec\n"
"\n"
"// Depth Peeling Support\n"
"//VTK::DepthPeeling::Dec\n"
"\n"
"// handle coincident offsets\n"
"//VTK::Coincident::Dec\n"
"\n"
"// Value raster\n"
"//VTK::ValuePass::Dec\n"
"\n"
"// Lights\n"
"//VTK::Light::Dec\n"
"\n"
"smooth in vec3 pcoordVSOutput;\n"
"#if {UsesGeometryShaders}\n"
"// distance of fragment from origin in patch coordinate system.\n"
"smooth in vec3 patchDistanceGSOutput;\n"
"// distance of fragment from origin in parametric coordinate system\n"
"// of the tessellated output primitive.\n"
"smooth in vec3 primDistanceGSOutput;\n"
"#endif\n"
"\n"
"flat in int cellIdVSOutput;\n"
"flat in int instanceIdVSOutput;\n"
"\n"
"uniform sampler2D color_map;\n"
"uniform vec3 color_range;\n"
"uniform int color_component;\n"
"\n"
"// The indices of all DOFs for all cells of this shape.\n"
"uniform highp isamplerBuffer shape_conn;\n"
"// The (x,y,z) points of each DOF in the entire mesh.\n"
"uniform samplerBuffer shape_vals;\n"
"// We may need this if the color and shape have different interpolation orders\n"
"// **and** the color attribute is continuous (i.e., shares coefficients at cell boundaries).\n"
"uniform highp isamplerBuffer color_conn;\n"
"// The coefficient of each basis function at each integration point in each cell.\n"
"uniform samplerBuffer color_vals;\n"
"\n"
"// basic material shading capabilities\n"
"uniform vec3 color_ambient;\n"
"uniform vec3 color_diffuse;\n"
"uniform vec3 color_specular;\n"
"uniform vec3 color_ambient_bf; // backface\n"
"uniform vec3 color_diffuse_bf; // backface\n"
"uniform vec3 color_specular_bf; // backface\n"
"uniform float intensity_ambient;\n"
"uniform float intensity_diffuse;\n"
"uniform float intensity_specular;\n"
"uniform float intensity_opacity;\n"
"uniform float intensity_ambient_bf; // backface\n"
"uniform float intensity_diffuse_bf; // backface\n"
"uniform float intensity_specular_bf; // backface\n"
"uniform float intensity_opacity_bf; // backface\n"
"uniform float power_specular;\n"
"uniform float power_specular_bf; // backface\n"
"uniform int enable_specular;\n"
"\n"
"// Picking\n"
"/// Picking pass that the renderer is currently in.\n"
"uniform int picking_pass;\n"
"/// This corresponds to index of a value in vtkCellGrid::GetCellTypes() for the cell being rendered.\n"
"uniform int celltype_idx;\n"
"/// x: Index of a vtkDGCell::Source spec object. y: Index of the offset into connectivity array.\n"
"/// A spec object corresponds to elements of `std::vector<vtkDGCell::Source>`.\n"
"/// For side-specs the index starts from 1. 0 is reserved for cell-spec object.\n"
"uniform int sidespec_idx;\n"
"/// Index for actor/composite/process pass\n"
"uniform vec3 mapper_idx_components;\n"
"\n"
"// debugging\n"
"uniform int color_override_type;\n"
"\n"
"{commonDefs}\n"
"{cellEval}\n"
"{cellUtil}\n"
"\n"
"#if {UsesTessellationShaders}\n"
"float amplify(float d, float scale, float offset)\n"
"{{\n"
"  d = scale * d + offset;\n"
"  d = 1 - exp2(-2*d*d);\n"
"  d = clamp(d, 0, 1);\n"
"  return d;\n"
"}}\n"
"#endif\n"
"\n"
"/// Split the 32-bit integer into 4 individual 8-bit integers.\n"
"/// The LSBs are stored in 'red' component and the MSBs are output in 'alpha' component.\n"
"vec4 split_integer_components(int value)\n"
"{{\n"
"  vec4 result;\n"
"  result.r = float(value % 256)/255.0f;\n"
"  result.g = float((value / 256) % 256)/255.0f;\n"
"  result.b = float((value / 65536) % 256)/255.0f;\n"
"  result.a = float(value) / 255.0;\n"
"  return result;\n"
"}}\n"
"\n"
"void main()\n"
"{{\n"
"  //VTK::PositionVC::Impl\n"
"\n"
"  // Place any calls that require uniform flow (e.g. dFdx) here.\n"
"  //VTK::UniformFlow::Impl\n"
"\n"
"  // Set gl_FragDepth here (gl_FragCoord.z by default)\n"
"  //VTK::Depth::Impl\n"
"\n"
"  // Early depth peeling abort:\n"
"  //VTK::DepthPeeling::PreColor\n"
"\n"
"  float colorValues[{ColorCoeffPerCell}];\n"
"  float fieldValue[{ColorNumValPP}];\n"
"  float scalar; // The non-normalized scalar value computed from a fieldValue tuple.\n"
"  vec2 texCoord; // Used for color lookup.\n"
"\n"
"  if ({HaveColors})\n"
"  {{\n"
"    float shapeValues[{ShapeCoeffPerCell}];\n"
"    shapeValuesForCell(cellIdVSOutput, shapeValues);\n"
"\n"
"    if ({ColorContinuous})\n"
"    {{\n"
"      // Continuous (shared) field values\n"
"      for (int ii = 0; ii < {ColorNumBasisFun}; ++ii)\n"
"      {{\n"
"        int dofId = texelFetchBuffer(color_conn, cellIdVSOutput * {ColorNumBasisFun} + ii).s;\n"
"        for (int jj = 0; jj < {ColorMultiplicity}; ++jj)\n"
"        {{\n"
"          colorValues[ii * {ColorMultiplicity} + jj] = texelFetchBuffer(color_vals, dofId * {ColorMultiplicity} + jj).x;\n"
"        }}\n"
"      }}\n"
"    }}\n"
"    else\n"
"    {{\n"
"      // Discontinuous field values\n"
"      for (int ii = 0; ii < {ColorNumBasisFun}; ++ii)\n"
"      {{\n"
"        for (int jj = 0; jj < {ColorMultiplicity}; ++jj)\n"
"        {{\n"
"          int colorValTBIdx = (cellIdVSOutput * {ColorNumBasisFun} + ii) * {ColorMultiplicity} + jj;\n"
"          int colorValVSIdx = ii * {ColorMultiplicity} + jj;\n"
"          colorValues[colorValVSIdx] = texelFetchBuffer(color_vals, colorValTBIdx).x;\n"
"        }}\n"
"      }}\n"
"    }}\n"
"\n"
"    // Evaluate the basis function at this fragment's parametric coords (pcoordVSOutput),\n"
"    // yielding the \\a fieldValue tuple.\n"
"    colorEvaluateAt(pcoordVSOutput, shapeValues, colorValues, fieldValue);\n"
"\n"
"    // Choose how we map the \\a fieldValue tuple into a texture-map coordinate.\n"
"    switch (color_component)\n"
"    {{\n"
"    case -2:\n"
"      // L₂ norm:\n"
"      {{\n"
"        float mag = 0.0;\n"
"        for (int cc = 0; cc < {ColorNumValPP}; ++cc)\n"
"        {{\n"
"          mag += fieldValue[cc] * fieldValue[cc];\n"
"        }}\n"
"        scalar = sqrt(mag);\n"
"      }}\n"
"      break;\n"
"    case -1:\n"
"      // L₁ norm (choose the maximum across components):\n"
"      {{\n"
"        scalar = fieldValue[0];\n"
"        for (int cc = 1; cc < {ColorNumValPP}; ++cc)\n"
"        {{\n"
"          if (fieldValue[cc] > scalar)\n"
"          {{\n"
"            scalar = fieldValue[cc];\n"
"          }}\n"
"        }}\n"
"      }}\n"
"      break;\n"
"    default:\n"
"      // Choose a single component.\n"
"      scalar = fieldValue[color_component];\n"
"    }}\n"
"    if (color_range[2] > 0.0)\n"
"    {{\n"
"      texCoord = vec2((scalar - color_range[0]) / color_range[2], 0.0);\n"
"    }}\n"
"    else\n"
"    {{\n"
"      texCoord = vec2((scalar - color_range[0]), 0.0);\n"
"    }}\n"
"    // texCoord = vec2(colorValues[3], 0.);\n"
"  }}\n"
"\n"
"  vec4 color;\n"
"  vec3 ambientColor;\n"
"  vec3 diffuseColor;\n"
"  vec3 specularColor;\n"
"  float opacity;\n"
"  float specularPower = 0.0f;\n"
"  if ({HaveColors})\n"
"  {{\n"
"    vec3 pcoord = pcoordVSOutput;\n"
"    switch (color_override_type)\n"
"    {{\n"
"      case ScalarVisualizationOverride_R:\n"
"        color = texture(color_map, vec2(pcoord.x * 0.5 + 0.5, 0.0));\n"
"        break;\n"
"      case ScalarVisualizationOverride_S:\n"
"        color = texture(color_map, vec2(pcoord.y * 0.5 + 0.5, 0.0));\n"
"        break;\n"
"      case ScalarVisualizationOverride_T:\n"
"        color = texture(color_map, vec2(pcoord.z * 0.5 + 0.5, 0.0));\n"
"        break;\n"
"      case ScalarVisualizationOverride_L2_NORM_R_S:\n"
"        color = texture(color_map, vec2(length(pcoord.xy) * 0.707106f, 0.0));\n"
"        break;\n"
"      case ScalarVisualizationOverride_L2_NORM_S_T:\n"
"        color = texture(color_map, vec2(length(pcoord.yz) * 0.707106f, 0.0));\n"
"        break;\n"
"      case ScalarVisualizationOverride_L2_NORM_T_R:\n"
"        color = texture(color_map, vec2(length(pcoord.zx) * 0.707106f, 0.0));\n"
"        break;\n"
"      case ScalarVisualizationOverride_NONE:\n"
"      default:\n"
"        color = texture(color_map, texCoord);\n"
"        break;\n"
"    }}\n"
"    // color = vec4((colorValues[0] - color_range[0])/color_range[2], (colorValues[1] - color_range[0])/color_range[2], (colorValues[2] - color_range[0])/color_range[2], 1.0);\n"
"    // color = vec4(texCoord.s, texCoord.s, texCoord.s, 1.0);\n"
"    ambientColor = intensity_ambient * color.rgb;\n"
"    diffuseColor = intensity_diffuse * color.rgb;\n"
"    specularColor = intensity_specular * color.rgb;\n"
"    opacity = intensity_opacity * color.a;\n"
"  }}\n"
"  else\n"
"  {{\n"
"    // FIXME: gl_FrontFacing cannot be relied upon for some reason.\n"
"    //        1. Dual depth peeling works and sometimes doesn't.\n"
"    //        2. Backfaces are not rendered.\n"
"    // if (gl_FrontFacing == false)\n"
"    // {{\n"
"    //   ambientColor = intensity_ambient_bf * color_ambient_bf;\n"
"    //   diffuseColor = intensity_diffuse_bf * color_diffuse_bf;\n"
"    //   specularColor = intensity_specular_bf * color_specular_bf;\n"
"    //   opacity = intensity_opacity_bf;\n"
"    //   specularPower = power_specular_bf;\n"
"    // }}\n"
"    // else\n"
"    {{\n"
"      ambientColor = intensity_ambient * color_ambient;\n"
"      diffuseColor = intensity_diffuse * color_diffuse;\n"
"      specularColor = intensity_specular * color_specular;\n"
"      opacity = intensity_opacity;\n"
"      specularPower = power_specular;\n"
"    }}\n"
"  }}\n"
"\n"
"  //VTK::Normal::Impl\n"
"  // vtkGLSLModLight inverts the z component of normal when gl_FrontFacing == false.\n"
"  // Some OpenGL implementations strictly adhere to the spec and set that property to false\n"
"  // when rendering lines and points.\n"
"  // This block reorients the normal vector to always point towards the camera to\n"
"  // avoid black lines and points.\n"
"  if ((DrawingCellsNotSides && NumPtsPerCell <= 2) || (!DrawingCellsNotSides && NumPtsPerSide <= 2))\n"
"  {{\n"
"    vertexNormalVCVS.z = 1;\n"
"    normalizedNormalVCVSOutput.z = 1;\n"
"  }}\n"
"\n"
"  //VTK::Light::Impl\n"
"\n"
"  // Discard fully transparent pixels\n"
"  if (gl_FragData[0].a <= 0.0) discard;\n"
"\n"
"#if {UsesGeometryShaders}\n"
"#if {GSOutputMaxVertices} == 3\n"
"  // minimum distance from all primitive edges.\n"
"  float d1 = min(min(primDistanceGSOutput.x, primDistanceGSOutput.y), primDistanceGSOutput.z);\n"
"#if {PatchSize} == 3\n"
"  // minimum distance from all patch edges.\n"
"  float d2 = min(min(patchDistanceGSOutput.x, patchDistanceGSOutput.y), patchDistanceGSOutput.z);\n"
"#elif {PatchSize} == 4\n"
"  // minimum distance from all patch edges.\n"
"  float d2 = min(patchDistanceGSOutput.x, patchDistanceGSOutput.y);\n"
"#endif\n"
"  gl_FragData[0].rgb *= amplify(d1, 40, -0.5) * amplify(d2, 60, -0.5);\n"
"#elif {GSOutputMaxVertices} == 2\n"
"  // minimum distance from two end points of primitive.\n"
"  float d1 = primDistanceGSOutput.x;\n"
"  // minimum distance from two end points of patch.\n"
"  float d2 = patchDistanceGSOutput.x;\n"
"  gl_FragData[0].rgb *= amplify(d1, 40, -0.5) * amplify(d2, 60, -0.5);\n"
"#endif\n"
"#endif\n"
"  //VTK::DepthPeeling::Impl\n"
"  switch (picking_pass)\n"
"  {{\n"
"    case -1:\n"
"      break;\n"
"    case 0: // ACTOR_PASS\n"
"    case 1: // COMPOSITE_INDEX_PASS\n"
"    case 4: // PROCESS_PASS\n"
"      gl_FragData[0].rgb = mapper_idx_components;\n"
"      gl_FragData[0].a = 1.0;\n"
"      break;\n"
"    case 2: // POINT_ID_LOW24\n"
"    case 3: // POINT_ID_HIGH24\n"
"    case 5: // CELL_ID_LOW24\n"
"    case 6: // CELL_ID_HIGH24\n"
"      break;\n"
"    case 7: // CELLGRID_CELL_TYPE_INDEX_PASS\n"
"      gl_FragData[0].rgb = split_integer_components(celltype_idx).rgb;\n"
"      gl_FragData[0].a = 1.0;\n"
"      break;\n"
"    case 8: // CELLGRID_SOURCE_INDEX_PASS\n"
"      if ({DrawingCellsNotSides})\n"
"      {{\n"
"        gl_FragData[0].rgb = vec3(0.0);\n"
"      }}\n"
"      else\n"
"      {{\n"
"        gl_FragData[0].rgb = split_integer_components(sidespec_idx).rgb;\n"
"      }}\n"
"      gl_FragData[0].a = 1.0;\n"
"      break;\n"
"    case 9: // CELLGRID_TUPLE_ID_LOW24\n"
"      gl_FragData[0].rgb = split_integer_components(instanceIdVSOutput).rgb;\n"
"      gl_FragData[0].a = 1.0;\n"
"      break;\n"
"    case 10: // CELLGRID_TUPLE_ID_HIGH24\n"
"      gl_FragData[0].r = split_integer_components(instanceIdVSOutput).a;\n"
"      gl_FragData[0].gba = vec3(0.0, 0.0, 1.0);\n"
"      break;\n"
"    default:\n"
"      break;\n"
"  }}\n"
"}}\n"
"";
