// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
#include "vtkFluidMapperGS.h"

const char *vtkFluidMapperGS =
"//VTK::System::Dec\n"
"\n"
"// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen\n"
"// SPDX-License-Identifier: BSD-3-Clause\n"
"\n"
"// primitiveID\n"
"//VTK::PrimID::Dec\n"
"\n"
"// optional color passed in from the vertex shader, vertexColor\n"
"//VTK::Color::Dec\n"
"\n"
"layout(points) in;\n"
"layout(triangle_strip, max_vertices = 3) out;\n"
"\n"
"uniform int   cameraParallel;\n"
"uniform float particleRadius;\n"
"uniform mat4  VCDCMatrix;\n"
"\n"
"out vec4 vertexVCGSOutput;\n"
"out vec3 centerVCGSOutput;\n"
"\n"
"in vec3 colorVSOut[];\n"
"out vec3 colorVCGSOutput;\n"
"\n"
"// clipping plane vars\n"
"//VTK::Clip::Dec\n"
"\n"
"// picking support\n"
"//VTK::Picking::Dec\n"
"\n"
"void main() {\n"
"    int  i = 0;\n"
"    vec4 offset;\n"
"\n"
"    vec4 base1 = vec4(1.0, 0.0, 0.0, 0.0);\n"
"    vec4 base2 = vec4(0.0, 1.0, 0.0, 0.0);\n"
"\n"
"    // make the triangle face the camera\n"
"    if(cameraParallel == 0) {\n"
"        vec3 dir = normalize(-gl_in[0].gl_Position.xyz);\n"
"        base2 = vec4(normalize(cross(dir, vec3(1.0, 0.0, 0.0))), 0.0);\n"
"        base1 = vec4(cross(base2.xyz, dir), 0.0);\n"
"    }\n"
"\n"
"    //VTK::PrimID::Impl\n"
"\n"
"    //VTK::Clip::Impl\n"
"\n"
"    //VTK::Color::Impl\n"
"\n"
"    centerVCGSOutput = gl_in[0].gl_Position.xyz / gl_in[0].gl_Position.w;\n"
"\n"
"    colorVCGSOutput = colorVSOut[0];\n"
"\n"
"    //VTK::Picking::Impl\n"
"\n"
"    // note 1.73205 = 2.0*cos(30)\n"
"\n"
"    offset           = vec4(-1.73205 * particleRadius, -particleRadius, 0.0, 0.0);\n"
"    vertexVCGSOutput = gl_in[0].gl_Position + offset.x * base1 + offset.y * base2;\n"
"    gl_Position      = VCDCMatrix * vertexVCGSOutput;\n"
"    EmitVertex();\n"
"\n"
"    offset           = vec4(1.73205 * particleRadius, -particleRadius, 0.0, 0.0);\n"
"    vertexVCGSOutput = gl_in[0].gl_Position + offset.x * base1 + offset.y * base2;\n"
"    gl_Position      = VCDCMatrix * vertexVCGSOutput;\n"
"    EmitVertex();\n"
"\n"
"    offset           = vec4(0.0, 2.0 * particleRadius, 0.0, 0.0);\n"
"    vertexVCGSOutput = gl_in[0].gl_Position + offset.x * base1 + offset.y * base2;\n"
"    gl_Position      = VCDCMatrix * vertexVCGSOutput;\n"
"    EmitVertex();\n"
"\n"
"    EndPrimitive();\n"
"}\n"
"";
