// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
#include "vtkPointGaussianGS.h"

const char *vtkPointGaussianGS =
"//VTK::System::Dec\n"
"\n"
"// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen\n"
"// SPDX-License-Identifier: BSD-3-Clause\n"
"// Template for the polydata mappers geometry shader\n"
"\n"
"// primitiveID\n"
"//VTK::PrimID::Dec\n"
"\n"
"// optional color passed in from the vertex shader, vertexColor\n"
"//VTK::Color::Dec\n"
"\n"
"layout(points) in;\n"
"layout(triangle_strip, max_vertices = 4) out;\n"
"\n"
"uniform float boundScale;\n"
"\n"
"in mat2 transformVCVSOutput[];\n"
"out vec2 offsetVCGSOutput;\n"
"\n"
"// clipping plane vars\n"
"//VTK::Clip::Dec\n"
"\n"
"// picking support\n"
"//VTK::Picking::Dec\n"
"\n"
"void main()\n"
"{\n"
"  int i = 0;\n"
"\n"
"  //VTK::PrimID::Impl\n"
"\n"
"  //VTK::Clip::Impl\n"
"\n"
"  //VTK::Color::Impl\n"
"\n"
"  //VTK::Picking::Impl\n"
"\n"
"  vec2 offsets[4] = vec2[](vec2(-boundScale, -boundScale),\n"
"                           vec2(boundScale, -boundScale),\n"
"                           vec2(-boundScale, boundScale),\n"
"                           vec2(boundScale, boundScale));\n"
"\n"
"  vec4 posNDC = gl_in[0].gl_Position;\n"
"  posNDC = posNDC / posNDC.w;\n"
"\n"
"  for (int i = 0; i < 4; i++)\n"
"  {\n"
"    vec2 offset = transformVCVSOutput[0] * offsets[i];\n"
"    offsetVCGSOutput = offsets[i];\n"
"    gl_Position = vec4(posNDC.xy + offset, posNDC.zw);\n"
"    EmitVertex();\n"
"  }\n"
"\n"
"  EndPrimitive();\n"
"}\n"
"";
