// java wrapper for vtkmDataSet object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkmDataSet.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkDataSet_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkmDataSet_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkmDataSet",dType)) { return me; }
  if ((res= vtkDataSet_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkmDataSet_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkmDataSet* op = static_cast<vtkmDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkmDataSet_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkmDataSet* op = static_cast<vtkmDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkmDataSet_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkmDataSet* op = static_cast<vtkmDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkmDataSet_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkmDataSet* op = static_cast<vtkmDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkmDataSet_CopyStructure_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataSet * temp0;
  temp0 = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, id0));

  vtkmDataSet* op = static_cast<vtkmDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyStructure(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkmDataSet_GetNumberOfPoints_15(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkmDataSet* op = static_cast<vtkmDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPoints();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkmDataSet_GetNumberOfCells_16(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkmDataSet* op = static_cast<vtkmDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfCells();
  return temp20;

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkmDataSet_GetPoint_17(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  double * temp20;
  temp0 = id0;

  vtkmDataSet* op = static_cast<vtkmDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPoint(temp0);
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkmDataSet_GetPoint_18(JNIEnv* env, jobject obj,jlong id0,jdoubleArray id1)
{
  long long   temp0;
  double temp1[3];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkmDataSet* op = static_cast<vtkmDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetPoint(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkmDataSet_GetCell_19(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  vtkCell * temp20;
  temp0 = id0;

  vtkmDataSet* op = static_cast<vtkmDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCell(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkmDataSet_GetCell_110(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkGenericCell * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, id1));

  vtkmDataSet* op = static_cast<vtkmDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCell(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkmDataSet_GetCellBounds_111(JNIEnv* env, jobject obj,jlong id0,jdoubleArray id1)
{
  long long   temp0;
  double temp1[6];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 6, &temp1[0]);

  vtkmDataSet* op = static_cast<vtkmDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCellBounds(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 6, &temp1[0]);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkmDataSet_GetCellType_112(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  int   temp20;
  temp0 = id0;

  vtkmDataSet* op = static_cast<vtkmDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellType(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkmDataSet_GetCellPoints_113(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkIdList * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));

  vtkmDataSet* op = static_cast<vtkmDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCellPoints(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkmDataSet_GetPointCells_114(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkIdList * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));

  vtkmDataSet* op = static_cast<vtkmDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetPointCells(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkmDataSet_FindPoint_115(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  long long   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkmDataSet* op = static_cast<vtkmDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FindPoint(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkmDataSet_Squeeze_116(JNIEnv* env, jobject obj)
{

  vtkmDataSet* op = static_cast<vtkmDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->Squeeze();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkmDataSet_ComputeBounds_117(JNIEnv* env, jobject obj)
{

  vtkmDataSet* op = static_cast<vtkmDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeBounds();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkmDataSet_Initialize_118(JNIEnv* env, jobject obj)
{

  vtkmDataSet* op = static_cast<vtkmDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->Initialize();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkmDataSet_GetMaxCellSize_119(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkmDataSet* op = static_cast<vtkmDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaxCellSize();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkmDataSet_GetActualMemorySize_120(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkmDataSet* op = static_cast<vtkmDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetActualMemorySize();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkmDataSet_GetDataObjectType_121(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkmDataSet* op = static_cast<vtkmDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataObjectType();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkmDataSet_ShallowCopy_122(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkmDataSet* op = static_cast<vtkmDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkmDataSet_DeepCopy_123(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkmDataSet* op = static_cast<vtkmDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkmDataSet_GetCell_124(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  vtkCell * temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkmDataSet* op = static_cast<vtkmDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCell(temp0,temp1,temp2);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkmDataSet_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkmDataSet::New());
}
