// java wrapper for vtkPlot3D object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkPlot3D.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkContextItem_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkPlot3D_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkPlot3D",dType)) { return me; }
  if ((res= vtkContextItem_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPlot3D_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPlot3D* op = static_cast<vtkPlot3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPlot3D_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPlot3D* op = static_cast<vtkPlot3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPlot3D_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPlot3D* op = static_cast<vtkPlot3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPlot3D_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPlot3D* op = static_cast<vtkPlot3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlot3D_SetPen_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPen * temp0;
  temp0 = static_cast<vtkPen*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPlot3D* op = static_cast<vtkPlot3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPen(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPlot3D_GetPen_15(JNIEnv* env, jobject obj)
{
  vtkPen * temp20;

  vtkPlot3D* op = static_cast<vtkPlot3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPen();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlot3D_SetSelectionPen_16(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPen * temp0;
  temp0 = static_cast<vtkPen*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPlot3D* op = static_cast<vtkPlot3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSelectionPen(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPlot3D_GetSelectionPen_17(JNIEnv* env, jobject obj)
{
  vtkPen * temp20;

  vtkPlot3D* op = static_cast<vtkPlot3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelectionPen();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlot3D_SetInputData_18(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTable * temp0;
  temp0 = static_cast<vtkTable*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPlot3D* op = static_cast<vtkPlot3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputData(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlot3D_SetInputData_19(JNIEnv* env, jobject obj,jobject id0, jbyteArray id1, jint len1, jbyteArray id2, jint len2, jbyteArray id3, jint len3)
{
  vtkTable * temp0;
  vtkStdString temp1;
  vtkStdString temp2;
  vtkStdString temp3;
  temp0 = static_cast<vtkTable*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = vtkJavaUTF8ToString(env, id1, len1);
  temp2 = vtkJavaUTF8ToString(env, id2, len2);
  temp3 = vtkJavaUTF8ToString(env, id3, len3);

  vtkPlot3D* op = static_cast<vtkPlot3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputData(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlot3D_SetInputData_110(JNIEnv* env, jobject obj,jobject id0, jbyteArray id1, jint len1, jbyteArray id2, jint len2, jbyteArray id3, jint len3, jbyteArray id4, jint len4)
{
  vtkTable * temp0;
  vtkStdString temp1;
  vtkStdString temp2;
  vtkStdString temp3;
  vtkStdString temp4;
  temp0 = static_cast<vtkTable*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = vtkJavaUTF8ToString(env, id1, len1);
  temp2 = vtkJavaUTF8ToString(env, id2, len2);
  temp3 = vtkJavaUTF8ToString(env, id3, len3);
  temp4 = vtkJavaUTF8ToString(env, id4, len4);

  vtkPlot3D* op = static_cast<vtkPlot3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputData(temp0,temp1,temp2,temp3,temp4);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlot3D_SetInputData_111(JNIEnv* env, jobject obj,jobject id0,jlong id1,jlong id2,jlong id3)
{
  vtkTable * temp0;
  long long   temp1;
  long long   temp2;
  long long   temp3;
  temp0 = static_cast<vtkTable*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkPlot3D* op = static_cast<vtkPlot3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputData(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlot3D_SetColors_112(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataArray * temp0;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPlot3D* op = static_cast<vtkPlot3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColors(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPlot3D_GetVTKPoints_113(JNIEnv* env, jobject obj)
{
  vtkPoints * temp20;

  vtkPlot3D* op = static_cast<vtkPlot3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVTKPoints();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPlot3D_GetChart_114(JNIEnv* env, jobject obj)
{
  vtkChartXYZ * temp20;

  vtkPlot3D* op = static_cast<vtkPlot3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetChart();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlot3D_SetChart_115(JNIEnv* env, jobject obj,jobject id0)
{
  vtkChartXYZ * temp0;
  temp0 = static_cast<vtkChartXYZ*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPlot3D* op = static_cast<vtkPlot3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetChart(temp0);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkPlot3D_GetXAxisLabel_116(JNIEnv* env, jobject obj)
{
  std::string   temp20;

  vtkPlot3D* op = static_cast<vtkPlot3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetXAxisLabel();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkPlot3D_GetYAxisLabel_117(JNIEnv* env, jobject obj)
{
  std::string   temp20;

  vtkPlot3D* op = static_cast<vtkPlot3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetYAxisLabel();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkPlot3D_GetZAxisLabel_118(JNIEnv* env, jobject obj)
{
  std::string   temp20;

  vtkPlot3D* op = static_cast<vtkPlot3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetZAxisLabel();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPlot3D_SetSelection_119(JNIEnv* env, jobject obj,jobject id0)
{
  vtkIdTypeArray * temp0;
  temp0 = static_cast<vtkIdTypeArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPlot3D* op = static_cast<vtkPlot3D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSelection(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPlot3D_GetSelection_120(JNIEnv* env, jobject obj)
{
  vtkIdTypeArray * temp20;

  vtkPlot3D* op = static_cast<vtkPlot3D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelection();
  return reinterpret_cast<jlong>(temp20);
}
