// java wrapper for vtkArray object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkArray.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkArray_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkArray",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkArray_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkArray* op = static_cast<vtkArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkArray_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkArray* op = static_cast<vtkArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkArray_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkArray* op = static_cast<vtkArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkArray_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkArray* op = static_cast<vtkArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkArray_CreateArray_14(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  vtkArray * temp20;
  temp0 = id0;
  temp1 = id1;

  vtkArray* op = static_cast<vtkArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CreateArray(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkArray_IsDense_15(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkArray* op = static_cast<vtkArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsDense();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArray_Resize_16(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkArray* op = static_cast<vtkArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->Resize(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArray_Resize_17(JNIEnv* env, jobject obj,jlong id0,jlong id1)
{
  long long   temp0;
  long long   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkArray* op = static_cast<vtkArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->Resize(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArray_Resize_18(JNIEnv* env, jobject obj,jlong id0,jlong id1,jlong id2)
{
  long long   temp0;
  long long   temp1;
  long long   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkArray* op = static_cast<vtkArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->Resize(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkArray_GetDimensions_19(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkArray* op = static_cast<vtkArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDimensions();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkArray_GetSize_110(JNIEnv* env, jobject obj)
{
   unsigned long long   temp20;

  vtkArray* op = static_cast<vtkArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSize();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkArray_GetNonNullSize_111(JNIEnv* env, jobject obj)
{
   unsigned long long   temp20;

  vtkArray* op = static_cast<vtkArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNonNullSize();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArray_SetName_112(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  vtkStdString temp0;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkArray* op = static_cast<vtkArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetName(temp0);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkArray_GetName_113(JNIEnv* env, jobject obj)
{
  vtkStdString   temp20;

  vtkArray* op = static_cast<vtkArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetName();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkArray_SetDimensionLabel_114(JNIEnv* env, jobject obj,jlong id0, jbyteArray id1, jint len1)
{
  long long   temp0;
  vtkStdString temp1;
  temp0 = id0;
  temp1 = vtkJavaUTF8ToString(env, id1, len1);

  vtkArray* op = static_cast<vtkArray*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDimensionLabel(temp0,temp1);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkArray_GetDimensionLabel_115(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  vtkStdString   temp20;
  temp0 = id0;

  vtkArray* op = static_cast<vtkArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDimensionLabel(temp0);
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkArray_DeepCopy_116(JNIEnv* env, jobject obj)
{
  vtkArray * temp20;

  vtkArray* op = static_cast<vtkArray*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->DeepCopy();
  return reinterpret_cast<jlong>(temp20);
}
