// java wrapper for vtkKdNode object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkKdNode.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkKdNode_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkKdNode",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkKdNode_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkKdNode* op = static_cast<vtkKdNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkKdNode_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkKdNode* op = static_cast<vtkKdNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkKdNode_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkKdNode* op = static_cast<vtkKdNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkKdNode_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkKdNode* op = static_cast<vtkKdNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdNode_SetDim_14(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkKdNode* op = static_cast<vtkKdNode*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDim(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkKdNode_GetDim_15(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkKdNode* op = static_cast<vtkKdNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDim();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkKdNode_GetDivisionPosition_16(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkKdNode* op = static_cast<vtkKdNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDivisionPosition();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdNode_SetNumberOfPoints_17(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkKdNode* op = static_cast<vtkKdNode*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfPoints(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkKdNode_GetNumberOfPoints_18(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkKdNode* op = static_cast<vtkKdNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPoints();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdNode_SetBounds_19(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkKdNode* op = static_cast<vtkKdNode*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBounds(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdNode_SetBounds_110(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkKdNode* op = static_cast<vtkKdNode*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBounds(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdNode_SetDataBounds_111(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkKdNode* op = static_cast<vtkKdNode*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataBounds(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkKdNode_GetMinBounds_112(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkKdNode* op = static_cast<vtkKdNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMinBounds();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkKdNode_GetMaxBounds_113(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkKdNode* op = static_cast<vtkKdNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaxBounds();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkKdNode_GetMinDataBounds_114(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkKdNode* op = static_cast<vtkKdNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMinDataBounds();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkKdNode_GetMaxDataBounds_115(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkKdNode* op = static_cast<vtkKdNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaxDataBounds();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdNode_SetID_116(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkKdNode* op = static_cast<vtkKdNode*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetID(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkKdNode_GetID_117(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkKdNode* op = static_cast<vtkKdNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetID();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkKdNode_GetMinID_118(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkKdNode* op = static_cast<vtkKdNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMinID();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkKdNode_GetMaxID_119(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkKdNode* op = static_cast<vtkKdNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaxID();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdNode_SetMinID_120(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkKdNode* op = static_cast<vtkKdNode*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMinID(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdNode_SetMaxID_121(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkKdNode* op = static_cast<vtkKdNode*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaxID(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdNode_AddChildNodes_122(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkKdNode * temp0;
  vtkKdNode * temp1;
  temp0 = static_cast<vtkKdNode*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkKdNode*>(vtkJavaGetPointerFromObject(env, id1));

  vtkKdNode* op = static_cast<vtkKdNode*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddChildNodes(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdNode_DeleteChildNodes_123(JNIEnv* env, jobject obj)
{

  vtkKdNode* op = static_cast<vtkKdNode*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeleteChildNodes();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkKdNode_GetLeft_124(JNIEnv* env, jobject obj)
{
  vtkKdNode * temp20;

  vtkKdNode* op = static_cast<vtkKdNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLeft();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdNode_SetLeft_125(JNIEnv* env, jobject obj,jobject id0)
{
  vtkKdNode * temp0;
  temp0 = static_cast<vtkKdNode*>(vtkJavaGetPointerFromObject(env, id0));

  vtkKdNode* op = static_cast<vtkKdNode*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLeft(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkKdNode_GetRight_126(JNIEnv* env, jobject obj)
{
  vtkKdNode * temp20;

  vtkKdNode* op = static_cast<vtkKdNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRight();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdNode_SetRight_127(JNIEnv* env, jobject obj,jobject id0)
{
  vtkKdNode * temp0;
  temp0 = static_cast<vtkKdNode*>(vtkJavaGetPointerFromObject(env, id0));

  vtkKdNode* op = static_cast<vtkKdNode*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRight(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkKdNode_GetUp_128(JNIEnv* env, jobject obj)
{
  vtkKdNode * temp20;

  vtkKdNode* op = static_cast<vtkKdNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUp();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdNode_SetUp_129(JNIEnv* env, jobject obj,jobject id0)
{
  vtkKdNode * temp0;
  temp0 = static_cast<vtkKdNode*>(vtkJavaGetPointerFromObject(env, id0));

  vtkKdNode* op = static_cast<vtkKdNode*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUp(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkKdNode_IntersectsBox_130(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5,jint id6)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  int   temp6;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;
  temp6 = id6;

  vtkKdNode* op = static_cast<vtkKdNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IntersectsBox(temp0,temp1,temp2,temp3,temp4,temp5,temp6);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkKdNode_IntersectsSphere2_131(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jint id4)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  int   temp4;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;

  vtkKdNode* op = static_cast<vtkKdNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IntersectsSphere2(temp0,temp1,temp2,temp3,temp4);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkKdNode_IntersectsRegion_132(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkPlanesIntersection * temp0;
  int   temp1;
  int   temp20;
  temp0 = static_cast<vtkPlanesIntersection*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkKdNode* op = static_cast<vtkKdNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IntersectsRegion(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkKdNode_ContainsBox_133(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5,jint id6)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  int   temp6;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;
  temp6 = id6;

  vtkKdNode* op = static_cast<vtkKdNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ContainsBox(temp0,temp1,temp2,temp3,temp4,temp5,temp6);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkKdNode_ContainsPoint_134(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jint id3)
{
  double   temp0;
  double   temp1;
  double   temp2;
  int   temp3;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkKdNode* op = static_cast<vtkKdNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ContainsPoint(temp0,temp1,temp2,temp3);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkKdNode_GetDistance2ToBoundary_135(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jint id3)
{
  double   temp0;
  double   temp1;
  double   temp2;
  int   temp3;
  double   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkKdNode* op = static_cast<vtkKdNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDistance2ToBoundary(temp0,temp1,temp2,temp3);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkKdNode_GetDistance2ToInnerBoundary_136(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkKdNode* op = static_cast<vtkKdNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDistance2ToInnerBoundary(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdNode_PrintNode_137(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkKdNode* op = static_cast<vtkKdNode*>(vtkJavaGetPointerFromObject(env, obj));
  op->PrintNode(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdNode_PrintVerboseNode_138(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkKdNode* op = static_cast<vtkKdNode*>(vtkJavaGetPointerFromObject(env, obj));
  op->PrintVerboseNode(temp0);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkKdNode_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkKdNode::New());
}
