// java wrapper for vtkKdTree object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkKdTree.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkLocator_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkKdTree_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkKdTree",dType)) { return me; }
  if ((res= vtkLocator_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkKdTree_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkKdTree_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkKdTree_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkKdTree_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTree_TimingOn_14(JNIEnv* env, jobject obj)
{

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->TimingOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTree_TimingOff_15(JNIEnv* env, jobject obj)
{

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->TimingOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTree_SetTiming_16(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTiming(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkKdTree_GetTiming_17(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTiming();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTree_SetMinCells_18(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMinCells(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkKdTree_GetMinCells_19(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMinCells();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkKdTree_GetNumberOfRegionsOrLess_110(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfRegionsOrLess();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTree_SetNumberOfRegionsOrLess_111(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfRegionsOrLess(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkKdTree_GetNumberOfRegionsOrMore_112(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfRegionsOrMore();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTree_SetNumberOfRegionsOrMore_113(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfRegionsOrMore(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkKdTree_GetFudgeFactor_114(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFudgeFactor();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTree_SetFudgeFactor_115(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFudgeFactor(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkKdTree_GetCuts_116(JNIEnv* env, jobject obj)
{
  vtkBSPCuts * temp20;

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCuts();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTree_SetCuts_117(JNIEnv* env, jobject obj,jobject id0)
{
  vtkBSPCuts * temp0;
  temp0 = static_cast<vtkBSPCuts*>(vtkJavaGetPointerFromObject(env, id0));

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCuts(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTree_OmitXPartitioning_118(JNIEnv* env, jobject obj)
{

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->OmitXPartitioning();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTree_OmitYPartitioning_119(JNIEnv* env, jobject obj)
{

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->OmitYPartitioning();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTree_OmitZPartitioning_120(JNIEnv* env, jobject obj)
{

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->OmitZPartitioning();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTree_OmitXYPartitioning_121(JNIEnv* env, jobject obj)
{

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->OmitXYPartitioning();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTree_OmitYZPartitioning_122(JNIEnv* env, jobject obj)
{

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->OmitYZPartitioning();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTree_OmitZXPartitioning_123(JNIEnv* env, jobject obj)
{

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->OmitZXPartitioning();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTree_OmitNoPartitioning_124(JNIEnv* env, jobject obj)
{

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->OmitNoPartitioning();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTree_SetDataSet_125(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataSet * temp0;
  temp0 = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, id0));

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataSet(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTree_AddDataSet_126(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataSet * temp0;
  temp0 = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, id0));

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddDataSet(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTree_RemoveDataSet_127(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveDataSet(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTree_RemoveDataSet_128(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataSet * temp0;
  temp0 = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, id0));

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveDataSet(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTree_RemoveAllDataSets_129(JNIEnv* env, jobject obj)
{

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveAllDataSets();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkKdTree_GetNumberOfDataSets_130(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfDataSets();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkKdTree_GetDataSet_131(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkDataSet * temp20;
  temp0 = id0;

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataSet(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkKdTree_GetDataSet_132(JNIEnv* env, jobject obj)
{
  vtkDataSet * temp20;

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataSet();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkKdTree_GetDataSets_133(JNIEnv* env, jobject obj)
{
  vtkDataSetCollection * temp20;

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataSets();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkKdTree_GetDataSetIndex_134(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataSet * temp0;
  int   temp20;
  temp0 = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, id0));

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataSetIndex(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkKdTree_GetNumberOfRegions_135(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfRegions();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTree_GetRegionBounds_136(JNIEnv* env, jobject obj,jint id0,jdoubleArray id1)
{
  int   temp0;
  double temp1[6];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 6, &temp1[0]);

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetRegionBounds(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 6, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTree_GetRegionDataBounds_137(JNIEnv* env, jobject obj,jint id0,jdoubleArray id1)
{
  int   temp0;
  double temp1[6];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 6, &temp1[0]);

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetRegionDataBounds(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 6, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTree_PrintTree_138(JNIEnv* env, jobject obj)
{

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->PrintTree();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTree_PrintVerboseTree_139(JNIEnv* env, jobject obj)
{

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->PrintVerboseTree();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTree_PrintRegion_140(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->PrintRegion(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTree_CreateCellLists_141(JNIEnv* env, jobject obj)
{

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->CreateCellLists();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTree_SetIncludeRegionBoundaryCells_142(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIncludeRegionBoundaryCells(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkKdTree_GetIncludeRegionBoundaryCells_143(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIncludeRegionBoundaryCells();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTree_IncludeRegionBoundaryCellsOn_144(JNIEnv* env, jobject obj)
{

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->IncludeRegionBoundaryCellsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTree_IncludeRegionBoundaryCellsOff_145(JNIEnv* env, jobject obj)
{

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->IncludeRegionBoundaryCellsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTree_DeleteCellLists_146(JNIEnv* env, jobject obj)
{

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeleteCellLists();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkKdTree_GetCellList_147(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkIdList * temp20;
  temp0 = id0;

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellList(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkKdTree_GetBoundaryCellList_148(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkIdList * temp20;
  temp0 = id0;

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBoundaryCellList(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkKdTree_GetCellLists_149(JNIEnv* env, jobject obj,jobject id0,jint id1,jobject id2,jobject id3)
{
  vtkIntArray * temp0;
  int   temp1;
  vtkIdList * temp2;
  vtkIdList * temp3;
  long long   temp20;
  temp0 = static_cast<vtkIntArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id2));
  temp3 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id3));

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellLists(temp0,temp1,temp2,temp3);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkKdTree_GetCellLists_150(JNIEnv* env, jobject obj,jobject id0,jobject id1,jobject id2,jobject id3)
{
  vtkIntArray * temp0;
  vtkDataSet * temp1;
  vtkIdList * temp2;
  vtkIdList * temp3;
  long long   temp20;
  temp0 = static_cast<vtkIntArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id2));
  temp3 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id3));

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellLists(temp0,temp1,temp2,temp3);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkKdTree_GetCellLists_151(JNIEnv* env, jobject obj,jobject id0,jobject id1,jobject id2)
{
  vtkIntArray * temp0;
  vtkIdList * temp1;
  vtkIdList * temp2;
  long long   temp20;
  temp0 = static_cast<vtkIntArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id2));

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellLists(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkKdTree_GetRegionContainingCell_152(JNIEnv* env, jobject obj,jobject id0,jlong id1)
{
  vtkDataSet * temp0;
  long long   temp1;
  int   temp20;
  temp0 = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRegionContainingCell(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkKdTree_GetRegionContainingCell_153(JNIEnv* env, jobject obj,jint id0,jlong id1)
{
  int   temp0;
  long long   temp1;
  int   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRegionContainingCell(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkKdTree_GetRegionContainingCell_154(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  int   temp20;
  temp0 = id0;

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRegionContainingCell(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkKdTree_GetRegionContainingPoint_155(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRegionContainingPoint(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTree_BuildLocator_156(JNIEnv* env, jobject obj)
{

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->BuildLocator();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTree_ForceBuildLocator_157(JNIEnv* env, jobject obj)
{

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->ForceBuildLocator();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkKdTree_ViewOrderAllRegionsInDirection_158(JNIEnv* env, jobject obj,jdoubleArray id0,jobject id1)
{
  double temp0[3];
  vtkIntArray * temp1;
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  temp1 = static_cast<vtkIntArray*>(vtkJavaGetPointerFromObject(env, id1));

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ViewOrderAllRegionsInDirection(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkKdTree_ViewOrderRegionsInDirection_159(JNIEnv* env, jobject obj,jobject id0,jdoubleArray id1,jobject id2)
{
  vtkIntArray * temp0;
  double temp1[3];
  vtkIntArray * temp2;
  int   temp20;
  temp0 = static_cast<vtkIntArray*>(vtkJavaGetPointerFromObject(env, id0));
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  temp2 = static_cast<vtkIntArray*>(vtkJavaGetPointerFromObject(env, id2));

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ViewOrderRegionsInDirection(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkKdTree_ViewOrderAllRegionsFromPosition_160(JNIEnv* env, jobject obj,jdoubleArray id0,jobject id1)
{
  double temp0[3];
  vtkIntArray * temp1;
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  temp1 = static_cast<vtkIntArray*>(vtkJavaGetPointerFromObject(env, id1));

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ViewOrderAllRegionsFromPosition(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkKdTree_ViewOrderRegionsFromPosition_161(JNIEnv* env, jobject obj,jobject id0,jdoubleArray id1,jobject id2)
{
  vtkIntArray * temp0;
  double temp1[3];
  vtkIntArray * temp2;
  int   temp20;
  temp0 = static_cast<vtkIntArray*>(vtkJavaGetPointerFromObject(env, id0));
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  temp2 = static_cast<vtkIntArray*>(vtkJavaGetPointerFromObject(env, id2));

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ViewOrderRegionsFromPosition(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTree_BuildLocatorFromPoints_162(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPointSet * temp0;
  temp0 = static_cast<vtkPointSet*>(vtkJavaGetPointerFromObject(env, id0));

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->BuildLocatorFromPoints(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTree_BuildLocatorFromPoints_163(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPoints * temp0;
  temp0 = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, id0));

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->BuildLocatorFromPoints(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkKdTree_BuildMapForDuplicatePoints_164(JNIEnv* env, jobject obj,jfloat id0)
{
  float   temp0;
  vtkIdTypeArray * temp20;
  temp0 = id0;

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->BuildMapForDuplicatePoints(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkKdTree_FindPoint_165(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  long long   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FindPoint(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTree_FindPointsWithinRadius_166(JNIEnv* env, jobject obj,jdouble id0,jdoubleArray id1,jobject id2)
{
  double   temp0;
  double temp1[3];
  vtkIdList * temp2;
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  temp2 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id2));

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->FindPointsWithinRadius(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTree_FindClosestNPoints_167(JNIEnv* env, jobject obj,jint id0,jdoubleArray id1,jobject id2)
{
  int   temp0;
  double temp1[3];
  vtkIdList * temp2;
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  temp2 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id2));

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->FindClosestNPoints(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkKdTree_GetPointsInRegion_168(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkIdTypeArray * temp20;
  temp0 = id0;

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointsInRegion(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTree_FreeSearchStructure_169(JNIEnv* env, jobject obj)
{

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->FreeSearchStructure();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTree_GenerateRepresentation_170(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkPolyData * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, id1));

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateRepresentation(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTree_GenerateRepresentationUsingDataBoundsOn_171(JNIEnv* env, jobject obj)
{

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateRepresentationUsingDataBoundsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTree_GenerateRepresentationUsingDataBoundsOff_172(JNIEnv* env, jobject obj)
{

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateRepresentationUsingDataBoundsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTree_SetGenerateRepresentationUsingDataBounds_173(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGenerateRepresentationUsingDataBounds(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkKdTree_GetGenerateRepresentationUsingDataBounds_174(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGenerateRepresentationUsingDataBounds();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkKdTree_NewGeometry_175(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->NewGeometry();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTree_InvalidateGeometry_176(JNIEnv* env, jobject obj)
{

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->InvalidateGeometry();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkKdTree_CopyTree_177(JNIEnv* env, jobject obj,jobject id0)
{
  vtkKdNode * temp0;
  vtkKdNode * temp20;
  temp0 = static_cast<vtkKdNode*>(vtkJavaGetPointerFromObject(env, id0));

  vtkKdTree* op = static_cast<vtkKdTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CopyTree(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkKdTree_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkKdTree::New());
}
