// java wrapper for vtkKdTreePointLocator object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkKdTreePointLocator.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkAbstractPointLocator_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkKdTreePointLocator_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkKdTreePointLocator",dType)) { return me; }
  if ((res= vtkAbstractPointLocator_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkKdTreePointLocator_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkKdTreePointLocator* op = static_cast<vtkKdTreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkKdTreePointLocator_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkKdTreePointLocator* op = static_cast<vtkKdTreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkKdTreePointLocator_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkKdTreePointLocator* op = static_cast<vtkKdTreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkKdTreePointLocator_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkKdTreePointLocator* op = static_cast<vtkKdTreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkKdTreePointLocator_FindClosestPoint_14(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  long long   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkKdTreePointLocator* op = static_cast<vtkKdTreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FindClosestPoint(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTreePointLocator_FindClosestNPoints_15(JNIEnv* env, jobject obj,jint id0,jdoubleArray id1,jobject id2)
{
  int   temp0;
  double temp1[3];
  vtkIdList * temp2;
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  temp2 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id2));

  vtkKdTreePointLocator* op = static_cast<vtkKdTreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->FindClosestNPoints(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTreePointLocator_FindPointsWithinRadius_16(JNIEnv* env, jobject obj,jdouble id0,jdoubleArray id1,jobject id2)
{
  double   temp0;
  double temp1[3];
  vtkIdList * temp2;
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  temp2 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id2));

  vtkKdTreePointLocator* op = static_cast<vtkKdTreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->FindPointsWithinRadius(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTreePointLocator_FreeSearchStructure_17(JNIEnv* env, jobject obj)
{

  vtkKdTreePointLocator* op = static_cast<vtkKdTreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->FreeSearchStructure();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTreePointLocator_BuildLocator_18(JNIEnv* env, jobject obj)
{

  vtkKdTreePointLocator* op = static_cast<vtkKdTreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->BuildLocator();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTreePointLocator_ForceBuildLocator_19(JNIEnv* env, jobject obj)
{

  vtkKdTreePointLocator* op = static_cast<vtkKdTreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->ForceBuildLocator();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkKdTreePointLocator_GenerateRepresentation_110(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkPolyData * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, id1));

  vtkKdTreePointLocator* op = static_cast<vtkKdTreePointLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateRepresentation(temp0,temp1);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkKdTreePointLocator_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkKdTreePointLocator::New());
}
