// java wrapper for vtkHomogeneousTransform object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkHomogeneousTransform.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkAbstractTransform_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkHomogeneousTransform_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkHomogeneousTransform",dType)) { return me; }
  if ((res= vtkAbstractTransform_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHomogeneousTransform_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHomogeneousTransform* op = static_cast<vtkHomogeneousTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHomogeneousTransform_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHomogeneousTransform* op = static_cast<vtkHomogeneousTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHomogeneousTransform_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHomogeneousTransform* op = static_cast<vtkHomogeneousTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHomogeneousTransform_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHomogeneousTransform* op = static_cast<vtkHomogeneousTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHomogeneousTransform_TransformPoints_14(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkPoints * temp0;
  vtkPoints * temp1;
  temp0 = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, id1));

  vtkHomogeneousTransform* op = static_cast<vtkHomogeneousTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->TransformPoints(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHomogeneousTransform_GetMatrix_15(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMatrix4x4 * temp0;
  temp0 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id0));

  vtkHomogeneousTransform* op = static_cast<vtkHomogeneousTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetMatrix(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHomogeneousTransform_GetMatrix_16(JNIEnv* env, jobject obj)
{
  vtkMatrix4x4 * temp20;

  vtkHomogeneousTransform* op = static_cast<vtkHomogeneousTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMatrix();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHomogeneousTransform_GetHomogeneousInverse_17(JNIEnv* env, jobject obj)
{
  vtkHomogeneousTransform * temp20;

  vtkHomogeneousTransform* op = static_cast<vtkHomogeneousTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHomogeneousInverse();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHomogeneousTransform_InternalTransformPoint_18(JNIEnv* env, jobject obj,jfloatArray id0,jfloatArray id1)
{
  float temp0[3];
  float temp1[3];
  env->GetFloatArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetFloatArrayRegion(id1, 0, 3, &temp1[0]);

  vtkHomogeneousTransform* op = static_cast<vtkHomogeneousTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->InternalTransformPoint(temp0,temp1);
  env->SetFloatArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHomogeneousTransform_InternalTransformPoint_19(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkHomogeneousTransform* op = static_cast<vtkHomogeneousTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->InternalTransformPoint(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}
