// java wrapper for vtkCleanPolyData object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkCleanPolyData.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkPolyDataAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkCleanPolyData_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkCleanPolyData",dType)) { return me; }
  if ((res= vtkPolyDataAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCleanPolyData_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCleanPolyData* op = static_cast<vtkCleanPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCleanPolyData_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCleanPolyData* op = static_cast<vtkCleanPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCleanPolyData_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCleanPolyData* op = static_cast<vtkCleanPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCleanPolyData_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCleanPolyData* op = static_cast<vtkCleanPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCleanPolyData_SetToleranceIsAbsolute_14(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCleanPolyData* op = static_cast<vtkCleanPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetToleranceIsAbsolute(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCleanPolyData_ToleranceIsAbsoluteOn_15(JNIEnv* env, jobject obj)
{

  vtkCleanPolyData* op = static_cast<vtkCleanPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->ToleranceIsAbsoluteOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCleanPolyData_ToleranceIsAbsoluteOff_16(JNIEnv* env, jobject obj)
{

  vtkCleanPolyData* op = static_cast<vtkCleanPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->ToleranceIsAbsoluteOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCleanPolyData_GetToleranceIsAbsolute_17(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCleanPolyData* op = static_cast<vtkCleanPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetToleranceIsAbsolute();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCleanPolyData_SetTolerance_18(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkCleanPolyData* op = static_cast<vtkCleanPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTolerance(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCleanPolyData_GetToleranceMinValue_19(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkCleanPolyData* op = static_cast<vtkCleanPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetToleranceMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCleanPolyData_GetToleranceMaxValue_110(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkCleanPolyData* op = static_cast<vtkCleanPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetToleranceMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCleanPolyData_GetTolerance_111(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkCleanPolyData* op = static_cast<vtkCleanPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTolerance();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCleanPolyData_SetAbsoluteTolerance_112(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkCleanPolyData* op = static_cast<vtkCleanPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAbsoluteTolerance(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCleanPolyData_GetAbsoluteToleranceMinValue_113(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkCleanPolyData* op = static_cast<vtkCleanPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAbsoluteToleranceMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCleanPolyData_GetAbsoluteToleranceMaxValue_114(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkCleanPolyData* op = static_cast<vtkCleanPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAbsoluteToleranceMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCleanPolyData_GetAbsoluteTolerance_115(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkCleanPolyData* op = static_cast<vtkCleanPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAbsoluteTolerance();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCleanPolyData_SetConvertLinesToPoints_116(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCleanPolyData* op = static_cast<vtkCleanPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetConvertLinesToPoints(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCleanPolyData_ConvertLinesToPointsOn_117(JNIEnv* env, jobject obj)
{

  vtkCleanPolyData* op = static_cast<vtkCleanPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->ConvertLinesToPointsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCleanPolyData_ConvertLinesToPointsOff_118(JNIEnv* env, jobject obj)
{

  vtkCleanPolyData* op = static_cast<vtkCleanPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->ConvertLinesToPointsOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCleanPolyData_GetConvertLinesToPoints_119(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCleanPolyData* op = static_cast<vtkCleanPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetConvertLinesToPoints();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCleanPolyData_SetConvertPolysToLines_120(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCleanPolyData* op = static_cast<vtkCleanPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetConvertPolysToLines(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCleanPolyData_ConvertPolysToLinesOn_121(JNIEnv* env, jobject obj)
{

  vtkCleanPolyData* op = static_cast<vtkCleanPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->ConvertPolysToLinesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCleanPolyData_ConvertPolysToLinesOff_122(JNIEnv* env, jobject obj)
{

  vtkCleanPolyData* op = static_cast<vtkCleanPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->ConvertPolysToLinesOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCleanPolyData_GetConvertPolysToLines_123(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCleanPolyData* op = static_cast<vtkCleanPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetConvertPolysToLines();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCleanPolyData_SetConvertStripsToPolys_124(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCleanPolyData* op = static_cast<vtkCleanPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetConvertStripsToPolys(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCleanPolyData_ConvertStripsToPolysOn_125(JNIEnv* env, jobject obj)
{

  vtkCleanPolyData* op = static_cast<vtkCleanPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->ConvertStripsToPolysOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCleanPolyData_ConvertStripsToPolysOff_126(JNIEnv* env, jobject obj)
{

  vtkCleanPolyData* op = static_cast<vtkCleanPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->ConvertStripsToPolysOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCleanPolyData_GetConvertStripsToPolys_127(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCleanPolyData* op = static_cast<vtkCleanPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetConvertStripsToPolys();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCleanPolyData_SetPointMerging_128(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCleanPolyData* op = static_cast<vtkCleanPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPointMerging(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCleanPolyData_GetPointMerging_129(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCleanPolyData* op = static_cast<vtkCleanPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointMerging();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCleanPolyData_PointMergingOn_130(JNIEnv* env, jobject obj)
{

  vtkCleanPolyData* op = static_cast<vtkCleanPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->PointMergingOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCleanPolyData_PointMergingOff_131(JNIEnv* env, jobject obj)
{

  vtkCleanPolyData* op = static_cast<vtkCleanPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->PointMergingOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCleanPolyData_SetLocator_132(JNIEnv* env, jobject obj,jobject id0)
{
  vtkIncrementalPointLocator * temp0;
  temp0 = static_cast<vtkIncrementalPointLocator*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCleanPolyData* op = static_cast<vtkCleanPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLocator(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCleanPolyData_GetLocator_133(JNIEnv* env, jobject obj)
{
  vtkIncrementalPointLocator * temp20;

  vtkCleanPolyData* op = static_cast<vtkCleanPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLocator();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCleanPolyData_CreateDefaultLocator_134(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPolyData * temp0;
  temp0 = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCleanPolyData* op = static_cast<vtkCleanPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->CreateDefaultLocator(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCleanPolyData_ReleaseLocator_135(JNIEnv* env, jobject obj)
{

  vtkCleanPolyData* op = static_cast<vtkCleanPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseLocator();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCleanPolyData_GetMTime_136(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkCleanPolyData* op = static_cast<vtkCleanPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCleanPolyData_OperateOnPoint_137(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkCleanPolyData* op = static_cast<vtkCleanPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->OperateOnPoint(temp0,temp1);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCleanPolyData_OperateOnBounds_138(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[6];
  double temp1[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 6, &temp1[0]);

  vtkCleanPolyData* op = static_cast<vtkCleanPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->OperateOnBounds(temp0,temp1);
  env->SetDoubleArrayRegion(id0, 0, 6, &temp0[0]);
  env->SetDoubleArrayRegion(id1, 0, 6, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCleanPolyData_SetPieceInvariant_139(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCleanPolyData* op = static_cast<vtkCleanPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPieceInvariant(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCleanPolyData_GetPieceInvariant_140(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCleanPolyData* op = static_cast<vtkCleanPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPieceInvariant();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCleanPolyData_PieceInvariantOn_141(JNIEnv* env, jobject obj)
{

  vtkCleanPolyData* op = static_cast<vtkCleanPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->PieceInvariantOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCleanPolyData_PieceInvariantOff_142(JNIEnv* env, jobject obj)
{

  vtkCleanPolyData* op = static_cast<vtkCleanPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->PieceInvariantOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCleanPolyData_SetOutputPointsPrecision_143(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCleanPolyData* op = static_cast<vtkCleanPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputPointsPrecision(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCleanPolyData_GetOutputPointsPrecision_144(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCleanPolyData* op = static_cast<vtkCleanPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutputPointsPrecision();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkCleanPolyData_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkCleanPolyData::New());
}
