// java wrapper for vtkCutter object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkCutter.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkPolyDataAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkCutter_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkCutter",dType)) { return me; }
  if ((res= vtkPolyDataAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCutter_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCutter* op = static_cast<vtkCutter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCutter_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCutter* op = static_cast<vtkCutter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCutter_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCutter* op = static_cast<vtkCutter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCutter_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCutter* op = static_cast<vtkCutter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCutter_SetValue_14(JNIEnv* env, jobject obj,jint id0,jdouble id1)
{
  int   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkCutter* op = static_cast<vtkCutter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetValue(temp0,temp1);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCutter_GetValue_15(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  double   temp20;
  temp0 = id0;

  vtkCutter* op = static_cast<vtkCutter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetValue(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCutter_SetNumberOfContours_16(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCutter* op = static_cast<vtkCutter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfContours(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCutter_GetNumberOfContours_17(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkCutter* op = static_cast<vtkCutter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfContours();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCutter_GenerateValues_18(JNIEnv* env, jobject obj,jint id0,jdoubleArray id1)
{
  int   temp0;
  double temp1[2];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 2, &temp1[0]);

  vtkCutter* op = static_cast<vtkCutter*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateValues(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 2, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCutter_GenerateValues_19(JNIEnv* env, jobject obj,jint id0,jdouble id1,jdouble id2)
{
  int   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkCutter* op = static_cast<vtkCutter*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateValues(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCutter_GetMTime_110(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkCutter* op = static_cast<vtkCutter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCutter_SetCutFunction_111(JNIEnv* env, jobject obj,jobject id0)
{
  vtkImplicitFunction * temp0;
  temp0 = static_cast<vtkImplicitFunction*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCutter* op = static_cast<vtkCutter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCutFunction(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCutter_GetCutFunction_112(JNIEnv* env, jobject obj)
{
  vtkImplicitFunction * temp20;

  vtkCutter* op = static_cast<vtkCutter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCutFunction();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCutter_SetGenerateCutScalars_113(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCutter* op = static_cast<vtkCutter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGenerateCutScalars(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCutter_GetGenerateCutScalars_114(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCutter* op = static_cast<vtkCutter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGenerateCutScalars();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCutter_GenerateCutScalarsOn_115(JNIEnv* env, jobject obj)
{

  vtkCutter* op = static_cast<vtkCutter*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateCutScalarsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCutter_GenerateCutScalarsOff_116(JNIEnv* env, jobject obj)
{

  vtkCutter* op = static_cast<vtkCutter*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateCutScalarsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCutter_SetGenerateTriangles_117(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCutter* op = static_cast<vtkCutter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGenerateTriangles(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCutter_GetGenerateTriangles_118(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCutter* op = static_cast<vtkCutter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGenerateTriangles();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCutter_GenerateTrianglesOn_119(JNIEnv* env, jobject obj)
{

  vtkCutter* op = static_cast<vtkCutter*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateTrianglesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCutter_GenerateTrianglesOff_120(JNIEnv* env, jobject obj)
{

  vtkCutter* op = static_cast<vtkCutter*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateTrianglesOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCutter_SetLocator_121(JNIEnv* env, jobject obj,jobject id0)
{
  vtkIncrementalPointLocator * temp0;
  temp0 = static_cast<vtkIncrementalPointLocator*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCutter* op = static_cast<vtkCutter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLocator(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCutter_GetLocator_122(JNIEnv* env, jobject obj)
{
  vtkIncrementalPointLocator * temp20;

  vtkCutter* op = static_cast<vtkCutter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLocator();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCutter_SetSortBy_123(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCutter* op = static_cast<vtkCutter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSortBy(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCutter_GetSortByMinValue_124(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCutter* op = static_cast<vtkCutter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSortByMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCutter_GetSortByMaxValue_125(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCutter* op = static_cast<vtkCutter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSortByMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCutter_GetSortBy_126(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCutter* op = static_cast<vtkCutter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSortBy();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCutter_SetSortByToSortByValue_127(JNIEnv* env, jobject obj)
{

  vtkCutter* op = static_cast<vtkCutter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSortByToSortByValue();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCutter_SetSortByToSortByCell_128(JNIEnv* env, jobject obj)
{

  vtkCutter* op = static_cast<vtkCutter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSortByToSortByCell();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkCutter_GetSortByAsString_129(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkCutter* op = static_cast<vtkCutter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSortByAsString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCutter_CreateDefaultLocator_130(JNIEnv* env, jobject obj)
{

  vtkCutter* op = static_cast<vtkCutter*>(vtkJavaGetPointerFromObject(env, obj));
  op->CreateDefaultLocator();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCutter_SetOutputPointsPrecision_131(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCutter* op = static_cast<vtkCutter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputPointsPrecision(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCutter_GetOutputPointsPrecisionMinValue_132(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCutter* op = static_cast<vtkCutter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutputPointsPrecisionMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCutter_GetOutputPointsPrecisionMaxValue_133(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCutter* op = static_cast<vtkCutter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutputPointsPrecisionMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCutter_GetOutputPointsPrecision_134(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCutter* op = static_cast<vtkCutter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutputPointsPrecision();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkCutter_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkCutter::New());
}
