// java wrapper for vtkAxes object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkAxes.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkPolyDataAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkAxes_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkAxes",dType)) { return me; }
  if ((res= vtkPolyDataAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxes_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAxes* op = static_cast<vtkAxes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxes_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAxes* op = static_cast<vtkAxes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAxes_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAxes* op = static_cast<vtkAxes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAxes_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAxes* op = static_cast<vtkAxes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxes_SetOrigin_14(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkAxes* op = static_cast<vtkAxes*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOrigin(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxes_SetOrigin_15(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkAxes* op = static_cast<vtkAxes*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOrigin(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkAxes_GetOrigin_16(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkAxes* op = static_cast<vtkAxes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOrigin();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxes_SetScaleFactor_17(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkAxes* op = static_cast<vtkAxes*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScaleFactor(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAxes_GetScaleFactor_18(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkAxes* op = static_cast<vtkAxes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScaleFactor();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxes_SetSymmetric_19(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkAxes* op = static_cast<vtkAxes*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSymmetric(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxes_GetSymmetric_110(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxes* op = static_cast<vtkAxes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSymmetric();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxes_SymmetricOn_111(JNIEnv* env, jobject obj)
{

  vtkAxes* op = static_cast<vtkAxes*>(vtkJavaGetPointerFromObject(env, obj));
  op->SymmetricOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxes_SymmetricOff_112(JNIEnv* env, jobject obj)
{

  vtkAxes* op = static_cast<vtkAxes*>(vtkJavaGetPointerFromObject(env, obj));
  op->SymmetricOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxes_SetComputeNormals_113(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkAxes* op = static_cast<vtkAxes*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetComputeNormals(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAxes_GetComputeNormals_114(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAxes* op = static_cast<vtkAxes*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetComputeNormals();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxes_ComputeNormalsOn_115(JNIEnv* env, jobject obj)
{

  vtkAxes* op = static_cast<vtkAxes*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeNormalsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAxes_ComputeNormalsOff_116(JNIEnv* env, jobject obj)
{

  vtkAxes* op = static_cast<vtkAxes*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeNormalsOff();

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkAxes_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkAxes::New());
}
