// java wrapper for vtkPointSource object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkPointSource.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkPolyDataAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkPointSource_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkPointSource",dType)) { return me; }
  if ((res= vtkPolyDataAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPointSource_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPointSource* op = static_cast<vtkPointSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPointSource_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPointSource* op = static_cast<vtkPointSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPointSource_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPointSource* op = static_cast<vtkPointSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPointSource_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPointSource* op = static_cast<vtkPointSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointSource_SetNumberOfPoints_14(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkPointSource* op = static_cast<vtkPointSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfPoints(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPointSource_GetNumberOfPointsMinValue_15(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkPointSource* op = static_cast<vtkPointSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPointsMinValue();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPointSource_GetNumberOfPointsMaxValue_16(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkPointSource* op = static_cast<vtkPointSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPointsMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPointSource_GetNumberOfPoints_17(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkPointSource* op = static_cast<vtkPointSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPoints();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointSource_SetCenter_18(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkPointSource* op = static_cast<vtkPointSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCenter(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointSource_SetCenter_19(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkPointSource* op = static_cast<vtkPointSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCenter(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkPointSource_GetCenter_110(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkPointSource* op = static_cast<vtkPointSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCenter();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointSource_SetRadius_111(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkPointSource* op = static_cast<vtkPointSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRadius(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPointSource_GetRadiusMinValue_112(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPointSource* op = static_cast<vtkPointSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRadiusMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPointSource_GetRadiusMaxValue_113(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPointSource* op = static_cast<vtkPointSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRadiusMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPointSource_GetRadius_114(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPointSource* op = static_cast<vtkPointSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRadius();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointSource_SetDistribution_115(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkPointSource* op = static_cast<vtkPointSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDistribution(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPointSource_GetDistributionMinValue_116(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPointSource* op = static_cast<vtkPointSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDistributionMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPointSource_GetDistributionMaxValue_117(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPointSource* op = static_cast<vtkPointSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDistributionMaxValue();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointSource_SetDistributionToShell_118(JNIEnv* env, jobject obj)
{

  vtkPointSource* op = static_cast<vtkPointSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDistributionToShell();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointSource_SetDistributionToUniform_119(JNIEnv* env, jobject obj)
{

  vtkPointSource* op = static_cast<vtkPointSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDistributionToUniform();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointSource_SetDistributionToExponential_120(JNIEnv* env, jobject obj)
{

  vtkPointSource* op = static_cast<vtkPointSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDistributionToExponential();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPointSource_GetDistribution_121(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPointSource* op = static_cast<vtkPointSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDistribution();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointSource_SetLambda_122(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkPointSource* op = static_cast<vtkPointSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLambda(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkPointSource_GetLambda_123(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkPointSource* op = static_cast<vtkPointSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLambda();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointSource_SetOutputPointsPrecision_124(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkPointSource* op = static_cast<vtkPointSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutputPointsPrecision(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPointSource_GetOutputPointsPrecision_125(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPointSource* op = static_cast<vtkPointSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutputPointsPrecision();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPointSource_SetRandomSequence_126(JNIEnv* env, jobject obj,jobject id0)
{
  vtkRandomSequence * temp0;
  temp0 = static_cast<vtkRandomSequence*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPointSource* op = static_cast<vtkPointSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRandomSequence(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPointSource_GetRandomSequence_127(JNIEnv* env, jobject obj)
{
  vtkRandomSequence * temp20;

  vtkPointSource* op = static_cast<vtkPointSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRandomSequence();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkPointSource_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkPointSource::New());
}
