// java wrapper for vtkMNITransformReader object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkMNITransformReader.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkMNITransformReader_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkMNITransformReader",dType)) { return me; }
  if ((res= vtkAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMNITransformReader_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMNITransformReader* op = static_cast<vtkMNITransformReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMNITransformReader_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMNITransformReader* op = static_cast<vtkMNITransformReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMNITransformReader_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMNITransformReader* op = static_cast<vtkMNITransformReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMNITransformReader_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMNITransformReader* op = static_cast<vtkMNITransformReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMNITransformReader_SetFileName_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMNITransformReader* op = static_cast<vtkMNITransformReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMNITransformReader_GetFileName_15(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkMNITransformReader* op = static_cast<vtkMNITransformReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMNITransformReader_GetFileExtensions_16(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkMNITransformReader* op = static_cast<vtkMNITransformReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileExtensions();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMNITransformReader_GetDescriptiveName_17(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkMNITransformReader* op = static_cast<vtkMNITransformReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDescriptiveName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMNITransformReader_CanReadFile_18(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMNITransformReader* op = static_cast<vtkMNITransformReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CanReadFile(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMNITransformReader_GetNumberOfTransforms_19(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkMNITransformReader* op = static_cast<vtkMNITransformReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfTransforms();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMNITransformReader_GetNthTransform_110(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkAbstractTransform * temp20;
  temp0 = id0;

  vtkMNITransformReader* op = static_cast<vtkMNITransformReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNthTransform(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMNITransformReader_GetTransform_111(JNIEnv* env, jobject obj)
{
  vtkAbstractTransform * temp20;

  vtkMNITransformReader* op = static_cast<vtkMNITransformReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTransform();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMNITransformReader_GetComments_112(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkMNITransformReader* op = static_cast<vtkMNITransformReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetComments();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkMNITransformReader_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkMNITransformReader::New());
}
