// java wrapper for vtkExtractVOI object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkExtractVOI.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkImageAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkExtractVOI_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkExtractVOI",dType)) { return me; }
  if ((res= vtkImageAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExtractVOI_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkExtractVOI* op = static_cast<vtkExtractVOI*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExtractVOI_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkExtractVOI* op = static_cast<vtkExtractVOI*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkExtractVOI_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkExtractVOI* op = static_cast<vtkExtractVOI*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkExtractVOI_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkExtractVOI* op = static_cast<vtkExtractVOI*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExtractVOI_SetVOI_14(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jint id4,jint id5)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  int   temp4;
  int   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkExtractVOI* op = static_cast<vtkExtractVOI*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVOI(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExtractVOI_SetVOI_15(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[6];
  env->GetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));

  vtkExtractVOI* op = static_cast<vtkExtractVOI*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVOI(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkExtractVOI_GetVOI_16(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkExtractVOI* op = static_cast<vtkExtractVOI*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVOI();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExtractVOI_SetSampleRate_17(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkExtractVOI* op = static_cast<vtkExtractVOI*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSampleRate(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExtractVOI_SetSampleRate_18(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[3];
  env->GetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

  vtkExtractVOI* op = static_cast<vtkExtractVOI*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSampleRate(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkExtractVOI_GetSampleRate_19(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkExtractVOI* op = static_cast<vtkExtractVOI*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSampleRate();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExtractVOI_SetIncludeBoundary_110(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkExtractVOI* op = static_cast<vtkExtractVOI*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIncludeBoundary(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExtractVOI_GetIncludeBoundary_111(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkExtractVOI* op = static_cast<vtkExtractVOI*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIncludeBoundary();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExtractVOI_IncludeBoundaryOn_112(JNIEnv* env, jobject obj)
{

  vtkExtractVOI* op = static_cast<vtkExtractVOI*>(vtkJavaGetPointerFromObject(env, obj));
  op->IncludeBoundaryOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExtractVOI_IncludeBoundaryOff_113(JNIEnv* env, jobject obj)
{

  vtkExtractVOI* op = static_cast<vtkExtractVOI*>(vtkJavaGetPointerFromObject(env, obj));
  op->IncludeBoundaryOff();

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkExtractVOI_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkExtractVOI::New());
}
