// java wrapper for vtkImagePlaneWidget object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkImagePlaneWidget.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkPolyDataSourceWidget_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkImagePlaneWidget_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkImagePlaneWidget",dType)) { return me; }
  if ((res= vtkPolyDataSourceWidget_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImagePlaneWidget_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImagePlaneWidget_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImagePlaneWidget_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImagePlaneWidget_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_SetEnabled_14(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEnabled(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_PlaceWidget_15(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->PlaceWidget(temp0);
  env->SetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_PlaceWidget_16(JNIEnv* env, jobject obj)
{

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->PlaceWidget();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_PlaceWidget_17(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->PlaceWidget(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_SetInputConnection_18(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAlgorithmOutput * temp0;
  temp0 = static_cast<vtkAlgorithmOutput*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputConnection(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_SetOrigin_19(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOrigin(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_SetOrigin_110(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOrigin(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkImagePlaneWidget_GetOrigin_111(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOrigin();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_GetOrigin_112(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetOrigin(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_SetPoint1_113(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPoint1(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_SetPoint1_114(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPoint1(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkImagePlaneWidget_GetPoint1_115(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPoint1();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_GetPoint1_116(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetPoint1(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_SetPoint2_117(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPoint2(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_SetPoint2_118(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPoint2(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkImagePlaneWidget_GetPoint2_119(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPoint2();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_GetPoint2_120(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetPoint2(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkImagePlaneWidget_GetCenter_121(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCenter();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_GetCenter_122(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCenter(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkImagePlaneWidget_GetNormal_123(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNormal();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_GetNormal_124(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetNormal(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_GetVector1_125(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetVector1(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_GetVector2_126(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetVector2(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImagePlaneWidget_GetSliceIndex_127(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSliceIndex();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_SetSliceIndex_128(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSliceIndex(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImagePlaneWidget_GetSlicePosition_129(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSlicePosition();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_SetSlicePosition_130(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSlicePosition(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_SetResliceInterpolate_131(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetResliceInterpolate(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImagePlaneWidget_GetResliceInterpolate_132(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetResliceInterpolate();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_SetResliceInterpolateToNearestNeighbour_133(JNIEnv* env, jobject obj)
{

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetResliceInterpolateToNearestNeighbour();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_SetResliceInterpolateToLinear_134(JNIEnv* env, jobject obj)
{

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetResliceInterpolateToLinear();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_SetResliceInterpolateToCubic_135(JNIEnv* env, jobject obj)
{

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetResliceInterpolateToCubic();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImagePlaneWidget_GetResliceOutput_136(JNIEnv* env, jobject obj)
{
  vtkImageData * temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetResliceOutput();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_SetRestrictPlaneToVolume_137(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRestrictPlaneToVolume(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImagePlaneWidget_GetRestrictPlaneToVolume_138(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRestrictPlaneToVolume();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_RestrictPlaneToVolumeOn_139(JNIEnv* env, jobject obj)
{

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->RestrictPlaneToVolumeOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_RestrictPlaneToVolumeOff_140(JNIEnv* env, jobject obj)
{

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->RestrictPlaneToVolumeOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_SetUserControlledLookupTable_141(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUserControlledLookupTable(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImagePlaneWidget_GetUserControlledLookupTable_142(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUserControlledLookupTable();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_UserControlledLookupTableOn_143(JNIEnv* env, jobject obj)
{

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->UserControlledLookupTableOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_UserControlledLookupTableOff_144(JNIEnv* env, jobject obj)
{

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->UserControlledLookupTableOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_SetTextureInterpolate_145(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTextureInterpolate(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImagePlaneWidget_GetTextureInterpolate_146(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTextureInterpolate();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_TextureInterpolateOn_147(JNIEnv* env, jobject obj)
{

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->TextureInterpolateOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_TextureInterpolateOff_148(JNIEnv* env, jobject obj)
{

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->TextureInterpolateOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_SetTextureVisibility_149(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTextureVisibility(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImagePlaneWidget_GetTextureVisibility_150(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTextureVisibility();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_TextureVisibilityOn_151(JNIEnv* env, jobject obj)
{

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->TextureVisibilityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_TextureVisibilityOff_152(JNIEnv* env, jobject obj)
{

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->TextureVisibilityOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_GetPolyData_153(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPolyData * temp0;
  temp0 = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetPolyData(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImagePlaneWidget_GetPolyDataAlgorithm_154(JNIEnv* env, jobject obj)
{
  vtkPolyDataAlgorithm * temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPolyDataAlgorithm();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_UpdatePlacement_155(JNIEnv* env, jobject obj)
{

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->UpdatePlacement();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImagePlaneWidget_GetTexture_156(JNIEnv* env, jobject obj)
{
  vtkTexture * temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTexture();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImagePlaneWidget_GetColorMap_157(JNIEnv* env, jobject obj)
{
  vtkImageMapToColors * temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetColorMap();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_SetColorMap_158(JNIEnv* env, jobject obj,jobject id0)
{
  vtkImageMapToColors * temp0;
  temp0 = static_cast<vtkImageMapToColors*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColorMap(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_SetPlaneProperty_159(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProperty * temp0;
  temp0 = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPlaneProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImagePlaneWidget_GetPlaneProperty_160(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPlaneProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_SetSelectedPlaneProperty_161(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProperty * temp0;
  temp0 = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSelectedPlaneProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImagePlaneWidget_GetSelectedPlaneProperty_162(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelectedPlaneProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_SetPlaneOrientation_163(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPlaneOrientation(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImagePlaneWidget_GetPlaneOrientation_164(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPlaneOrientation();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_SetPlaneOrientationToXAxes_165(JNIEnv* env, jobject obj)
{

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPlaneOrientationToXAxes();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_SetPlaneOrientationToYAxes_166(JNIEnv* env, jobject obj)
{

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPlaneOrientationToYAxes();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_SetPlaneOrientationToZAxes_167(JNIEnv* env, jobject obj)
{

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPlaneOrientationToZAxes();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_SetPicker_168(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractPropPicker * temp0;
  temp0 = static_cast<vtkAbstractPropPicker*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPicker(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_SetLookupTable_169(JNIEnv* env, jobject obj,jobject id0)
{
  vtkLookupTable * temp0;
  temp0 = static_cast<vtkLookupTable*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLookupTable(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImagePlaneWidget_GetLookupTable_170(JNIEnv* env, jobject obj)
{
  vtkLookupTable * temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLookupTable();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_SetDisplayText_171(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDisplayText(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImagePlaneWidget_GetDisplayText_172(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDisplayText();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_DisplayTextOn_173(JNIEnv* env, jobject obj)
{

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->DisplayTextOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_DisplayTextOff_174(JNIEnv* env, jobject obj)
{

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->DisplayTextOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_SetCursorProperty_175(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProperty * temp0;
  temp0 = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCursorProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImagePlaneWidget_GetCursorProperty_176(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCursorProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_SetMarginProperty_177(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProperty * temp0;
  temp0 = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMarginProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImagePlaneWidget_GetMarginProperty_178(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMarginProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_SetMarginSizeX_179(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMarginSizeX(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImagePlaneWidget_GetMarginSizeXMinValue_180(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMarginSizeXMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImagePlaneWidget_GetMarginSizeXMaxValue_181(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMarginSizeXMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImagePlaneWidget_GetMarginSizeX_182(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMarginSizeX();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_SetMarginSizeY_183(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMarginSizeY(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImagePlaneWidget_GetMarginSizeYMinValue_184(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMarginSizeYMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImagePlaneWidget_GetMarginSizeYMaxValue_185(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMarginSizeYMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImagePlaneWidget_GetMarginSizeY_186(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMarginSizeY();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_SetTextProperty_187(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTextProperty * temp0;
  temp0 = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTextProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImagePlaneWidget_GetTextProperty_188(JNIEnv* env, jobject obj)
{
  vtkTextProperty * temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTextProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_SetTexturePlaneProperty_189(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProperty * temp0;
  temp0 = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTexturePlaneProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImagePlaneWidget_GetTexturePlaneProperty_190(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTexturePlaneProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_SetWindowLevel_191(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jint id2)
{
  double   temp0;
  double   temp1;
  int   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetWindowLevel(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_GetWindowLevel_192(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetWindowLevel(temp0);
  env->SetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImagePlaneWidget_GetWindow_193(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetWindow();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImagePlaneWidget_GetLevel_194(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLevel();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImagePlaneWidget_GetCursorData_195(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[4];
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 4, &temp0[0]);

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCursorData(temp0);
  env->SetDoubleArrayRegion(id0, 0, 4, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImagePlaneWidget_GetCursorDataStatus_196(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCursorDataStatus();
  return temp20;

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkImagePlaneWidget_GetCurrentCursorPosition_197(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCurrentCursorPosition();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImagePlaneWidget_GetCurrentImageValue_198(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCurrentImageValue();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImagePlaneWidget_GetResliceAxes_199(JNIEnv* env, jobject obj)
{
  vtkMatrix4x4 * temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetResliceAxes();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImagePlaneWidget_GetReslice_1100(JNIEnv* env, jobject obj)
{
  vtkImageReslice * temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetReslice();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_SetUseContinuousCursor_1101(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseContinuousCursor(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImagePlaneWidget_GetUseContinuousCursor_1102(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseContinuousCursor();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_UseContinuousCursorOn_1103(JNIEnv* env, jobject obj)
{

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseContinuousCursorOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_UseContinuousCursorOff_1104(JNIEnv* env, jobject obj)
{

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseContinuousCursorOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_SetInteraction_1105(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInteraction(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImagePlaneWidget_GetInteraction_1106(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInteraction();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_InteractionOn_1107(JNIEnv* env, jobject obj)
{

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->InteractionOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_InteractionOff_1108(JNIEnv* env, jobject obj)
{

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->InteractionOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_SetLeftButtonAction_1109(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLeftButtonAction(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImagePlaneWidget_GetLeftButtonActionMinValue_1110(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLeftButtonActionMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImagePlaneWidget_GetLeftButtonActionMaxValue_1111(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLeftButtonActionMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImagePlaneWidget_GetLeftButtonAction_1112(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLeftButtonAction();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_SetMiddleButtonAction_1113(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMiddleButtonAction(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImagePlaneWidget_GetMiddleButtonActionMinValue_1114(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMiddleButtonActionMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImagePlaneWidget_GetMiddleButtonActionMaxValue_1115(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMiddleButtonActionMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImagePlaneWidget_GetMiddleButtonAction_1116(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMiddleButtonAction();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_SetRightButtonAction_1117(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRightButtonAction(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImagePlaneWidget_GetRightButtonActionMinValue_1118(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRightButtonActionMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImagePlaneWidget_GetRightButtonActionMaxValue_1119(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRightButtonActionMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImagePlaneWidget_GetRightButtonAction_1120(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRightButtonAction();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_SetLeftButtonAutoModifier_1121(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLeftButtonAutoModifier(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImagePlaneWidget_GetLeftButtonAutoModifierMinValue_1122(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLeftButtonAutoModifierMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImagePlaneWidget_GetLeftButtonAutoModifierMaxValue_1123(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLeftButtonAutoModifierMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImagePlaneWidget_GetLeftButtonAutoModifier_1124(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLeftButtonAutoModifier();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_SetMiddleButtonAutoModifier_1125(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMiddleButtonAutoModifier(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImagePlaneWidget_GetMiddleButtonAutoModifierMinValue_1126(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMiddleButtonAutoModifierMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImagePlaneWidget_GetMiddleButtonAutoModifierMaxValue_1127(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMiddleButtonAutoModifierMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImagePlaneWidget_GetMiddleButtonAutoModifier_1128(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMiddleButtonAutoModifier();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImagePlaneWidget_SetRightButtonAutoModifier_1129(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRightButtonAutoModifier(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImagePlaneWidget_GetRightButtonAutoModifierMinValue_1130(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRightButtonAutoModifierMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImagePlaneWidget_GetRightButtonAutoModifierMaxValue_1131(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRightButtonAutoModifierMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImagePlaneWidget_GetRightButtonAutoModifier_1132(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImagePlaneWidget* op = static_cast<vtkImagePlaneWidget*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRightButtonAutoModifier();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkImagePlaneWidget_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkImagePlaneWidget::New());
}
