// java wrapper for vtkCoordinate object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkCoordinate.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkCoordinate_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkCoordinate",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCoordinate_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCoordinate* op = static_cast<vtkCoordinate*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCoordinate_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCoordinate* op = static_cast<vtkCoordinate*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCoordinate_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCoordinate* op = static_cast<vtkCoordinate*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCoordinate_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCoordinate* op = static_cast<vtkCoordinate*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCoordinate_SetCoordinateSystem_14(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCoordinate* op = static_cast<vtkCoordinate*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCoordinateSystem(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCoordinate_GetCoordinateSystem_15(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCoordinate* op = static_cast<vtkCoordinate*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCoordinateSystem();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCoordinate_SetCoordinateSystemToDisplay_16(JNIEnv* env, jobject obj)
{

  vtkCoordinate* op = static_cast<vtkCoordinate*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCoordinateSystemToDisplay();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCoordinate_SetCoordinateSystemToNormalizedDisplay_17(JNIEnv* env, jobject obj)
{

  vtkCoordinate* op = static_cast<vtkCoordinate*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCoordinateSystemToNormalizedDisplay();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCoordinate_SetCoordinateSystemToViewport_18(JNIEnv* env, jobject obj)
{

  vtkCoordinate* op = static_cast<vtkCoordinate*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCoordinateSystemToViewport();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCoordinate_SetCoordinateSystemToNormalizedViewport_19(JNIEnv* env, jobject obj)
{

  vtkCoordinate* op = static_cast<vtkCoordinate*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCoordinateSystemToNormalizedViewport();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCoordinate_SetCoordinateSystemToView_110(JNIEnv* env, jobject obj)
{

  vtkCoordinate* op = static_cast<vtkCoordinate*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCoordinateSystemToView();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCoordinate_SetCoordinateSystemToPose_111(JNIEnv* env, jobject obj)
{

  vtkCoordinate* op = static_cast<vtkCoordinate*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCoordinateSystemToPose();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCoordinate_SetCoordinateSystemToWorld_112(JNIEnv* env, jobject obj)
{

  vtkCoordinate* op = static_cast<vtkCoordinate*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCoordinateSystemToWorld();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkCoordinate_GetCoordinateSystemAsString_113(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkCoordinate* op = static_cast<vtkCoordinate*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCoordinateSystemAsString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCoordinate_SetValue_114(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkCoordinate* op = static_cast<vtkCoordinate*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetValue(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCoordinate_SetValue_115(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkCoordinate* op = static_cast<vtkCoordinate*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetValue(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkCoordinate_GetValue_116(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkCoordinate* op = static_cast<vtkCoordinate*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetValue();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCoordinate_SetValue_117(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkCoordinate* op = static_cast<vtkCoordinate*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetValue(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCoordinate_SetReferenceCoordinate_118(JNIEnv* env, jobject obj,jobject id0)
{
  vtkCoordinate * temp0;
  temp0 = static_cast<vtkCoordinate*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCoordinate* op = static_cast<vtkCoordinate*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetReferenceCoordinate(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCoordinate_GetReferenceCoordinate_119(JNIEnv* env, jobject obj)
{
  vtkCoordinate * temp20;

  vtkCoordinate* op = static_cast<vtkCoordinate*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetReferenceCoordinate();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCoordinate_SetViewport_120(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCoordinate* op = static_cast<vtkCoordinate*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetViewport(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCoordinate_GetViewport_121(JNIEnv* env, jobject obj)
{
  vtkViewport * temp20;

  vtkCoordinate* op = static_cast<vtkCoordinate*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetViewport();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkCoordinate_GetComputedWorldValue_122(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  double * temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCoordinate* op = static_cast<vtkCoordinate*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetComputedWorldValue(temp0);
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkCoordinate_GetComputedViewportValue_123(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int * temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCoordinate* op = static_cast<vtkCoordinate*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetComputedViewportValue(temp0);
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkCoordinate_GetComputedDisplayValue_124(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int * temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCoordinate* op = static_cast<vtkCoordinate*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetComputedDisplayValue(temp0);
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkCoordinate_GetComputedLocalDisplayValue_125(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int * temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCoordinate* op = static_cast<vtkCoordinate*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetComputedLocalDisplayValue(temp0);
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkCoordinate_GetComputedDoubleViewportValue_126(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  double * temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCoordinate* op = static_cast<vtkCoordinate*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetComputedDoubleViewportValue(temp0);
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkCoordinate_GetComputedDoubleDisplayValue_127(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  double * temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCoordinate* op = static_cast<vtkCoordinate*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetComputedDoubleDisplayValue(temp0);
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkCoordinate_GetComputedValue_128(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  double * temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCoordinate* op = static_cast<vtkCoordinate*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetComputedValue(temp0);
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkCoordinate_GetComputedUserDefinedValue_129(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  double * temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkCoordinate* op = static_cast<vtkCoordinate*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetComputedUserDefinedValue(temp0);
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkCoordinate_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkCoordinate::New());
}
