// java wrapper for vtkProperty object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkProperty.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkProperty_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkProperty",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkProperty_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkProperty_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkProperty_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkProperty_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_DeepCopy_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProperty * temp0;
  temp0 = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_Render_15(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkActor * temp0;
  vtkRenderer * temp1;
  temp0 = static_cast<vtkActor*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id1));

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->Render(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_BackfaceRender_16(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkActor * temp0;
  vtkRenderer * temp1;
  temp0 = static_cast<vtkActor*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id1));

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->BackfaceRender(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_PostRender_17(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkActor * temp0;
  vtkRenderer * temp1;
  temp0 = static_cast<vtkActor*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id1));

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->PostRender(temp0,temp1);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkProperty_GetLighting_18(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLighting();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetLighting_19(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLighting(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_LightingOn_110(JNIEnv* env, jobject obj)
{

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->LightingOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_LightingOff_111(JNIEnv* env, jobject obj)
{

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->LightingOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetPoint2DShape_112(JNIEnv* env, jobject obj,jint id0)
{
  vtkProperty::Point2DShapeType   temp0;
  temp0 = static_cast<vtkProperty::Point2DShapeType>(id0);

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPoint2DShape(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkProperty_GetPoint2DShape_113(JNIEnv* env, jobject obj)
{
  vtkProperty::Point2DShapeType   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPoint2DShape();
  return static_cast<jint>(temp20);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkProperty_GetRenderPointsAsSpheres_114(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRenderPointsAsSpheres();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetRenderPointsAsSpheres_115(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRenderPointsAsSpheres(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_RenderPointsAsSpheresOn_116(JNIEnv* env, jobject obj)
{

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->RenderPointsAsSpheresOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_RenderPointsAsSpheresOff_117(JNIEnv* env, jobject obj)
{

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->RenderPointsAsSpheresOff();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkProperty_GetRenderLinesAsTubes_118(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRenderLinesAsTubes();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetRenderLinesAsTubes_119(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRenderLinesAsTubes(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_RenderLinesAsTubesOn_120(JNIEnv* env, jobject obj)
{

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->RenderLinesAsTubesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_RenderLinesAsTubesOff_121(JNIEnv* env, jobject obj)
{

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->RenderLinesAsTubesOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetInterpolation_122(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInterpolation(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkProperty_GetInterpolationMinValue_123(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInterpolationMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkProperty_GetInterpolationMaxValue_124(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInterpolationMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkProperty_GetInterpolation_125(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInterpolation();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetInterpolationToFlat_126(JNIEnv* env, jobject obj)
{

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInterpolationToFlat();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetInterpolationToGouraud_127(JNIEnv* env, jobject obj)
{

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInterpolationToGouraud();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetInterpolationToPhong_128(JNIEnv* env, jobject obj)
{

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInterpolationToPhong();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetInterpolationToPBR_129(JNIEnv* env, jobject obj)
{

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInterpolationToPBR();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkProperty_GetInterpolationAsString_130(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInterpolationAsString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetRepresentation_131(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRepresentation(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkProperty_GetRepresentationMinValue_132(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRepresentationMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkProperty_GetRepresentationMaxValue_133(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRepresentationMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkProperty_GetRepresentation_134(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRepresentation();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetRepresentationToPoints_135(JNIEnv* env, jobject obj)
{

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRepresentationToPoints();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetRepresentationToWireframe_136(JNIEnv* env, jobject obj)
{

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRepresentationToWireframe();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetRepresentationToSurface_137(JNIEnv* env, jobject obj)
{

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRepresentationToSurface();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkProperty_GetRepresentationAsString_138(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRepresentationAsString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetColor_139(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetColor_140(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColor(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkProperty_GetColor_141(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetColor();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_GetColor_142(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetColor(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetBaseIOR_143(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBaseIOR(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProperty_GetBaseIORMinValue_144(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBaseIORMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProperty_GetBaseIORMaxValue_145(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBaseIORMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProperty_GetBaseIOR_146(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBaseIOR();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetMetallic_147(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMetallic(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProperty_GetMetallicMinValue_148(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMetallicMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProperty_GetMetallicMaxValue_149(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMetallicMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProperty_GetMetallic_150(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMetallic();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetRoughness_151(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRoughness(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProperty_GetRoughnessMinValue_152(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRoughnessMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProperty_GetRoughnessMaxValue_153(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRoughnessMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProperty_GetRoughness_154(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRoughness();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetAnisotropy_155(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAnisotropy(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProperty_GetAnisotropyMinValue_156(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAnisotropyMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProperty_GetAnisotropyMaxValue_157(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAnisotropyMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProperty_GetAnisotropy_158(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAnisotropy();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetAnisotropyRotation_159(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAnisotropyRotation(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProperty_GetAnisotropyRotationMinValue_160(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAnisotropyRotationMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProperty_GetAnisotropyRotationMaxValue_161(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAnisotropyRotationMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProperty_GetAnisotropyRotation_162(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAnisotropyRotation();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetCoatIOR_163(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCoatIOR(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProperty_GetCoatIORMinValue_164(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCoatIORMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProperty_GetCoatIORMaxValue_165(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCoatIORMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProperty_GetCoatIOR_166(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCoatIOR();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetCoatRoughness_167(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCoatRoughness(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProperty_GetCoatRoughnessMinValue_168(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCoatRoughnessMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProperty_GetCoatRoughnessMaxValue_169(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCoatRoughnessMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProperty_GetCoatRoughness_170(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCoatRoughness();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetCoatStrength_171(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCoatStrength(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProperty_GetCoatStrengthMinValue_172(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCoatStrengthMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProperty_GetCoatStrengthMaxValue_173(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCoatStrengthMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProperty_GetCoatStrength_174(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCoatStrength();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetCoatColor_175(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCoatColor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetCoatColor_176(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCoatColor(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkProperty_GetCoatColor_177(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCoatColor();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetCoatNormalScale_178(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCoatNormalScale(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProperty_GetCoatNormalScaleMinValue_179(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCoatNormalScaleMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProperty_GetCoatNormalScaleMaxValue_180(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCoatNormalScaleMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProperty_GetCoatNormalScale_181(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCoatNormalScale();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetNormalScale_182(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNormalScale(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProperty_GetNormalScale_183(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNormalScale();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetOcclusionStrength_184(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOcclusionStrength(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProperty_GetOcclusionStrengthMinValue_185(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOcclusionStrengthMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProperty_GetOcclusionStrengthMaxValue_186(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOcclusionStrengthMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProperty_GetOcclusionStrength_187(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOcclusionStrength();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetEmissiveFactor_188(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEmissiveFactor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetEmissiveFactor_189(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEmissiveFactor(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkProperty_GetEmissiveFactor_190(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEmissiveFactor();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetEdgeTint_191(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgeTint(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetEdgeTint_192(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgeTint(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkProperty_GetEdgeTint_193(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeTint();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetAmbient_194(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAmbient(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProperty_GetAmbientMinValue_195(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAmbientMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProperty_GetAmbientMaxValue_196(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAmbientMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProperty_GetAmbient_197(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAmbient();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetDiffuse_198(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDiffuse(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProperty_GetDiffuseMinValue_199(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDiffuseMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProperty_GetDiffuseMaxValue_1100(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDiffuseMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProperty_GetDiffuse_1101(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDiffuse();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetSpecular_1102(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSpecular(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProperty_GetSpecularMinValue_1103(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSpecularMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProperty_GetSpecularMaxValue_1104(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSpecularMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProperty_GetSpecular_1105(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSpecular();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetSpecularPower_1106(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSpecularPower(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProperty_GetSpecularPowerMinValue_1107(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSpecularPowerMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProperty_GetSpecularPowerMaxValue_1108(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSpecularPowerMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProperty_GetSpecularPower_1109(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSpecularPower();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetOpacity_1110(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOpacity(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProperty_GetOpacityMinValue_1111(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOpacityMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProperty_GetOpacityMaxValue_1112(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOpacityMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProperty_GetOpacity_1113(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOpacity();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetEdgeOpacity_1114(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgeOpacity(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProperty_GetEdgeOpacityMinValue_1115(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeOpacityMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProperty_GetEdgeOpacityMaxValue_1116(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeOpacityMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProperty_GetEdgeOpacity_1117(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeOpacity();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetAmbientColor_1118(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAmbientColor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetAmbientColor_1119(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAmbientColor(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkProperty_GetAmbientColor_1120(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAmbientColor();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetDiffuseColor_1121(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDiffuseColor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetDiffuseColor_1122(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDiffuseColor(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkProperty_GetDiffuseColor_1123(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDiffuseColor();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetSpecularColor_1124(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSpecularColor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetSpecularColor_1125(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSpecularColor(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkProperty_GetSpecularColor_1126(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSpecularColor();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkProperty_GetEdgeVisibility_1127(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeVisibility();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetEdgeVisibility_1128(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgeVisibility(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_EdgeVisibilityOn_1129(JNIEnv* env, jobject obj)
{

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->EdgeVisibilityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_EdgeVisibilityOff_1130(JNIEnv* env, jobject obj)
{

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->EdgeVisibilityOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetEdgeColor_1131(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgeColor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetEdgeColor_1132(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgeColor(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkProperty_GetEdgeColor_1133(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeColor();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkProperty_GetVertexVisibility_1134(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVertexVisibility();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetVertexVisibility_1135(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVertexVisibility(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_VertexVisibilityOn_1136(JNIEnv* env, jobject obj)
{

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->VertexVisibilityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_VertexVisibilityOff_1137(JNIEnv* env, jobject obj)
{

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->VertexVisibilityOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetVertexColor_1138(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVertexColor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetVertexColor_1139(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVertexColor(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkProperty_GetVertexColor_1140(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVertexColor();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetSelectionColor_1141(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSelectionColor(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetSelectionColor_1142(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[4];
  env->GetDoubleArrayRegion(id0, 0, 4, &temp0[0]);

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSelectionColor(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkProperty_GetSelectionColor_1143(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelectionColor();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 4);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetSelectionLineWidth_1144(JNIEnv* env, jobject obj,jfloat id0)
{
  float   temp0;
  temp0 = id0;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSelectionLineWidth(temp0);

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkProperty_GetSelectionLineWidth_1145(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelectionLineWidth();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetSelectionPointSize_1146(JNIEnv* env, jobject obj,jfloat id0)
{
  float   temp0;
  temp0 = id0;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSelectionPointSize(temp0);

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkProperty_GetSelectionPointSize_1147(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelectionPointSize();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetLineWidth_1148(JNIEnv* env, jobject obj,jfloat id0)
{
  float   temp0;
  temp0 = id0;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLineWidth(temp0);

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkProperty_GetLineWidthMinValue_1149(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLineWidthMinValue();
  return temp20;

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkProperty_GetLineWidthMaxValue_1150(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLineWidthMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkProperty_GetLineWidth_1151(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLineWidth();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetEdgeWidth_1152(JNIEnv* env, jobject obj,jfloat id0)
{
  float   temp0;
  temp0 = id0;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgeWidth(temp0);

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkProperty_GetEdgeWidthMinValue_1153(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeWidthMinValue();
  return temp20;

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkProperty_GetEdgeWidthMaxValue_1154(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeWidthMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkProperty_GetEdgeWidth_1155(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeWidth();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_UseLineWidthForEdgeThicknessOn_1156(JNIEnv* env, jobject obj)
{

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseLineWidthForEdgeThicknessOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_UseLineWidthForEdgeThicknessOff_1157(JNIEnv* env, jobject obj)
{

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseLineWidthForEdgeThicknessOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetUseLineWidthForEdgeThickness_1158(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseLineWidthForEdgeThickness(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkProperty_GetUseLineWidthForEdgeThickness_1159(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseLineWidthForEdgeThickness();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetLineStipplePattern_1160(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLineStipplePattern(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkProperty_GetLineStipplePattern_1161(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLineStipplePattern();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetLineStippleRepeatFactor_1162(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLineStippleRepeatFactor(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkProperty_GetLineStippleRepeatFactorMinValue_1163(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLineStippleRepeatFactorMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkProperty_GetLineStippleRepeatFactorMaxValue_1164(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLineStippleRepeatFactorMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkProperty_GetLineStippleRepeatFactor_1165(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLineStippleRepeatFactor();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetPointSize_1166(JNIEnv* env, jobject obj,jfloat id0)
{
  float   temp0;
  temp0 = id0;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPointSize(temp0);

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkProperty_GetPointSizeMinValue_1167(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointSizeMinValue();
  return temp20;

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkProperty_GetPointSizeMaxValue_1168(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointSizeMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkProperty_GetPointSize_1169(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointSize();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkProperty_GetBackfaceCulling_1170(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBackfaceCulling();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetBackfaceCulling_1171(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBackfaceCulling(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_BackfaceCullingOn_1172(JNIEnv* env, jobject obj)
{

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->BackfaceCullingOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_BackfaceCullingOff_1173(JNIEnv* env, jobject obj)
{

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->BackfaceCullingOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkProperty_GetFrontfaceCulling_1174(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFrontfaceCulling();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetFrontfaceCulling_1175(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFrontfaceCulling(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_FrontfaceCullingOn_1176(JNIEnv* env, jobject obj)
{

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->FrontfaceCullingOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_FrontfaceCullingOff_1177(JNIEnv* env, jobject obj)
{

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->FrontfaceCullingOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetMaterialName_1178(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaterialName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkProperty_GetMaterialName_1179(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaterialName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetShading_1180(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetShading(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkProperty_GetShading_1181(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetShading();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_ShadingOn_1182(JNIEnv* env, jobject obj)
{

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShadingOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_ShadingOff_1183(JNIEnv* env, jobject obj)
{

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShadingOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_AddShaderVariable_1184(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddShaderVariable(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_AddShaderVariable_1185(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jfloat id1)
{
  char * temp0;
  float   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddShaderVariable(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_AddShaderVariable_1186(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jdouble id1)
{
  char * temp0;
  double   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddShaderVariable(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_AddShaderVariable_1187(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1,jint id2)
{
  char * temp0;
  int   temp1;
  int   temp2;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;
  temp2 = id2;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddShaderVariable(temp0,temp1,temp2);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_AddShaderVariable_1188(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jfloat id1,jfloat id2)
{
  char * temp0;
  float   temp1;
  float   temp2;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;
  temp2 = id2;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddShaderVariable(temp0,temp1,temp2);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_AddShaderVariable_1189(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jdouble id1,jdouble id2)
{
  char * temp0;
  double   temp1;
  double   temp2;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;
  temp2 = id2;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddShaderVariable(temp0,temp1,temp2);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_AddShaderVariable_1190(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1,jint id2,jint id3)
{
  char * temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddShaderVariable(temp0,temp1,temp2,temp3);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_AddShaderVariable_1191(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jfloat id1,jfloat id2,jfloat id3)
{
  char * temp0;
  float   temp1;
  float   temp2;
  float   temp3;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddShaderVariable(temp0,temp1,temp2,temp3);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_AddShaderVariable_1192(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jdouble id1,jdouble id2,jdouble id3)
{
  char * temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddShaderVariable(temp0,temp1,temp2,temp3);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetShowTexturesOnBackface_1193(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetShowTexturesOnBackface(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkProperty_GetShowTexturesOnBackface_1194(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetShowTexturesOnBackface();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_ShowTexturesOnBackfaceOn_1195(JNIEnv* env, jobject obj)
{

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShowTexturesOnBackfaceOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_ShowTexturesOnBackfaceOff_1196(JNIEnv* env, jobject obj)
{

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShowTexturesOnBackfaceOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetTexture_1197(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jobject id1)
{
  char * temp0;
  vtkTexture * temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, id1));

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTexture(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkProperty_GetTexture_1198(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  vtkTexture * temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTexture(temp0);
  delete[] temp0;
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetBaseColorTexture_1199(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTexture * temp0;
  temp0 = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, id0));

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBaseColorTexture(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetORMTexture_1200(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTexture * temp0;
  temp0 = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, id0));

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetORMTexture(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetAnisotropyTexture_1201(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTexture * temp0;
  temp0 = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, id0));

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAnisotropyTexture(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetNormalTexture_1202(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTexture * temp0;
  temp0 = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, id0));

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNormalTexture(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetEmissiveTexture_1203(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTexture * temp0;
  temp0 = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, id0));

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEmissiveTexture(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetCoatNormalTexture_1204(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTexture * temp0;
  temp0 = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, id0));

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCoatNormalTexture(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_RemoveTexture_1205(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveTexture(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_RemoveAllTextures_1206(JNIEnv* env, jobject obj)
{

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveAllTextures();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkProperty_GetNumberOfTextures_1207(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfTextures();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_ReleaseGraphicsResources_1208(JNIEnv* env, jobject obj,jobject id0)
{
  vtkWindow * temp0;
  temp0 = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseGraphicsResources(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkProperty_GetInformation_1209(JNIEnv* env, jobject obj)
{
  vtkInformation * temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInformation();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkProperty_SetInformation_1210(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformation * temp0;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInformation(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProperty_ComputeReflectanceFromIOR_1211(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  double   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ComputeReflectanceFromIOR(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProperty_ComputeIORFromReflectance_1212(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  double   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ComputeIORFromReflectance(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkProperty_ComputeReflectanceOfBaseLayer_1213(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkProperty* op = static_cast<vtkProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ComputeReflectanceOfBaseLayer();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkProperty_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkProperty::New());
}
