// java wrapper for vtkVolumeProperty object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkVolumeProperty.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkVolumeProperty_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkVolumeProperty",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVolumeProperty_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVolumeProperty_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVolumeProperty_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVolumeProperty_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeProperty_DeepCopy_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkVolumeProperty * temp0;
  temp0 = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVolumeProperty_GetMTime_15(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeProperty_SetIndependentComponents_16(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIndependentComponents(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVolumeProperty_GetIndependentComponentsMinValue_17(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIndependentComponentsMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVolumeProperty_GetIndependentComponentsMaxValue_18(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIndependentComponentsMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVolumeProperty_GetIndependentComponents_19(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIndependentComponents();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeProperty_IndependentComponentsOn_110(JNIEnv* env, jobject obj)
{

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->IndependentComponentsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeProperty_IndependentComponentsOff_111(JNIEnv* env, jobject obj)
{

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->IndependentComponentsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeProperty_SetInterpolationType_112(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInterpolationType(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVolumeProperty_GetInterpolationTypeMinValue_113(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInterpolationTypeMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVolumeProperty_GetInterpolationTypeMaxValue_114(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInterpolationTypeMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVolumeProperty_GetInterpolationType_115(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInterpolationType();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeProperty_SetInterpolationTypeToNearest_116(JNIEnv* env, jobject obj)
{

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInterpolationTypeToNearest();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeProperty_SetInterpolationTypeToLinear_117(JNIEnv* env, jobject obj)
{

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInterpolationTypeToLinear();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkVolumeProperty_GetInterpolationTypeAsString_118(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInterpolationTypeAsString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeProperty_SetComponentWeight_119(JNIEnv* env, jobject obj,jint id0,jdouble id1)
{
  int   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetComponentWeight(temp0,temp1);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkVolumeProperty_GetComponentWeight_120(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  double   temp20;
  temp0 = id0;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetComponentWeight(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeProperty_SetColor_121(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkPiecewiseFunction * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkPiecewiseFunction*>(vtkJavaGetPointerFromObject(env, id1));

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColor(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeProperty_SetColor_122(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPiecewiseFunction * temp0;
  temp0 = static_cast<vtkPiecewiseFunction*>(vtkJavaGetPointerFromObject(env, id0));

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColor(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeProperty_SetColor_123(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkColorTransferFunction * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, id1));

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColor(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeProperty_SetColor_124(JNIEnv* env, jobject obj,jobject id0)
{
  vtkColorTransferFunction * temp0;
  temp0 = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, id0));

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColor(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVolumeProperty_GetColorChannels_125(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetColorChannels(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVolumeProperty_GetColorChannels_126(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetColorChannels();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVolumeProperty_GetGrayTransferFunction_127(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkPiecewiseFunction * temp20;
  temp0 = id0;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGrayTransferFunction(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVolumeProperty_GetGrayTransferFunction_128(JNIEnv* env, jobject obj)
{
  vtkPiecewiseFunction * temp20;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGrayTransferFunction();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVolumeProperty_GetRGBTransferFunction_129(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkColorTransferFunction * temp20;
  temp0 = id0;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRGBTransferFunction(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVolumeProperty_GetRGBTransferFunction_130(JNIEnv* env, jobject obj)
{
  vtkColorTransferFunction * temp20;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRGBTransferFunction();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeProperty_SetScalarOpacity_131(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkPiecewiseFunction * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkPiecewiseFunction*>(vtkJavaGetPointerFromObject(env, id1));

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarOpacity(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeProperty_SetScalarOpacity_132(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPiecewiseFunction * temp0;
  temp0 = static_cast<vtkPiecewiseFunction*>(vtkJavaGetPointerFromObject(env, id0));

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarOpacity(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVolumeProperty_GetScalarOpacity_133(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkPiecewiseFunction * temp20;
  temp0 = id0;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScalarOpacity(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVolumeProperty_GetScalarOpacity_134(JNIEnv* env, jobject obj)
{
  vtkPiecewiseFunction * temp20;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScalarOpacity();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeProperty_SetScalarOpacityUnitDistance_135(JNIEnv* env, jobject obj,jint id0,jdouble id1)
{
  int   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarOpacityUnitDistance(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeProperty_SetScalarOpacityUnitDistance_136(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarOpacityUnitDistance(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkVolumeProperty_GetScalarOpacityUnitDistance_137(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  double   temp20;
  temp0 = id0;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScalarOpacityUnitDistance(temp0);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkVolumeProperty_GetScalarOpacityUnitDistance_138(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScalarOpacityUnitDistance();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeProperty_SetGradientOpacity_139(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkPiecewiseFunction * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkPiecewiseFunction*>(vtkJavaGetPointerFromObject(env, id1));

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGradientOpacity(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeProperty_SetGradientOpacity_140(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPiecewiseFunction * temp0;
  temp0 = static_cast<vtkPiecewiseFunction*>(vtkJavaGetPointerFromObject(env, id0));

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGradientOpacity(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeProperty_SetTransferFunction2D_141(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkImageData * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, id1));

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTransferFunction2D(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeProperty_SetTransferFunction2D_142(JNIEnv* env, jobject obj,jobject id0)
{
  vtkImageData * temp0;
  temp0 = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, id0));

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTransferFunction2D(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVolumeProperty_GetTransferFunction2D_143(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkImageData * temp20;
  temp0 = id0;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTransferFunction2D(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVolumeProperty_GetTransferFunction2D_144(JNIEnv* env, jobject obj)
{
  vtkImageData * temp20;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTransferFunction2D();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeProperty_SetTransferFunctionMode_145(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTransferFunctionMode(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVolumeProperty_GetTransferFunctionModeMinValue_146(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTransferFunctionModeMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVolumeProperty_GetTransferFunctionModeMaxValue_147(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTransferFunctionModeMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVolumeProperty_GetTransferFunctionMode_148(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTransferFunctionMode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeProperty_SetTransferFunctionModeTo1D_149(JNIEnv* env, jobject obj)
{

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTransferFunctionModeTo1D();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeProperty_SetTransferFunctionModeTo2D_150(JNIEnv* env, jobject obj)
{

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTransferFunctionModeTo2D();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVolumeProperty_GetGradientOpacity_151(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkPiecewiseFunction * temp20;
  temp0 = id0;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGradientOpacity(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVolumeProperty_GetGradientOpacity_152(JNIEnv* env, jobject obj)
{
  vtkPiecewiseFunction * temp20;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGradientOpacity();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeProperty_SetDisableGradientOpacity_153(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDisableGradientOpacity(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeProperty_SetDisableGradientOpacity_154(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDisableGradientOpacity(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeProperty_DisableGradientOpacityOn_155(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->DisableGradientOpacityOn(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeProperty_DisableGradientOpacityOn_156(JNIEnv* env, jobject obj)
{

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->DisableGradientOpacityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeProperty_DisableGradientOpacityOff_157(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->DisableGradientOpacityOff(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeProperty_DisableGradientOpacityOff_158(JNIEnv* env, jobject obj)
{

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->DisableGradientOpacityOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVolumeProperty_GetDisableGradientOpacity_159(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDisableGradientOpacity(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVolumeProperty_GetDisableGradientOpacity_160(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDisableGradientOpacity();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVolumeProperty_GetStoredGradientOpacity_161(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkPiecewiseFunction * temp20;
  temp0 = id0;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStoredGradientOpacity(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVolumeProperty_GetStoredGradientOpacity_162(JNIEnv* env, jobject obj)
{
  vtkPiecewiseFunction * temp20;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStoredGradientOpacity();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkVolumeProperty_HasGradientOpacity_163(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  bool   temp20;
  temp0 = id0;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasGradientOpacity(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkVolumeProperty_HasLabelGradientOpacity_164(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasLabelGradientOpacity();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeProperty_SetShade_165(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetShade(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeProperty_SetShade_166(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetShade(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVolumeProperty_GetShade_167(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  int   temp20;
  temp0 = id0;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetShade(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVolumeProperty_GetShade_168(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetShade();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeProperty_ShadeOn_169(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShadeOn(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeProperty_ShadeOn_170(JNIEnv* env, jobject obj)
{

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShadeOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeProperty_ShadeOff_171(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShadeOff(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeProperty_ShadeOff_172(JNIEnv* env, jobject obj)
{

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShadeOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeProperty_SetAmbient_173(JNIEnv* env, jobject obj,jint id0,jdouble id1)
{
  int   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAmbient(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeProperty_SetAmbient_174(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAmbient(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkVolumeProperty_GetAmbient_175(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  double   temp20;
  temp0 = id0;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAmbient(temp0);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkVolumeProperty_GetAmbient_176(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAmbient();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeProperty_SetDiffuse_177(JNIEnv* env, jobject obj,jint id0,jdouble id1)
{
  int   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDiffuse(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeProperty_SetDiffuse_178(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDiffuse(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkVolumeProperty_GetDiffuse_179(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  double   temp20;
  temp0 = id0;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDiffuse(temp0);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkVolumeProperty_GetDiffuse_180(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDiffuse();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeProperty_SetSpecular_181(JNIEnv* env, jobject obj,jint id0,jdouble id1)
{
  int   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSpecular(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeProperty_SetSpecular_182(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSpecular(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkVolumeProperty_GetSpecular_183(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  double   temp20;
  temp0 = id0;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSpecular(temp0);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkVolumeProperty_GetSpecular_184(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSpecular();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeProperty_SetSpecularPower_185(JNIEnv* env, jobject obj,jint id0,jdouble id1)
{
  int   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSpecularPower(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeProperty_SetSpecularPower_186(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSpecularPower(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkVolumeProperty_GetSpecularPower_187(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  double   temp20;
  temp0 = id0;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSpecularPower(temp0);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkVolumeProperty_GetSpecularPower_188(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSpecularPower();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVolumeProperty_GetIsoSurfaceValues_189(JNIEnv* env, jobject obj)
{
  vtkContourValues * temp20;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIsoSurfaceValues();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeProperty_SetSliceFunction_190(JNIEnv* env, jobject obj,jobject id0)
{
  vtkImplicitFunction * temp0;
  temp0 = static_cast<vtkImplicitFunction*>(vtkJavaGetPointerFromObject(env, id0));

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSliceFunction(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVolumeProperty_GetSliceFunction_191(JNIEnv* env, jobject obj)
{
  vtkImplicitFunction * temp20;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSliceFunction();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeProperty_SetScatteringAnisotropy_192(JNIEnv* env, jobject obj,jfloat id0)
{
  float   temp0;
  temp0 = id0;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScatteringAnisotropy(temp0);

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkVolumeProperty_GetScatteringAnisotropyMinValue_193(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScatteringAnisotropyMinValue();
  return temp20;

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkVolumeProperty_GetScatteringAnisotropyMaxValue_194(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScatteringAnisotropyMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkVolumeProperty_GetScatteringAnisotropy_195(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScatteringAnisotropy();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeProperty_UpdateMTimes_196(JNIEnv* env, jobject obj)
{

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->UpdateMTimes();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeProperty_SetUseClippedVoxelIntensity_197(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseClippedVoxelIntensity(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkVolumeProperty_GetUseClippedVoxelIntensity_198(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseClippedVoxelIntensity();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeProperty_UseClippedVoxelIntensityOn_199(JNIEnv* env, jobject obj)
{

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseClippedVoxelIntensityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeProperty_UseClippedVoxelIntensityOff_1100(JNIEnv* env, jobject obj)
{

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseClippedVoxelIntensityOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeProperty_SetClippedVoxelIntensity_1101(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetClippedVoxelIntensity(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkVolumeProperty_GetClippedVoxelIntensity_1102(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetClippedVoxelIntensity();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeProperty_SetLabelColor_1103(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkColorTransferFunction * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkColorTransferFunction*>(vtkJavaGetPointerFromObject(env, id1));

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabelColor(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVolumeProperty_GetLabelColor_1104(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkColorTransferFunction * temp20;
  temp0 = id0;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLabelColor(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeProperty_SetLabelScalarOpacity_1105(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkPiecewiseFunction * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkPiecewiseFunction*>(vtkJavaGetPointerFromObject(env, id1));

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabelScalarOpacity(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVolumeProperty_GetLabelScalarOpacity_1106(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkPiecewiseFunction * temp20;
  temp0 = id0;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLabelScalarOpacity(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkVolumeProperty_SetLabelGradientOpacity_1107(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkPiecewiseFunction * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkPiecewiseFunction*>(vtkJavaGetPointerFromObject(env, id1));

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabelGradientOpacity(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkVolumeProperty_GetLabelGradientOpacity_1108(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkPiecewiseFunction * temp20;
  temp0 = id0;

  vtkVolumeProperty* op = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLabelGradientOpacity(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkVolumeProperty_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkVolumeProperty::New());
}
