// java wrapper for vtkAMRVolumeMapper object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkAMRVolumeMapper.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkVolumeMapper_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkAMRVolumeMapper_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkAMRVolumeMapper",dType)) { return me; }
  if ((res= vtkVolumeMapper_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAMRVolumeMapper_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAMRVolumeMapper* op = static_cast<vtkAMRVolumeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAMRVolumeMapper_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAMRVolumeMapper* op = static_cast<vtkAMRVolumeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAMRVolumeMapper_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAMRVolumeMapper* op = static_cast<vtkAMRVolumeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAMRVolumeMapper_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAMRVolumeMapper* op = static_cast<vtkAMRVolumeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAMRVolumeMapper_SetInputData_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkImageData * temp0;
  temp0 = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAMRVolumeMapper* op = static_cast<vtkAMRVolumeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputData(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAMRVolumeMapper_SetInputData_15(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataSet * temp0;
  temp0 = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAMRVolumeMapper* op = static_cast<vtkAMRVolumeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputData(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAMRVolumeMapper_SetInputData_16(JNIEnv* env, jobject obj,jobject id0)
{
  vtkRectilinearGrid * temp0;
  temp0 = static_cast<vtkRectilinearGrid*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAMRVolumeMapper* op = static_cast<vtkAMRVolumeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputData(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAMRVolumeMapper_SetInputData_17(JNIEnv* env, jobject obj,jobject id0)
{
  vtkOverlappingAMR * temp0;
  temp0 = static_cast<vtkOverlappingAMR*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAMRVolumeMapper* op = static_cast<vtkAMRVolumeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputData(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAMRVolumeMapper_SetInputConnection_18(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkAlgorithmOutput * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkAlgorithmOutput*>(vtkJavaGetPointerFromObject(env, id1));

  vtkAMRVolumeMapper* op = static_cast<vtkAMRVolumeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputConnection(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAMRVolumeMapper_SetInputConnection_19(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAlgorithmOutput * temp0;
  temp0 = static_cast<vtkAlgorithmOutput*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAMRVolumeMapper* op = static_cast<vtkAMRVolumeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputConnection(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAMRVolumeMapper_GetBounds_110(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkAMRVolumeMapper* op = static_cast<vtkAMRVolumeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetBounds(temp0);
  env->SetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAMRVolumeMapper_SetScalarMode_111(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkAMRVolumeMapper* op = static_cast<vtkAMRVolumeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalarMode(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAMRVolumeMapper_SetBlendMode_112(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkAMRVolumeMapper* op = static_cast<vtkAMRVolumeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBlendMode(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAMRVolumeMapper_GetBlendMode_113(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAMRVolumeMapper* op = static_cast<vtkAMRVolumeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBlendMode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAMRVolumeMapper_SelectScalarArray_114(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkAMRVolumeMapper* op = static_cast<vtkAMRVolumeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SelectScalarArray(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAMRVolumeMapper_SelectScalarArray_115(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAMRVolumeMapper* op = static_cast<vtkAMRVolumeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SelectScalarArray(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkAMRVolumeMapper_GetArrayName_116(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkAMRVolumeMapper* op = static_cast<vtkAMRVolumeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAMRVolumeMapper_GetArrayId_117(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAMRVolumeMapper* op = static_cast<vtkAMRVolumeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetArrayId();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAMRVolumeMapper_GetArrayAccessMode_118(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAMRVolumeMapper* op = static_cast<vtkAMRVolumeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetArrayAccessMode();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkAMRVolumeMapper_GetScalarModeAsString_119(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkAMRVolumeMapper* op = static_cast<vtkAMRVolumeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScalarModeAsString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAMRVolumeMapper_SetCropping_120(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkAMRVolumeMapper* op = static_cast<vtkAMRVolumeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCropping(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAMRVolumeMapper_GetCropping_121(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAMRVolumeMapper* op = static_cast<vtkAMRVolumeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCropping();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAMRVolumeMapper_SetCroppingRegionPlanes_122(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkAMRVolumeMapper* op = static_cast<vtkAMRVolumeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCroppingRegionPlanes(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkAMRVolumeMapper_GetCroppingRegionPlanes_123(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkAMRVolumeMapper* op = static_cast<vtkAMRVolumeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCroppingRegionPlanes();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAMRVolumeMapper_SetCroppingRegionFlags_124(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkAMRVolumeMapper* op = static_cast<vtkAMRVolumeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCroppingRegionFlags(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAMRVolumeMapper_GetCroppingRegionFlags_125(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAMRVolumeMapper* op = static_cast<vtkAMRVolumeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCroppingRegionFlags();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAMRVolumeMapper_SetRequestedRenderMode_126(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkAMRVolumeMapper* op = static_cast<vtkAMRVolumeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRequestedRenderMode(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAMRVolumeMapper_GetRequestedRenderMode_127(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAMRVolumeMapper* op = static_cast<vtkAMRVolumeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRequestedRenderMode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAMRVolumeMapper_SetRequestedRenderModeToDefault_128(JNIEnv* env, jobject obj)
{

  vtkAMRVolumeMapper* op = static_cast<vtkAMRVolumeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRequestedRenderModeToDefault();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAMRVolumeMapper_SetRequestedRenderModeToRayCastAndTexture_129(JNIEnv* env, jobject obj)
{

  vtkAMRVolumeMapper* op = static_cast<vtkAMRVolumeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRequestedRenderModeToRayCastAndTexture();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAMRVolumeMapper_SetRequestedRenderModeToRayCast_130(JNIEnv* env, jobject obj)
{

  vtkAMRVolumeMapper* op = static_cast<vtkAMRVolumeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRequestedRenderModeToRayCast();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAMRVolumeMapper_SetRequestedRenderModeToTexture_131(JNIEnv* env, jobject obj)
{

  vtkAMRVolumeMapper* op = static_cast<vtkAMRVolumeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRequestedRenderModeToTexture();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAMRVolumeMapper_SetRequestedRenderModeToGPU_132(JNIEnv* env, jobject obj)
{

  vtkAMRVolumeMapper* op = static_cast<vtkAMRVolumeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRequestedRenderModeToGPU();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAMRVolumeMapper_SetInterpolationMode_133(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkAMRVolumeMapper* op = static_cast<vtkAMRVolumeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInterpolationMode(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAMRVolumeMapper_GetInterpolationMode_134(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAMRVolumeMapper* op = static_cast<vtkAMRVolumeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInterpolationMode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAMRVolumeMapper_SetInterpolationModeToNearestNeighbor_135(JNIEnv* env, jobject obj)
{

  vtkAMRVolumeMapper* op = static_cast<vtkAMRVolumeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInterpolationModeToNearestNeighbor();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAMRVolumeMapper_SetInterpolationModeToLinear_136(JNIEnv* env, jobject obj)
{

  vtkAMRVolumeMapper* op = static_cast<vtkAMRVolumeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInterpolationModeToLinear();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAMRVolumeMapper_SetInterpolationModeToCubic_137(JNIEnv* env, jobject obj)
{

  vtkAMRVolumeMapper* op = static_cast<vtkAMRVolumeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInterpolationModeToCubic();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAMRVolumeMapper_SetNumberOfSamples_138(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkAMRVolumeMapper* op = static_cast<vtkAMRVolumeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfSamples(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAMRVolumeMapper_SetNumberOfSamples_139(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[3];
  env->GetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

  vtkAMRVolumeMapper* op = static_cast<vtkAMRVolumeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfSamples(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkAMRVolumeMapper_GetNumberOfSamples_140(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkAMRVolumeMapper* op = static_cast<vtkAMRVolumeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfSamples();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAMRVolumeMapper_Render_141(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkRenderer * temp0;
  vtkVolume * temp1;
  temp0 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkVolume*>(vtkJavaGetPointerFromObject(env, id1));

  vtkAMRVolumeMapper* op = static_cast<vtkAMRVolumeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->Render(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAMRVolumeMapper_ReleaseGraphicsResources_142(JNIEnv* env, jobject obj,jobject id0)
{
  vtkWindow * temp0;
  temp0 = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAMRVolumeMapper* op = static_cast<vtkAMRVolumeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseGraphicsResources(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAMRVolumeMapper_UpdateResampler_143(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkRenderer * temp0;
  vtkOverlappingAMR * temp1;
  temp0 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkOverlappingAMR*>(vtkJavaGetPointerFromObject(env, id1));

  vtkAMRVolumeMapper* op = static_cast<vtkAMRVolumeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->UpdateResampler(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAMRVolumeMapper_UpdateResamplerFrustrumMethod_144(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkRenderer * temp0;
  vtkOverlappingAMR * temp1;
  temp0 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkOverlappingAMR*>(vtkJavaGetPointerFromObject(env, id1));

  vtkAMRVolumeMapper* op = static_cast<vtkAMRVolumeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->UpdateResamplerFrustrumMethod(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAMRVolumeMapper_SetRequestedResamplingMode_145(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkAMRVolumeMapper* op = static_cast<vtkAMRVolumeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRequestedResamplingMode(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAMRVolumeMapper_GetRequestedResamplingMode_146(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAMRVolumeMapper* op = static_cast<vtkAMRVolumeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRequestedResamplingMode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAMRVolumeMapper_SetFreezeFocalPoint_147(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkAMRVolumeMapper* op = static_cast<vtkAMRVolumeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFreezeFocalPoint(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkAMRVolumeMapper_GetFreezeFocalPoint_148(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkAMRVolumeMapper* op = static_cast<vtkAMRVolumeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFreezeFocalPoint();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAMRVolumeMapper_SetResamplerUpdateTolerance_149(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkAMRVolumeMapper* op = static_cast<vtkAMRVolumeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetResamplerUpdateTolerance(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkAMRVolumeMapper_GetResamplerUpdateTolerance_150(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkAMRVolumeMapper* op = static_cast<vtkAMRVolumeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetResamplerUpdateTolerance();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAMRVolumeMapper_SetUseDefaultThreading_151(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkAMRVolumeMapper* op = static_cast<vtkAMRVolumeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseDefaultThreading(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkAMRVolumeMapper_GetUseDefaultThreading_152(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkAMRVolumeMapper* op = static_cast<vtkAMRVolumeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseDefaultThreading();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkAMRVolumeMapper_ComputeResamplerBoundsFrustumMethod_153(JNIEnv* env, jobject obj,jobject id0,jobject id1,jdoubleArray id2,jdoubleArray id3)
{
  vtkCamera * temp0;
  vtkRenderer * temp1;
  double temp2[6];
  double temp3[6];
  bool   temp20;
  temp0 = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id1));
  env->GetDoubleArrayRegion(id2, 0, 6, &temp2[0]);
  env->GetDoubleArrayRegion(id3, 0, 6, &temp3[0]);

  vtkAMRVolumeMapper* op = static_cast<vtkAMRVolumeMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ComputeResamplerBoundsFrustumMethod(temp0,temp1,temp2,temp3);
  env->SetDoubleArrayRegion(id3, 0, 6, &temp3[0]);
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkAMRVolumeMapper_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkAMRVolumeMapper::New());
}
