#include "nv_push_cl90b5.h"

#include <stdio.h>





const char *P_PARSE_NV85B5_MTHD(uint16_t idx) ATTRIBUTE_COLD;
void P_DUMP_NV85B5_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                                   const char *prefix) ATTRIBUTE_COLD;

const char*
P_PARSE_NV90B5_MTHD(uint16_t idx)
{
    switch (idx) {

  
    default:

    return P_PARSE_NV85B5_MTHD(idx);

    case NV90B5_LL_CMD1:
        return "NV90B5_LL_CMD1";
            case NV90B5_SET_APPLICATION_ID:
        return "NV90B5_SET_APPLICATION_ID";
        case NV90B5_SET_SEMAPHORE_A:
        return "NV90B5_SET_SEMAPHORE_A";
            case NV90B5_ADDRESSING_MODE:
        return "NV90B5_ADDRESSING_MODE";
    case NV90B5_SET_RENDER_ENABLE_A:
        return "NV90B5_SET_RENDER_ENABLE_A";
    case NV90B5_SET_RENDER_ENABLE_B:
        return "NV90B5_SET_RENDER_ENABLE_B";
    case NV90B5_SET_RENDER_ENABLE_C:
        return "NV90B5_SET_RENDER_ENABLE_C";
        case NV90B5_OFFSET_IN_UPPER:
        return "NV90B5_OFFSET_IN_UPPER";
        case NV90B5_OFFSET_OUT_UPPER:
        return "NV90B5_OFFSET_OUT_UPPER";
                                                                                    
    }
}

void
P_DUMP_NV90B5_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                         const char *prefix)
{
    UNUSED uint32_t parsed;
    switch (idx) {

  
    default:

    P_DUMP_NV85B5_MTHD_DATA(fp, idx, data, prefix);
    break;

  
    case NV90B5_LL_CMD1:

    
        parsed = (data >> 0) & ((1u << 2) - 1);
        fprintf(fp, "%s.SRC_MAX_GOBLINE_PAD_POLICY = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 2) & ((1u << 2) - 1);
        fprintf(fp, "%s.DST_MAX_GOBLINE_PAD_POLICY = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 4) & ((1u << 4) - 1);
        fprintf(fp, "%s.SRC_NONCROSSING_BOUNDARY = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 8) & ((1u << 4) - 1);
        fprintf(fp, "%s.DST_NONCROSSING_BOUNDARY = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 12) & ((1u << 1) - 1);
        fprintf(fp, "%s.P2_P_1_LINE_TRAVERSAL = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 17) & ((1u << 1) - 1);
        fprintf(fp, "%s.NO_WRITE_B14 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 18) & ((1u << 5) - 1);
        fprintf(fp, "%s.SELECT_OUT_B15 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 23) & ((1u << 1) - 1);
        fprintf(fp, "%s.NO_WRITE_B15 = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 9) & ((1u << 1) - 1);
        fprintf(fp, "%s.COPY_TYPE_SWIZ = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 10) & ((1u << 1) - 1);
        fprintf(fp, "%s.COPY_TYPE_BIGMEM = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 11) & ((1u << 3) - 1);
        fprintf(fp, "%s.BURSTSIZE_SRC = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 14) & ((1u << 3) - 1);
        fprintf(fp, "%s.BURSTSIZE_DST = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 17) & ((1u << 1) - 1);
        fprintf(fp, "%s.GOBWIDTH_SRC = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 18) & ((1u << 1) - 1);
        fprintf(fp, "%s.GOBWIDTH_DST = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 19) & ((1u << 1) - 1);
        fprintf(fp, "%s.PIPELINED_READS = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 20) & ((1u << 3) - 1);
        fprintf(fp, "%s.SRC_CTXDMA = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 23) & ((1u << 3) - 1);
        fprintf(fp, "%s.DST_CTXDMA = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
          
    case NV90B5_SET_APPLICATION_ID:

    
        parsed = data;
        fprintf(fp, "%s.ID = ", prefix);
        switch (parsed) {
        case NV90B5_SET_APPLICATION_ID_ID_NORMAL:
            fprintf(fp, "NORMAL\n");
            break;
        case NV90B5_SET_APPLICATION_ID_ID_LOW_LEVEL_CLASS:
            fprintf(fp, "LOW_LEVEL_CLASS\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
      
    case NV90B5_SET_SEMAPHORE_A:

    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
          
    case NV90B5_ADDRESSING_MODE:

    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.SRC_TYPE = ", prefix);
        switch (parsed) {
        case NV90B5_ADDRESSING_MODE_SRC_TYPE_VIRTUAL:
            fprintf(fp, "VIRTUAL\n");
            break;
        case NV90B5_ADDRESSING_MODE_SRC_TYPE_PHYSICAL:
            fprintf(fp, "PHYSICAL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 4) & ((1u << 2) - 1);
        fprintf(fp, "%s.SRC_TARGET = ", prefix);
        switch (parsed) {
        case NV90B5_ADDRESSING_MODE_SRC_TARGET_LOCAL_FB:
            fprintf(fp, "LOCAL_FB\n");
            break;
        case NV90B5_ADDRESSING_MODE_SRC_TARGET_COHERENT_SYSMEM:
            fprintf(fp, "COHERENT_SYSMEM\n");
            break;
        case NV90B5_ADDRESSING_MODE_SRC_TARGET_NONCOHERENT_SYSMEM:
            fprintf(fp, "NONCOHERENT_SYSMEM\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 8) & ((1u << 1) - 1);
        fprintf(fp, "%s.DST_TYPE = ", prefix);
        switch (parsed) {
        case NV90B5_ADDRESSING_MODE_DST_TYPE_VIRTUAL:
            fprintf(fp, "VIRTUAL\n");
            break;
        case NV90B5_ADDRESSING_MODE_DST_TYPE_PHYSICAL:
            fprintf(fp, "PHYSICAL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 12) & ((1u << 2) - 1);
        fprintf(fp, "%s.DST_TARGET = ", prefix);
        switch (parsed) {
        case NV90B5_ADDRESSING_MODE_DST_TARGET_LOCAL_FB:
            fprintf(fp, "LOCAL_FB\n");
            break;
        case NV90B5_ADDRESSING_MODE_DST_TARGET_COHERENT_SYSMEM:
            fprintf(fp, "COHERENT_SYSMEM\n");
            break;
        case NV90B5_ADDRESSING_MODE_DST_TARGET_NONCOHERENT_SYSMEM:
            fprintf(fp, "NONCOHERENT_SYSMEM\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
  
    case NV90B5_SET_RENDER_ENABLE_A:

    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NV90B5_SET_RENDER_ENABLE_B:

    
        parsed = data;
        fprintf(fp, "%s.LOWER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
  
    case NV90B5_SET_RENDER_ENABLE_C:

    
        parsed = (data >> 0) & ((1u << 3) - 1);
        fprintf(fp, "%s.MODE = ", prefix);
        switch (parsed) {
        case NV90B5_SET_RENDER_ENABLE_C_MODE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NV90B5_SET_RENDER_ENABLE_C_MODE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        case NV90B5_SET_RENDER_ENABLE_C_MODE_CONDITIONAL:
            fprintf(fp, "CONDITIONAL\n");
            break;
        case NV90B5_SET_RENDER_ENABLE_C_MODE_RENDER_IF_EQUAL:
            fprintf(fp, "RENDER_IF_EQUAL\n");
            break;
        case NV90B5_SET_RENDER_ENABLE_C_MODE_RENDER_IF_NOT_EQUAL:
            fprintf(fp, "RENDER_IF_NOT_EQUAL\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
      
    case NV90B5_OFFSET_IN_UPPER:

    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
      
    case NV90B5_OFFSET_OUT_UPPER:

    
        parsed = (data >> 0) & ((1u << 8) - 1);
        fprintf(fp, "%s.UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
                                                                                        }
}
