/* THIS FILE IS AUTOGENERATED FROM RTCPeerConnection.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "AtomList.h"
#include "DOMMediaStream.h"
#include "EventHandlerBinding.h"
#include "EventTargetBinding.h"
#include "FunctionBinding.h"
#include "MainThreadUtils.h"
#include "RTCConfigurationBinding.h"
#include "RTCIceCandidateBinding.h"
#include "RTCIdentityProviderBinding.h"
#include "RTCPeerConnectionBinding.h"
#include "RTCRtpTransceiverBinding.h"
#include "RTCSessionDescriptionBinding.h"
#include "SubtleCryptoBinding.h"
#include "WrapperFactory.h"
#include "js/Array.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/ForOfIterator.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "jsapi.h"
#include "jsfriendapi.h"
#include "mozilla/Atomics.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/StaticPrefs_media.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/DOMException.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/Document.h"
#include "mozilla/dom/MediaStreamTrack.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/Promise.h"
#include "mozilla/dom/RTCCertificate.h"
#include "mozilla/dom/RTCDataChannel.h"
#include "mozilla/dom/RTCRtpReceiver.h"
#include "mozilla/dom/RTCRtpSender.h"
#include "mozilla/dom/RTCRtpTransceiver.h"
#include "mozilla/dom/RTCSctpTransport.h"
#include "mozilla/dom/RTCStatsReport.h"
#include "mozilla/dom/ScriptSettings.h"
#include "mozilla/dom/SimpleGlobalObject.h"
#include "mozilla/dom/ToJSValue.h"
#include "mozilla/dom/XrayExpandoClass.h"
#include "nsContentUtils.h"
#include "nsIGlobalObject.h"

namespace mozilla {

namespace dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;


namespace binding_detail {
constexpr nsLiteralCString EnumStrings<RTCSignalingState>::Values[6];
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, RTCSignalingState aArgument, JS::MutableHandle<JS::Value> aValue)
{
  MOZ_ASSERT(uint32_t(aArgument) < std::size(binding_detail::EnumStrings<RTCSignalingState>::Values));
  JSString* resultStr =
    JS_NewStringCopyN(aCx, binding_detail::EnumStrings<RTCSignalingState>::Values[uint32_t(aArgument)].BeginReading(),
                      binding_detail::EnumStrings<RTCSignalingState>::Values[uint32_t(aArgument)].Length());
  if (!resultStr) {
    return false;
  }
  aValue.setString(resultStr);
  return true;
}


namespace binding_detail {
constexpr nsLiteralCString EnumStrings<RTCIceGatheringState>::Values[3];
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, RTCIceGatheringState aArgument, JS::MutableHandle<JS::Value> aValue)
{
  MOZ_ASSERT(uint32_t(aArgument) < std::size(binding_detail::EnumStrings<RTCIceGatheringState>::Values));
  JSString* resultStr =
    JS_NewStringCopyN(aCx, binding_detail::EnumStrings<RTCIceGatheringState>::Values[uint32_t(aArgument)].BeginReading(),
                      binding_detail::EnumStrings<RTCIceGatheringState>::Values[uint32_t(aArgument)].Length());
  if (!resultStr) {
    return false;
  }
  aValue.setString(resultStr);
  return true;
}


namespace binding_detail {
constexpr nsLiteralCString EnumStrings<RTCIceConnectionState>::Values[7];
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, RTCIceConnectionState aArgument, JS::MutableHandle<JS::Value> aValue)
{
  MOZ_ASSERT(uint32_t(aArgument) < std::size(binding_detail::EnumStrings<RTCIceConnectionState>::Values));
  JSString* resultStr =
    JS_NewStringCopyN(aCx, binding_detail::EnumStrings<RTCIceConnectionState>::Values[uint32_t(aArgument)].BeginReading(),
                      binding_detail::EnumStrings<RTCIceConnectionState>::Values[uint32_t(aArgument)].Length());
  if (!resultStr) {
    return false;
  }
  aValue.setString(resultStr);
  return true;
}


namespace binding_detail {
constexpr nsLiteralCString EnumStrings<RTCPeerConnectionState>::Values[6];
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, RTCPeerConnectionState aArgument, JS::MutableHandle<JS::Value> aValue)
{
  MOZ_ASSERT(uint32_t(aArgument) < std::size(binding_detail::EnumStrings<RTCPeerConnectionState>::Values));
  JSString* resultStr =
    JS_NewStringCopyN(aCx, binding_detail::EnumStrings<RTCPeerConnectionState>::Values[uint32_t(aArgument)].BeginReading(),
                      binding_detail::EnumStrings<RTCPeerConnectionState>::Values[uint32_t(aArgument)].Length());
  if (!resultStr) {
    return false;
  }
  aValue.setString(resultStr);
  return true;
}


namespace binding_detail {
constexpr nsLiteralCString EnumStrings<mozPacketDumpType>::Values[4];
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, mozPacketDumpType aArgument, JS::MutableHandle<JS::Value> aValue)
{
  MOZ_ASSERT(uint32_t(aArgument) < std::size(binding_detail::EnumStrings<mozPacketDumpType>::Values));
  JSString* resultStr =
    JS_NewStringCopyN(aCx, binding_detail::EnumStrings<mozPacketDumpType>::Values[uint32_t(aArgument)].BeginReading(),
                      binding_detail::EnumStrings<mozPacketDumpType>::Values[uint32_t(aArgument)].Length());
  if (!resultStr) {
    return false;
  }
  aValue.setString(resultStr);
  return true;
}


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningMediaStreamTrackOrString& aUnion, const char* aName, uint32_t aFlags)
{
  if (aUnion.IsMediaStreamTrack()) {
    ImplCycleCollectionTraverse(aCallback, aUnion.GetAsMediaStreamTrack(), "mMediaStreamTrack", aFlags);
  }
}


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningRTCIceCandidateInitOrRTCIceCandidate& aUnion, const char* aName, uint32_t aFlags)
{
  if (aUnion.IsRTCIceCandidate()) {
    ImplCycleCollectionTraverse(aCallback, aUnion.GetAsRTCIceCandidate(), "mRTCIceCandidate", aFlags);
  }
}


void
ImplCycleCollectionUnlink(OwningMediaStreamTrackOrString& aUnion)
{
  aUnion.Uninit();
}


void
ImplCycleCollectionUnlink(OwningRTCIceCandidateInitOrRTCIceCandidate& aUnion)
{
  aUnion.Uninit();
}


bool
MediaStreamTrackOrString::TrySetToMediaStreamTrack(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    NonNull<mozilla::dom::MediaStreamTrack>& memberSlot = RawSetAsMediaStreamTrack();
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::MediaStreamTrack, mozilla::dom::MediaStreamTrack>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroyMediaStreamTrack();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
MediaStreamTrackOrString::TrySetToMediaStreamTrack(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToMediaStreamTrack(cx, value, tryNext, passedToJSImpl);
}







bool
MediaStreamTrackOrString::TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    binding_detail::FakeString<char16_t>& memberSlot = RawSetAsString();
    if (!ConvertJSValueToString(cx, value, eStringify, eStringify, memberSlot)) {
      return false;
    }
  }
  return true;
}








bool
MediaStreamTrackOrString::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  bool done = false, failed = false, tryNext;
  if (value.isObject()) {
    done = (failed = !TrySetToMediaStreamTrack(cx, value, tryNext, passedToJSImpl)) || !tryNext;
  }
  if (!done) {
    do {
      done = (failed = !TrySetToString(cx, value, tryNext)) || !tryNext;
      break;
    } while (false);
  }
  if (failed) {
    return false;
  }
  if (!done) {
    cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "MediaStreamTrack");
    return false;
  }
  return true;
}

bool
MediaStreamTrackOrString::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}


bool
MediaStreamTrackOrString::ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const
{
  switch (mType) {
    case eUninitialized: {
      return false;
    }
    case eMediaStreamTrack: {
      if (!GetOrCreateDOMReflector(cx, mValue.mMediaStreamTrack.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    case eString: {
      if (!xpc::NonVoidStringToJsval(cx, mValue.mString.Value(), rval)) {
        return false;
      }
      return true;
    }
    default: {
      return false;
    }
  }
}



OwningMediaStreamTrackOrString::OwningMediaStreamTrackOrString(OwningMediaStreamTrackOrString&& aOther)
  : mType(eUninitialized)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eMediaStreamTrack: {
      mType = eMediaStreamTrack;
      mValue.mMediaStreamTrack.SetValue(std::move(aOther.mValue.mMediaStreamTrack.Value()));
      break;
    }
    case eString: {
      mType = eString;
      mValue.mString.SetValue(std::move(aOther.mValue.mString.Value()));
      break;
    }
  }
}



bool
OwningMediaStreamTrackOrString::TrySetToMediaStreamTrack(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    OwningNonNull<mozilla::dom::MediaStreamTrack>& memberSlot = RawSetAsMediaStreamTrack();
    static_assert(IsRefcounted<mozilla::dom::MediaStreamTrack>::value, "We can only store refcounted classes.");
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::MediaStreamTrack, mozilla::dom::MediaStreamTrack>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroyMediaStreamTrack();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
OwningMediaStreamTrackOrString::TrySetToMediaStreamTrack(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToMediaStreamTrack(cx, value, tryNext, passedToJSImpl);
}

[[nodiscard]] OwningNonNull<mozilla::dom::MediaStreamTrack>&
OwningMediaStreamTrackOrString::RawSetAsMediaStreamTrack()
{
  if (mType == eMediaStreamTrack) {
    return mValue.mMediaStreamTrack.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eMediaStreamTrack;
  return mValue.mMediaStreamTrack.SetValue();
}

[[nodiscard]] OwningNonNull<mozilla::dom::MediaStreamTrack>&
OwningMediaStreamTrackOrString::SetAsMediaStreamTrack()
{
  if (mType == eMediaStreamTrack) {
    return mValue.mMediaStreamTrack.Value();
  }
  Uninit();
  mType = eMediaStreamTrack;
  return mValue.mMediaStreamTrack.SetValue();
}


void
OwningMediaStreamTrackOrString::DestroyMediaStreamTrack()
{
  MOZ_RELEASE_ASSERT(IsMediaStreamTrack(), "Wrong type!");
  mValue.mMediaStreamTrack.Destroy();
  mType = eUninitialized;
}



bool
OwningMediaStreamTrackOrString::TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    nsString& memberSlot = RawSetAsString();
    if (!ConvertJSValueToString(cx, value, eStringify, eStringify, memberSlot)) {
      return false;
    }
  }
  return true;
}

[[nodiscard]] nsString&
OwningMediaStreamTrackOrString::RawSetAsString()
{
  if (mType == eString) {
    return mValue.mString.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eString;
  return mValue.mString.SetValue();
}

[[nodiscard]] nsString&
OwningMediaStreamTrackOrString::SetAsString()
{
  if (mType == eString) {
    return mValue.mString.Value();
  }
  Uninit();
  mType = eString;
  return mValue.mString.SetValue();
}



void
OwningMediaStreamTrackOrString::DestroyString()
{
  MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
  mValue.mString.Destroy();
  mType = eUninitialized;
}



bool
OwningMediaStreamTrackOrString::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  bool done = false, failed = false, tryNext;
  if (value.isObject()) {
    done = (failed = !TrySetToMediaStreamTrack(cx, value, tryNext, passedToJSImpl)) || !tryNext;
  }
  if (!done) {
    do {
      done = (failed = !TrySetToString(cx, value, tryNext)) || !tryNext;
      break;
    } while (false);
  }
  if (failed) {
    return false;
  }
  if (!done) {
    cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "MediaStreamTrack");
    return false;
  }
  return true;
}

bool
OwningMediaStreamTrackOrString::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}

void
OwningMediaStreamTrackOrString::Uninit()
{
  switch (mType) {
    case eUninitialized: {
      break;
    }
    case eMediaStreamTrack: {
      DestroyMediaStreamTrack();
      break;
    }
    case eString: {
      DestroyString();
      break;
    }
  }
}

bool
OwningMediaStreamTrackOrString::ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const
{
  switch (mType) {
    case eUninitialized: {
      return false;
    }
    case eMediaStreamTrack: {
      if (!GetOrCreateDOMReflector(cx, mValue.mMediaStreamTrack.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    case eString: {
      if (!xpc::NonVoidStringToJsval(cx, mValue.mString.Value(), rval)) {
        return false;
      }
      return true;
    }
    default: {
      return false;
    }
  }
}

OwningMediaStreamTrackOrString&
OwningMediaStreamTrackOrString::operator=(OwningMediaStreamTrackOrString&& aOther)
{
  this->~OwningMediaStreamTrackOrString();
  new (this) OwningMediaStreamTrackOrString (std::move(aOther));
  return *this;
}


OwningMediaStreamTrackOrString&
OwningMediaStreamTrackOrString::operator=(const OwningMediaStreamTrackOrString& aOther)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eMediaStreamTrack: {
      SetAsMediaStreamTrack() = aOther.GetAsMediaStreamTrack();
      break;
    }
    case eString: {
      SetAsString() = aOther.GetAsString();
      break;
    }
  }
  return *this;
}



RTCDataChannelInit::RTCDataChannelInit()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
RTCDataChannelInit::InitIds(JSContext* cx, RTCDataChannelInitAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->protocol_id.init(cx, "protocol") ||
      !atomsCache->ordered_id.init(cx, "ordered") ||
      !atomsCache->negotiated_id.init(cx, "negotiated") ||
      !atomsCache->maxRetransmits_id.init(cx, "maxRetransmits") ||
      !atomsCache->maxPacketLifeTime_id.init(cx, "maxPacketLifeTime") ||
      !atomsCache->id_id.init(cx, "id")) {
    return false;
  }
  return true;
}

bool
RTCDataChannelInit::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  RTCDataChannelInitAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<RTCDataChannelInitAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->id_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mId.Construct();
    if (!ValueToPrimitive<uint16_t, eEnforceRange>(cx, temp.ref(), "'id' member of RTCDataChannelInit", &(mId.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->maxPacketLifeTime_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mMaxPacketLifeTime.Construct();
    if (!ValueToPrimitive<uint16_t, eEnforceRange>(cx, temp.ref(), "'maxPacketLifeTime' member of RTCDataChannelInit", &(mMaxPacketLifeTime.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->maxRetransmits_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mMaxRetransmits.Construct();
    if (!ValueToPrimitive<uint16_t, eEnforceRange>(cx, temp.ref(), "'maxRetransmits' member of RTCDataChannelInit", &(mMaxRetransmits.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->negotiated_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'negotiated' member of RTCDataChannelInit", &mNegotiated)) {
      return false;
    }
  } else {
    mNegotiated = false;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->ordered_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'ordered' member of RTCDataChannelInit", &mOrdered)) {
      return false;
    }
  } else {
    mOrdered = true;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->protocol_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, mProtocol)) {
      return false;
    }
  } else {
    mProtocol.AssignLiteral("");
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
RTCDataChannelInit::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

bool
RTCDataChannelInit::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  RTCDataChannelInitAtoms* atomsCache = GetAtomCache<RTCDataChannelInitAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  if (mId.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint16_t const & currentValue = mId.InternalValue();
      temp.setInt32(int32_t(currentValue));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->id_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mMaxPacketLifeTime.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint16_t const & currentValue = mMaxPacketLifeTime.InternalValue();
      temp.setInt32(int32_t(currentValue));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->maxPacketLifeTime_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mMaxRetransmits.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint16_t const & currentValue = mMaxRetransmits.InternalValue();
      temp.setInt32(int32_t(currentValue));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->maxRetransmits_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    bool const & currentValue = mNegotiated;
    temp.setBoolean(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->negotiated_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    bool const & currentValue = mOrdered;
    temp.setBoolean(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->ordered_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsCString const & currentValue = mProtocol;
    if (!NonVoidUTF8StringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->protocol_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
RTCDataChannelInit::TraceDictionary(JSTracer* trc)
{
}

RTCDataChannelInit&
RTCDataChannelInit::operator=(const RTCDataChannelInit& aOther)
{
  DictionaryBase::operator=(aOther);
  mId.Reset();
  if (aOther.mId.WasPassed()) {
    mId.Construct(aOther.mId.Value());
  }
  mMaxPacketLifeTime.Reset();
  if (aOther.mMaxPacketLifeTime.WasPassed()) {
    mMaxPacketLifeTime.Construct(aOther.mMaxPacketLifeTime.Value());
  }
  mMaxRetransmits.Reset();
  if (aOther.mMaxRetransmits.WasPassed()) {
    mMaxRetransmits.Construct(aOther.mMaxRetransmits.Value());
  }
  mNegotiated = aOther.mNegotiated;
  mOrdered = aOther.mOrdered;
  mProtocol = aOther.mProtocol;
  return *this;
}


bool
RTCIceCandidateInitOrRTCIceCandidate::TrySetToRTCIceCandidateInit(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    binding_detail::FastRTCIceCandidateInit& memberSlot = RawSetAsRTCIceCandidateInit();
    if (!IsConvertibleToDictionary(value)) {
      DestroyRTCIceCandidateInit();
      tryNext = true;
      return true;
    }
    if (!memberSlot.Init(cx, value, "RTCIceCandidateInit branch of (RTCIceCandidateInit or RTCIceCandidate)", passedToJSImpl)) {
      return false;
    }
  }
  return true;
}

bool
RTCIceCandidateInitOrRTCIceCandidate::TrySetToRTCIceCandidateInit(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToRTCIceCandidateInit(cx, value, tryNext, passedToJSImpl);
}







bool
RTCIceCandidateInitOrRTCIceCandidate::TrySetToRTCIceCandidate(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    NonNull<mozilla::dom::RTCIceCandidate>& memberSlot = RawSetAsRTCIceCandidate();
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::RTCIceCandidate, mozilla::dom::RTCIceCandidate>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroyRTCIceCandidate();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
RTCIceCandidateInitOrRTCIceCandidate::TrySetToRTCIceCandidate(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToRTCIceCandidate(cx, value, tryNext, passedToJSImpl);
}







bool
RTCIceCandidateInitOrRTCIceCandidate::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  bool done = false, failed = false, tryNext;
  if (value.isObject()) {
    done = (failed = !TrySetToRTCIceCandidate(cx, value, tryNext, passedToJSImpl)) || !tryNext;
  }
  if (!done) {
    done = (failed = !TrySetToRTCIceCandidateInit(cx, value, tryNext, passedToJSImpl)) || !tryNext;
  }
  if (failed) {
    return false;
  }
  if (!done) {
    cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "RTCIceCandidate, RTCIceCandidateInit");
    return false;
  }
  return true;
}

bool
RTCIceCandidateInitOrRTCIceCandidate::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}


bool
RTCIceCandidateInitOrRTCIceCandidate::ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const
{
  switch (mType) {
    case eUninitialized: {
      return false;
    }
    case eRTCIceCandidateInit: {
      if (!mValue.mRTCIceCandidateInit.Value().ToObjectInternal(cx, rval)) {
        return false;
      }
      return true;
    }
    case eRTCIceCandidate: {
      if (!GetOrCreateDOMReflector(cx, mValue.mRTCIceCandidate.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    default: {
      return false;
    }
  }
}



OwningRTCIceCandidateInitOrRTCIceCandidate::OwningRTCIceCandidateInitOrRTCIceCandidate(OwningRTCIceCandidateInitOrRTCIceCandidate&& aOther)
  : mType(eUninitialized)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eRTCIceCandidateInit: {
      mType = eRTCIceCandidateInit;
      mValue.mRTCIceCandidateInit.SetValue(std::move(aOther.mValue.mRTCIceCandidateInit.Value()));
      break;
    }
    case eRTCIceCandidate: {
      mType = eRTCIceCandidate;
      mValue.mRTCIceCandidate.SetValue(std::move(aOther.mValue.mRTCIceCandidate.Value()));
      break;
    }
  }
}



bool
OwningRTCIceCandidateInitOrRTCIceCandidate::TrySetToRTCIceCandidateInit(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    RTCIceCandidateInit& memberSlot = RawSetAsRTCIceCandidateInit();
    if (!IsConvertibleToDictionary(value)) {
      DestroyRTCIceCandidateInit();
      tryNext = true;
      return true;
    }
    if (!memberSlot.Init(cx, value, "RTCIceCandidateInit branch of (RTCIceCandidateInit or RTCIceCandidate)", passedToJSImpl)) {
      return false;
    }
  }
  return true;
}

bool
OwningRTCIceCandidateInitOrRTCIceCandidate::TrySetToRTCIceCandidateInit(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToRTCIceCandidateInit(cx, value, tryNext, passedToJSImpl);
}

[[nodiscard]] RTCIceCandidateInit&
OwningRTCIceCandidateInitOrRTCIceCandidate::RawSetAsRTCIceCandidateInit()
{
  if (mType == eRTCIceCandidateInit) {
    return mValue.mRTCIceCandidateInit.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eRTCIceCandidateInit;
  return mValue.mRTCIceCandidateInit.SetValue();
}

[[nodiscard]] RTCIceCandidateInit&
OwningRTCIceCandidateInitOrRTCIceCandidate::SetAsRTCIceCandidateInit()
{
  if (mType == eRTCIceCandidateInit) {
    return mValue.mRTCIceCandidateInit.Value();
  }
  Uninit();
  mType = eRTCIceCandidateInit;
  return mValue.mRTCIceCandidateInit.SetValue();
}


void
OwningRTCIceCandidateInitOrRTCIceCandidate::DestroyRTCIceCandidateInit()
{
  MOZ_RELEASE_ASSERT(IsRTCIceCandidateInit(), "Wrong type!");
  mValue.mRTCIceCandidateInit.Destroy();
  mType = eUninitialized;
}



bool
OwningRTCIceCandidateInitOrRTCIceCandidate::TrySetToRTCIceCandidate(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    OwningNonNull<mozilla::dom::RTCIceCandidate>& memberSlot = RawSetAsRTCIceCandidate();
    static_assert(IsRefcounted<mozilla::dom::RTCIceCandidate>::value, "We can only store refcounted classes.");
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::RTCIceCandidate, mozilla::dom::RTCIceCandidate>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroyRTCIceCandidate();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
OwningRTCIceCandidateInitOrRTCIceCandidate::TrySetToRTCIceCandidate(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToRTCIceCandidate(cx, value, tryNext, passedToJSImpl);
}

[[nodiscard]] OwningNonNull<mozilla::dom::RTCIceCandidate>&
OwningRTCIceCandidateInitOrRTCIceCandidate::RawSetAsRTCIceCandidate()
{
  if (mType == eRTCIceCandidate) {
    return mValue.mRTCIceCandidate.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eRTCIceCandidate;
  return mValue.mRTCIceCandidate.SetValue();
}

[[nodiscard]] OwningNonNull<mozilla::dom::RTCIceCandidate>&
OwningRTCIceCandidateInitOrRTCIceCandidate::SetAsRTCIceCandidate()
{
  if (mType == eRTCIceCandidate) {
    return mValue.mRTCIceCandidate.Value();
  }
  Uninit();
  mType = eRTCIceCandidate;
  return mValue.mRTCIceCandidate.SetValue();
}


void
OwningRTCIceCandidateInitOrRTCIceCandidate::DestroyRTCIceCandidate()
{
  MOZ_RELEASE_ASSERT(IsRTCIceCandidate(), "Wrong type!");
  mValue.mRTCIceCandidate.Destroy();
  mType = eUninitialized;
}



bool
OwningRTCIceCandidateInitOrRTCIceCandidate::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  bool done = false, failed = false, tryNext;
  if (value.isObject()) {
    done = (failed = !TrySetToRTCIceCandidate(cx, value, tryNext, passedToJSImpl)) || !tryNext;
  }
  if (!done) {
    done = (failed = !TrySetToRTCIceCandidateInit(cx, value, tryNext, passedToJSImpl)) || !tryNext;
  }
  if (failed) {
    return false;
  }
  if (!done) {
    cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "RTCIceCandidate, RTCIceCandidateInit");
    return false;
  }
  return true;
}

bool
OwningRTCIceCandidateInitOrRTCIceCandidate::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}

void
OwningRTCIceCandidateInitOrRTCIceCandidate::Uninit()
{
  switch (mType) {
    case eUninitialized: {
      break;
    }
    case eRTCIceCandidateInit: {
      DestroyRTCIceCandidateInit();
      break;
    }
    case eRTCIceCandidate: {
      DestroyRTCIceCandidate();
      break;
    }
  }
}

bool
OwningRTCIceCandidateInitOrRTCIceCandidate::ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const
{
  switch (mType) {
    case eUninitialized: {
      return false;
    }
    case eRTCIceCandidateInit: {
      if (!mValue.mRTCIceCandidateInit.Value().ToObjectInternal(cx, rval)) {
        return false;
      }
      return true;
    }
    case eRTCIceCandidate: {
      if (!GetOrCreateDOMReflector(cx, mValue.mRTCIceCandidate.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    default: {
      return false;
    }
  }
}

OwningRTCIceCandidateInitOrRTCIceCandidate&
OwningRTCIceCandidateInitOrRTCIceCandidate::operator=(OwningRTCIceCandidateInitOrRTCIceCandidate&& aOther)
{
  this->~OwningRTCIceCandidateInitOrRTCIceCandidate();
  new (this) OwningRTCIceCandidateInitOrRTCIceCandidate (std::move(aOther));
  return *this;
}


OwningRTCIceCandidateInitOrRTCIceCandidate&
OwningRTCIceCandidateInitOrRTCIceCandidate::operator=(const OwningRTCIceCandidateInitOrRTCIceCandidate& aOther)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eRTCIceCandidateInit: {
      SetAsRTCIceCandidateInit() = aOther.GetAsRTCIceCandidateInit();
      break;
    }
    case eRTCIceCandidate: {
      SetAsRTCIceCandidate() = aOther.GetAsRTCIceCandidate();
      break;
    }
  }
  return *this;
}



RTCOfferAnswerOptions::RTCOfferAnswerOptions()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
RTCOfferAnswerOptions::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  return true;
}

bool
RTCOfferAnswerOptions::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

bool
RTCOfferAnswerOptions::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));


  return true;
}

void
RTCOfferAnswerOptions::TraceDictionary(JSTracer* trc)
{
}

RTCOfferAnswerOptions&
RTCOfferAnswerOptions::operator=(const RTCOfferAnswerOptions& aOther)
{
  DictionaryBase::operator=(aOther);
  return *this;
}


MOZ_CAN_RUN_SCRIPT void
RTCPeerConnectionErrorCallback::Call(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, DOMException& error, ErrorResult& aRv)
{
  JS::Rooted<JS::Value> rval(cx);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(1)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return;
  }
  unsigned argc = 1;

  do {
    if (!GetOrCreateDOMReflector(cx, error, argv[0])) {
      MOZ_ASSERT(JS_IsExceptionPending(cx));
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    break;
  } while (false);

  JS::Rooted<JS::Value> callable(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, aThisVal, callable,
                JS::HandleValueArray::subarray(argv, 0, argc), &rval)) {
    aRv.NoteJSContextException(cx);
    return;
  }
}



MOZ_CAN_RUN_SCRIPT void
RTCSessionDescriptionCallback::Call(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, const RTCSessionDescriptionInit& description, ErrorResult& aRv)
{
  JS::Rooted<JS::Value> rval(cx);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(1)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return;
  }
  unsigned argc = 1;

  do {
    if (!description.ToObjectInternal(cx, argv[0])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    break;
  } while (false);

  JS::Rooted<JS::Value> callable(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, aThisVal, callable,
                JS::HandleValueArray::subarray(argv, 0, argc), &rval)) {
    aRv.NoteJSContextException(cx);
    return;
  }
}



MOZ_CAN_RUN_SCRIPT void
RTCStatsCallback::Call(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, RTCStatsReport& report, ErrorResult& aRv)
{
  JS::Rooted<JS::Value> rval(cx);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(1)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return;
  }
  unsigned argc = 1;

  do {
    if (!GetOrCreateDOMReflector(cx, report, argv[0])) {
      MOZ_ASSERT(JS_IsExceptionPending(cx));
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    break;
  } while (false);

  JS::Rooted<JS::Value> callable(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, aThisVal, callable,
                JS::HandleValueArray::subarray(argv, 0, argc), &rval)) {
    aRv.NoteJSContextException(cx);
    return;
  }
}



MOZ_CAN_RUN_SCRIPT void
mozPacketCallback::Call(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, uint32_t level, mozPacketDumpType type, bool sending, JS::Handle<JSObject*> packet, ErrorResult& aRv)
{
  JS::Rooted<JS::Value> rval(cx);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(4)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return;
  }
  unsigned argc = 4;

  do {
    JS::ExposeObjectToActiveJS(packet);
    argv[3].setObject(*packet);
    if (!MaybeWrapNonDOMObjectValue(cx, argv[3])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    break;
  } while (false);

  do {
    argv[2].setBoolean(sending);
    break;
  } while (false);

  do {
    if (!ToJSValue(cx, type, argv[1])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    break;
  } while (false);

  do {
    argv[0].setNumber(level);
    break;
  } while (false);

  JS::Rooted<JS::Value> callable(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, aThisVal, callable,
                JS::HandleValueArray::subarray(argv, 0, argc), &rval)) {
    aRv.NoteJSContextException(cx);
    return;
  }
}




RTCAnswerOptions::RTCAnswerOptions()
  : RTCOfferAnswerOptions(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
RTCAnswerOptions::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  // Per spec, we init the parent's members first
  if (!RTCOfferAnswerOptions::Init(cx, val)) {
    return false;
  }

  return true;
}

bool
RTCAnswerOptions::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

bool
RTCAnswerOptions::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  // Per spec, we define the parent's members first
  if (!RTCOfferAnswerOptions::ToObjectInternal(cx, rval)) {
    return false;
  }
  JS::Rooted<JSObject*> obj(cx, &rval.toObject());


  return true;
}

void
RTCAnswerOptions::TraceDictionary(JSTracer* trc)
{
  RTCOfferAnswerOptions::TraceDictionary(trc);
}

RTCAnswerOptions&
RTCAnswerOptions::operator=(const RTCAnswerOptions& aOther)
{
  RTCOfferAnswerOptions::operator=(aOther);
  return *this;
}



RTCOfferOptions::RTCOfferOptions()
  : RTCOfferAnswerOptions(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
RTCOfferOptions::InitIds(JSContext* cx, RTCOfferOptionsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->offerToReceiveVideo_id.init(cx, "offerToReceiveVideo") ||
      !atomsCache->offerToReceiveAudio_id.init(cx, "offerToReceiveAudio") ||
      !atomsCache->iceRestart_id.init(cx, "iceRestart")) {
    return false;
  }
  return true;
}

bool
RTCOfferOptions::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  RTCOfferOptionsAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<RTCOfferOptionsAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  // Per spec, we init the parent's members first
  if (!RTCOfferAnswerOptions::Init(cx, val)) {
    return false;
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->iceRestart_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'iceRestart' member of RTCOfferOptions", &mIceRestart)) {
      return false;
    }
  } else {
    mIceRestart = false;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->offerToReceiveAudio_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mOfferToReceiveAudio.Construct();
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'offerToReceiveAudio' member of RTCOfferOptions", &(mOfferToReceiveAudio.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->offerToReceiveVideo_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mOfferToReceiveVideo.Construct();
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'offerToReceiveVideo' member of RTCOfferOptions", &(mOfferToReceiveVideo.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }
  return true;
}

bool
RTCOfferOptions::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

bool
RTCOfferOptions::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  RTCOfferOptionsAtoms* atomsCache = GetAtomCache<RTCOfferOptionsAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  // Per spec, we define the parent's members first
  if (!RTCOfferAnswerOptions::ToObjectInternal(cx, rval)) {
    return false;
  }
  JS::Rooted<JSObject*> obj(cx, &rval.toObject());

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    bool const & currentValue = mIceRestart;
    temp.setBoolean(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->iceRestart_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  if (mOfferToReceiveAudio.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      bool const & currentValue = mOfferToReceiveAudio.InternalValue();
      temp.setBoolean(currentValue);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->offerToReceiveAudio_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mOfferToReceiveVideo.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      bool const & currentValue = mOfferToReceiveVideo.InternalValue();
      temp.setBoolean(currentValue);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->offerToReceiveVideo_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  return true;
}

void
RTCOfferOptions::TraceDictionary(JSTracer* trc)
{
  RTCOfferAnswerOptions::TraceDictionary(trc);
}

RTCOfferOptions&
RTCOfferOptions::operator=(const RTCOfferOptions& aOther)
{
  RTCOfferAnswerOptions::operator=(aOther);
  mIceRestart = aOther.mIceRestart;
  mOfferToReceiveAudio.Reset();
  if (aOther.mOfferToReceiveAudio.WasPassed()) {
    mOfferToReceiveAudio.Construct(aOther.mOfferToReceiveAudio.Value());
  }
  mOfferToReceiveVideo.Reset();
  if (aOther.mOfferToReceiveVideo.WasPassed()) {
    mOfferToReceiveVideo.Construct(aOther.mOfferToReceiveVideo.Value());
  }
  return *this;
}


namespace RTCPeerConnection_Binding {

static_assert(IsRefcounted<NativeType>::value == IsRefcounted<EventTarget_Binding::NativeType>::value,
              "Can't inherit from an interface with a different ownership model.");

MOZ_CAN_RUN_SCRIPT static bool
generateCertificate(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "RTCPeerConnection.generateCertificate");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "generateCertificate", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "RTCPeerConnection.generateCertificate", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  ObjectOrString arg0;
  if (!arg0.Init(cx, args[0], "Argument 1", true)) {
    return false;
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<Promise>(mozilla::dom::RTCCertificate::GenerateCertificate(global, Constify(arg0), rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.generateCertificate"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}


static const JSJitInfo generateCertificate_methodinfo = {
  { (JSJitGetterOp)generateCertificate },
  { prototypes::id::_ID_Count }, { 0 }, JSJitInfo::StaticMethod,
  JSJitInfo::AliasEverything, JSVAL_TYPE_OBJECT, false, false,
  false, false, 0
};

MOZ_CAN_RUN_SCRIPT static bool
setIdentityProvider(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "RTCPeerConnection.setIdentityProvider");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "setIdentityProvider", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  if (!args.requireAtLeast(cx, "RTCPeerConnection.setIdentityProvider", 1)) {
    return false;
  }
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  binding_detail::FastRTCIdentityProviderOptions arg1;
  if (!arg1.Init(cx, (args.hasDefined(1)) ? args[1] : JS::NullHandleValue, "Argument 2", true)) {
    return false;
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetIdentityProvider(NonNullHelper(Constify(arg0)), Constify(arg1), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetIdentityProvider(NonNullHelper(Constify(arg0)), Constify(arg1), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.setIdentityProvider"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo setIdentityProvider_methodinfo = {
  { (JSJitGetterOp)setIdentityProvider },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getIdentityAssertion(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "getIdentityAssertion", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->GetIdentityAssertion(rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)))));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.getIdentityAssertion"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
getIdentityAssertion_promiseWrapper(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  bool ok = getIdentityAssertion(cx, obj, void_self, args);
  if (ok) {
    return true;
  }
  return ConvertExceptionToPromise(cx, args.rval());
}

static const JSJitInfo getIdentityAssertion_methodinfo = {
  { (JSJitGetterOp)getIdentityAssertion_promiseWrapper },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
createOffer(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "RTCPeerConnection.createOffer");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "createOffer", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  unsigned argcount = std::min(args.length(), 3u);
  switch (argcount) {
    case 0: {
      [[fallthrough]];
    }
    case 1: {
      Maybe<JS::Rooted<JSObject*> > unwrappedObj;
      bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
      if (objIsXray) {
        unwrappedObj.emplace(cx, obj);
      }
      binding_detail::FastRTCOfferOptions arg0;
      if (!arg0.Init(cx, (args.hasDefined(0)) ? args[0] : JS::NullHandleValue, "Argument 1", true)) {
        return false;
      }
      if (objIsXray) {
        // Since our object is an Xray, we can just CheckedUnwrapStatic:
        // we know Xrays have no dynamic unwrap behavior.
        unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
        if (!unwrappedObj.ref()) {
          return false;
        }
      }
      FastErrorResult rv;
      auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->CreateOffer(Constify(arg0), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)))));
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.createOffer"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      if (!ToJSValue(cx, result, args.rval())) {
        return false;
      }
      return true;
      break;
    }
    case 2: {
      [[fallthrough]];
    }
    case 3: {
      Maybe<JS::Rooted<JSObject*> > unwrappedObj;
      bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
      if (objIsXray) {
        unwrappedObj.emplace(cx, obj);
      }
      RootedCallback<OwningNonNull<binding_detail::FastRTCSessionDescriptionCallback>> arg0(cx);
      if (args[0].isObject()) {
        if (JS::IsCallable(&args[0].toObject())) {
        { // scope for tempRoot and tempGlobalRoot if needed
          arg0 = new binding_detail::FastRTCSessionDescriptionCallback(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
        }
        } else {
          cx.ThrowErrorMessage<MSG_NOT_CALLABLE>("Argument 1");
          return false;
        }
      } else {
        cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
        return false;
      }
      RootedCallback<OwningNonNull<binding_detail::FastRTCPeerConnectionErrorCallback>> arg1(cx);
      if (args[1].isObject()) {
        if (JS::IsCallable(&args[1].toObject())) {
        { // scope for tempRoot and tempGlobalRoot if needed
          arg1 = new binding_detail::FastRTCPeerConnectionErrorCallback(&args[1].toObject(), JS::CurrentGlobalOrNull(cx));
        }
        } else {
          cx.ThrowErrorMessage<MSG_NOT_CALLABLE>("Argument 2");
          return false;
        }
      } else {
        cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 2");
        return false;
      }
      binding_detail::FastRTCOfferOptions arg2;
      if (!arg2.Init(cx, (args.hasDefined(2)) ? args[2] : JS::NullHandleValue, "Argument 3", true)) {
        return false;
      }
      if (objIsXray) {
        // Since our object is an Xray, we can just CheckedUnwrapStatic:
        // we know Xrays have no dynamic unwrap behavior.
        unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
        if (!unwrappedObj.ref()) {
          return false;
        }
      }
      FastErrorResult rv;
      auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->CreateOffer(MOZ_KnownLive(NonNullHelper(arg0)), MOZ_KnownLive(NonNullHelper(arg1)), Constify(arg2), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)))));
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.createOffer"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      if (!ToJSValue(cx, result, args.rval())) {
        return false;
      }
      return true;
      break;
    }
    default: {
      // Using nsPrintfCString here would require including that
      // header.  Let's not worry about it.
      nsAutoCString argCountStr;
      argCountStr.AppendPrintf("%u", args.length());
      return cx.ThrowErrorMessage<MSG_INVALID_OVERLOAD_ARGCOUNT>(argCountStr.get());
    }
  }
  MOZ_CRASH("We have an always-returning default case");
  return false;
}

MOZ_CAN_RUN_SCRIPT static bool
createOffer_promiseWrapper(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  bool ok = createOffer(cx, obj, void_self, args);
  if (ok) {
    return true;
  }
  return ConvertExceptionToPromise(cx, args.rval());
}

static const JSJitInfo createOffer_methodinfo = {
  { (JSJitGetterOp)createOffer_promiseWrapper },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
createAnswer(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "RTCPeerConnection.createAnswer");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "createAnswer", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  unsigned argcount = std::min(args.length(), 2u);
  switch (argcount) {
    case 0: {
      [[fallthrough]];
    }
    case 1: {
      Maybe<JS::Rooted<JSObject*> > unwrappedObj;
      bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
      if (objIsXray) {
        unwrappedObj.emplace(cx, obj);
      }
      binding_detail::FastRTCAnswerOptions arg0;
      if (!arg0.Init(cx, (args.hasDefined(0)) ? args[0] : JS::NullHandleValue, "Argument 1", true)) {
        return false;
      }
      if (objIsXray) {
        // Since our object is an Xray, we can just CheckedUnwrapStatic:
        // we know Xrays have no dynamic unwrap behavior.
        unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
        if (!unwrappedObj.ref()) {
          return false;
        }
      }
      FastErrorResult rv;
      auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->CreateAnswer(Constify(arg0), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)))));
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.createAnswer"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      if (!ToJSValue(cx, result, args.rval())) {
        return false;
      }
      return true;
      break;
    }
    case 2: {
      Maybe<JS::Rooted<JSObject*> > unwrappedObj;
      bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
      if (objIsXray) {
        unwrappedObj.emplace(cx, obj);
      }
      RootedCallback<OwningNonNull<binding_detail::FastRTCSessionDescriptionCallback>> arg0(cx);
      if (args[0].isObject()) {
        if (JS::IsCallable(&args[0].toObject())) {
        { // scope for tempRoot and tempGlobalRoot if needed
          arg0 = new binding_detail::FastRTCSessionDescriptionCallback(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
        }
        } else {
          cx.ThrowErrorMessage<MSG_NOT_CALLABLE>("Argument 1");
          return false;
        }
      } else {
        cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
        return false;
      }
      RootedCallback<OwningNonNull<binding_detail::FastRTCPeerConnectionErrorCallback>> arg1(cx);
      if (args[1].isObject()) {
        if (JS::IsCallable(&args[1].toObject())) {
        { // scope for tempRoot and tempGlobalRoot if needed
          arg1 = new binding_detail::FastRTCPeerConnectionErrorCallback(&args[1].toObject(), JS::CurrentGlobalOrNull(cx));
        }
        } else {
          cx.ThrowErrorMessage<MSG_NOT_CALLABLE>("Argument 2");
          return false;
        }
      } else {
        cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 2");
        return false;
      }
      if (objIsXray) {
        // Since our object is an Xray, we can just CheckedUnwrapStatic:
        // we know Xrays have no dynamic unwrap behavior.
        unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
        if (!unwrappedObj.ref()) {
          return false;
        }
      }
      FastErrorResult rv;
      auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->CreateAnswer(MOZ_KnownLive(NonNullHelper(arg0)), MOZ_KnownLive(NonNullHelper(arg1)), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)))));
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.createAnswer"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      if (!ToJSValue(cx, result, args.rval())) {
        return false;
      }
      return true;
      break;
    }
    default: {
      // Using nsPrintfCString here would require including that
      // header.  Let's not worry about it.
      nsAutoCString argCountStr;
      argCountStr.AppendPrintf("%u", args.length());
      return cx.ThrowErrorMessage<MSG_INVALID_OVERLOAD_ARGCOUNT>(argCountStr.get());
    }
  }
  MOZ_CRASH("We have an always-returning default case");
  return false;
}

MOZ_CAN_RUN_SCRIPT static bool
createAnswer_promiseWrapper(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  bool ok = createAnswer(cx, obj, void_self, args);
  if (ok) {
    return true;
  }
  return ConvertExceptionToPromise(cx, args.rval());
}

static const JSJitInfo createAnswer_methodinfo = {
  { (JSJitGetterOp)createAnswer_promiseWrapper },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
setLocalDescription(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "RTCPeerConnection.setLocalDescription");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "setLocalDescription", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  unsigned argcount = std::min(args.length(), 3u);
  switch (argcount) {
    case 0: {
      [[fallthrough]];
    }
    case 1: {
      Maybe<JS::Rooted<JSObject*> > unwrappedObj;
      bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
      if (objIsXray) {
        unwrappedObj.emplace(cx, obj);
      }
      binding_detail::FastRTCLocalSessionDescriptionInit arg0;
      if (!arg0.Init(cx, (args.hasDefined(0)) ? args[0] : JS::NullHandleValue, "Argument 1", true)) {
        return false;
      }
      if (objIsXray) {
        // Since our object is an Xray, we can just CheckedUnwrapStatic:
        // we know Xrays have no dynamic unwrap behavior.
        unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
        if (!unwrappedObj.ref()) {
          return false;
        }
      }
      FastErrorResult rv;
      auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->SetLocalDescription(Constify(arg0), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)))));
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.setLocalDescription"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      if (!ToJSValue(cx, result, args.rval())) {
        return false;
      }
      return true;
      break;
    }
    case 3: {
      Maybe<JS::Rooted<JSObject*> > unwrappedObj;
      bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
      if (objIsXray) {
        unwrappedObj.emplace(cx, obj);
      }
      binding_detail::FastRTCLocalSessionDescriptionInit arg0;
      if (!arg0.Init(cx, args[0], "Argument 1", true)) {
        return false;
      }
      RootedCallback<OwningNonNull<binding_detail::FastVoidFunction>> arg1(cx);
      if (args[1].isObject()) {
        if (JS::IsCallable(&args[1].toObject())) {
        { // scope for tempRoot and tempGlobalRoot if needed
          arg1 = new binding_detail::FastVoidFunction(&args[1].toObject(), JS::CurrentGlobalOrNull(cx));
        }
        } else {
          cx.ThrowErrorMessage<MSG_NOT_CALLABLE>("Argument 2");
          return false;
        }
      } else {
        cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 2");
        return false;
      }
      RootedCallback<OwningNonNull<binding_detail::FastRTCPeerConnectionErrorCallback>> arg2(cx);
      if (args[2].isObject()) {
        if (JS::IsCallable(&args[2].toObject())) {
        { // scope for tempRoot and tempGlobalRoot if needed
          arg2 = new binding_detail::FastRTCPeerConnectionErrorCallback(&args[2].toObject(), JS::CurrentGlobalOrNull(cx));
        }
        } else {
          cx.ThrowErrorMessage<MSG_NOT_CALLABLE>("Argument 3");
          return false;
        }
      } else {
        cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 3");
        return false;
      }
      if (objIsXray) {
        // Since our object is an Xray, we can just CheckedUnwrapStatic:
        // we know Xrays have no dynamic unwrap behavior.
        unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
        if (!unwrappedObj.ref()) {
          return false;
        }
      }
      FastErrorResult rv;
      auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->SetLocalDescription(Constify(arg0), MOZ_KnownLive(NonNullHelper(arg1)), MOZ_KnownLive(NonNullHelper(arg2)), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)))));
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.setLocalDescription"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      if (!ToJSValue(cx, result, args.rval())) {
        return false;
      }
      return true;
      break;
    }
    default: {
      // Using nsPrintfCString here would require including that
      // header.  Let's not worry about it.
      nsAutoCString argCountStr;
      argCountStr.AppendPrintf("%u", args.length());
      return cx.ThrowErrorMessage<MSG_INVALID_OVERLOAD_ARGCOUNT>(argCountStr.get());
    }
  }
  MOZ_CRASH("We have an always-returning default case");
  return false;
}

MOZ_CAN_RUN_SCRIPT static bool
setLocalDescription_promiseWrapper(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  bool ok = setLocalDescription(cx, obj, void_self, args);
  if (ok) {
    return true;
  }
  return ConvertExceptionToPromise(cx, args.rval());
}

static const JSJitInfo setLocalDescription_methodinfo = {
  { (JSJitGetterOp)setLocalDescription_promiseWrapper },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_localDescription(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "localDescription", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::RTCSessionDescription>(MOZ_KnownLive(self)->GetLocalDescription(rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)))));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.localDescription getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo localDescription_getterinfo = {
  { get_localDescription },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_currentLocalDescription(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "currentLocalDescription", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::RTCSessionDescription>(MOZ_KnownLive(self)->GetCurrentLocalDescription(rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)))));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.currentLocalDescription getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo currentLocalDescription_getterinfo = {
  { get_currentLocalDescription },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_pendingLocalDescription(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "pendingLocalDescription", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::RTCSessionDescription>(MOZ_KnownLive(self)->GetPendingLocalDescription(rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)))));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.pendingLocalDescription getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo pendingLocalDescription_getterinfo = {
  { get_pendingLocalDescription },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
setRemoteDescription(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "RTCPeerConnection.setRemoteDescription");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "setRemoteDescription", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  unsigned argcount = std::min(args.length(), 3u);
  switch (argcount) {
    case 1: {
      Maybe<JS::Rooted<JSObject*> > unwrappedObj;
      bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
      if (objIsXray) {
        unwrappedObj.emplace(cx, obj);
      }
      binding_detail::FastRTCSessionDescriptionInit arg0;
      if (!arg0.Init(cx, args[0], "Argument 1", true)) {
        return false;
      }
      if (objIsXray) {
        // Since our object is an Xray, we can just CheckedUnwrapStatic:
        // we know Xrays have no dynamic unwrap behavior.
        unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
        if (!unwrappedObj.ref()) {
          return false;
        }
      }
      FastErrorResult rv;
      auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->SetRemoteDescription(Constify(arg0), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)))));
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.setRemoteDescription"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      if (!ToJSValue(cx, result, args.rval())) {
        return false;
      }
      return true;
      break;
    }
    case 3: {
      Maybe<JS::Rooted<JSObject*> > unwrappedObj;
      bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
      if (objIsXray) {
        unwrappedObj.emplace(cx, obj);
      }
      binding_detail::FastRTCSessionDescriptionInit arg0;
      if (!arg0.Init(cx, args[0], "Argument 1", true)) {
        return false;
      }
      RootedCallback<OwningNonNull<binding_detail::FastVoidFunction>> arg1(cx);
      if (args[1].isObject()) {
        if (JS::IsCallable(&args[1].toObject())) {
        { // scope for tempRoot and tempGlobalRoot if needed
          arg1 = new binding_detail::FastVoidFunction(&args[1].toObject(), JS::CurrentGlobalOrNull(cx));
        }
        } else {
          cx.ThrowErrorMessage<MSG_NOT_CALLABLE>("Argument 2");
          return false;
        }
      } else {
        cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 2");
        return false;
      }
      RootedCallback<OwningNonNull<binding_detail::FastRTCPeerConnectionErrorCallback>> arg2(cx);
      if (args[2].isObject()) {
        if (JS::IsCallable(&args[2].toObject())) {
        { // scope for tempRoot and tempGlobalRoot if needed
          arg2 = new binding_detail::FastRTCPeerConnectionErrorCallback(&args[2].toObject(), JS::CurrentGlobalOrNull(cx));
        }
        } else {
          cx.ThrowErrorMessage<MSG_NOT_CALLABLE>("Argument 3");
          return false;
        }
      } else {
        cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 3");
        return false;
      }
      if (objIsXray) {
        // Since our object is an Xray, we can just CheckedUnwrapStatic:
        // we know Xrays have no dynamic unwrap behavior.
        unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
        if (!unwrappedObj.ref()) {
          return false;
        }
      }
      FastErrorResult rv;
      auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->SetRemoteDescription(Constify(arg0), MOZ_KnownLive(NonNullHelper(arg1)), MOZ_KnownLive(NonNullHelper(arg2)), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)))));
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.setRemoteDescription"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      if (!ToJSValue(cx, result, args.rval())) {
        return false;
      }
      return true;
      break;
    }
    default: {
      // Using nsPrintfCString here would require including that
      // header.  Let's not worry about it.
      nsAutoCString argCountStr;
      argCountStr.AppendPrintf("%u", args.length());
      return cx.ThrowErrorMessage<MSG_INVALID_OVERLOAD_ARGCOUNT>(argCountStr.get());
    }
  }
  MOZ_CRASH("We have an always-returning default case");
  return false;
}

MOZ_CAN_RUN_SCRIPT static bool
setRemoteDescription_promiseWrapper(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  bool ok = setRemoteDescription(cx, obj, void_self, args);
  if (ok) {
    return true;
  }
  return ConvertExceptionToPromise(cx, args.rval());
}

static const JSJitInfo setRemoteDescription_methodinfo = {
  { (JSJitGetterOp)setRemoteDescription_promiseWrapper },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_remoteDescription(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "remoteDescription", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::RTCSessionDescription>(MOZ_KnownLive(self)->GetRemoteDescription(rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)))));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.remoteDescription getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo remoteDescription_getterinfo = {
  { get_remoteDescription },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_currentRemoteDescription(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "currentRemoteDescription", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::RTCSessionDescription>(MOZ_KnownLive(self)->GetCurrentRemoteDescription(rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)))));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.currentRemoteDescription getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo currentRemoteDescription_getterinfo = {
  { get_currentRemoteDescription },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_pendingRemoteDescription(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "pendingRemoteDescription", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::RTCSessionDescription>(MOZ_KnownLive(self)->GetPendingRemoteDescription(rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)))));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.pendingRemoteDescription getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo pendingRemoteDescription_getterinfo = {
  { get_pendingRemoteDescription },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_signalingState(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "signalingState", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  RTCSignalingState result(MOZ_KnownLive(self)->GetSignalingState(rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.signalingState getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo signalingState_getterinfo = {
  { get_signalingState },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
addIceCandidate(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "RTCPeerConnection.addIceCandidate");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "addIceCandidate", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  unsigned argcount = std::min(args.length(), 3u);
  switch (argcount) {
    case 0: {
      [[fallthrough]];
    }
    case 1: {
      Maybe<JS::Rooted<JSObject*> > unwrappedObj;
      bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
      if (objIsXray) {
        unwrappedObj.emplace(cx, obj);
      }
      RTCIceCandidateInitOrRTCIceCandidate arg0;
      if (!(args.hasDefined(0))) {
        if (!arg0.RawSetAsRTCIceCandidateInit().Init(cx, JS::NullHandleValue, "Member of (RTCIceCandidateInit or RTCIceCandidate)")) {
          return false;
        }
      } else {
        if (!arg0.Init(cx, args[0], "Argument 1", true)) {
          return false;
        }
      }
      if (objIsXray) {
        // Since our object is an Xray, we can just CheckedUnwrapStatic:
        // we know Xrays have no dynamic unwrap behavior.
        unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
        if (!unwrappedObj.ref()) {
          return false;
        }
      }
      FastErrorResult rv;
      auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->AddIceCandidate(Constify(arg0), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)))));
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.addIceCandidate"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      if (!ToJSValue(cx, result, args.rval())) {
        return false;
      }
      return true;
      break;
    }
    case 3: {
      Maybe<JS::Rooted<JSObject*> > unwrappedObj;
      bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
      if (objIsXray) {
        unwrappedObj.emplace(cx, obj);
      }
      binding_detail::FastRTCIceCandidateInit arg0;
      if (!arg0.Init(cx, args[0], "Argument 1", true)) {
        return false;
      }
      RootedCallback<OwningNonNull<binding_detail::FastVoidFunction>> arg1(cx);
      if (args[1].isObject()) {
        if (JS::IsCallable(&args[1].toObject())) {
        { // scope for tempRoot and tempGlobalRoot if needed
          arg1 = new binding_detail::FastVoidFunction(&args[1].toObject(), JS::CurrentGlobalOrNull(cx));
        }
        } else {
          cx.ThrowErrorMessage<MSG_NOT_CALLABLE>("Argument 2");
          return false;
        }
      } else {
        cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 2");
        return false;
      }
      RootedCallback<OwningNonNull<binding_detail::FastRTCPeerConnectionErrorCallback>> arg2(cx);
      if (args[2].isObject()) {
        if (JS::IsCallable(&args[2].toObject())) {
        { // scope for tempRoot and tempGlobalRoot if needed
          arg2 = new binding_detail::FastRTCPeerConnectionErrorCallback(&args[2].toObject(), JS::CurrentGlobalOrNull(cx));
        }
        } else {
          cx.ThrowErrorMessage<MSG_NOT_CALLABLE>("Argument 3");
          return false;
        }
      } else {
        cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 3");
        return false;
      }
      if (objIsXray) {
        // Since our object is an Xray, we can just CheckedUnwrapStatic:
        // we know Xrays have no dynamic unwrap behavior.
        unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
        if (!unwrappedObj.ref()) {
          return false;
        }
      }
      FastErrorResult rv;
      auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->AddIceCandidate(Constify(arg0), MOZ_KnownLive(NonNullHelper(arg1)), MOZ_KnownLive(NonNullHelper(arg2)), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)))));
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.addIceCandidate"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      if (!ToJSValue(cx, result, args.rval())) {
        return false;
      }
      return true;
      break;
    }
    default: {
      // Using nsPrintfCString here would require including that
      // header.  Let's not worry about it.
      nsAutoCString argCountStr;
      argCountStr.AppendPrintf("%u", args.length());
      return cx.ThrowErrorMessage<MSG_INVALID_OVERLOAD_ARGCOUNT>(argCountStr.get());
    }
  }
  MOZ_CRASH("We have an always-returning default case");
  return false;
}

MOZ_CAN_RUN_SCRIPT static bool
addIceCandidate_promiseWrapper(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  bool ok = addIceCandidate(cx, obj, void_self, args);
  if (ok) {
    return true;
  }
  return ConvertExceptionToPromise(cx, args.rval());
}

static const JSJitInfo addIceCandidate_methodinfo = {
  { (JSJitGetterOp)addIceCandidate_promiseWrapper },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_canTrickleIceCandidates(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "canTrickleIceCandidates", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  Nullable<bool> result(MOZ_KnownLive(self)->GetCanTrickleIceCandidates(rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.canTrickleIceCandidates getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result.IsNull()) {
    args.rval().setNull();
    return true;
  }
  args.rval().setBoolean(result.Value());
  return true;
}

static const JSJitInfo canTrickleIceCandidates_getterinfo = {
  { get_canTrickleIceCandidates },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_iceGatheringState(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "iceGatheringState", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  RTCIceGatheringState result(MOZ_KnownLive(self)->GetIceGatheringState(rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.iceGatheringState getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo iceGatheringState_getterinfo = {
  { get_iceGatheringState },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_iceConnectionState(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "iceConnectionState", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  RTCIceConnectionState result(MOZ_KnownLive(self)->GetIceConnectionState(rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.iceConnectionState getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo iceConnectionState_getterinfo = {
  { get_iceConnectionState },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_connectionState(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "connectionState", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  RTCPeerConnectionState result(MOZ_KnownLive(self)->GetConnectionState(rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.connectionState getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo connectionState_getterinfo = {
  { get_connectionState },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
restartIce(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "restartIce", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->RestartIce(rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))))>, "Should be returning void here");
  MOZ_KnownLive(self)->RestartIce(rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.restartIce"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo restartIce_methodinfo = {
  { (JSJitGetterOp)restartIce },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_peerIdentity(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "peerIdentity", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->GetPeerIdentity(rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)))));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.peerIdentity getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
get_peerIdentity_promiseWrapper(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  bool ok = get_peerIdentity(cx, obj, void_self, args);
  if (ok) {
    return true;
  }
  return ConvertExceptionToPromise(cx, args.rval());
}

static const JSJitInfo peerIdentity_getterinfo = {
  { get_peerIdentity_promiseWrapper },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_idpLoginUrl(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "idpLoginUrl", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetIdpLoginUrl(result, rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetIdpLoginUrl(result, rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.idpLoginUrl getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::StringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo idpLoginUrl_getterinfo = {
  { get_idpLoginUrl },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_id(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "id", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetId(result, rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetId(result, rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.id getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::NonVoidStringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_id(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "id", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetId(NonNullHelper(Constify(arg0)), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetId(NonNullHelper(Constify(arg0)), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.id setter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo id_getterinfo = {
  { get_id },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo id_setterinfo = {
  { (JSJitGetterOp)set_id },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getConfiguration(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "getConfiguration", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  RTCConfiguration result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetConfiguration(result, rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetConfiguration(result, rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.getConfiguration"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result.ToObjectInternal(cx, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo getConfiguration_methodinfo = {
  { (JSJitGetterOp)getConfiguration },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
setConfiguration(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "RTCPeerConnection.setConfiguration");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "setConfiguration", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  binding_detail::FastRTCConfiguration arg0;
  if (!arg0.Init(cx, (args.hasDefined(0)) ? args[0] : JS::NullHandleValue, "Argument 1", true)) {
    return false;
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetConfiguration(Constify(arg0), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetConfiguration(Constify(arg0), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.setConfiguration"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo setConfiguration_methodinfo = {
  { (JSJitGetterOp)setConfiguration },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getLocalStreams(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "getLocalStreams", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  DeprecationWarning(cx, obj, DeprecatedOperations::eRTCPeerConnectionGetStreams);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  nsTArray<StrongPtrForMember<mozilla::DOMMediaStream>> result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetLocalStreams(result, rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetLocalStreams(result, rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.getLocalStreams"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  uint32_t length = result.Length();
  JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
  if (!returnArray) {
    return false;
  }
  // Scope for 'tmp'
  {
    JS::Rooted<JS::Value> tmp(cx);
    for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
      // Control block to let us common up the JS_DefineElement calls when there
      // are different ways to succeed at wrapping the object.
      do {
        if (!GetOrCreateDOMReflector(cx, result[sequenceIdx0], &tmp)) {
          MOZ_ASSERT(JS_IsExceptionPending(cx));
          return false;
        }
        break;
      } while (false);
      if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                            JSPROP_ENUMERATE)) {
        return false;
      }
    }
  }
  args.rval().setObject(*returnArray);
  return true;
}

static const JSJitInfo getLocalStreams_methodinfo = {
  { (JSJitGetterOp)getLocalStreams },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getRemoteStreams(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "getRemoteStreams", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  DeprecationWarning(cx, obj, DeprecatedOperations::eRTCPeerConnectionGetStreams);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  nsTArray<StrongPtrForMember<mozilla::DOMMediaStream>> result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetRemoteStreams(result, rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetRemoteStreams(result, rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.getRemoteStreams"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  uint32_t length = result.Length();
  JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
  if (!returnArray) {
    return false;
  }
  // Scope for 'tmp'
  {
    JS::Rooted<JS::Value> tmp(cx);
    for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
      // Control block to let us common up the JS_DefineElement calls when there
      // are different ways to succeed at wrapping the object.
      do {
        if (!GetOrCreateDOMReflector(cx, result[sequenceIdx0], &tmp)) {
          MOZ_ASSERT(JS_IsExceptionPending(cx));
          return false;
        }
        break;
      } while (false);
      if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                            JSPROP_ENUMERATE)) {
        return false;
      }
    }
  }
  args.rval().setObject(*returnArray);
  return true;
}

static const JSJitInfo getRemoteStreams_methodinfo = {
  { (JSJitGetterOp)getRemoteStreams },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
addStream(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "RTCPeerConnection.addStream");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "addStream", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  if (!args.requireAtLeast(cx, "RTCPeerConnection.addStream", 1)) {
    return false;
  }
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  NonNull<mozilla::DOMMediaStream> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::MediaStream, mozilla::DOMMediaStream>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "MediaStream");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->AddStream(MOZ_KnownLive(NonNullHelper(arg0)), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))))>, "Should be returning void here");
  MOZ_KnownLive(self)->AddStream(MOZ_KnownLive(NonNullHelper(arg0)), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.addStream"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo addStream_methodinfo = {
  { (JSJitGetterOp)addStream },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
addTrack(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "RTCPeerConnection.addTrack");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "addTrack", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  if (!args.requireAtLeast(cx, "RTCPeerConnection.addTrack", 1)) {
    return false;
  }
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  NonNull<mozilla::dom::MediaStreamTrack> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::MediaStreamTrack, mozilla::dom::MediaStreamTrack>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "MediaStreamTrack");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  AutoSequence<OwningNonNull<mozilla::DOMMediaStream>> arg1;
  if (args.length() > 1) {
    if (!arg1.SetCapacity(args.length() - 1, mozilla::fallible)) {
      JS_ReportOutOfMemory(cx);
      return false;
    }
    for (uint32_t variadicArg = 1; variadicArg < args.length(); ++variadicArg) {
      // OK to do infallible append here, since we ensured capacity already.
      OwningNonNull<mozilla::DOMMediaStream>& slot = *arg1.AppendElement();
      if (args[variadicArg].isObject()) {
        static_assert(IsRefcounted<mozilla::DOMMediaStream>::value, "We can only store refcounted classes.");
        {
          // Our JSContext should be in the right global to do unwrapping in.
          nsresult rv = UnwrapObject<prototypes::id::MediaStream, mozilla::DOMMediaStream>(args[variadicArg], slot, cx);
          if (NS_FAILED(rv)) {
            cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 2", "MediaStream");
            return false;
          }
        }
      } else {
        cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 2");
        return false;
      }
    }
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::RTCRtpSender>(MOZ_KnownLive(self)->AddTrack(MOZ_KnownLive(NonNullHelper(arg0)), MOZ_KnownLive(NonNullHelper(Constify(arg1))), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)))));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.addTrack"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo addTrack_methodinfo = {
  { (JSJitGetterOp)addTrack },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
removeTrack(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "RTCPeerConnection.removeTrack");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "removeTrack", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  if (!args.requireAtLeast(cx, "RTCPeerConnection.removeTrack", 1)) {
    return false;
  }
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  NonNull<mozilla::dom::RTCRtpSender> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::RTCRtpSender, mozilla::dom::RTCRtpSender>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "RTCRtpSender");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->RemoveTrack(MOZ_KnownLive(NonNullHelper(arg0)), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))))>, "Should be returning void here");
  MOZ_KnownLive(self)->RemoveTrack(MOZ_KnownLive(NonNullHelper(arg0)), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.removeTrack"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo removeTrack_methodinfo = {
  { (JSJitGetterOp)removeTrack },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
addTransceiver(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "RTCPeerConnection.addTransceiver");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "addTransceiver", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  if (!args.requireAtLeast(cx, "RTCPeerConnection.addTransceiver", 1)) {
    return false;
  }
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  MediaStreamTrackOrString arg0;
  if (!arg0.Init(cx, args[0], "Argument 1", true)) {
    return false;
  }
  binding_detail::FastRTCRtpTransceiverInit arg1;
  if (!arg1.Init(cx, (args.hasDefined(1)) ? args[1] : JS::NullHandleValue, "Argument 2", true)) {
    return false;
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::RTCRtpTransceiver>(MOZ_KnownLive(self)->AddTransceiver(Constify(arg0), Constify(arg1), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)))));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.addTransceiver"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo addTransceiver_methodinfo = {
  { (JSJitGetterOp)addTransceiver },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getSenders(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "getSenders", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  nsTArray<StrongPtrForMember<mozilla::dom::RTCRtpSender>> result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetSenders(result, rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetSenders(result, rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.getSenders"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  uint32_t length = result.Length();
  JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
  if (!returnArray) {
    return false;
  }
  // Scope for 'tmp'
  {
    JS::Rooted<JS::Value> tmp(cx);
    for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
      // Control block to let us common up the JS_DefineElement calls when there
      // are different ways to succeed at wrapping the object.
      do {
        if (!GetOrCreateDOMReflector(cx, result[sequenceIdx0], &tmp)) {
          MOZ_ASSERT(JS_IsExceptionPending(cx));
          return false;
        }
        break;
      } while (false);
      if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                            JSPROP_ENUMERATE)) {
        return false;
      }
    }
  }
  args.rval().setObject(*returnArray);
  return true;
}

static const JSJitInfo getSenders_methodinfo = {
  { (JSJitGetterOp)getSenders },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getReceivers(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "getReceivers", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  nsTArray<StrongPtrForMember<mozilla::dom::RTCRtpReceiver>> result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetReceivers(result, rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetReceivers(result, rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.getReceivers"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  uint32_t length = result.Length();
  JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
  if (!returnArray) {
    return false;
  }
  // Scope for 'tmp'
  {
    JS::Rooted<JS::Value> tmp(cx);
    for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
      // Control block to let us common up the JS_DefineElement calls when there
      // are different ways to succeed at wrapping the object.
      do {
        if (!GetOrCreateDOMReflector(cx, result[sequenceIdx0], &tmp)) {
          MOZ_ASSERT(JS_IsExceptionPending(cx));
          return false;
        }
        break;
      } while (false);
      if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                            JSPROP_ENUMERATE)) {
        return false;
      }
    }
  }
  args.rval().setObject(*returnArray);
  return true;
}

static const JSJitInfo getReceivers_methodinfo = {
  { (JSJitGetterOp)getReceivers },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getTransceivers(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "getTransceivers", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  nsTArray<StrongPtrForMember<mozilla::dom::RTCRtpTransceiver>> result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetTransceivers(result, rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetTransceivers(result, rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.getTransceivers"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  uint32_t length = result.Length();
  JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
  if (!returnArray) {
    return false;
  }
  // Scope for 'tmp'
  {
    JS::Rooted<JS::Value> tmp(cx);
    for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
      // Control block to let us common up the JS_DefineElement calls when there
      // are different ways to succeed at wrapping the object.
      do {
        if (!GetOrCreateDOMReflector(cx, result[sequenceIdx0], &tmp)) {
          MOZ_ASSERT(JS_IsExceptionPending(cx));
          return false;
        }
        break;
      } while (false);
      if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                            JSPROP_ENUMERATE)) {
        return false;
      }
    }
  }
  args.rval().setObject(*returnArray);
  return true;
}

static const JSJitInfo getTransceivers_methodinfo = {
  { (JSJitGetterOp)getTransceivers },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
mozSetPacketCallback(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "RTCPeerConnection.mozSetPacketCallback");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "mozSetPacketCallback", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  if (!args.requireAtLeast(cx, "RTCPeerConnection.mozSetPacketCallback", 1)) {
    return false;
  }
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  RootedCallback<OwningNonNull<binding_detail::FastmozPacketCallback>> arg0(cx);
  if (args[0].isObject()) {
    if (JS::IsCallable(&args[0].toObject())) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastmozPacketCallback(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
    } else {
      cx.ThrowErrorMessage<MSG_NOT_CALLABLE>("Argument 1");
      return false;
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->MozSetPacketCallback(MOZ_KnownLive(NonNullHelper(arg0)), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))))>, "Should be returning void here");
  MOZ_KnownLive(self)->MozSetPacketCallback(MOZ_KnownLive(NonNullHelper(arg0)), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.mozSetPacketCallback"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo mozSetPacketCallback_methodinfo = {
  { (JSJitGetterOp)mozSetPacketCallback },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
mozEnablePacketDump(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "RTCPeerConnection.mozEnablePacketDump");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "mozEnablePacketDump", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  if (!args.requireAtLeast(cx, "RTCPeerConnection.mozEnablePacketDump", 3)) {
    return false;
  }
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  mozPacketDumpType arg1;
  {
    int index;
    if (!binding_detail::FindEnumStringIndex<true>(cx, args[1],
                                                                       binding_detail::EnumStrings<mozPacketDumpType>::Values,
                                                                       "mozPacketDumpType", "argument 2",
                                                                       &index)) {
      return false;
    }
    MOZ_ASSERT(index >= 0);
    arg1 = static_cast<mozPacketDumpType>(index);
  }
  bool arg2;
  if (!ValueToPrimitive<bool, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->MozEnablePacketDump(arg0, arg1, arg2, rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))))>, "Should be returning void here");
  MOZ_KnownLive(self)->MozEnablePacketDump(arg0, arg1, arg2, rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.mozEnablePacketDump"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo mozEnablePacketDump_methodinfo = {
  { (JSJitGetterOp)mozEnablePacketDump },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
mozDisablePacketDump(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "RTCPeerConnection.mozDisablePacketDump");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "mozDisablePacketDump", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  if (!args.requireAtLeast(cx, "RTCPeerConnection.mozDisablePacketDump", 3)) {
    return false;
  }
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  uint32_t arg0;
  if (!ValueToPrimitive<uint32_t, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  mozPacketDumpType arg1;
  {
    int index;
    if (!binding_detail::FindEnumStringIndex<true>(cx, args[1],
                                                                       binding_detail::EnumStrings<mozPacketDumpType>::Values,
                                                                       "mozPacketDumpType", "argument 2",
                                                                       &index)) {
      return false;
    }
    MOZ_ASSERT(index >= 0);
    arg1 = static_cast<mozPacketDumpType>(index);
  }
  bool arg2;
  if (!ValueToPrimitive<bool, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->MozDisablePacketDump(arg0, arg1, arg2, rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))))>, "Should be returning void here");
  MOZ_KnownLive(self)->MozDisablePacketDump(arg0, arg1, arg2, rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.mozDisablePacketDump"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo mozDisablePacketDump_methodinfo = {
  { (JSJitGetterOp)mozDisablePacketDump },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
close(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "close", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Close(rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))))>, "Should be returning void here");
  MOZ_KnownLive(self)->Close(rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.close"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo close_methodinfo = {
  { (JSJitGetterOp)close },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onnegotiationneeded(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "onnegotiationneeded", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnnegotiationneeded(rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.onnegotiationneeded getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onnegotiationneeded(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "onnegotiationneeded", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnnegotiationneeded(MOZ_KnownLive(Constify(arg0)), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnnegotiationneeded(MOZ_KnownLive(Constify(arg0)), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.onnegotiationneeded setter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onnegotiationneeded_getterinfo = {
  { get_onnegotiationneeded },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onnegotiationneeded_setterinfo = {
  { (JSJitGetterOp)set_onnegotiationneeded },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onicecandidate(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "onicecandidate", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnicecandidate(rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.onicecandidate getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onicecandidate(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "onicecandidate", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnicecandidate(MOZ_KnownLive(Constify(arg0)), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnicecandidate(MOZ_KnownLive(Constify(arg0)), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.onicecandidate setter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onicecandidate_getterinfo = {
  { get_onicecandidate },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onicecandidate_setterinfo = {
  { (JSJitGetterOp)set_onicecandidate },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onsignalingstatechange(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "onsignalingstatechange", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnsignalingstatechange(rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.onsignalingstatechange getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onsignalingstatechange(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "onsignalingstatechange", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnsignalingstatechange(MOZ_KnownLive(Constify(arg0)), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnsignalingstatechange(MOZ_KnownLive(Constify(arg0)), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.onsignalingstatechange setter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onsignalingstatechange_getterinfo = {
  { get_onsignalingstatechange },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onsignalingstatechange_setterinfo = {
  { (JSJitGetterOp)set_onsignalingstatechange },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onaddstream(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "onaddstream", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnaddstream(rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.onaddstream getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onaddstream(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "onaddstream", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnaddstream(MOZ_KnownLive(Constify(arg0)), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnaddstream(MOZ_KnownLive(Constify(arg0)), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.onaddstream setter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onaddstream_getterinfo = {
  { get_onaddstream },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onaddstream_setterinfo = {
  { (JSJitGetterOp)set_onaddstream },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onaddtrack(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "onaddtrack", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnaddtrack(rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.onaddtrack getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onaddtrack(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "onaddtrack", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnaddtrack(MOZ_KnownLive(Constify(arg0)), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnaddtrack(MOZ_KnownLive(Constify(arg0)), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.onaddtrack setter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onaddtrack_getterinfo = {
  { get_onaddtrack },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onaddtrack_setterinfo = {
  { (JSJitGetterOp)set_onaddtrack },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_ontrack(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "ontrack", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOntrack(rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.ontrack getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_ontrack(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "ontrack", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOntrack(MOZ_KnownLive(Constify(arg0)), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOntrack(MOZ_KnownLive(Constify(arg0)), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.ontrack setter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo ontrack_getterinfo = {
  { get_ontrack },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo ontrack_setterinfo = {
  { (JSJitGetterOp)set_ontrack },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_oniceconnectionstatechange(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "oniceconnectionstatechange", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOniceconnectionstatechange(rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.oniceconnectionstatechange getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_oniceconnectionstatechange(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "oniceconnectionstatechange", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOniceconnectionstatechange(MOZ_KnownLive(Constify(arg0)), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOniceconnectionstatechange(MOZ_KnownLive(Constify(arg0)), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.oniceconnectionstatechange setter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo oniceconnectionstatechange_getterinfo = {
  { get_oniceconnectionstatechange },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo oniceconnectionstatechange_setterinfo = {
  { (JSJitGetterOp)set_oniceconnectionstatechange },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onicegatheringstatechange(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "onicegatheringstatechange", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnicegatheringstatechange(rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.onicegatheringstatechange getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onicegatheringstatechange(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "onicegatheringstatechange", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnicegatheringstatechange(MOZ_KnownLive(Constify(arg0)), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnicegatheringstatechange(MOZ_KnownLive(Constify(arg0)), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.onicegatheringstatechange setter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onicegatheringstatechange_getterinfo = {
  { get_onicegatheringstatechange },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onicegatheringstatechange_setterinfo = {
  { (JSJitGetterOp)set_onicegatheringstatechange },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onconnectionstatechange(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "onconnectionstatechange", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnconnectionstatechange(rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.onconnectionstatechange getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onconnectionstatechange(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "onconnectionstatechange", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnconnectionstatechange(MOZ_KnownLive(Constify(arg0)), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnconnectionstatechange(MOZ_KnownLive(Constify(arg0)), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.onconnectionstatechange setter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onconnectionstatechange_getterinfo = {
  { get_onconnectionstatechange },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onconnectionstatechange_setterinfo = {
  { (JSJitGetterOp)set_onconnectionstatechange },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getStats(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "RTCPeerConnection.getStats");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "getStats", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  mozilla::dom::MediaStreamTrack* arg0;
  if (args.hasDefined(0)) {
    if (args[0].isObject()) {
      {
        // Our JSContext should be in the right global to do unwrapping in.
        nsresult rv = UnwrapObject<prototypes::id::MediaStreamTrack, mozilla::dom::MediaStreamTrack>(args[0], arg0, cx);
        if (NS_FAILED(rv)) {
          cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "MediaStreamTrack");
          return false;
        }
      }
    } else if (args[0].isNullOrUndefined()) {
      arg0 = nullptr;
    } else {
      cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
      return false;
    }
  } else {
    arg0 = nullptr;
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->GetStats(MOZ_KnownLive(Constify(arg0)), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)))));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.getStats"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
getStats_promiseWrapper(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  bool ok = getStats(cx, obj, void_self, args);
  if (ok) {
    return true;
  }
  return ConvertExceptionToPromise(cx, args.rval());
}

static const JSJitInfo getStats_methodinfo = {
  { (JSJitGetterOp)getStats_promiseWrapper },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_sctp(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "sctp", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::RTCSctpTransport>(MOZ_KnownLive(self)->GetSctp(rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)))));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.sctp getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo sctp_getterinfo = {
  { get_sctp },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
createDataChannel(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "RTCPeerConnection.createDataChannel");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "createDataChannel", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  if (!args.requireAtLeast(cx, "RTCPeerConnection.createDataChannel", 1)) {
    return false;
  }
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  binding_detail::FakeString<char> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  binding_detail::FastRTCDataChannelInit arg1;
  if (!arg1.Init(cx, (args.hasDefined(1)) ? args[1] : JS::NullHandleValue, "Argument 2", true)) {
    return false;
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::RTCDataChannel>(MOZ_KnownLive(self)->CreateDataChannel(Constify(arg0), Constify(arg1), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)))));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.createDataChannel"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo createDataChannel_methodinfo = {
  { (JSJitGetterOp)createDataChannel },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_ondatachannel(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "ondatachannel", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOndatachannel(rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.ondatachannel getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_ondatachannel(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "ondatachannel", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCPeerConnection*>(void_self);
  Maybe<JS::Rooted<JSObject*> > unwrappedObj;
  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  if (objIsXray) {
    unwrappedObj.emplace(cx, obj);
  }
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    unwrappedObj.ref() = js::CheckedUnwrapStatic(unwrappedObj.ref());
    if (!unwrappedObj.ref()) {
      return false;
    }
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOndatachannel(MOZ_KnownLive(Constify(arg0)), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOndatachannel(MOZ_KnownLive(Constify(arg0)), rv, (unwrappedObj ? js::GetNonCCWObjectRealm(*unwrappedObj) : js::GetContextRealm(cx)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection.ondatachannel setter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo ondatachannel_getterinfo = {
  { get_ondatachannel },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo ondatachannel_setterinfo = {
  { (JSJitGetterOp)set_ondatachannel },
  { prototypes::id::RTCPeerConnection },
  { PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

static void
_finalize(JS::GCContext* gcx, JSObject* obj)
{
  mozilla::dom::RTCPeerConnection* self = UnwrapPossiblyNotInitializedDOMObject<mozilla::dom::RTCPeerConnection>(obj);
  if (self) {
    JS::SetReservedSlot(obj, DOM_OBJECT_SLOT, JS::UndefinedValue());
    ClearWrapper(self, self, obj);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(obj, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<mozilla::dom::RTCPeerConnection>(self);
  }
}

MOZ_GLOBINIT static const JSFunctionSpec sStaticMethods_specs[] = {
  JS_FNSPEC("generateCertificate", StaticMethodPromiseWrapper, &generateCertificate_methodinfo, 1, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sStaticMethods[] = {
  { nullptr, &sStaticMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSFunctionSpec sChromeStaticMethods_specs[] = {
  JS_FNSPEC("_create", RTCPeerConnection::_Create, nullptr, 2, 0, nullptr),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sChromeStaticMethods[] = {
  { nullptr, &sChromeStaticMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSFunctionSpec sMethods_specs[] = {
  JS_FNSPEC("setIdentityProvider", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&setIdentityProvider_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getIdentityAssertion", (GenericMethod<NormalThisPolicy, ConvertExceptionsToPromises>), reinterpret_cast<const JSJitInfo*>(&getIdentityAssertion_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("createOffer", (GenericMethod<NormalThisPolicy, ConvertExceptionsToPromises>), reinterpret_cast<const JSJitInfo*>(&createOffer_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("createAnswer", (GenericMethod<NormalThisPolicy, ConvertExceptionsToPromises>), reinterpret_cast<const JSJitInfo*>(&createAnswer_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("setLocalDescription", (GenericMethod<NormalThisPolicy, ConvertExceptionsToPromises>), reinterpret_cast<const JSJitInfo*>(&setLocalDescription_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("setRemoteDescription", (GenericMethod<NormalThisPolicy, ConvertExceptionsToPromises>), reinterpret_cast<const JSJitInfo*>(&setRemoteDescription_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("addIceCandidate", (GenericMethod<NormalThisPolicy, ConvertExceptionsToPromises>), reinterpret_cast<const JSJitInfo*>(&addIceCandidate_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("restartIce", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&restartIce_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getConfiguration", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getConfiguration_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("setConfiguration", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&setConfiguration_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getLocalStreams", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getLocalStreams_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getRemoteStreams", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getRemoteStreams_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("addStream", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&addStream_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("addTrack", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&addTrack_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("removeTrack", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&removeTrack_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("addTransceiver", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&addTransceiver_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getSenders", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getSenders_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getReceivers", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getReceivers_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getTransceivers", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getTransceivers_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("close", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&close_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getStats", (GenericMethod<NormalThisPolicy, ConvertExceptionsToPromises>), reinterpret_cast<const JSJitInfo*>(&getStats_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("createDataChannel", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&createDataChannel_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sMethods[] = {
  { nullptr, &sMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(22 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSFunctionSpec sChromeMethods_specs[] = {
  JS_FNSPEC("mozSetPacketCallback", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&mozSetPacketCallback_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("mozEnablePacketDump", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&mozEnablePacketDump_methodinfo), 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("mozDisablePacketDump", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&mozDisablePacketDump_methodinfo), 3, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sChromeMethods[] = {
  { nullptr, &sChromeMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(3 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSPropertySpec sAttributes_specs[] = {
  JSPropertySpec::nativeAccessors("localDescription", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &localDescription_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("currentLocalDescription", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &currentLocalDescription_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("pendingLocalDescription", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &pendingLocalDescription_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("remoteDescription", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &remoteDescription_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("currentRemoteDescription", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &currentRemoteDescription_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("pendingRemoteDescription", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &pendingRemoteDescription_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("signalingState", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &signalingState_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("canTrickleIceCandidates", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &canTrickleIceCandidates_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("iceGatheringState", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &iceGatheringState_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("iceConnectionState", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &iceConnectionState_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("connectionState", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &connectionState_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("peerIdentity", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ConvertExceptionsToPromises>, &peerIdentity_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("idpLoginUrl", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &idpLoginUrl_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("onnegotiationneeded", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &onnegotiationneeded_getterinfo, GenericSetter<NormalThisPolicy>, &onnegotiationneeded_setterinfo),
  JSPropertySpec::nativeAccessors("onicecandidate", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &onicecandidate_getterinfo, GenericSetter<NormalThisPolicy>, &onicecandidate_setterinfo),
  JSPropertySpec::nativeAccessors("onsignalingstatechange", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &onsignalingstatechange_getterinfo, GenericSetter<NormalThisPolicy>, &onsignalingstatechange_setterinfo),
  JSPropertySpec::nativeAccessors("onaddstream", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &onaddstream_getterinfo, GenericSetter<NormalThisPolicy>, &onaddstream_setterinfo),
  JSPropertySpec::nativeAccessors("onaddtrack", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &onaddtrack_getterinfo, GenericSetter<NormalThisPolicy>, &onaddtrack_setterinfo),
  JSPropertySpec::nativeAccessors("ontrack", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &ontrack_getterinfo, GenericSetter<NormalThisPolicy>, &ontrack_setterinfo),
  JSPropertySpec::nativeAccessors("oniceconnectionstatechange", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &oniceconnectionstatechange_getterinfo, GenericSetter<NormalThisPolicy>, &oniceconnectionstatechange_setterinfo),
  JSPropertySpec::nativeAccessors("onicegatheringstatechange", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &onicegatheringstatechange_getterinfo, GenericSetter<NormalThisPolicy>, &onicegatheringstatechange_setterinfo),
  JSPropertySpec::nativeAccessors("onconnectionstatechange", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &onconnectionstatechange_getterinfo, GenericSetter<NormalThisPolicy>, &onconnectionstatechange_setterinfo),
  JSPropertySpec::nativeAccessors("sctp", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &sctp_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("ondatachannel", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &ondatachannel_getterinfo, GenericSetter<NormalThisPolicy>, &ondatachannel_setterinfo),
  JS_PS_END
};


static const Prefable<const JSPropertySpec> sAttributes[] = {
  { nullptr, &sAttributes_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(24 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSPropertySpec sChromeAttributes_specs[] = {
  JSPropertySpec::nativeAccessors("id", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &id_getterinfo, GenericSetter<NormalThisPolicy>, &id_setterinfo),
  JS_PS_END
};


static const Prefable<const JSPropertySpec> sChromeAttributes[] = {
  { nullptr, &sChromeAttributes_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[47];
static PropertyInfo sNativeProperties_propertyInfos[47];

static const NativePropertiesN<3> sNativeProperties = {
  true,  0 /* sStaticMethods */,
  false, 0,
  true,  1 /* sMethods */,
  true,  2 /* sAttributes */,
  false, 0,
  false, 0,
  false, 0,
  -1,
  47,
  sNativeProperties_sortedPropertyIndices,
  {
    { sStaticMethods, &sNativeProperties_propertyInfos[0] },
    { sMethods, &sNativeProperties_propertyInfos[1] },
    { sAttributes, &sNativeProperties_propertyInfos[23] }
  }
};
static_assert(47 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

static uint16_t sChromeOnlyNativeProperties_sortedPropertyIndices[5];
static PropertyInfo sChromeOnlyNativeProperties_propertyInfos[5];

static const NativePropertiesN<3> sChromeOnlyNativeProperties = {
  true,  0 /* sChromeStaticMethods */,
  false, 0,
  true,  1 /* sChromeMethods */,
  true,  2 /* sChromeAttributes */,
  false, 0,
  false, 0,
  false, 0,
  -1,
  5,
  sChromeOnlyNativeProperties_sortedPropertyIndices,
  {
    { sChromeStaticMethods, &sChromeOnlyNativeProperties_propertyInfos[0] },
    { sChromeMethods, &sChromeOnlyNativeProperties_propertyInfos[1] },
    { sChromeAttributes, &sChromeOnlyNativeProperties_propertyInfos[4] }
  }
};
static_assert(5 < 1ull << (CHAR_BIT * sizeof(sChromeOnlyNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  nullptr,
  { sNativeProperties.Upcast(), sChromeOnlyNativeProperties.Upcast(), &sNativePropertiesInited },
  prototypes::id::RTCPeerConnection,
  constructors::id::RTCPeerConnection,
  &DefaultXrayExpandoObjectClass
};

static bool
_constructor(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "RTCPeerConnection constructor");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCPeerConnection", "constructor", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());
  if (!args.isConstructing()) {
    return ThrowConstructorWithoutNew(cx, "RTCPeerConnection");
  }

  JS::Rooted<JSObject*> desiredProto(cx);
  if (!GetDesiredProto(cx, args,
                       prototypes::id::RTCPeerConnection,
                       CreateInterfaceObjects,
                       &desiredProto)) {
    return false;
  }

  GlobalObject global(cx, obj);
  if (global.Failed()) {
    return false;
  }

  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  binding_detail::FastRTCConfiguration arg0;
  if (!arg0.Init(cx, (args.hasDefined(0)) ? args[0] : JS::NullHandleValue, "Argument 1", true)) {
    return false;
  }
  Maybe<JSAutoRealm> ar;
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    obj = js::CheckedUnwrapStatic(obj);
    if (!obj) {
      return false;
    }
    ar.emplace(cx, obj);
    if (!JS_WrapObject(cx, &desiredProto)) {
      return false;
    }
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::RTCPeerConnection>(mozilla::dom::RTCPeerConnection::Constructor(global, cx, Constify(arg0), rv, desiredProto)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "RTCPeerConnection constructor"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval(), desiredProto)) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const DOMInterfaceInfo sInterfaceObjectInfo = {
  { _constructor, &sNativePropertyHooks },
  EventTarget_Binding::GetConstructorObjectHandle,
  PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth,
  prototypes::id::RTCPeerConnection,
  true,
  0,
  "RTCPeerConnection",
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "RTCPeerConnectionPrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::RTCPeerConnection,
  PrototypeTraits<prototypes::id::RTCPeerConnection>::Depth,
  &sNativePropertyHooks,
  EventTarget_Binding::GetProtoObject
};

bool
ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj)
{
  return StaticPrefs::media_peerconnection_enabled();
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx);

static const JSClassOps sClassOps = {
  nullptr,               /* addProperty */
  nullptr,               /* delProperty */
  nullptr,               /* enumerate */
  nullptr, /* newEnumerate */
  nullptr, /* resolve */
  nullptr, /* mayResolve */
  _finalize, /* finalize */
  nullptr, /* call */
  nullptr,               /* construct */
  nullptr, /* trace */
};

static const DOMJSClass sClass = {
  { "RTCPeerConnection",
    JSCLASS_IS_DOMJSCLASS | JSCLASS_FOREGROUND_FINALIZE | JSCLASS_HAS_RESERVED_SLOTS(1) | JSCLASS_PRESERVES_WRAPPER,
    &sClassOps,
    JS_NULL_CLASS_SPEC,
    &NativeTypeHelpers<mozilla::dom::RTCPeerConnection>::sClassExtension,
    JS_NULL_OBJECT_OPS
  },
  { prototypes::id::EventTarget, prototypes::id::RTCPeerConnection, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, mozilla::dom::RTCPeerConnection>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<mozilla::dom::RTCPeerConnection>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<mozilla::dom::RTCPeerConnection>::Get(),
  nullptr,
  NativeTypeHelpers<mozilla::dom::RTCPeerConnection>::GetWrapperCache
};
static_assert(1 == DOM_INSTANCE_RESERVED_SLOTS,
              "Must have the right minimal number of reserved slots.");
static_assert(1 >= 1,
              "Must have enough reserved slots.");

bool
Wrap(JSContext* aCx, mozilla::dom::RTCPeerConnection* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, mozilla::dom::RTCPeerConnection>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), mozilla::dom::RTCPeerConnection*>);
  MOZ_ASSERT(static_cast<mozilla::dom::EventTarget*>(aObject) ==
             reinterpret_cast<mozilla::dom::EventTarget*>(aObject),
             "Multiple inheritance for mozilla::dom::EventTarget is broken.");
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    _finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<mozilla::dom::RTCPeerConnection> creator(aCx);
  creator.CreateObject(aCx, sClass.ToJSClass(), proto, aObject, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::RTCPeerConnection);
  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::RTCPeerConnection);

  JS::Handle<JSObject*> parentProto(EventTarget_Binding::GetProtoObjectHandle(aCx));
  if (!parentProto) {
    return;
  }

  JS::Handle<JSObject*> constructorProto(EventTarget_Binding::GetConstructorObjectHandle(aCx));
  if (!constructorProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              constructorProto, &sInterfaceObjectInfo, 0, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              sNativeProperties.Upcast(),
                              sChromeOnlyNativeProperties.Upcast(),
                              "RTCPeerConnection",
                              ShouldExpose<RTCPeerConnection_Binding::ConstructorEnabled>(aCx, aGlobal, aDefineOnGlobal),
                              nullptr,
                              false,
                              nullptr);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::RTCPeerConnection,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::RTCPeerConnection,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace RTCPeerConnection_Binding



void
RTCPeerConnectionJSImpl::SetIdentityProvider(const nsAString& provider, const RTCIdentityProviderOptions& options, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.setIdentityProvider", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(2)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return;
  }
  unsigned argc = 2;

  do {
    if (!options.ToObjectInternal(cx, argv[1])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    break;
  } while (false);

  do {
    if (!xpc::NonVoidStringToJsval(cx, provider, argv[0])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    break;
  } while (false);

  JS::Rooted<JS::Value> callable(cx);
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !GetCallableProperty(cx, atomsCache->setIdentityProvider_id, &callable)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  JS::Rooted<JS::Value> thisValue(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::subarray(argv, 0, argc), &rval)) {
    aRv.NoteJSContextException(cx);
    return;
  }
}

already_AddRefed<Promise>
RTCPeerConnectionJSImpl::GetIdentityAssertion(ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.getIdentityAssertion", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return nullptr;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);

  JS::Rooted<JS::Value> callable(cx);
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !GetCallableProperty(cx, atomsCache->getIdentityAssertion_id, &callable)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  JS::Rooted<JS::Value> thisValue(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::empty(), &rval)) {
    aRv.NoteJSContextException(cx);
    return nullptr;
  }
  RefPtr<Promise> rvalDecl;
  { // Scope for our GlobalObject, FastErrorResult, JSAutoRealm,
    // etc.

    JS::Rooted<JSObject*> globalObj(cx);
    if (!rval.isObject()) {
      aRv.ThrowTypeError<MSG_NOT_OBJECT>("return value of RTCPeerConnection.getIdentityAssertion");
      return nullptr;
    }
    JSObject* unwrappedVal = js::CheckedUnwrapStatic(&rval.toObject());
    if (!unwrappedVal) {
      // A slight lie, but not much of one, for a dead object wrapper.
      aRv.ThrowTypeError<MSG_NOT_OBJECT>("return value of RTCPeerConnection.getIdentityAssertion");
      return nullptr;
    }
    globalObj = JS::GetNonCCWObjectGlobal(unwrappedVal);
    JSAutoRealm ar(cx, globalObj);
    GlobalObject promiseGlobal(cx, globalObj);
    if (promiseGlobal.Failed()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }

    JS::Rooted<JS::Value> valueToResolve(cx, rval);
    if (!JS_WrapValue(cx, &valueToResolve)) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
    binding_detail::FastErrorResult promiseRv;
    nsCOMPtr<nsIGlobalObject> global =
      do_QueryInterface(promiseGlobal.GetAsSupports());
    if (!global) {
      promiseRv.Throw(NS_ERROR_UNEXPECTED);
      MOZ_ALWAYS_TRUE(promiseRv.MaybeSetPendingException(cx));
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
    rvalDecl = Promise::Resolve(global, cx, valueToResolve,
                                    promiseRv);
    if (promiseRv.MaybeSetPendingException(cx)) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
  }
  return rvalDecl.forget();
}

already_AddRefed<Promise>
RTCPeerConnectionJSImpl::CreateOffer(const RTCOfferOptions& options, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.createOffer", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return nullptr;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(1)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return nullptr;
  }
  unsigned argc = 1;

  do {
    if (!options.ToObjectInternal(cx, argv[0])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
    break;
  } while (false);

  JS::Rooted<JS::Value> callable(cx);
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !GetCallableProperty(cx, atomsCache->createOffer_id, &callable)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  JS::Rooted<JS::Value> thisValue(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::subarray(argv, 0, argc), &rval)) {
    aRv.NoteJSContextException(cx);
    return nullptr;
  }
  RefPtr<Promise> rvalDecl;
  { // Scope for our GlobalObject, FastErrorResult, JSAutoRealm,
    // etc.

    JS::Rooted<JSObject*> globalObj(cx);
    if (!rval.isObject()) {
      aRv.ThrowTypeError<MSG_NOT_OBJECT>("return value of RTCPeerConnection.createOffer");
      return nullptr;
    }
    JSObject* unwrappedVal = js::CheckedUnwrapStatic(&rval.toObject());
    if (!unwrappedVal) {
      // A slight lie, but not much of one, for a dead object wrapper.
      aRv.ThrowTypeError<MSG_NOT_OBJECT>("return value of RTCPeerConnection.createOffer");
      return nullptr;
    }
    globalObj = JS::GetNonCCWObjectGlobal(unwrappedVal);
    JSAutoRealm ar(cx, globalObj);
    GlobalObject promiseGlobal(cx, globalObj);
    if (promiseGlobal.Failed()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }

    JS::Rooted<JS::Value> valueToResolve(cx, rval);
    if (!JS_WrapValue(cx, &valueToResolve)) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
    binding_detail::FastErrorResult promiseRv;
    nsCOMPtr<nsIGlobalObject> global =
      do_QueryInterface(promiseGlobal.GetAsSupports());
    if (!global) {
      promiseRv.Throw(NS_ERROR_UNEXPECTED);
      MOZ_ALWAYS_TRUE(promiseRv.MaybeSetPendingException(cx));
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
    rvalDecl = Promise::Resolve(global, cx, valueToResolve,
                                    promiseRv);
    if (promiseRv.MaybeSetPendingException(cx)) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
  }
  return rvalDecl.forget();
}

already_AddRefed<Promise>
RTCPeerConnectionJSImpl::CreateOffer(RTCSessionDescriptionCallback& successCallback, RTCPeerConnectionErrorCallback& failureCallback, const RTCOfferOptions& options, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.createOffer", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return nullptr;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(3)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return nullptr;
  }
  unsigned argc = 3;

  do {
    if (!options.ToObjectInternal(cx, argv[2])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
    break;
  } while (false);

  do {
    argv[1].setObjectOrNull(GetCallbackFromCallbackObject(cx, failureCallback));
    if (!MaybeWrapObjectValue(cx, argv[1])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
    break;
  } while (false);

  do {
    argv[0].setObjectOrNull(GetCallbackFromCallbackObject(cx, successCallback));
    if (!MaybeWrapObjectValue(cx, argv[0])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
    break;
  } while (false);

  JS::Rooted<JS::Value> callable(cx);
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !GetCallableProperty(cx, atomsCache->createOffer_id, &callable)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  JS::Rooted<JS::Value> thisValue(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::subarray(argv, 0, argc), &rval)) {
    aRv.NoteJSContextException(cx);
    return nullptr;
  }
  RefPtr<Promise> rvalDecl;
  { // Scope for our GlobalObject, FastErrorResult, JSAutoRealm,
    // etc.

    JS::Rooted<JSObject*> globalObj(cx);
    if (!rval.isObject()) {
      aRv.ThrowTypeError<MSG_NOT_OBJECT>("return value of RTCPeerConnection.createOffer");
      return nullptr;
    }
    JSObject* unwrappedVal = js::CheckedUnwrapStatic(&rval.toObject());
    if (!unwrappedVal) {
      // A slight lie, but not much of one, for a dead object wrapper.
      aRv.ThrowTypeError<MSG_NOT_OBJECT>("return value of RTCPeerConnection.createOffer");
      return nullptr;
    }
    globalObj = JS::GetNonCCWObjectGlobal(unwrappedVal);
    JSAutoRealm ar(cx, globalObj);
    GlobalObject promiseGlobal(cx, globalObj);
    if (promiseGlobal.Failed()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }

    JS::Rooted<JS::Value> valueToResolve(cx, rval);
    if (!JS_WrapValue(cx, &valueToResolve)) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
    binding_detail::FastErrorResult promiseRv;
    nsCOMPtr<nsIGlobalObject> global =
      do_QueryInterface(promiseGlobal.GetAsSupports());
    if (!global) {
      promiseRv.Throw(NS_ERROR_UNEXPECTED);
      MOZ_ALWAYS_TRUE(promiseRv.MaybeSetPendingException(cx));
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
    rvalDecl = Promise::Resolve(global, cx, valueToResolve,
                                    promiseRv);
    if (promiseRv.MaybeSetPendingException(cx)) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
  }
  return rvalDecl.forget();
}

already_AddRefed<Promise>
RTCPeerConnectionJSImpl::CreateAnswer(const RTCAnswerOptions& options, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.createAnswer", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return nullptr;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(1)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return nullptr;
  }
  unsigned argc = 1;

  do {
    if (!options.ToObjectInternal(cx, argv[0])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
    break;
  } while (false);

  JS::Rooted<JS::Value> callable(cx);
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !GetCallableProperty(cx, atomsCache->createAnswer_id, &callable)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  JS::Rooted<JS::Value> thisValue(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::subarray(argv, 0, argc), &rval)) {
    aRv.NoteJSContextException(cx);
    return nullptr;
  }
  RefPtr<Promise> rvalDecl;
  { // Scope for our GlobalObject, FastErrorResult, JSAutoRealm,
    // etc.

    JS::Rooted<JSObject*> globalObj(cx);
    if (!rval.isObject()) {
      aRv.ThrowTypeError<MSG_NOT_OBJECT>("return value of RTCPeerConnection.createAnswer");
      return nullptr;
    }
    JSObject* unwrappedVal = js::CheckedUnwrapStatic(&rval.toObject());
    if (!unwrappedVal) {
      // A slight lie, but not much of one, for a dead object wrapper.
      aRv.ThrowTypeError<MSG_NOT_OBJECT>("return value of RTCPeerConnection.createAnswer");
      return nullptr;
    }
    globalObj = JS::GetNonCCWObjectGlobal(unwrappedVal);
    JSAutoRealm ar(cx, globalObj);
    GlobalObject promiseGlobal(cx, globalObj);
    if (promiseGlobal.Failed()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }

    JS::Rooted<JS::Value> valueToResolve(cx, rval);
    if (!JS_WrapValue(cx, &valueToResolve)) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
    binding_detail::FastErrorResult promiseRv;
    nsCOMPtr<nsIGlobalObject> global =
      do_QueryInterface(promiseGlobal.GetAsSupports());
    if (!global) {
      promiseRv.Throw(NS_ERROR_UNEXPECTED);
      MOZ_ALWAYS_TRUE(promiseRv.MaybeSetPendingException(cx));
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
    rvalDecl = Promise::Resolve(global, cx, valueToResolve,
                                    promiseRv);
    if (promiseRv.MaybeSetPendingException(cx)) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
  }
  return rvalDecl.forget();
}

already_AddRefed<Promise>
RTCPeerConnectionJSImpl::CreateAnswer(RTCSessionDescriptionCallback& successCallback, RTCPeerConnectionErrorCallback& failureCallback, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.createAnswer", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return nullptr;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(2)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return nullptr;
  }
  unsigned argc = 2;

  do {
    argv[1].setObjectOrNull(GetCallbackFromCallbackObject(cx, failureCallback));
    if (!MaybeWrapObjectValue(cx, argv[1])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
    break;
  } while (false);

  do {
    argv[0].setObjectOrNull(GetCallbackFromCallbackObject(cx, successCallback));
    if (!MaybeWrapObjectValue(cx, argv[0])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
    break;
  } while (false);

  JS::Rooted<JS::Value> callable(cx);
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !GetCallableProperty(cx, atomsCache->createAnswer_id, &callable)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  JS::Rooted<JS::Value> thisValue(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::subarray(argv, 0, argc), &rval)) {
    aRv.NoteJSContextException(cx);
    return nullptr;
  }
  RefPtr<Promise> rvalDecl;
  { // Scope for our GlobalObject, FastErrorResult, JSAutoRealm,
    // etc.

    JS::Rooted<JSObject*> globalObj(cx);
    if (!rval.isObject()) {
      aRv.ThrowTypeError<MSG_NOT_OBJECT>("return value of RTCPeerConnection.createAnswer");
      return nullptr;
    }
    JSObject* unwrappedVal = js::CheckedUnwrapStatic(&rval.toObject());
    if (!unwrappedVal) {
      // A slight lie, but not much of one, for a dead object wrapper.
      aRv.ThrowTypeError<MSG_NOT_OBJECT>("return value of RTCPeerConnection.createAnswer");
      return nullptr;
    }
    globalObj = JS::GetNonCCWObjectGlobal(unwrappedVal);
    JSAutoRealm ar(cx, globalObj);
    GlobalObject promiseGlobal(cx, globalObj);
    if (promiseGlobal.Failed()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }

    JS::Rooted<JS::Value> valueToResolve(cx, rval);
    if (!JS_WrapValue(cx, &valueToResolve)) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
    binding_detail::FastErrorResult promiseRv;
    nsCOMPtr<nsIGlobalObject> global =
      do_QueryInterface(promiseGlobal.GetAsSupports());
    if (!global) {
      promiseRv.Throw(NS_ERROR_UNEXPECTED);
      MOZ_ALWAYS_TRUE(promiseRv.MaybeSetPendingException(cx));
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
    rvalDecl = Promise::Resolve(global, cx, valueToResolve,
                                    promiseRv);
    if (promiseRv.MaybeSetPendingException(cx)) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
  }
  return rvalDecl.forget();
}

already_AddRefed<Promise>
RTCPeerConnectionJSImpl::SetLocalDescription(const RTCLocalSessionDescriptionInit& description, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.setLocalDescription", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return nullptr;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(1)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return nullptr;
  }
  unsigned argc = 1;

  do {
    if (!description.ToObjectInternal(cx, argv[0])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
    break;
  } while (false);

  JS::Rooted<JS::Value> callable(cx);
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !GetCallableProperty(cx, atomsCache->setLocalDescription_id, &callable)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  JS::Rooted<JS::Value> thisValue(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::subarray(argv, 0, argc), &rval)) {
    aRv.NoteJSContextException(cx);
    return nullptr;
  }
  RefPtr<Promise> rvalDecl;
  { // Scope for our GlobalObject, FastErrorResult, JSAutoRealm,
    // etc.

    JS::Rooted<JSObject*> globalObj(cx);
    if (!rval.isObject()) {
      aRv.ThrowTypeError<MSG_NOT_OBJECT>("return value of RTCPeerConnection.setLocalDescription");
      return nullptr;
    }
    JSObject* unwrappedVal = js::CheckedUnwrapStatic(&rval.toObject());
    if (!unwrappedVal) {
      // A slight lie, but not much of one, for a dead object wrapper.
      aRv.ThrowTypeError<MSG_NOT_OBJECT>("return value of RTCPeerConnection.setLocalDescription");
      return nullptr;
    }
    globalObj = JS::GetNonCCWObjectGlobal(unwrappedVal);
    JSAutoRealm ar(cx, globalObj);
    GlobalObject promiseGlobal(cx, globalObj);
    if (promiseGlobal.Failed()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }

    JS::Rooted<JS::Value> valueToResolve(cx, rval);
    if (!JS_WrapValue(cx, &valueToResolve)) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
    binding_detail::FastErrorResult promiseRv;
    nsCOMPtr<nsIGlobalObject> global =
      do_QueryInterface(promiseGlobal.GetAsSupports());
    if (!global) {
      promiseRv.Throw(NS_ERROR_UNEXPECTED);
      MOZ_ALWAYS_TRUE(promiseRv.MaybeSetPendingException(cx));
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
    rvalDecl = Promise::Resolve(global, cx, valueToResolve,
                                    promiseRv);
    if (promiseRv.MaybeSetPendingException(cx)) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
  }
  return rvalDecl.forget();
}

already_AddRefed<Promise>
RTCPeerConnectionJSImpl::SetLocalDescription(const RTCLocalSessionDescriptionInit& description, VoidFunction& successCallback, RTCPeerConnectionErrorCallback& failureCallback, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.setLocalDescription", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return nullptr;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(3)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return nullptr;
  }
  unsigned argc = 3;

  do {
    argv[2].setObjectOrNull(GetCallbackFromCallbackObject(cx, failureCallback));
    if (!MaybeWrapObjectValue(cx, argv[2])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
    break;
  } while (false);

  do {
    argv[1].setObjectOrNull(GetCallbackFromCallbackObject(cx, successCallback));
    if (!MaybeWrapObjectValue(cx, argv[1])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
    break;
  } while (false);

  do {
    if (!description.ToObjectInternal(cx, argv[0])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
    break;
  } while (false);

  JS::Rooted<JS::Value> callable(cx);
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !GetCallableProperty(cx, atomsCache->setLocalDescription_id, &callable)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  JS::Rooted<JS::Value> thisValue(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::subarray(argv, 0, argc), &rval)) {
    aRv.NoteJSContextException(cx);
    return nullptr;
  }
  RefPtr<Promise> rvalDecl;
  { // Scope for our GlobalObject, FastErrorResult, JSAutoRealm,
    // etc.

    JS::Rooted<JSObject*> globalObj(cx);
    if (!rval.isObject()) {
      aRv.ThrowTypeError<MSG_NOT_OBJECT>("return value of RTCPeerConnection.setLocalDescription");
      return nullptr;
    }
    JSObject* unwrappedVal = js::CheckedUnwrapStatic(&rval.toObject());
    if (!unwrappedVal) {
      // A slight lie, but not much of one, for a dead object wrapper.
      aRv.ThrowTypeError<MSG_NOT_OBJECT>("return value of RTCPeerConnection.setLocalDescription");
      return nullptr;
    }
    globalObj = JS::GetNonCCWObjectGlobal(unwrappedVal);
    JSAutoRealm ar(cx, globalObj);
    GlobalObject promiseGlobal(cx, globalObj);
    if (promiseGlobal.Failed()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }

    JS::Rooted<JS::Value> valueToResolve(cx, rval);
    if (!JS_WrapValue(cx, &valueToResolve)) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
    binding_detail::FastErrorResult promiseRv;
    nsCOMPtr<nsIGlobalObject> global =
      do_QueryInterface(promiseGlobal.GetAsSupports());
    if (!global) {
      promiseRv.Throw(NS_ERROR_UNEXPECTED);
      MOZ_ALWAYS_TRUE(promiseRv.MaybeSetPendingException(cx));
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
    rvalDecl = Promise::Resolve(global, cx, valueToResolve,
                                    promiseRv);
    if (promiseRv.MaybeSetPendingException(cx)) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
  }
  return rvalDecl.forget();
}

already_AddRefed<Promise>
RTCPeerConnectionJSImpl::SetRemoteDescription(const RTCSessionDescriptionInit& description, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.setRemoteDescription", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return nullptr;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(1)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return nullptr;
  }
  unsigned argc = 1;

  do {
    if (!description.ToObjectInternal(cx, argv[0])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
    break;
  } while (false);

  JS::Rooted<JS::Value> callable(cx);
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !GetCallableProperty(cx, atomsCache->setRemoteDescription_id, &callable)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  JS::Rooted<JS::Value> thisValue(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::subarray(argv, 0, argc), &rval)) {
    aRv.NoteJSContextException(cx);
    return nullptr;
  }
  RefPtr<Promise> rvalDecl;
  { // Scope for our GlobalObject, FastErrorResult, JSAutoRealm,
    // etc.

    JS::Rooted<JSObject*> globalObj(cx);
    if (!rval.isObject()) {
      aRv.ThrowTypeError<MSG_NOT_OBJECT>("return value of RTCPeerConnection.setRemoteDescription");
      return nullptr;
    }
    JSObject* unwrappedVal = js::CheckedUnwrapStatic(&rval.toObject());
    if (!unwrappedVal) {
      // A slight lie, but not much of one, for a dead object wrapper.
      aRv.ThrowTypeError<MSG_NOT_OBJECT>("return value of RTCPeerConnection.setRemoteDescription");
      return nullptr;
    }
    globalObj = JS::GetNonCCWObjectGlobal(unwrappedVal);
    JSAutoRealm ar(cx, globalObj);
    GlobalObject promiseGlobal(cx, globalObj);
    if (promiseGlobal.Failed()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }

    JS::Rooted<JS::Value> valueToResolve(cx, rval);
    if (!JS_WrapValue(cx, &valueToResolve)) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
    binding_detail::FastErrorResult promiseRv;
    nsCOMPtr<nsIGlobalObject> global =
      do_QueryInterface(promiseGlobal.GetAsSupports());
    if (!global) {
      promiseRv.Throw(NS_ERROR_UNEXPECTED);
      MOZ_ALWAYS_TRUE(promiseRv.MaybeSetPendingException(cx));
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
    rvalDecl = Promise::Resolve(global, cx, valueToResolve,
                                    promiseRv);
    if (promiseRv.MaybeSetPendingException(cx)) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
  }
  return rvalDecl.forget();
}

already_AddRefed<Promise>
RTCPeerConnectionJSImpl::SetRemoteDescription(const RTCSessionDescriptionInit& description, VoidFunction& successCallback, RTCPeerConnectionErrorCallback& failureCallback, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.setRemoteDescription", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return nullptr;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(3)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return nullptr;
  }
  unsigned argc = 3;

  do {
    argv[2].setObjectOrNull(GetCallbackFromCallbackObject(cx, failureCallback));
    if (!MaybeWrapObjectValue(cx, argv[2])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
    break;
  } while (false);

  do {
    argv[1].setObjectOrNull(GetCallbackFromCallbackObject(cx, successCallback));
    if (!MaybeWrapObjectValue(cx, argv[1])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
    break;
  } while (false);

  do {
    if (!description.ToObjectInternal(cx, argv[0])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
    break;
  } while (false);

  JS::Rooted<JS::Value> callable(cx);
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !GetCallableProperty(cx, atomsCache->setRemoteDescription_id, &callable)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  JS::Rooted<JS::Value> thisValue(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::subarray(argv, 0, argc), &rval)) {
    aRv.NoteJSContextException(cx);
    return nullptr;
  }
  RefPtr<Promise> rvalDecl;
  { // Scope for our GlobalObject, FastErrorResult, JSAutoRealm,
    // etc.

    JS::Rooted<JSObject*> globalObj(cx);
    if (!rval.isObject()) {
      aRv.ThrowTypeError<MSG_NOT_OBJECT>("return value of RTCPeerConnection.setRemoteDescription");
      return nullptr;
    }
    JSObject* unwrappedVal = js::CheckedUnwrapStatic(&rval.toObject());
    if (!unwrappedVal) {
      // A slight lie, but not much of one, for a dead object wrapper.
      aRv.ThrowTypeError<MSG_NOT_OBJECT>("return value of RTCPeerConnection.setRemoteDescription");
      return nullptr;
    }
    globalObj = JS::GetNonCCWObjectGlobal(unwrappedVal);
    JSAutoRealm ar(cx, globalObj);
    GlobalObject promiseGlobal(cx, globalObj);
    if (promiseGlobal.Failed()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }

    JS::Rooted<JS::Value> valueToResolve(cx, rval);
    if (!JS_WrapValue(cx, &valueToResolve)) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
    binding_detail::FastErrorResult promiseRv;
    nsCOMPtr<nsIGlobalObject> global =
      do_QueryInterface(promiseGlobal.GetAsSupports());
    if (!global) {
      promiseRv.Throw(NS_ERROR_UNEXPECTED);
      MOZ_ALWAYS_TRUE(promiseRv.MaybeSetPendingException(cx));
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
    rvalDecl = Promise::Resolve(global, cx, valueToResolve,
                                    promiseRv);
    if (promiseRv.MaybeSetPendingException(cx)) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
  }
  return rvalDecl.forget();
}

already_AddRefed<Promise>
RTCPeerConnectionJSImpl::AddIceCandidate(const RTCIceCandidateInitOrRTCIceCandidate& candidate, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.addIceCandidate", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return nullptr;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(1)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return nullptr;
  }
  unsigned argc = 1;

  do {
    JS::Rooted<JSObject*> callbackObj(cx, CallbackKnownNotGray());
    if (!candidate.ToJSVal(cx, callbackObj, argv[0])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
    break;
  } while (false);

  JS::Rooted<JS::Value> callable(cx);
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !GetCallableProperty(cx, atomsCache->addIceCandidate_id, &callable)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  JS::Rooted<JS::Value> thisValue(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::subarray(argv, 0, argc), &rval)) {
    aRv.NoteJSContextException(cx);
    return nullptr;
  }
  RefPtr<Promise> rvalDecl;
  { // Scope for our GlobalObject, FastErrorResult, JSAutoRealm,
    // etc.

    JS::Rooted<JSObject*> globalObj(cx);
    if (!rval.isObject()) {
      aRv.ThrowTypeError<MSG_NOT_OBJECT>("return value of RTCPeerConnection.addIceCandidate");
      return nullptr;
    }
    JSObject* unwrappedVal = js::CheckedUnwrapStatic(&rval.toObject());
    if (!unwrappedVal) {
      // A slight lie, but not much of one, for a dead object wrapper.
      aRv.ThrowTypeError<MSG_NOT_OBJECT>("return value of RTCPeerConnection.addIceCandidate");
      return nullptr;
    }
    globalObj = JS::GetNonCCWObjectGlobal(unwrappedVal);
    JSAutoRealm ar(cx, globalObj);
    GlobalObject promiseGlobal(cx, globalObj);
    if (promiseGlobal.Failed()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }

    JS::Rooted<JS::Value> valueToResolve(cx, rval);
    if (!JS_WrapValue(cx, &valueToResolve)) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
    binding_detail::FastErrorResult promiseRv;
    nsCOMPtr<nsIGlobalObject> global =
      do_QueryInterface(promiseGlobal.GetAsSupports());
    if (!global) {
      promiseRv.Throw(NS_ERROR_UNEXPECTED);
      MOZ_ALWAYS_TRUE(promiseRv.MaybeSetPendingException(cx));
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
    rvalDecl = Promise::Resolve(global, cx, valueToResolve,
                                    promiseRv);
    if (promiseRv.MaybeSetPendingException(cx)) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
  }
  return rvalDecl.forget();
}

already_AddRefed<Promise>
RTCPeerConnectionJSImpl::AddIceCandidate(const RTCIceCandidateInit& candidate, VoidFunction& successCallback, RTCPeerConnectionErrorCallback& failureCallback, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.addIceCandidate", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return nullptr;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(3)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return nullptr;
  }
  unsigned argc = 3;

  do {
    argv[2].setObjectOrNull(GetCallbackFromCallbackObject(cx, failureCallback));
    if (!MaybeWrapObjectValue(cx, argv[2])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
    break;
  } while (false);

  do {
    argv[1].setObjectOrNull(GetCallbackFromCallbackObject(cx, successCallback));
    if (!MaybeWrapObjectValue(cx, argv[1])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
    break;
  } while (false);

  do {
    if (!candidate.ToObjectInternal(cx, argv[0])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
    break;
  } while (false);

  JS::Rooted<JS::Value> callable(cx);
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !GetCallableProperty(cx, atomsCache->addIceCandidate_id, &callable)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  JS::Rooted<JS::Value> thisValue(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::subarray(argv, 0, argc), &rval)) {
    aRv.NoteJSContextException(cx);
    return nullptr;
  }
  RefPtr<Promise> rvalDecl;
  { // Scope for our GlobalObject, FastErrorResult, JSAutoRealm,
    // etc.

    JS::Rooted<JSObject*> globalObj(cx);
    if (!rval.isObject()) {
      aRv.ThrowTypeError<MSG_NOT_OBJECT>("return value of RTCPeerConnection.addIceCandidate");
      return nullptr;
    }
    JSObject* unwrappedVal = js::CheckedUnwrapStatic(&rval.toObject());
    if (!unwrappedVal) {
      // A slight lie, but not much of one, for a dead object wrapper.
      aRv.ThrowTypeError<MSG_NOT_OBJECT>("return value of RTCPeerConnection.addIceCandidate");
      return nullptr;
    }
    globalObj = JS::GetNonCCWObjectGlobal(unwrappedVal);
    JSAutoRealm ar(cx, globalObj);
    GlobalObject promiseGlobal(cx, globalObj);
    if (promiseGlobal.Failed()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }

    JS::Rooted<JS::Value> valueToResolve(cx, rval);
    if (!JS_WrapValue(cx, &valueToResolve)) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
    binding_detail::FastErrorResult promiseRv;
    nsCOMPtr<nsIGlobalObject> global =
      do_QueryInterface(promiseGlobal.GetAsSupports());
    if (!global) {
      promiseRv.Throw(NS_ERROR_UNEXPECTED);
      MOZ_ALWAYS_TRUE(promiseRv.MaybeSetPendingException(cx));
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
    rvalDecl = Promise::Resolve(global, cx, valueToResolve,
                                    promiseRv);
    if (promiseRv.MaybeSetPendingException(cx)) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
  }
  return rvalDecl.forget();
}

void
RTCPeerConnectionJSImpl::RestartIce(ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.restartIce", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);

  JS::Rooted<JS::Value> callable(cx);
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !GetCallableProperty(cx, atomsCache->restartIce_id, &callable)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  JS::Rooted<JS::Value> thisValue(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::empty(), &rval)) {
    aRv.NoteJSContextException(cx);
    return;
  }
}

void
RTCPeerConnectionJSImpl::GetConfiguration(RTCConfiguration& aRetVal, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.getConfiguration", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);

  JS::Rooted<JS::Value> callable(cx);
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !GetCallableProperty(cx, atomsCache->getConfiguration_id, &callable)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  JS::Rooted<JS::Value> thisValue(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::empty(), &rval)) {
    aRv.NoteJSContextException(cx);
    return;
  }
  RTCConfiguration& rvalDecl(aRetVal);
  if (!rvalDecl.Init(cx, rval, "Return value of RTCPeerConnection.getConfiguration", false)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
}

void
RTCPeerConnectionJSImpl::SetConfiguration(const RTCConfiguration& configuration, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.setConfiguration", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(1)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return;
  }
  unsigned argc = 1;

  do {
    if (!configuration.ToObjectInternal(cx, argv[0])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    break;
  } while (false);

  JS::Rooted<JS::Value> callable(cx);
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !GetCallableProperty(cx, atomsCache->setConfiguration_id, &callable)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  JS::Rooted<JS::Value> thisValue(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::subarray(argv, 0, argc), &rval)) {
    aRv.NoteJSContextException(cx);
    return;
  }
}

void
RTCPeerConnectionJSImpl::GetLocalStreams(nsTArray<RefPtr<DOMMediaStream>>& aRetVal, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.getLocalStreams", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);

  JS::Rooted<JS::Value> callable(cx);
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !GetCallableProperty(cx, atomsCache->getLocalStreams_id, &callable)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  JS::Rooted<JS::Value> thisValue(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::empty(), &rval)) {
    aRv.NoteJSContextException(cx);
    return;
  }
  Sequence<RefPtr<mozilla::DOMMediaStream>> rvalDecl;
  if (rval.isObject()) {
    JS::ForOfIterator iter(cx);
    if (!iter.init(rval, JS::ForOfIterator::AllowNonIterable)) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    if (!iter.valueIsIterable()) {
      cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Return value of RTCPeerConnection.getLocalStreams", "sequence");
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    Sequence<RefPtr<mozilla::DOMMediaStream>> &arr = rvalDecl;
    JS::Rooted<JS::Value> temp(cx);
    while (true) {
      bool done;
      if (!iter.next(&temp, &done)) {
        aRv.Throw(NS_ERROR_UNEXPECTED);
        return;
      }
      if (done) {
        break;
      }
      RefPtr<mozilla::DOMMediaStream>* slotPtr = arr.AppendElement(mozilla::fallible);
      if (!slotPtr) {
        JS_ReportOutOfMemory(cx);
        aRv.Throw(NS_ERROR_UNEXPECTED);
        return;
      }
      RefPtr<mozilla::DOMMediaStream>& slot = *slotPtr;
      if (temp.isObject()) {
        static_assert(IsRefcounted<mozilla::DOMMediaStream>::value, "We can only store refcounted classes.");
        {
          // Our JSContext should be in the right global to do unwrapping in.
          nsresult rv = UnwrapObject<prototypes::id::MediaStream, mozilla::DOMMediaStream>(&temp, slot, cx);
          if (NS_FAILED(rv)) {
            cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Element of return value of RTCPeerConnection.getLocalStreams", "MediaStream");
            aRv.Throw(NS_ERROR_UNEXPECTED);
            return;
          }
        }
      } else {
        cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Element of return value of RTCPeerConnection.getLocalStreams");
        aRv.Throw(NS_ERROR_UNEXPECTED);
        return;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Return value of RTCPeerConnection.getLocalStreams", "sequence");
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  aRetVal = std::move(rvalDecl);
}

void
RTCPeerConnectionJSImpl::GetRemoteStreams(nsTArray<RefPtr<DOMMediaStream>>& aRetVal, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.getRemoteStreams", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);

  JS::Rooted<JS::Value> callable(cx);
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !GetCallableProperty(cx, atomsCache->getRemoteStreams_id, &callable)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  JS::Rooted<JS::Value> thisValue(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::empty(), &rval)) {
    aRv.NoteJSContextException(cx);
    return;
  }
  Sequence<RefPtr<mozilla::DOMMediaStream>> rvalDecl;
  if (rval.isObject()) {
    JS::ForOfIterator iter(cx);
    if (!iter.init(rval, JS::ForOfIterator::AllowNonIterable)) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    if (!iter.valueIsIterable()) {
      cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Return value of RTCPeerConnection.getRemoteStreams", "sequence");
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    Sequence<RefPtr<mozilla::DOMMediaStream>> &arr = rvalDecl;
    JS::Rooted<JS::Value> temp(cx);
    while (true) {
      bool done;
      if (!iter.next(&temp, &done)) {
        aRv.Throw(NS_ERROR_UNEXPECTED);
        return;
      }
      if (done) {
        break;
      }
      RefPtr<mozilla::DOMMediaStream>* slotPtr = arr.AppendElement(mozilla::fallible);
      if (!slotPtr) {
        JS_ReportOutOfMemory(cx);
        aRv.Throw(NS_ERROR_UNEXPECTED);
        return;
      }
      RefPtr<mozilla::DOMMediaStream>& slot = *slotPtr;
      if (temp.isObject()) {
        static_assert(IsRefcounted<mozilla::DOMMediaStream>::value, "We can only store refcounted classes.");
        {
          // Our JSContext should be in the right global to do unwrapping in.
          nsresult rv = UnwrapObject<prototypes::id::MediaStream, mozilla::DOMMediaStream>(&temp, slot, cx);
          if (NS_FAILED(rv)) {
            cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Element of return value of RTCPeerConnection.getRemoteStreams", "MediaStream");
            aRv.Throw(NS_ERROR_UNEXPECTED);
            return;
          }
        }
      } else {
        cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Element of return value of RTCPeerConnection.getRemoteStreams");
        aRv.Throw(NS_ERROR_UNEXPECTED);
        return;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Return value of RTCPeerConnection.getRemoteStreams", "sequence");
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  aRetVal = std::move(rvalDecl);
}

void
RTCPeerConnectionJSImpl::AddStream(DOMMediaStream& stream, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.addStream", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(1)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return;
  }
  unsigned argc = 1;

  do {
    if (!GetOrCreateDOMReflector(cx, stream, argv[0])) {
      MOZ_ASSERT(JS_IsExceptionPending(cx));
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    break;
  } while (false);

  JS::Rooted<JS::Value> callable(cx);
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !GetCallableProperty(cx, atomsCache->addStream_id, &callable)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  JS::Rooted<JS::Value> thisValue(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::subarray(argv, 0, argc), &rval)) {
    aRv.NoteJSContextException(cx);
    return;
  }
}

already_AddRefed<RTCRtpSender>
RTCPeerConnectionJSImpl::AddTrack(MediaStreamTrack& track, const nsTArray<OwningNonNull<DOMMediaStream>>& streams, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.addTrack", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return nullptr;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize((2 - 1) + streams.Length())) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return nullptr;
  }
  unsigned argc = (2 - 1) + streams.Length();

  do {
    for (uint32_t idx = 0; idx < streams.Length(); ++idx) {
      if (!GetOrCreateDOMReflector(cx, streams[idx], argv[1 + idx])) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        aRv.Throw(NS_ERROR_UNEXPECTED);
        return nullptr;
      }
      continue;
    }
    break;
  } while (false);

  do {
    if (!GetOrCreateDOMReflector(cx, track, argv[0])) {
      MOZ_ASSERT(JS_IsExceptionPending(cx));
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
    break;
  } while (false);

  JS::Rooted<JS::Value> callable(cx);
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !GetCallableProperty(cx, atomsCache->addTrack_id, &callable)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  JS::Rooted<JS::Value> thisValue(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::subarray(argv, 0, argc), &rval)) {
    aRv.NoteJSContextException(cx);
    return nullptr;
  }
  RefPtr<mozilla::dom::RTCRtpSender> rvalDecl;
  if (rval.isObject()) {
    static_assert(IsRefcounted<mozilla::dom::RTCRtpSender>::value, "We can only store refcounted classes.");
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::RTCRtpSender, mozilla::dom::RTCRtpSender>(rval, rvalDecl, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Return value of RTCPeerConnection.addTrack", "RTCRtpSender");
        aRv.Throw(NS_ERROR_UNEXPECTED);
        return nullptr;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Return value of RTCPeerConnection.addTrack");
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  return rvalDecl.forget();
}

void
RTCPeerConnectionJSImpl::RemoveTrack(RTCRtpSender& sender, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.removeTrack", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(1)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return;
  }
  unsigned argc = 1;

  do {
    if (!GetOrCreateDOMReflector(cx, sender, argv[0])) {
      MOZ_ASSERT(JS_IsExceptionPending(cx));
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    break;
  } while (false);

  JS::Rooted<JS::Value> callable(cx);
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !GetCallableProperty(cx, atomsCache->removeTrack_id, &callable)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  JS::Rooted<JS::Value> thisValue(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::subarray(argv, 0, argc), &rval)) {
    aRv.NoteJSContextException(cx);
    return;
  }
}

already_AddRefed<RTCRtpTransceiver>
RTCPeerConnectionJSImpl::AddTransceiver(const MediaStreamTrackOrString& trackOrKind, const RTCRtpTransceiverInit& init, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.addTransceiver", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return nullptr;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(2)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return nullptr;
  }
  unsigned argc = 2;

  do {
    if (!init.ToObjectInternal(cx, argv[1])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
    break;
  } while (false);

  do {
    JS::Rooted<JSObject*> callbackObj(cx, CallbackKnownNotGray());
    if (!trackOrKind.ToJSVal(cx, callbackObj, argv[0])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
    break;
  } while (false);

  JS::Rooted<JS::Value> callable(cx);
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !GetCallableProperty(cx, atomsCache->addTransceiver_id, &callable)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  JS::Rooted<JS::Value> thisValue(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::subarray(argv, 0, argc), &rval)) {
    aRv.NoteJSContextException(cx);
    return nullptr;
  }
  RefPtr<mozilla::dom::RTCRtpTransceiver> rvalDecl;
  if (rval.isObject()) {
    static_assert(IsRefcounted<mozilla::dom::RTCRtpTransceiver>::value, "We can only store refcounted classes.");
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::RTCRtpTransceiver, mozilla::dom::RTCRtpTransceiver>(rval, rvalDecl, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Return value of RTCPeerConnection.addTransceiver", "RTCRtpTransceiver");
        aRv.Throw(NS_ERROR_UNEXPECTED);
        return nullptr;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Return value of RTCPeerConnection.addTransceiver");
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  return rvalDecl.forget();
}

void
RTCPeerConnectionJSImpl::GetSenders(nsTArray<RefPtr<RTCRtpSender>>& aRetVal, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.getSenders", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);

  JS::Rooted<JS::Value> callable(cx);
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !GetCallableProperty(cx, atomsCache->getSenders_id, &callable)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  JS::Rooted<JS::Value> thisValue(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::empty(), &rval)) {
    aRv.NoteJSContextException(cx);
    return;
  }
  Sequence<RefPtr<mozilla::dom::RTCRtpSender>> rvalDecl;
  if (rval.isObject()) {
    JS::ForOfIterator iter(cx);
    if (!iter.init(rval, JS::ForOfIterator::AllowNonIterable)) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    if (!iter.valueIsIterable()) {
      cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Return value of RTCPeerConnection.getSenders", "sequence");
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    Sequence<RefPtr<mozilla::dom::RTCRtpSender>> &arr = rvalDecl;
    JS::Rooted<JS::Value> temp(cx);
    while (true) {
      bool done;
      if (!iter.next(&temp, &done)) {
        aRv.Throw(NS_ERROR_UNEXPECTED);
        return;
      }
      if (done) {
        break;
      }
      RefPtr<mozilla::dom::RTCRtpSender>* slotPtr = arr.AppendElement(mozilla::fallible);
      if (!slotPtr) {
        JS_ReportOutOfMemory(cx);
        aRv.Throw(NS_ERROR_UNEXPECTED);
        return;
      }
      RefPtr<mozilla::dom::RTCRtpSender>& slot = *slotPtr;
      if (temp.isObject()) {
        static_assert(IsRefcounted<mozilla::dom::RTCRtpSender>::value, "We can only store refcounted classes.");
        {
          // Our JSContext should be in the right global to do unwrapping in.
          nsresult rv = UnwrapObject<prototypes::id::RTCRtpSender, mozilla::dom::RTCRtpSender>(&temp, slot, cx);
          if (NS_FAILED(rv)) {
            cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Element of return value of RTCPeerConnection.getSenders", "RTCRtpSender");
            aRv.Throw(NS_ERROR_UNEXPECTED);
            return;
          }
        }
      } else {
        cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Element of return value of RTCPeerConnection.getSenders");
        aRv.Throw(NS_ERROR_UNEXPECTED);
        return;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Return value of RTCPeerConnection.getSenders", "sequence");
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  aRetVal = std::move(rvalDecl);
}

void
RTCPeerConnectionJSImpl::GetReceivers(nsTArray<RefPtr<RTCRtpReceiver>>& aRetVal, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.getReceivers", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);

  JS::Rooted<JS::Value> callable(cx);
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !GetCallableProperty(cx, atomsCache->getReceivers_id, &callable)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  JS::Rooted<JS::Value> thisValue(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::empty(), &rval)) {
    aRv.NoteJSContextException(cx);
    return;
  }
  Sequence<RefPtr<mozilla::dom::RTCRtpReceiver>> rvalDecl;
  if (rval.isObject()) {
    JS::ForOfIterator iter(cx);
    if (!iter.init(rval, JS::ForOfIterator::AllowNonIterable)) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    if (!iter.valueIsIterable()) {
      cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Return value of RTCPeerConnection.getReceivers", "sequence");
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    Sequence<RefPtr<mozilla::dom::RTCRtpReceiver>> &arr = rvalDecl;
    JS::Rooted<JS::Value> temp(cx);
    while (true) {
      bool done;
      if (!iter.next(&temp, &done)) {
        aRv.Throw(NS_ERROR_UNEXPECTED);
        return;
      }
      if (done) {
        break;
      }
      RefPtr<mozilla::dom::RTCRtpReceiver>* slotPtr = arr.AppendElement(mozilla::fallible);
      if (!slotPtr) {
        JS_ReportOutOfMemory(cx);
        aRv.Throw(NS_ERROR_UNEXPECTED);
        return;
      }
      RefPtr<mozilla::dom::RTCRtpReceiver>& slot = *slotPtr;
      if (temp.isObject()) {
        static_assert(IsRefcounted<mozilla::dom::RTCRtpReceiver>::value, "We can only store refcounted classes.");
        {
          // Our JSContext should be in the right global to do unwrapping in.
          nsresult rv = UnwrapObject<prototypes::id::RTCRtpReceiver, mozilla::dom::RTCRtpReceiver>(&temp, slot, cx);
          if (NS_FAILED(rv)) {
            cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Element of return value of RTCPeerConnection.getReceivers", "RTCRtpReceiver");
            aRv.Throw(NS_ERROR_UNEXPECTED);
            return;
          }
        }
      } else {
        cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Element of return value of RTCPeerConnection.getReceivers");
        aRv.Throw(NS_ERROR_UNEXPECTED);
        return;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Return value of RTCPeerConnection.getReceivers", "sequence");
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  aRetVal = std::move(rvalDecl);
}

void
RTCPeerConnectionJSImpl::GetTransceivers(nsTArray<RefPtr<RTCRtpTransceiver>>& aRetVal, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.getTransceivers", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);

  JS::Rooted<JS::Value> callable(cx);
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !GetCallableProperty(cx, atomsCache->getTransceivers_id, &callable)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  JS::Rooted<JS::Value> thisValue(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::empty(), &rval)) {
    aRv.NoteJSContextException(cx);
    return;
  }
  Sequence<RefPtr<mozilla::dom::RTCRtpTransceiver>> rvalDecl;
  if (rval.isObject()) {
    JS::ForOfIterator iter(cx);
    if (!iter.init(rval, JS::ForOfIterator::AllowNonIterable)) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    if (!iter.valueIsIterable()) {
      cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Return value of RTCPeerConnection.getTransceivers", "sequence");
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    Sequence<RefPtr<mozilla::dom::RTCRtpTransceiver>> &arr = rvalDecl;
    JS::Rooted<JS::Value> temp(cx);
    while (true) {
      bool done;
      if (!iter.next(&temp, &done)) {
        aRv.Throw(NS_ERROR_UNEXPECTED);
        return;
      }
      if (done) {
        break;
      }
      RefPtr<mozilla::dom::RTCRtpTransceiver>* slotPtr = arr.AppendElement(mozilla::fallible);
      if (!slotPtr) {
        JS_ReportOutOfMemory(cx);
        aRv.Throw(NS_ERROR_UNEXPECTED);
        return;
      }
      RefPtr<mozilla::dom::RTCRtpTransceiver>& slot = *slotPtr;
      if (temp.isObject()) {
        static_assert(IsRefcounted<mozilla::dom::RTCRtpTransceiver>::value, "We can only store refcounted classes.");
        {
          // Our JSContext should be in the right global to do unwrapping in.
          nsresult rv = UnwrapObject<prototypes::id::RTCRtpTransceiver, mozilla::dom::RTCRtpTransceiver>(&temp, slot, cx);
          if (NS_FAILED(rv)) {
            cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Element of return value of RTCPeerConnection.getTransceivers", "RTCRtpTransceiver");
            aRv.Throw(NS_ERROR_UNEXPECTED);
            return;
          }
        }
      } else {
        cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Element of return value of RTCPeerConnection.getTransceivers");
        aRv.Throw(NS_ERROR_UNEXPECTED);
        return;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Return value of RTCPeerConnection.getTransceivers", "sequence");
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  aRetVal = std::move(rvalDecl);
}

void
RTCPeerConnectionJSImpl::MozSetPacketCallback(mozPacketCallback& callback, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.mozSetPacketCallback", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(1)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return;
  }
  unsigned argc = 1;

  do {
    argv[0].setObjectOrNull(GetCallbackFromCallbackObject(cx, callback));
    if (!MaybeWrapObjectValue(cx, argv[0])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    break;
  } while (false);

  JS::Rooted<JS::Value> callable(cx);
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !GetCallableProperty(cx, atomsCache->mozSetPacketCallback_id, &callable)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  JS::Rooted<JS::Value> thisValue(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::subarray(argv, 0, argc), &rval)) {
    aRv.NoteJSContextException(cx);
    return;
  }
}

void
RTCPeerConnectionJSImpl::MozEnablePacketDump(uint32_t level, mozPacketDumpType type, bool sending, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.mozEnablePacketDump", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(3)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return;
  }
  unsigned argc = 3;

  do {
    argv[2].setBoolean(sending);
    break;
  } while (false);

  do {
    if (!ToJSValue(cx, type, argv[1])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    break;
  } while (false);

  do {
    argv[0].setNumber(level);
    break;
  } while (false);

  JS::Rooted<JS::Value> callable(cx);
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !GetCallableProperty(cx, atomsCache->mozEnablePacketDump_id, &callable)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  JS::Rooted<JS::Value> thisValue(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::subarray(argv, 0, argc), &rval)) {
    aRv.NoteJSContextException(cx);
    return;
  }
}

void
RTCPeerConnectionJSImpl::MozDisablePacketDump(uint32_t level, mozPacketDumpType type, bool sending, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.mozDisablePacketDump", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(3)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return;
  }
  unsigned argc = 3;

  do {
    argv[2].setBoolean(sending);
    break;
  } while (false);

  do {
    if (!ToJSValue(cx, type, argv[1])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    break;
  } while (false);

  do {
    argv[0].setNumber(level);
    break;
  } while (false);

  JS::Rooted<JS::Value> callable(cx);
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !GetCallableProperty(cx, atomsCache->mozDisablePacketDump_id, &callable)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  JS::Rooted<JS::Value> thisValue(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::subarray(argv, 0, argc), &rval)) {
    aRv.NoteJSContextException(cx);
    return;
  }
}

void
RTCPeerConnectionJSImpl::Close(ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.close", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);

  JS::Rooted<JS::Value> callable(cx);
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !GetCallableProperty(cx, atomsCache->close_id, &callable)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  JS::Rooted<JS::Value> thisValue(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::empty(), &rval)) {
    aRv.NoteJSContextException(cx);
    return;
  }
}

already_AddRefed<Promise>
RTCPeerConnectionJSImpl::GetStats(MediaStreamTrack* selector, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.getStats", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return nullptr;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(1)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return nullptr;
  }
  unsigned argc = 1;

  do {
    if (!selector) {
      argv[0].setNull();
      break;
    }
    if (!GetOrCreateDOMReflector(cx, selector, argv[0])) {
      MOZ_ASSERT(JS_IsExceptionPending(cx));
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
    break;
  } while (false);

  JS::Rooted<JS::Value> callable(cx);
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !GetCallableProperty(cx, atomsCache->getStats_id, &callable)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  JS::Rooted<JS::Value> thisValue(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::subarray(argv, 0, argc), &rval)) {
    aRv.NoteJSContextException(cx);
    return nullptr;
  }
  RefPtr<Promise> rvalDecl;
  { // Scope for our GlobalObject, FastErrorResult, JSAutoRealm,
    // etc.

    JS::Rooted<JSObject*> globalObj(cx);
    if (!rval.isObject()) {
      aRv.ThrowTypeError<MSG_NOT_OBJECT>("return value of RTCPeerConnection.getStats");
      return nullptr;
    }
    JSObject* unwrappedVal = js::CheckedUnwrapStatic(&rval.toObject());
    if (!unwrappedVal) {
      // A slight lie, but not much of one, for a dead object wrapper.
      aRv.ThrowTypeError<MSG_NOT_OBJECT>("return value of RTCPeerConnection.getStats");
      return nullptr;
    }
    globalObj = JS::GetNonCCWObjectGlobal(unwrappedVal);
    JSAutoRealm ar(cx, globalObj);
    GlobalObject promiseGlobal(cx, globalObj);
    if (promiseGlobal.Failed()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }

    JS::Rooted<JS::Value> valueToResolve(cx, rval);
    if (!JS_WrapValue(cx, &valueToResolve)) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
    binding_detail::FastErrorResult promiseRv;
    nsCOMPtr<nsIGlobalObject> global =
      do_QueryInterface(promiseGlobal.GetAsSupports());
    if (!global) {
      promiseRv.Throw(NS_ERROR_UNEXPECTED);
      MOZ_ALWAYS_TRUE(promiseRv.MaybeSetPendingException(cx));
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
    rvalDecl = Promise::Resolve(global, cx, valueToResolve,
                                    promiseRv);
    if (promiseRv.MaybeSetPendingException(cx)) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
  }
  return rvalDecl.forget();
}

already_AddRefed<RTCDataChannel>
RTCPeerConnectionJSImpl::CreateDataChannel(const nsACString& label, const RTCDataChannelInit& dataChannelDict, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.createDataChannel", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return nullptr;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(2)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return nullptr;
  }
  unsigned argc = 2;

  do {
    if (!dataChannelDict.ToObjectInternal(cx, argv[1])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
    break;
  } while (false);

  do {
    if (!NonVoidUTF8StringToJsval(cx, label, argv[0])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
    break;
  } while (false);

  JS::Rooted<JS::Value> callable(cx);
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !GetCallableProperty(cx, atomsCache->createDataChannel_id, &callable)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  JS::Rooted<JS::Value> thisValue(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::subarray(argv, 0, argc), &rval)) {
    aRv.NoteJSContextException(cx);
    return nullptr;
  }
  RefPtr<mozilla::dom::RTCDataChannel> rvalDecl;
  if (rval.isObject()) {
    static_assert(IsRefcounted<mozilla::dom::RTCDataChannel>::value, "We can only store refcounted classes.");
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::RTCDataChannel, mozilla::dom::RTCDataChannel>(rval, rvalDecl, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Return value of RTCPeerConnection.createDataChannel", "RTCDataChannel");
        aRv.Throw(NS_ERROR_UNEXPECTED);
        return nullptr;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Return value of RTCPeerConnection.createDataChannel");
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  return rvalDecl.forget();
}

void
RTCPeerConnectionJSImpl::__Init(const RTCConfiguration& configuration, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "__init", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(1)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return;
  }
  unsigned argc = 1;

  do {
    if (!configuration.ToObjectInternal(cx, argv[0])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    break;
  } while (false);

  JS::Rooted<JS::Value> callable(cx);
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !GetCallableProperty(cx, atomsCache->__init_id, &callable)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  JS::Rooted<JS::Value> thisValue(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::subarray(argv, 0, argc), &rval)) {
    aRv.NoteJSContextException(cx);
    return;
  }
}

bool
RTCPeerConnectionJSImpl::InitIds(JSContext* cx, RTCPeerConnectionAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->__init_id.init(cx, "__init") ||
      !atomsCache->ondatachannel_id.init(cx, "ondatachannel") ||
      !atomsCache->createDataChannel_id.init(cx, "createDataChannel") ||
      !atomsCache->sctp_id.init(cx, "sctp") ||
      !atomsCache->getStats_id.init(cx, "getStats") ||
      !atomsCache->onconnectionstatechange_id.init(cx, "onconnectionstatechange") ||
      !atomsCache->onicegatheringstatechange_id.init(cx, "onicegatheringstatechange") ||
      !atomsCache->oniceconnectionstatechange_id.init(cx, "oniceconnectionstatechange") ||
      !atomsCache->ontrack_id.init(cx, "ontrack") ||
      !atomsCache->onaddtrack_id.init(cx, "onaddtrack") ||
      !atomsCache->onaddstream_id.init(cx, "onaddstream") ||
      !atomsCache->onsignalingstatechange_id.init(cx, "onsignalingstatechange") ||
      !atomsCache->onicecandidate_id.init(cx, "onicecandidate") ||
      !atomsCache->onnegotiationneeded_id.init(cx, "onnegotiationneeded") ||
      !atomsCache->close_id.init(cx, "close") ||
      !atomsCache->mozDisablePacketDump_id.init(cx, "mozDisablePacketDump") ||
      !atomsCache->mozEnablePacketDump_id.init(cx, "mozEnablePacketDump") ||
      !atomsCache->mozSetPacketCallback_id.init(cx, "mozSetPacketCallback") ||
      !atomsCache->getTransceivers_id.init(cx, "getTransceivers") ||
      !atomsCache->getReceivers_id.init(cx, "getReceivers") ||
      !atomsCache->getSenders_id.init(cx, "getSenders") ||
      !atomsCache->addTransceiver_id.init(cx, "addTransceiver") ||
      !atomsCache->removeTrack_id.init(cx, "removeTrack") ||
      !atomsCache->addTrack_id.init(cx, "addTrack") ||
      !atomsCache->addStream_id.init(cx, "addStream") ||
      !atomsCache->getRemoteStreams_id.init(cx, "getRemoteStreams") ||
      !atomsCache->getLocalStreams_id.init(cx, "getLocalStreams") ||
      !atomsCache->setConfiguration_id.init(cx, "setConfiguration") ||
      !atomsCache->getConfiguration_id.init(cx, "getConfiguration") ||
      !atomsCache->id_id.init(cx, "id") ||
      !atomsCache->idpLoginUrl_id.init(cx, "idpLoginUrl") ||
      !atomsCache->peerIdentity_id.init(cx, "peerIdentity") ||
      !atomsCache->restartIce_id.init(cx, "restartIce") ||
      !atomsCache->connectionState_id.init(cx, "connectionState") ||
      !atomsCache->iceConnectionState_id.init(cx, "iceConnectionState") ||
      !atomsCache->iceGatheringState_id.init(cx, "iceGatheringState") ||
      !atomsCache->canTrickleIceCandidates_id.init(cx, "canTrickleIceCandidates") ||
      !atomsCache->addIceCandidate_id.init(cx, "addIceCandidate") ||
      !atomsCache->signalingState_id.init(cx, "signalingState") ||
      !atomsCache->pendingRemoteDescription_id.init(cx, "pendingRemoteDescription") ||
      !atomsCache->currentRemoteDescription_id.init(cx, "currentRemoteDescription") ||
      !atomsCache->remoteDescription_id.init(cx, "remoteDescription") ||
      !atomsCache->setRemoteDescription_id.init(cx, "setRemoteDescription") ||
      !atomsCache->pendingLocalDescription_id.init(cx, "pendingLocalDescription") ||
      !atomsCache->currentLocalDescription_id.init(cx, "currentLocalDescription") ||
      !atomsCache->localDescription_id.init(cx, "localDescription") ||
      !atomsCache->setLocalDescription_id.init(cx, "setLocalDescription") ||
      !atomsCache->createAnswer_id.init(cx, "createAnswer") ||
      !atomsCache->createOffer_id.init(cx, "createOffer") ||
      !atomsCache->getIdentityAssertion_id.init(cx, "getIdentityAssertion") ||
      !atomsCache->setIdentityProvider_id.init(cx, "setIdentityProvider") ||
      !atomsCache->generateCertificate_id.init(cx, "generateCertificate")) {
    return false;
  }
  return true;
}


already_AddRefed<RTCSessionDescription>
RTCPeerConnectionJSImpl::GetLocalDescription(ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.localDescription", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return nullptr;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);

  JS::Rooted<JSObject *> callback(cx, mCallback);
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid()
       && !InitIds(cx, atomsCache)) ||
      !JS_GetPropertyById(cx, callback, atomsCache->localDescription_id, &rval)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  RefPtr<mozilla::dom::RTCSessionDescription> rvalDecl;
  if (rval.isObject()) {
    static_assert(IsRefcounted<mozilla::dom::RTCSessionDescription>::value, "We can only store refcounted classes.");
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::RTCSessionDescription, mozilla::dom::RTCSessionDescription>(rval, rvalDecl, cx);
      if (NS_FAILED(rv)) {
        // Be careful to not wrap random DOM objects here, even if
        // they're wrapped in opaque security wrappers for some reason.
        // XXXbz Wish we could check for a JS-implemented object
        // that already has a content reflection...
        if (!IsDOMObject(js::UncheckedUnwrap(&rval.toObject()))) {
          nsCOMPtr<nsIGlobalObject> contentGlobal;
          JS::Rooted<JSObject*> callback(cx, CallbackOrNull());
          if (!callback ||
              !GetContentGlobalForJSImplementedObject(cx, callback, getter_AddRefs(contentGlobal))) {
            aRv.Throw(NS_ERROR_UNEXPECTED);
            return nullptr;
          }
          JS::Rooted<JSObject*> jsImplSourceObj(cx, &rval.toObject());
          MOZ_RELEASE_ASSERT(!js::IsWrapper(jsImplSourceObj),
                             "Don't return JS implementations from other compartments");
          JS::Rooted<JSObject*> jsImplSourceGlobal(cx, JS::GetNonCCWObjectGlobal(jsImplSourceObj));
          rvalDecl = new mozilla::dom::RTCSessionDescription(jsImplSourceObj, jsImplSourceGlobal, contentGlobal);
        } else {
          cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Return value of RTCPeerConnection.localDescription", "RTCSessionDescription");
          aRv.Throw(NS_ERROR_UNEXPECTED);
          return nullptr;
        }
      }
    }
  } else if (rval.isNullOrUndefined()) {
    rvalDecl = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Return value of RTCPeerConnection.localDescription");
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  return rvalDecl.forget();
}

already_AddRefed<RTCSessionDescription>
RTCPeerConnectionJSImpl::GetCurrentLocalDescription(ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.currentLocalDescription", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return nullptr;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);

  JS::Rooted<JSObject *> callback(cx, mCallback);
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid()
       && !InitIds(cx, atomsCache)) ||
      !JS_GetPropertyById(cx, callback, atomsCache->currentLocalDescription_id, &rval)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  RefPtr<mozilla::dom::RTCSessionDescription> rvalDecl;
  if (rval.isObject()) {
    static_assert(IsRefcounted<mozilla::dom::RTCSessionDescription>::value, "We can only store refcounted classes.");
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::RTCSessionDescription, mozilla::dom::RTCSessionDescription>(rval, rvalDecl, cx);
      if (NS_FAILED(rv)) {
        // Be careful to not wrap random DOM objects here, even if
        // they're wrapped in opaque security wrappers for some reason.
        // XXXbz Wish we could check for a JS-implemented object
        // that already has a content reflection...
        if (!IsDOMObject(js::UncheckedUnwrap(&rval.toObject()))) {
          nsCOMPtr<nsIGlobalObject> contentGlobal;
          JS::Rooted<JSObject*> callback(cx, CallbackOrNull());
          if (!callback ||
              !GetContentGlobalForJSImplementedObject(cx, callback, getter_AddRefs(contentGlobal))) {
            aRv.Throw(NS_ERROR_UNEXPECTED);
            return nullptr;
          }
          JS::Rooted<JSObject*> jsImplSourceObj(cx, &rval.toObject());
          MOZ_RELEASE_ASSERT(!js::IsWrapper(jsImplSourceObj),
                             "Don't return JS implementations from other compartments");
          JS::Rooted<JSObject*> jsImplSourceGlobal(cx, JS::GetNonCCWObjectGlobal(jsImplSourceObj));
          rvalDecl = new mozilla::dom::RTCSessionDescription(jsImplSourceObj, jsImplSourceGlobal, contentGlobal);
        } else {
          cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Return value of RTCPeerConnection.currentLocalDescription", "RTCSessionDescription");
          aRv.Throw(NS_ERROR_UNEXPECTED);
          return nullptr;
        }
      }
    }
  } else if (rval.isNullOrUndefined()) {
    rvalDecl = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Return value of RTCPeerConnection.currentLocalDescription");
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  return rvalDecl.forget();
}

already_AddRefed<RTCSessionDescription>
RTCPeerConnectionJSImpl::GetPendingLocalDescription(ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.pendingLocalDescription", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return nullptr;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);

  JS::Rooted<JSObject *> callback(cx, mCallback);
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid()
       && !InitIds(cx, atomsCache)) ||
      !JS_GetPropertyById(cx, callback, atomsCache->pendingLocalDescription_id, &rval)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  RefPtr<mozilla::dom::RTCSessionDescription> rvalDecl;
  if (rval.isObject()) {
    static_assert(IsRefcounted<mozilla::dom::RTCSessionDescription>::value, "We can only store refcounted classes.");
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::RTCSessionDescription, mozilla::dom::RTCSessionDescription>(rval, rvalDecl, cx);
      if (NS_FAILED(rv)) {
        // Be careful to not wrap random DOM objects here, even if
        // they're wrapped in opaque security wrappers for some reason.
        // XXXbz Wish we could check for a JS-implemented object
        // that already has a content reflection...
        if (!IsDOMObject(js::UncheckedUnwrap(&rval.toObject()))) {
          nsCOMPtr<nsIGlobalObject> contentGlobal;
          JS::Rooted<JSObject*> callback(cx, CallbackOrNull());
          if (!callback ||
              !GetContentGlobalForJSImplementedObject(cx, callback, getter_AddRefs(contentGlobal))) {
            aRv.Throw(NS_ERROR_UNEXPECTED);
            return nullptr;
          }
          JS::Rooted<JSObject*> jsImplSourceObj(cx, &rval.toObject());
          MOZ_RELEASE_ASSERT(!js::IsWrapper(jsImplSourceObj),
                             "Don't return JS implementations from other compartments");
          JS::Rooted<JSObject*> jsImplSourceGlobal(cx, JS::GetNonCCWObjectGlobal(jsImplSourceObj));
          rvalDecl = new mozilla::dom::RTCSessionDescription(jsImplSourceObj, jsImplSourceGlobal, contentGlobal);
        } else {
          cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Return value of RTCPeerConnection.pendingLocalDescription", "RTCSessionDescription");
          aRv.Throw(NS_ERROR_UNEXPECTED);
          return nullptr;
        }
      }
    }
  } else if (rval.isNullOrUndefined()) {
    rvalDecl = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Return value of RTCPeerConnection.pendingLocalDescription");
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  return rvalDecl.forget();
}

already_AddRefed<RTCSessionDescription>
RTCPeerConnectionJSImpl::GetRemoteDescription(ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.remoteDescription", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return nullptr;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);

  JS::Rooted<JSObject *> callback(cx, mCallback);
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid()
       && !InitIds(cx, atomsCache)) ||
      !JS_GetPropertyById(cx, callback, atomsCache->remoteDescription_id, &rval)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  RefPtr<mozilla::dom::RTCSessionDescription> rvalDecl;
  if (rval.isObject()) {
    static_assert(IsRefcounted<mozilla::dom::RTCSessionDescription>::value, "We can only store refcounted classes.");
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::RTCSessionDescription, mozilla::dom::RTCSessionDescription>(rval, rvalDecl, cx);
      if (NS_FAILED(rv)) {
        // Be careful to not wrap random DOM objects here, even if
        // they're wrapped in opaque security wrappers for some reason.
        // XXXbz Wish we could check for a JS-implemented object
        // that already has a content reflection...
        if (!IsDOMObject(js::UncheckedUnwrap(&rval.toObject()))) {
          nsCOMPtr<nsIGlobalObject> contentGlobal;
          JS::Rooted<JSObject*> callback(cx, CallbackOrNull());
          if (!callback ||
              !GetContentGlobalForJSImplementedObject(cx, callback, getter_AddRefs(contentGlobal))) {
            aRv.Throw(NS_ERROR_UNEXPECTED);
            return nullptr;
          }
          JS::Rooted<JSObject*> jsImplSourceObj(cx, &rval.toObject());
          MOZ_RELEASE_ASSERT(!js::IsWrapper(jsImplSourceObj),
                             "Don't return JS implementations from other compartments");
          JS::Rooted<JSObject*> jsImplSourceGlobal(cx, JS::GetNonCCWObjectGlobal(jsImplSourceObj));
          rvalDecl = new mozilla::dom::RTCSessionDescription(jsImplSourceObj, jsImplSourceGlobal, contentGlobal);
        } else {
          cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Return value of RTCPeerConnection.remoteDescription", "RTCSessionDescription");
          aRv.Throw(NS_ERROR_UNEXPECTED);
          return nullptr;
        }
      }
    }
  } else if (rval.isNullOrUndefined()) {
    rvalDecl = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Return value of RTCPeerConnection.remoteDescription");
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  return rvalDecl.forget();
}

already_AddRefed<RTCSessionDescription>
RTCPeerConnectionJSImpl::GetCurrentRemoteDescription(ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.currentRemoteDescription", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return nullptr;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);

  JS::Rooted<JSObject *> callback(cx, mCallback);
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid()
       && !InitIds(cx, atomsCache)) ||
      !JS_GetPropertyById(cx, callback, atomsCache->currentRemoteDescription_id, &rval)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  RefPtr<mozilla::dom::RTCSessionDescription> rvalDecl;
  if (rval.isObject()) {
    static_assert(IsRefcounted<mozilla::dom::RTCSessionDescription>::value, "We can only store refcounted classes.");
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::RTCSessionDescription, mozilla::dom::RTCSessionDescription>(rval, rvalDecl, cx);
      if (NS_FAILED(rv)) {
        // Be careful to not wrap random DOM objects here, even if
        // they're wrapped in opaque security wrappers for some reason.
        // XXXbz Wish we could check for a JS-implemented object
        // that already has a content reflection...
        if (!IsDOMObject(js::UncheckedUnwrap(&rval.toObject()))) {
          nsCOMPtr<nsIGlobalObject> contentGlobal;
          JS::Rooted<JSObject*> callback(cx, CallbackOrNull());
          if (!callback ||
              !GetContentGlobalForJSImplementedObject(cx, callback, getter_AddRefs(contentGlobal))) {
            aRv.Throw(NS_ERROR_UNEXPECTED);
            return nullptr;
          }
          JS::Rooted<JSObject*> jsImplSourceObj(cx, &rval.toObject());
          MOZ_RELEASE_ASSERT(!js::IsWrapper(jsImplSourceObj),
                             "Don't return JS implementations from other compartments");
          JS::Rooted<JSObject*> jsImplSourceGlobal(cx, JS::GetNonCCWObjectGlobal(jsImplSourceObj));
          rvalDecl = new mozilla::dom::RTCSessionDescription(jsImplSourceObj, jsImplSourceGlobal, contentGlobal);
        } else {
          cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Return value of RTCPeerConnection.currentRemoteDescription", "RTCSessionDescription");
          aRv.Throw(NS_ERROR_UNEXPECTED);
          return nullptr;
        }
      }
    }
  } else if (rval.isNullOrUndefined()) {
    rvalDecl = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Return value of RTCPeerConnection.currentRemoteDescription");
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  return rvalDecl.forget();
}

already_AddRefed<RTCSessionDescription>
RTCPeerConnectionJSImpl::GetPendingRemoteDescription(ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.pendingRemoteDescription", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return nullptr;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);

  JS::Rooted<JSObject *> callback(cx, mCallback);
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid()
       && !InitIds(cx, atomsCache)) ||
      !JS_GetPropertyById(cx, callback, atomsCache->pendingRemoteDescription_id, &rval)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  RefPtr<mozilla::dom::RTCSessionDescription> rvalDecl;
  if (rval.isObject()) {
    static_assert(IsRefcounted<mozilla::dom::RTCSessionDescription>::value, "We can only store refcounted classes.");
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::RTCSessionDescription, mozilla::dom::RTCSessionDescription>(rval, rvalDecl, cx);
      if (NS_FAILED(rv)) {
        // Be careful to not wrap random DOM objects here, even if
        // they're wrapped in opaque security wrappers for some reason.
        // XXXbz Wish we could check for a JS-implemented object
        // that already has a content reflection...
        if (!IsDOMObject(js::UncheckedUnwrap(&rval.toObject()))) {
          nsCOMPtr<nsIGlobalObject> contentGlobal;
          JS::Rooted<JSObject*> callback(cx, CallbackOrNull());
          if (!callback ||
              !GetContentGlobalForJSImplementedObject(cx, callback, getter_AddRefs(contentGlobal))) {
            aRv.Throw(NS_ERROR_UNEXPECTED);
            return nullptr;
          }
          JS::Rooted<JSObject*> jsImplSourceObj(cx, &rval.toObject());
          MOZ_RELEASE_ASSERT(!js::IsWrapper(jsImplSourceObj),
                             "Don't return JS implementations from other compartments");
          JS::Rooted<JSObject*> jsImplSourceGlobal(cx, JS::GetNonCCWObjectGlobal(jsImplSourceObj));
          rvalDecl = new mozilla::dom::RTCSessionDescription(jsImplSourceObj, jsImplSourceGlobal, contentGlobal);
        } else {
          cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Return value of RTCPeerConnection.pendingRemoteDescription", "RTCSessionDescription");
          aRv.Throw(NS_ERROR_UNEXPECTED);
          return nullptr;
        }
      }
    }
  } else if (rval.isNullOrUndefined()) {
    rvalDecl = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Return value of RTCPeerConnection.pendingRemoteDescription");
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  return rvalDecl.forget();
}

RTCSignalingState
RTCPeerConnectionJSImpl::GetSignalingState(ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.signalingState", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return RTCSignalingState(0);
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);

  JS::Rooted<JSObject *> callback(cx, mCallback);
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid()
       && !InitIds(cx, atomsCache)) ||
      !JS_GetPropertyById(cx, callback, atomsCache->signalingState_id, &rval)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return RTCSignalingState(0);
  }
  RTCSignalingState rvalDecl;
  {
    int index;
    if (!binding_detail::FindEnumStringIndex<true>(cx, rval,
                                                                       binding_detail::EnumStrings<RTCSignalingState>::Values,
                                                                       "RTCSignalingState", "return value of RTCPeerConnection.signalingState",
                                                                       &index)) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return RTCSignalingState(0);
    }
    MOZ_ASSERT(index >= 0);
    rvalDecl = static_cast<RTCSignalingState>(index);
  }
  return rvalDecl;
}

Nullable<bool>
RTCPeerConnectionJSImpl::GetCanTrickleIceCandidates(ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.canTrickleIceCandidates", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return Nullable<bool>();
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);

  JS::Rooted<JSObject *> callback(cx, mCallback);
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid()
       && !InitIds(cx, atomsCache)) ||
      !JS_GetPropertyById(cx, callback, atomsCache->canTrickleIceCandidates_id, &rval)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return Nullable<bool>();
  }
  Nullable<bool> rvalDecl;
  if (rval.isNullOrUndefined()) {
    rvalDecl.SetNull();
  } else if (!ValueToPrimitive<bool, eDefault>(cx, rval, "Return value of RTCPeerConnection.canTrickleIceCandidates", &rvalDecl.SetValue())) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return Nullable<bool>();
  }
  return rvalDecl;
}

RTCIceGatheringState
RTCPeerConnectionJSImpl::GetIceGatheringState(ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.iceGatheringState", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return RTCIceGatheringState(0);
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);

  JS::Rooted<JSObject *> callback(cx, mCallback);
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid()
       && !InitIds(cx, atomsCache)) ||
      !JS_GetPropertyById(cx, callback, atomsCache->iceGatheringState_id, &rval)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return RTCIceGatheringState(0);
  }
  RTCIceGatheringState rvalDecl;
  {
    int index;
    if (!binding_detail::FindEnumStringIndex<true>(cx, rval,
                                                                       binding_detail::EnumStrings<RTCIceGatheringState>::Values,
                                                                       "RTCIceGatheringState", "return value of RTCPeerConnection.iceGatheringState",
                                                                       &index)) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return RTCIceGatheringState(0);
    }
    MOZ_ASSERT(index >= 0);
    rvalDecl = static_cast<RTCIceGatheringState>(index);
  }
  return rvalDecl;
}

RTCIceConnectionState
RTCPeerConnectionJSImpl::GetIceConnectionState(ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.iceConnectionState", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return RTCIceConnectionState(0);
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);

  JS::Rooted<JSObject *> callback(cx, mCallback);
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid()
       && !InitIds(cx, atomsCache)) ||
      !JS_GetPropertyById(cx, callback, atomsCache->iceConnectionState_id, &rval)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return RTCIceConnectionState(0);
  }
  RTCIceConnectionState rvalDecl;
  {
    int index;
    if (!binding_detail::FindEnumStringIndex<true>(cx, rval,
                                                                       binding_detail::EnumStrings<RTCIceConnectionState>::Values,
                                                                       "RTCIceConnectionState", "return value of RTCPeerConnection.iceConnectionState",
                                                                       &index)) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return RTCIceConnectionState(0);
    }
    MOZ_ASSERT(index >= 0);
    rvalDecl = static_cast<RTCIceConnectionState>(index);
  }
  return rvalDecl;
}

RTCPeerConnectionState
RTCPeerConnectionJSImpl::GetConnectionState(ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.connectionState", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return RTCPeerConnectionState(0);
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);

  JS::Rooted<JSObject *> callback(cx, mCallback);
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid()
       && !InitIds(cx, atomsCache)) ||
      !JS_GetPropertyById(cx, callback, atomsCache->connectionState_id, &rval)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return RTCPeerConnectionState(0);
  }
  RTCPeerConnectionState rvalDecl;
  {
    int index;
    if (!binding_detail::FindEnumStringIndex<true>(cx, rval,
                                                                       binding_detail::EnumStrings<RTCPeerConnectionState>::Values,
                                                                       "RTCPeerConnectionState", "return value of RTCPeerConnection.connectionState",
                                                                       &index)) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return RTCPeerConnectionState(0);
    }
    MOZ_ASSERT(index >= 0);
    rvalDecl = static_cast<RTCPeerConnectionState>(index);
  }
  return rvalDecl;
}

already_AddRefed<Promise>
RTCPeerConnectionJSImpl::GetPeerIdentity(ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.peerIdentity", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return nullptr;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);

  JS::Rooted<JSObject *> callback(cx, mCallback);
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid()
       && !InitIds(cx, atomsCache)) ||
      !JS_GetPropertyById(cx, callback, atomsCache->peerIdentity_id, &rval)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  RefPtr<Promise> rvalDecl;
  { // Scope for our GlobalObject, FastErrorResult, JSAutoRealm,
    // etc.

    JS::Rooted<JSObject*> globalObj(cx);
    if (!rval.isObject()) {
      aRv.ThrowTypeError<MSG_NOT_OBJECT>("return value of RTCPeerConnection.peerIdentity");
      return nullptr;
    }
    JSObject* unwrappedVal = js::CheckedUnwrapStatic(&rval.toObject());
    if (!unwrappedVal) {
      // A slight lie, but not much of one, for a dead object wrapper.
      aRv.ThrowTypeError<MSG_NOT_OBJECT>("return value of RTCPeerConnection.peerIdentity");
      return nullptr;
    }
    globalObj = JS::GetNonCCWObjectGlobal(unwrappedVal);
    JSAutoRealm ar(cx, globalObj);
    GlobalObject promiseGlobal(cx, globalObj);
    if (promiseGlobal.Failed()) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }

    JS::Rooted<JS::Value> valueToResolve(cx, rval);
    if (!JS_WrapValue(cx, &valueToResolve)) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
    binding_detail::FastErrorResult promiseRv;
    nsCOMPtr<nsIGlobalObject> global =
      do_QueryInterface(promiseGlobal.GetAsSupports());
    if (!global) {
      promiseRv.Throw(NS_ERROR_UNEXPECTED);
      MOZ_ALWAYS_TRUE(promiseRv.MaybeSetPendingException(cx));
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
    rvalDecl = Promise::Resolve(global, cx, valueToResolve,
                                    promiseRv);
    if (promiseRv.MaybeSetPendingException(cx)) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
  }
  return rvalDecl.forget();
}

void
RTCPeerConnectionJSImpl::GetIdpLoginUrl(nsString& aRetVal, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.idpLoginUrl", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);

  JS::Rooted<JSObject *> callback(cx, mCallback);
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid()
       && !InitIds(cx, atomsCache)) ||
      !JS_GetPropertyById(cx, callback, atomsCache->idpLoginUrl_id, &rval)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  binding_detail::FakeString<char16_t> rvalDecl;
  if (!ConvertJSValueToString(cx, rval, eNull, eNull, rvalDecl)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  aRetVal = rvalDecl;
}

void
RTCPeerConnectionJSImpl::GetId(nsString& aRetVal, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.id", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);

  JS::Rooted<JSObject *> callback(cx, mCallback);
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid()
       && !InitIds(cx, atomsCache)) ||
      !JS_GetPropertyById(cx, callback, atomsCache->id_id, &rval)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  binding_detail::FakeString<char16_t> rvalDecl;
  if (!ConvertJSValueToString(cx, rval, eStringify, eStringify, rvalDecl)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  aRetVal = rvalDecl;
}

already_AddRefed<EventHandlerNonNull>
RTCPeerConnectionJSImpl::GetOnnegotiationneeded(ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.onnegotiationneeded", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return nullptr;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);

  JS::Rooted<JSObject *> callback(cx, mCallback);
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid()
       && !InitIds(cx, atomsCache)) ||
      !JS_GetPropertyById(cx, callback, atomsCache->onnegotiationneeded_id, &rval)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  RefPtr<EventHandlerNonNull> rvalDecl;
  if (rval.isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      JS::Rooted<JSObject*> tempRoot(cx, &rval.toObject());
      JS::Rooted<JSObject*> tempGlobalRoot(cx, JS::CurrentGlobalOrNull(cx));
      rvalDecl = new EventHandlerNonNull(cx, tempRoot, tempGlobalRoot, GetIncumbentGlobal());
    }
  } else {
    rvalDecl = nullptr;
  }
  return rvalDecl.forget();
}

already_AddRefed<EventHandlerNonNull>
RTCPeerConnectionJSImpl::GetOnicecandidate(ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.onicecandidate", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return nullptr;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);

  JS::Rooted<JSObject *> callback(cx, mCallback);
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid()
       && !InitIds(cx, atomsCache)) ||
      !JS_GetPropertyById(cx, callback, atomsCache->onicecandidate_id, &rval)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  RefPtr<EventHandlerNonNull> rvalDecl;
  if (rval.isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      JS::Rooted<JSObject*> tempRoot(cx, &rval.toObject());
      JS::Rooted<JSObject*> tempGlobalRoot(cx, JS::CurrentGlobalOrNull(cx));
      rvalDecl = new EventHandlerNonNull(cx, tempRoot, tempGlobalRoot, GetIncumbentGlobal());
    }
  } else {
    rvalDecl = nullptr;
  }
  return rvalDecl.forget();
}

already_AddRefed<EventHandlerNonNull>
RTCPeerConnectionJSImpl::GetOnsignalingstatechange(ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.onsignalingstatechange", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return nullptr;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);

  JS::Rooted<JSObject *> callback(cx, mCallback);
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid()
       && !InitIds(cx, atomsCache)) ||
      !JS_GetPropertyById(cx, callback, atomsCache->onsignalingstatechange_id, &rval)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  RefPtr<EventHandlerNonNull> rvalDecl;
  if (rval.isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      JS::Rooted<JSObject*> tempRoot(cx, &rval.toObject());
      JS::Rooted<JSObject*> tempGlobalRoot(cx, JS::CurrentGlobalOrNull(cx));
      rvalDecl = new EventHandlerNonNull(cx, tempRoot, tempGlobalRoot, GetIncumbentGlobal());
    }
  } else {
    rvalDecl = nullptr;
  }
  return rvalDecl.forget();
}

already_AddRefed<EventHandlerNonNull>
RTCPeerConnectionJSImpl::GetOnaddstream(ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.onaddstream", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return nullptr;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);

  JS::Rooted<JSObject *> callback(cx, mCallback);
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid()
       && !InitIds(cx, atomsCache)) ||
      !JS_GetPropertyById(cx, callback, atomsCache->onaddstream_id, &rval)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  RefPtr<EventHandlerNonNull> rvalDecl;
  if (rval.isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      JS::Rooted<JSObject*> tempRoot(cx, &rval.toObject());
      JS::Rooted<JSObject*> tempGlobalRoot(cx, JS::CurrentGlobalOrNull(cx));
      rvalDecl = new EventHandlerNonNull(cx, tempRoot, tempGlobalRoot, GetIncumbentGlobal());
    }
  } else {
    rvalDecl = nullptr;
  }
  return rvalDecl.forget();
}

already_AddRefed<EventHandlerNonNull>
RTCPeerConnectionJSImpl::GetOnaddtrack(ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.onaddtrack", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return nullptr;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);

  JS::Rooted<JSObject *> callback(cx, mCallback);
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid()
       && !InitIds(cx, atomsCache)) ||
      !JS_GetPropertyById(cx, callback, atomsCache->onaddtrack_id, &rval)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  RefPtr<EventHandlerNonNull> rvalDecl;
  if (rval.isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      JS::Rooted<JSObject*> tempRoot(cx, &rval.toObject());
      JS::Rooted<JSObject*> tempGlobalRoot(cx, JS::CurrentGlobalOrNull(cx));
      rvalDecl = new EventHandlerNonNull(cx, tempRoot, tempGlobalRoot, GetIncumbentGlobal());
    }
  } else {
    rvalDecl = nullptr;
  }
  return rvalDecl.forget();
}

already_AddRefed<EventHandlerNonNull>
RTCPeerConnectionJSImpl::GetOntrack(ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.ontrack", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return nullptr;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);

  JS::Rooted<JSObject *> callback(cx, mCallback);
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid()
       && !InitIds(cx, atomsCache)) ||
      !JS_GetPropertyById(cx, callback, atomsCache->ontrack_id, &rval)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  RefPtr<EventHandlerNonNull> rvalDecl;
  if (rval.isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      JS::Rooted<JSObject*> tempRoot(cx, &rval.toObject());
      JS::Rooted<JSObject*> tempGlobalRoot(cx, JS::CurrentGlobalOrNull(cx));
      rvalDecl = new EventHandlerNonNull(cx, tempRoot, tempGlobalRoot, GetIncumbentGlobal());
    }
  } else {
    rvalDecl = nullptr;
  }
  return rvalDecl.forget();
}

already_AddRefed<EventHandlerNonNull>
RTCPeerConnectionJSImpl::GetOniceconnectionstatechange(ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.oniceconnectionstatechange", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return nullptr;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);

  JS::Rooted<JSObject *> callback(cx, mCallback);
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid()
       && !InitIds(cx, atomsCache)) ||
      !JS_GetPropertyById(cx, callback, atomsCache->oniceconnectionstatechange_id, &rval)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  RefPtr<EventHandlerNonNull> rvalDecl;
  if (rval.isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      JS::Rooted<JSObject*> tempRoot(cx, &rval.toObject());
      JS::Rooted<JSObject*> tempGlobalRoot(cx, JS::CurrentGlobalOrNull(cx));
      rvalDecl = new EventHandlerNonNull(cx, tempRoot, tempGlobalRoot, GetIncumbentGlobal());
    }
  } else {
    rvalDecl = nullptr;
  }
  return rvalDecl.forget();
}

already_AddRefed<EventHandlerNonNull>
RTCPeerConnectionJSImpl::GetOnicegatheringstatechange(ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.onicegatheringstatechange", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return nullptr;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);

  JS::Rooted<JSObject *> callback(cx, mCallback);
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid()
       && !InitIds(cx, atomsCache)) ||
      !JS_GetPropertyById(cx, callback, atomsCache->onicegatheringstatechange_id, &rval)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  RefPtr<EventHandlerNonNull> rvalDecl;
  if (rval.isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      JS::Rooted<JSObject*> tempRoot(cx, &rval.toObject());
      JS::Rooted<JSObject*> tempGlobalRoot(cx, JS::CurrentGlobalOrNull(cx));
      rvalDecl = new EventHandlerNonNull(cx, tempRoot, tempGlobalRoot, GetIncumbentGlobal());
    }
  } else {
    rvalDecl = nullptr;
  }
  return rvalDecl.forget();
}

already_AddRefed<EventHandlerNonNull>
RTCPeerConnectionJSImpl::GetOnconnectionstatechange(ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.onconnectionstatechange", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return nullptr;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);

  JS::Rooted<JSObject *> callback(cx, mCallback);
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid()
       && !InitIds(cx, atomsCache)) ||
      !JS_GetPropertyById(cx, callback, atomsCache->onconnectionstatechange_id, &rval)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  RefPtr<EventHandlerNonNull> rvalDecl;
  if (rval.isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      JS::Rooted<JSObject*> tempRoot(cx, &rval.toObject());
      JS::Rooted<JSObject*> tempGlobalRoot(cx, JS::CurrentGlobalOrNull(cx));
      rvalDecl = new EventHandlerNonNull(cx, tempRoot, tempGlobalRoot, GetIncumbentGlobal());
    }
  } else {
    rvalDecl = nullptr;
  }
  return rvalDecl.forget();
}

already_AddRefed<RTCSctpTransport>
RTCPeerConnectionJSImpl::GetSctp(ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.sctp", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return nullptr;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);

  JS::Rooted<JSObject *> callback(cx, mCallback);
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid()
       && !InitIds(cx, atomsCache)) ||
      !JS_GetPropertyById(cx, callback, atomsCache->sctp_id, &rval)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  RefPtr<mozilla::dom::RTCSctpTransport> rvalDecl;
  if (rval.isObject()) {
    static_assert(IsRefcounted<mozilla::dom::RTCSctpTransport>::value, "We can only store refcounted classes.");
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::RTCSctpTransport, mozilla::dom::RTCSctpTransport>(rval, rvalDecl, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Return value of RTCPeerConnection.sctp", "RTCSctpTransport");
        aRv.Throw(NS_ERROR_UNEXPECTED);
        return nullptr;
      }
    }
  } else if (rval.isNullOrUndefined()) {
    rvalDecl = nullptr;
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Return value of RTCPeerConnection.sctp");
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  return rvalDecl.forget();
}

already_AddRefed<EventHandlerNonNull>
RTCPeerConnectionJSImpl::GetOndatachannel(ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.ondatachannel", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return nullptr;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);

  JS::Rooted<JSObject *> callback(cx, mCallback);
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid()
       && !InitIds(cx, atomsCache)) ||
      !JS_GetPropertyById(cx, callback, atomsCache->ondatachannel_id, &rval)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  RefPtr<EventHandlerNonNull> rvalDecl;
  if (rval.isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      JS::Rooted<JSObject*> tempRoot(cx, &rval.toObject());
      JS::Rooted<JSObject*> tempGlobalRoot(cx, JS::CurrentGlobalOrNull(cx));
      rvalDecl = new EventHandlerNonNull(cx, tempRoot, tempGlobalRoot, GetIncumbentGlobal());
    }
  } else {
    rvalDecl = nullptr;
  }
  return rvalDecl.forget();
}

void
RTCPeerConnectionJSImpl::SetId(const nsAString& arg, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.id", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(1)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return;
  }
  do {
    if (!xpc::NonVoidStringToJsval(cx, arg, argv[0])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    break;
  } while (false);

  MOZ_ASSERT(argv.length() == 1);
  JS::Rooted<JSObject*> callback(cx, CallbackKnownNotGray());
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !JS_SetPropertyById(cx, callback, atomsCache->id_id, argv[0])) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
}

void
RTCPeerConnectionJSImpl::SetOnnegotiationneeded(EventHandlerNonNull* arg, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.onnegotiationneeded", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(1)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return;
  }
  do {
    if (arg) {
      argv[0].setObjectOrNull(GetCallbackFromCallbackObject(cx, arg));
      if (!MaybeWrapObjectOrNullValue(cx, argv[0])) {
        aRv.Throw(NS_ERROR_UNEXPECTED);
        return;
      }
      break;
    } else {
      argv[0].setNull();
      break;
    }
  } while (false);

  MOZ_ASSERT(argv.length() == 1);
  JS::Rooted<JSObject*> callback(cx, CallbackKnownNotGray());
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !JS_SetPropertyById(cx, callback, atomsCache->onnegotiationneeded_id, argv[0])) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
}

void
RTCPeerConnectionJSImpl::SetOnicecandidate(EventHandlerNonNull* arg, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.onicecandidate", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(1)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return;
  }
  do {
    if (arg) {
      argv[0].setObjectOrNull(GetCallbackFromCallbackObject(cx, arg));
      if (!MaybeWrapObjectOrNullValue(cx, argv[0])) {
        aRv.Throw(NS_ERROR_UNEXPECTED);
        return;
      }
      break;
    } else {
      argv[0].setNull();
      break;
    }
  } while (false);

  MOZ_ASSERT(argv.length() == 1);
  JS::Rooted<JSObject*> callback(cx, CallbackKnownNotGray());
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !JS_SetPropertyById(cx, callback, atomsCache->onicecandidate_id, argv[0])) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
}

void
RTCPeerConnectionJSImpl::SetOnsignalingstatechange(EventHandlerNonNull* arg, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.onsignalingstatechange", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(1)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return;
  }
  do {
    if (arg) {
      argv[0].setObjectOrNull(GetCallbackFromCallbackObject(cx, arg));
      if (!MaybeWrapObjectOrNullValue(cx, argv[0])) {
        aRv.Throw(NS_ERROR_UNEXPECTED);
        return;
      }
      break;
    } else {
      argv[0].setNull();
      break;
    }
  } while (false);

  MOZ_ASSERT(argv.length() == 1);
  JS::Rooted<JSObject*> callback(cx, CallbackKnownNotGray());
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !JS_SetPropertyById(cx, callback, atomsCache->onsignalingstatechange_id, argv[0])) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
}

void
RTCPeerConnectionJSImpl::SetOnaddstream(EventHandlerNonNull* arg, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.onaddstream", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(1)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return;
  }
  do {
    if (arg) {
      argv[0].setObjectOrNull(GetCallbackFromCallbackObject(cx, arg));
      if (!MaybeWrapObjectOrNullValue(cx, argv[0])) {
        aRv.Throw(NS_ERROR_UNEXPECTED);
        return;
      }
      break;
    } else {
      argv[0].setNull();
      break;
    }
  } while (false);

  MOZ_ASSERT(argv.length() == 1);
  JS::Rooted<JSObject*> callback(cx, CallbackKnownNotGray());
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !JS_SetPropertyById(cx, callback, atomsCache->onaddstream_id, argv[0])) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
}

void
RTCPeerConnectionJSImpl::SetOnaddtrack(EventHandlerNonNull* arg, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.onaddtrack", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(1)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return;
  }
  do {
    if (arg) {
      argv[0].setObjectOrNull(GetCallbackFromCallbackObject(cx, arg));
      if (!MaybeWrapObjectOrNullValue(cx, argv[0])) {
        aRv.Throw(NS_ERROR_UNEXPECTED);
        return;
      }
      break;
    } else {
      argv[0].setNull();
      break;
    }
  } while (false);

  MOZ_ASSERT(argv.length() == 1);
  JS::Rooted<JSObject*> callback(cx, CallbackKnownNotGray());
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !JS_SetPropertyById(cx, callback, atomsCache->onaddtrack_id, argv[0])) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
}

void
RTCPeerConnectionJSImpl::SetOntrack(EventHandlerNonNull* arg, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.ontrack", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(1)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return;
  }
  do {
    if (arg) {
      argv[0].setObjectOrNull(GetCallbackFromCallbackObject(cx, arg));
      if (!MaybeWrapObjectOrNullValue(cx, argv[0])) {
        aRv.Throw(NS_ERROR_UNEXPECTED);
        return;
      }
      break;
    } else {
      argv[0].setNull();
      break;
    }
  } while (false);

  MOZ_ASSERT(argv.length() == 1);
  JS::Rooted<JSObject*> callback(cx, CallbackKnownNotGray());
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !JS_SetPropertyById(cx, callback, atomsCache->ontrack_id, argv[0])) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
}

void
RTCPeerConnectionJSImpl::SetOniceconnectionstatechange(EventHandlerNonNull* arg, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.oniceconnectionstatechange", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(1)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return;
  }
  do {
    if (arg) {
      argv[0].setObjectOrNull(GetCallbackFromCallbackObject(cx, arg));
      if (!MaybeWrapObjectOrNullValue(cx, argv[0])) {
        aRv.Throw(NS_ERROR_UNEXPECTED);
        return;
      }
      break;
    } else {
      argv[0].setNull();
      break;
    }
  } while (false);

  MOZ_ASSERT(argv.length() == 1);
  JS::Rooted<JSObject*> callback(cx, CallbackKnownNotGray());
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !JS_SetPropertyById(cx, callback, atomsCache->oniceconnectionstatechange_id, argv[0])) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
}

void
RTCPeerConnectionJSImpl::SetOnicegatheringstatechange(EventHandlerNonNull* arg, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.onicegatheringstatechange", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(1)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return;
  }
  do {
    if (arg) {
      argv[0].setObjectOrNull(GetCallbackFromCallbackObject(cx, arg));
      if (!MaybeWrapObjectOrNullValue(cx, argv[0])) {
        aRv.Throw(NS_ERROR_UNEXPECTED);
        return;
      }
      break;
    } else {
      argv[0].setNull();
      break;
    }
  } while (false);

  MOZ_ASSERT(argv.length() == 1);
  JS::Rooted<JSObject*> callback(cx, CallbackKnownNotGray());
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !JS_SetPropertyById(cx, callback, atomsCache->onicegatheringstatechange_id, argv[0])) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
}

void
RTCPeerConnectionJSImpl::SetOnconnectionstatechange(EventHandlerNonNull* arg, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.onconnectionstatechange", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(1)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return;
  }
  do {
    if (arg) {
      argv[0].setObjectOrNull(GetCallbackFromCallbackObject(cx, arg));
      if (!MaybeWrapObjectOrNullValue(cx, argv[0])) {
        aRv.Throw(NS_ERROR_UNEXPECTED);
        return;
      }
      break;
    } else {
      argv[0].setNull();
      break;
    }
  } while (false);

  MOZ_ASSERT(argv.length() == 1);
  JS::Rooted<JSObject*> callback(cx, CallbackKnownNotGray());
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !JS_SetPropertyById(cx, callback, atomsCache->onconnectionstatechange_id, argv[0])) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
}

void
RTCPeerConnectionJSImpl::SetOndatachannel(EventHandlerNonNull* arg, ErrorResult& aRv, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "RTCPeerConnection.ondatachannel", eRethrowContentExceptions, aRealm, /* aIsJSImplementedWebIDL = */ true);
  if (aRv.Failed()) {
    return;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(1)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return;
  }
  do {
    if (arg) {
      argv[0].setObjectOrNull(GetCallbackFromCallbackObject(cx, arg));
      if (!MaybeWrapObjectOrNullValue(cx, argv[0])) {
        aRv.Throw(NS_ERROR_UNEXPECTED);
        return;
      }
      break;
    } else {
      argv[0].setNull();
      break;
    }
  } while (false);

  MOZ_ASSERT(argv.length() == 1);
  JS::Rooted<JSObject*> callback(cx, CallbackKnownNotGray());
  RTCPeerConnectionAtoms* atomsCache = GetAtomCache<RTCPeerConnectionAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !JS_SetPropertyById(cx, callback, atomsCache->ondatachannel_id, argv[0])) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
}


NS_IMPL_CYCLE_COLLECTION_INHERITED(RTCPeerConnection, mozilla::DOMEventTargetHelper, mImpl, mParent)
NS_IMPL_ADDREF_INHERITED(RTCPeerConnection, mozilla::DOMEventTargetHelper)
NS_IMPL_RELEASE_INHERITED(RTCPeerConnection, mozilla::DOMEventTargetHelper)
NS_INTERFACE_MAP_BEGIN_CYCLE_COLLECTION(RTCPeerConnection)
NS_INTERFACE_MAP_END_INHERITING(mozilla::DOMEventTargetHelper)

RTCPeerConnection::RTCPeerConnection(JS::Handle<JSObject*> aJSImplObject, JS::Handle<JSObject*> aJSImplGlobal, nsIGlobalObject* aParent)
  : mozilla::DOMEventTargetHelper(aParent),
    mImpl(new RTCPeerConnectionJSImpl(nullptr, aJSImplObject, aJSImplGlobal, /* aIncumbentGlobal = */ nullptr)),
    mParent(aParent)
{
}


RTCPeerConnection::~RTCPeerConnection()
{
}

nsISupports*
RTCPeerConnection::GetParentObject() const
{
  return mParent;
}

JSObject*
RTCPeerConnection::WrapObject(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  JS::Rooted<JSObject*> obj(aCx, RTCPeerConnection_Binding::Wrap(aCx, this, aGivenProto));
  if (!obj) {
    return nullptr;
  }

  // Now define it on our chrome object
  JSAutoRealm ar(aCx, mImpl->CallbackGlobalOrNull());
  if (!JS_WrapObject(aCx, &obj)) {
    return nullptr;
  }
  JS::Rooted<JSObject*> callback(aCx, mImpl->CallbackOrNull());
  if (!JS_DefineProperty(aCx, callback, "__DOM_IMPL__", obj, 0)) {
    return nullptr;
  }
  return obj;
}

already_AddRefed<RTCPeerConnection>
RTCPeerConnection::Constructor(const GlobalObject& global, JSContext* cx, const RTCConfiguration& configuration, ErrorResult& aRv, JS::Handle<JSObject*> aGivenProto)
{
  RefPtr<RTCPeerConnection> impl =
    ConstructJSImplementation<RTCPeerConnection>("@mozilla.org/dom/peerconnection;1", global, aRv);
  if (aRv.Failed()) {
    return nullptr;
  }
  // Wrap the object before calling __Init so that __DOM_IMPL__ is available.
  JS::Rooted<JSObject*> scopeObj(cx, global.Get());
  MOZ_ASSERT(js::IsObjectInContextCompartment(scopeObj, cx));
  JS::Rooted<JS::Value> wrappedVal(cx);
  if (!GetOrCreateDOMReflector(cx, impl, &wrappedVal, aGivenProto)) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  // Initialize the object with the constructor arguments.
  impl->mImpl->__Init(configuration, aRv, js::GetNonCCWObjectRealm(scopeObj));
  if (aRv.Failed()) {
    return nullptr;
  }
  return impl.forget();
}

void
RTCPeerConnection::SetIdentityProvider(const nsAString& provider, const RTCIdentityProviderOptions& options, ErrorResult& aRv, JS::Realm* aRealm)
{
  return mImpl->SetIdentityProvider(provider, options, aRv, aRealm);
}

// Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
already_AddRefed<Promise>
RTCPeerConnection::GetIdentityAssertion(ErrorResult& aRv, JS::Realm* aRealm)
{
  return mImpl->GetIdentityAssertion(aRv, aRealm);
}

// Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
already_AddRefed<Promise>
RTCPeerConnection::CreateOffer(const RTCOfferOptions& options, ErrorResult& aRv, JS::Realm* aRealm)
{
  return mImpl->CreateOffer(options, aRv, aRealm);
}

// Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
already_AddRefed<Promise>
RTCPeerConnection::CreateOffer(RTCSessionDescriptionCallback& successCallback, RTCPeerConnectionErrorCallback& failureCallback, const RTCOfferOptions& options, ErrorResult& aRv, JS::Realm* aRealm)
{
  return mImpl->CreateOffer(successCallback, failureCallback, options, aRv, aRealm);
}

// Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
already_AddRefed<Promise>
RTCPeerConnection::CreateAnswer(const RTCAnswerOptions& options, ErrorResult& aRv, JS::Realm* aRealm)
{
  return mImpl->CreateAnswer(options, aRv, aRealm);
}

// Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
already_AddRefed<Promise>
RTCPeerConnection::CreateAnswer(RTCSessionDescriptionCallback& successCallback, RTCPeerConnectionErrorCallback& failureCallback, ErrorResult& aRv, JS::Realm* aRealm)
{
  return mImpl->CreateAnswer(successCallback, failureCallback, aRv, aRealm);
}

// Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
already_AddRefed<Promise>
RTCPeerConnection::SetLocalDescription(const RTCLocalSessionDescriptionInit& description, ErrorResult& aRv, JS::Realm* aRealm)
{
  return mImpl->SetLocalDescription(description, aRv, aRealm);
}

// Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
already_AddRefed<Promise>
RTCPeerConnection::SetLocalDescription(const RTCLocalSessionDescriptionInit& description, VoidFunction& successCallback, RTCPeerConnectionErrorCallback& failureCallback, ErrorResult& aRv, JS::Realm* aRealm)
{
  return mImpl->SetLocalDescription(description, successCallback, failureCallback, aRv, aRealm);
}

// Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
already_AddRefed<RTCSessionDescription>
RTCPeerConnection::GetLocalDescription(ErrorResult& aRv, JS::Realm* aRealm) const
{
  return mImpl->GetLocalDescription(aRv, aRealm);
}

// Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
already_AddRefed<RTCSessionDescription>
RTCPeerConnection::GetCurrentLocalDescription(ErrorResult& aRv, JS::Realm* aRealm) const
{
  return mImpl->GetCurrentLocalDescription(aRv, aRealm);
}

// Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
already_AddRefed<RTCSessionDescription>
RTCPeerConnection::GetPendingLocalDescription(ErrorResult& aRv, JS::Realm* aRealm) const
{
  return mImpl->GetPendingLocalDescription(aRv, aRealm);
}

// Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
already_AddRefed<Promise>
RTCPeerConnection::SetRemoteDescription(const RTCSessionDescriptionInit& description, ErrorResult& aRv, JS::Realm* aRealm)
{
  return mImpl->SetRemoteDescription(description, aRv, aRealm);
}

// Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
already_AddRefed<Promise>
RTCPeerConnection::SetRemoteDescription(const RTCSessionDescriptionInit& description, VoidFunction& successCallback, RTCPeerConnectionErrorCallback& failureCallback, ErrorResult& aRv, JS::Realm* aRealm)
{
  return mImpl->SetRemoteDescription(description, successCallback, failureCallback, aRv, aRealm);
}

// Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
already_AddRefed<RTCSessionDescription>
RTCPeerConnection::GetRemoteDescription(ErrorResult& aRv, JS::Realm* aRealm) const
{
  return mImpl->GetRemoteDescription(aRv, aRealm);
}

// Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
already_AddRefed<RTCSessionDescription>
RTCPeerConnection::GetCurrentRemoteDescription(ErrorResult& aRv, JS::Realm* aRealm) const
{
  return mImpl->GetCurrentRemoteDescription(aRv, aRealm);
}

// Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
already_AddRefed<RTCSessionDescription>
RTCPeerConnection::GetPendingRemoteDescription(ErrorResult& aRv, JS::Realm* aRealm) const
{
  return mImpl->GetPendingRemoteDescription(aRv, aRealm);
}

RTCSignalingState
RTCPeerConnection::GetSignalingState(ErrorResult& aRv, JS::Realm* aRealm) const
{
  return mImpl->GetSignalingState(aRv, aRealm);
}

// Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
already_AddRefed<Promise>
RTCPeerConnection::AddIceCandidate(const RTCIceCandidateInitOrRTCIceCandidate& candidate, ErrorResult& aRv, JS::Realm* aRealm)
{
  return mImpl->AddIceCandidate(candidate, aRv, aRealm);
}

// Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
already_AddRefed<Promise>
RTCPeerConnection::AddIceCandidate(const RTCIceCandidateInit& candidate, VoidFunction& successCallback, RTCPeerConnectionErrorCallback& failureCallback, ErrorResult& aRv, JS::Realm* aRealm)
{
  return mImpl->AddIceCandidate(candidate, successCallback, failureCallback, aRv, aRealm);
}

Nullable<bool>
RTCPeerConnection::GetCanTrickleIceCandidates(ErrorResult& aRv, JS::Realm* aRealm) const
{
  return mImpl->GetCanTrickleIceCandidates(aRv, aRealm);
}

RTCIceGatheringState
RTCPeerConnection::GetIceGatheringState(ErrorResult& aRv, JS::Realm* aRealm) const
{
  return mImpl->GetIceGatheringState(aRv, aRealm);
}

RTCIceConnectionState
RTCPeerConnection::GetIceConnectionState(ErrorResult& aRv, JS::Realm* aRealm) const
{
  return mImpl->GetIceConnectionState(aRv, aRealm);
}

RTCPeerConnectionState
RTCPeerConnection::GetConnectionState(ErrorResult& aRv, JS::Realm* aRealm) const
{
  return mImpl->GetConnectionState(aRv, aRealm);
}

void
RTCPeerConnection::RestartIce(ErrorResult& aRv, JS::Realm* aRealm)
{
  return mImpl->RestartIce(aRv, aRealm);
}

// Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
already_AddRefed<Promise>
RTCPeerConnection::GetPeerIdentity(ErrorResult& aRv, JS::Realm* aRealm) const
{
  return mImpl->GetPeerIdentity(aRv, aRealm);
}

void
RTCPeerConnection::GetIdpLoginUrl(nsString& aRetVal, ErrorResult& aRv, JS::Realm* aRealm) const
{
  return mImpl->GetIdpLoginUrl(aRetVal, aRv, aRealm);
}

void
RTCPeerConnection::GetId(nsString& aRetVal, ErrorResult& aRv, JS::Realm* aRealm) const
{
  return mImpl->GetId(aRetVal, aRv, aRealm);
}

void
RTCPeerConnection::SetId(const nsAString& arg, ErrorResult& aRv, JS::Realm* aRealm)
{
  mImpl->SetId(arg, aRv, aRealm);
}

void
RTCPeerConnection::GetConfiguration(RTCConfiguration& aRetVal, ErrorResult& aRv, JS::Realm* aRealm)
{
  return mImpl->GetConfiguration(aRetVal, aRv, aRealm);
}

void
RTCPeerConnection::SetConfiguration(const RTCConfiguration& configuration, ErrorResult& aRv, JS::Realm* aRealm)
{
  return mImpl->SetConfiguration(configuration, aRv, aRealm);
}

void
RTCPeerConnection::GetLocalStreams(nsTArray<RefPtr<DOMMediaStream>>& aRetVal, ErrorResult& aRv, JS::Realm* aRealm)
{
  return mImpl->GetLocalStreams(aRetVal, aRv, aRealm);
}

void
RTCPeerConnection::GetRemoteStreams(nsTArray<RefPtr<DOMMediaStream>>& aRetVal, ErrorResult& aRv, JS::Realm* aRealm)
{
  return mImpl->GetRemoteStreams(aRetVal, aRv, aRealm);
}

void
RTCPeerConnection::AddStream(DOMMediaStream& stream, ErrorResult& aRv, JS::Realm* aRealm)
{
  return mImpl->AddStream(stream, aRv, aRealm);
}

// Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
already_AddRefed<RTCRtpSender>
RTCPeerConnection::AddTrack(MediaStreamTrack& track, const Sequence<OwningNonNull<DOMMediaStream>>& streams, ErrorResult& aRv, JS::Realm* aRealm)
{
  return mImpl->AddTrack(track, streams, aRv, aRealm);
}

void
RTCPeerConnection::RemoveTrack(RTCRtpSender& sender, ErrorResult& aRv, JS::Realm* aRealm)
{
  return mImpl->RemoveTrack(sender, aRv, aRealm);
}

// Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
already_AddRefed<RTCRtpTransceiver>
RTCPeerConnection::AddTransceiver(const MediaStreamTrackOrString& trackOrKind, const RTCRtpTransceiverInit& init, ErrorResult& aRv, JS::Realm* aRealm)
{
  return mImpl->AddTransceiver(trackOrKind, init, aRv, aRealm);
}

void
RTCPeerConnection::GetSenders(nsTArray<RefPtr<RTCRtpSender>>& aRetVal, ErrorResult& aRv, JS::Realm* aRealm)
{
  return mImpl->GetSenders(aRetVal, aRv, aRealm);
}

void
RTCPeerConnection::GetReceivers(nsTArray<RefPtr<RTCRtpReceiver>>& aRetVal, ErrorResult& aRv, JS::Realm* aRealm)
{
  return mImpl->GetReceivers(aRetVal, aRv, aRealm);
}

void
RTCPeerConnection::GetTransceivers(nsTArray<RefPtr<RTCRtpTransceiver>>& aRetVal, ErrorResult& aRv, JS::Realm* aRealm)
{
  return mImpl->GetTransceivers(aRetVal, aRv, aRealm);
}

void
RTCPeerConnection::MozSetPacketCallback(mozPacketCallback& callback, ErrorResult& aRv, JS::Realm* aRealm)
{
  return mImpl->MozSetPacketCallback(callback, aRv, aRealm);
}

void
RTCPeerConnection::MozEnablePacketDump(uint32_t level, mozPacketDumpType type, bool sending, ErrorResult& aRv, JS::Realm* aRealm)
{
  return mImpl->MozEnablePacketDump(level, type, sending, aRv, aRealm);
}

void
RTCPeerConnection::MozDisablePacketDump(uint32_t level, mozPacketDumpType type, bool sending, ErrorResult& aRv, JS::Realm* aRealm)
{
  return mImpl->MozDisablePacketDump(level, type, sending, aRv, aRealm);
}

void
RTCPeerConnection::Close(ErrorResult& aRv, JS::Realm* aRealm)
{
  return mImpl->Close(aRv, aRealm);
}

already_AddRefed<EventHandlerNonNull>
RTCPeerConnection::GetOnnegotiationneeded(ErrorResult& aRv, JS::Realm* aRealm) const
{
  return mImpl->GetOnnegotiationneeded(aRv, aRealm);
}

void
RTCPeerConnection::SetOnnegotiationneeded(EventHandlerNonNull* arg, ErrorResult& aRv, JS::Realm* aRealm)
{
  mImpl->SetOnnegotiationneeded(arg, aRv, aRealm);
}

already_AddRefed<EventHandlerNonNull>
RTCPeerConnection::GetOnicecandidate(ErrorResult& aRv, JS::Realm* aRealm) const
{
  return mImpl->GetOnicecandidate(aRv, aRealm);
}

void
RTCPeerConnection::SetOnicecandidate(EventHandlerNonNull* arg, ErrorResult& aRv, JS::Realm* aRealm)
{
  mImpl->SetOnicecandidate(arg, aRv, aRealm);
}

already_AddRefed<EventHandlerNonNull>
RTCPeerConnection::GetOnsignalingstatechange(ErrorResult& aRv, JS::Realm* aRealm) const
{
  return mImpl->GetOnsignalingstatechange(aRv, aRealm);
}

void
RTCPeerConnection::SetOnsignalingstatechange(EventHandlerNonNull* arg, ErrorResult& aRv, JS::Realm* aRealm)
{
  mImpl->SetOnsignalingstatechange(arg, aRv, aRealm);
}

already_AddRefed<EventHandlerNonNull>
RTCPeerConnection::GetOnaddstream(ErrorResult& aRv, JS::Realm* aRealm) const
{
  return mImpl->GetOnaddstream(aRv, aRealm);
}

void
RTCPeerConnection::SetOnaddstream(EventHandlerNonNull* arg, ErrorResult& aRv, JS::Realm* aRealm)
{
  mImpl->SetOnaddstream(arg, aRv, aRealm);
}

already_AddRefed<EventHandlerNonNull>
RTCPeerConnection::GetOnaddtrack(ErrorResult& aRv, JS::Realm* aRealm) const
{
  return mImpl->GetOnaddtrack(aRv, aRealm);
}

void
RTCPeerConnection::SetOnaddtrack(EventHandlerNonNull* arg, ErrorResult& aRv, JS::Realm* aRealm)
{
  mImpl->SetOnaddtrack(arg, aRv, aRealm);
}

already_AddRefed<EventHandlerNonNull>
RTCPeerConnection::GetOntrack(ErrorResult& aRv, JS::Realm* aRealm) const
{
  return mImpl->GetOntrack(aRv, aRealm);
}

void
RTCPeerConnection::SetOntrack(EventHandlerNonNull* arg, ErrorResult& aRv, JS::Realm* aRealm)
{
  mImpl->SetOntrack(arg, aRv, aRealm);
}

already_AddRefed<EventHandlerNonNull>
RTCPeerConnection::GetOniceconnectionstatechange(ErrorResult& aRv, JS::Realm* aRealm) const
{
  return mImpl->GetOniceconnectionstatechange(aRv, aRealm);
}

void
RTCPeerConnection::SetOniceconnectionstatechange(EventHandlerNonNull* arg, ErrorResult& aRv, JS::Realm* aRealm)
{
  mImpl->SetOniceconnectionstatechange(arg, aRv, aRealm);
}

already_AddRefed<EventHandlerNonNull>
RTCPeerConnection::GetOnicegatheringstatechange(ErrorResult& aRv, JS::Realm* aRealm) const
{
  return mImpl->GetOnicegatheringstatechange(aRv, aRealm);
}

void
RTCPeerConnection::SetOnicegatheringstatechange(EventHandlerNonNull* arg, ErrorResult& aRv, JS::Realm* aRealm)
{
  mImpl->SetOnicegatheringstatechange(arg, aRv, aRealm);
}

already_AddRefed<EventHandlerNonNull>
RTCPeerConnection::GetOnconnectionstatechange(ErrorResult& aRv, JS::Realm* aRealm) const
{
  return mImpl->GetOnconnectionstatechange(aRv, aRealm);
}

void
RTCPeerConnection::SetOnconnectionstatechange(EventHandlerNonNull* arg, ErrorResult& aRv, JS::Realm* aRealm)
{
  mImpl->SetOnconnectionstatechange(arg, aRv, aRealm);
}

// Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
already_AddRefed<Promise>
RTCPeerConnection::GetStats(MediaStreamTrack* selector, ErrorResult& aRv, JS::Realm* aRealm)
{
  return mImpl->GetStats(selector, aRv, aRealm);
}

// Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
already_AddRefed<RTCSctpTransport>
RTCPeerConnection::GetSctp(ErrorResult& aRv, JS::Realm* aRealm) const
{
  return mImpl->GetSctp(aRv, aRealm);
}

// Return a raw pointer here to avoid refcounting, but make sure it's safe (the object should be kept alive by the callee).
already_AddRefed<RTCDataChannel>
RTCPeerConnection::CreateDataChannel(const nsACString& label, const RTCDataChannelInit& dataChannelDict, ErrorResult& aRv, JS::Realm* aRealm)
{
  return mImpl->CreateDataChannel(label, dataChannelDict, aRv, aRealm);
}

already_AddRefed<EventHandlerNonNull>
RTCPeerConnection::GetOndatachannel(ErrorResult& aRv, JS::Realm* aRealm) const
{
  return mImpl->GetOndatachannel(aRv, aRealm);
}

void
RTCPeerConnection::SetOndatachannel(EventHandlerNonNull* arg, ErrorResult& aRv, JS::Realm* aRealm)
{
  mImpl->SetOndatachannel(arg, aRv, aRealm);
}

bool
RTCPeerConnection::_Create(JSContext* cx, unsigned argc, JS::Value* vp)
{
  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  if (!args.requireAtLeast(cx, "RTCPeerConnection._create", 2)) {
    return false;
  }
  BindingCallContext callCx(cx, "RTCPeerConnection._create");
  if (!args[0].isObject()) {
    return callCx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
  }
  if (!args[1].isObject()) {
    return callCx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 2");
  }

  // GlobalObject will go through wrappers as needed for us, and
  // is simpler than the right UnwrapArg incantation.
  GlobalObject global(cx, &args[0].toObject());
  if (global.Failed()) {
    return false;
  }
  nsCOMPtr<nsIGlobalObject> globalHolder = do_QueryInterface(global.GetAsSupports());
  MOZ_ASSERT(globalHolder);
  JS::Rooted<JSObject*> arg(cx, &args[1].toObject());
  JS::Rooted<JSObject*> argGlobal(cx, JS::CurrentGlobalOrNull(cx));
  RefPtr<RTCPeerConnection> impl = new RTCPeerConnection(arg, argGlobal, globalHolder);
  MOZ_ASSERT(js::IsObjectInContextCompartment(arg, cx));
  return GetOrCreateDOMReflector(cx, impl, args.rval());
}


} // namespace dom


} // namespace mozilla
