/* THIS FILE IS AUTOGENERATED FROM RTCStatsReport.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "AtomList.h"
#include "MainThreadUtils.h"
#include "RTCStatsReportBinding.h"
#include "WrapperFactory.h"
#include "XrayWrapper.h"
#include "js/Array.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/ForOfIterator.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/Symbol.h"
#include "js/experimental/JitInfo.h"
#include "jsapi.h"
#include "mozilla/Atomics.h"
#include "mozilla/FloatingPoint.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/StaticPrefs_media.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/RTCStatsReport.h"
#include "mozilla/dom/ScriptSettings.h"
#include "mozilla/dom/SimpleGlobalObject.h"
#include "mozilla/dom/ToJSValue.h"
#include "mozilla/dom/XrayExpandoClass.h"
#include "nsContentUtils.h"

namespace mozilla {

namespace dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;


namespace binding_detail {
constexpr nsLiteralCString EnumStrings<RTCStatsType>::Values[15];
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, RTCStatsType aArgument, JS::MutableHandle<JS::Value> aValue)
{
  MOZ_ASSERT(uint32_t(aArgument) < std::size(binding_detail::EnumStrings<RTCStatsType>::Values));
  JSString* resultStr =
    JS_NewStringCopyN(aCx, binding_detail::EnumStrings<RTCStatsType>::Values[uint32_t(aArgument)].BeginReading(),
                      binding_detail::EnumStrings<RTCStatsType>::Values[uint32_t(aArgument)].Length());
  if (!resultStr) {
    return false;
  }
  aValue.setString(resultStr);
  return true;
}


namespace binding_detail {
constexpr nsLiteralCString EnumStrings<RTCCodecType>::Values[2];
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, RTCCodecType aArgument, JS::MutableHandle<JS::Value> aValue)
{
  MOZ_ASSERT(uint32_t(aArgument) < std::size(binding_detail::EnumStrings<RTCCodecType>::Values));
  JSString* resultStr =
    JS_NewStringCopyN(aCx, binding_detail::EnumStrings<RTCCodecType>::Values[uint32_t(aArgument)].BeginReading(),
                      binding_detail::EnumStrings<RTCCodecType>::Values[uint32_t(aArgument)].Length());
  if (!resultStr) {
    return false;
  }
  aValue.setString(resultStr);
  return true;
}


namespace binding_detail {
constexpr nsLiteralCString EnumStrings<RTCStatsIceCandidatePairState>::Values[6];
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, RTCStatsIceCandidatePairState aArgument, JS::MutableHandle<JS::Value> aValue)
{
  MOZ_ASSERT(uint32_t(aArgument) < std::size(binding_detail::EnumStrings<RTCStatsIceCandidatePairState>::Values));
  JSString* resultStr =
    JS_NewStringCopyN(aCx, binding_detail::EnumStrings<RTCStatsIceCandidatePairState>::Values[uint32_t(aArgument)].BeginReading(),
                      binding_detail::EnumStrings<RTCStatsIceCandidatePairState>::Values[uint32_t(aArgument)].Length());
  if (!resultStr) {
    return false;
  }
  aValue.setString(resultStr);
  return true;
}



RTCBandwidthEstimationInternal::RTCBandwidthEstimationInternal()
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
RTCBandwidthEstimationInternal::InitIds(JSContext* cx, RTCBandwidthEstimationInternalAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->trackIdentifier_id.init(cx, "trackIdentifier") ||
      !atomsCache->sendBandwidthBps_id.init(cx, "sendBandwidthBps") ||
      !atomsCache->rttMs_id.init(cx, "rttMs") ||
      !atomsCache->receiveBandwidthBps_id.init(cx, "receiveBandwidthBps") ||
      !atomsCache->pacerDelayMs_id.init(cx, "pacerDelayMs") ||
      !atomsCache->maxPaddingBps_id.init(cx, "maxPaddingBps")) {
    return false;
  }
  return true;
}

bool
RTCBandwidthEstimationInternal::Init(const char* sourceDescription, bool passedToJSImpl)
{
  return true;
}

bool
RTCBandwidthEstimationInternal::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  RTCBandwidthEstimationInternalAtoms* atomsCache = GetAtomCache<RTCBandwidthEstimationInternalAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  if (mMaxPaddingBps.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      int32_t const & currentValue = mMaxPaddingBps.InternalValue();
      temp.setInt32(int32_t(currentValue));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->maxPaddingBps_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mPacerDelayMs.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      int32_t const & currentValue = mPacerDelayMs.InternalValue();
      temp.setInt32(int32_t(currentValue));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->pacerDelayMs_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mReceiveBandwidthBps.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      int32_t const & currentValue = mReceiveBandwidthBps.InternalValue();
      temp.setInt32(int32_t(currentValue));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->receiveBandwidthBps_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mRttMs.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      int32_t const & currentValue = mRttMs.InternalValue();
      temp.setInt32(int32_t(currentValue));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->rttMs_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mSendBandwidthBps.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      int32_t const & currentValue = mSendBandwidthBps.InternalValue();
      temp.setInt32(int32_t(currentValue));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->sendBandwidthBps_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mTrackIdentifier;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->trackIdentifier_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
RTCBandwidthEstimationInternal::TraceDictionary(JSTracer* trc)
{
}

RTCBandwidthEstimationInternal&
RTCBandwidthEstimationInternal::operator=(const RTCBandwidthEstimationInternal& aOther)
{
  DictionaryBase::operator=(aOther);
  mMaxPaddingBps.Reset();
  if (aOther.mMaxPaddingBps.WasPassed()) {
    mMaxPaddingBps.Construct(aOther.mMaxPaddingBps.Value());
  }
  mPacerDelayMs.Reset();
  if (aOther.mPacerDelayMs.WasPassed()) {
    mPacerDelayMs.Construct(aOther.mPacerDelayMs.Value());
  }
  mReceiveBandwidthBps.Reset();
  if (aOther.mReceiveBandwidthBps.WasPassed()) {
    mReceiveBandwidthBps.Construct(aOther.mReceiveBandwidthBps.Value());
  }
  mRttMs.Reset();
  if (aOther.mRttMs.WasPassed()) {
    mRttMs.Construct(aOther.mRttMs.Value());
  }
  mSendBandwidthBps.Reset();
  if (aOther.mSendBandwidthBps.WasPassed()) {
    mSendBandwidthBps.Construct(aOther.mSendBandwidthBps.Value());
  }
  mTrackIdentifier = aOther.mTrackIdentifier;
  return *this;
}



RTCIceServerInternal::RTCIceServerInternal()
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
RTCIceServerInternal::InitIds(JSContext* cx, RTCIceServerInternalAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->userNameProvided_id.init(cx, "userNameProvided") ||
      !atomsCache->urls_id.init(cx, "urls") ||
      !atomsCache->credentialProvided_id.init(cx, "credentialProvided")) {
    return false;
  }
  return true;
}

bool
RTCIceServerInternal::Init(const char* sourceDescription, bool passedToJSImpl)
{
  {
    // scope for any temporaries our default value setting needs.
    /* mUrls array is already empty; nothing to do */
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
RTCIceServerInternal::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  RTCIceServerInternalAtoms* atomsCache = GetAtomCache<RTCIceServerInternalAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    bool const & currentValue = mCredentialProvided;
    temp.setBoolean(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->credentialProvided_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    Sequence<nsString> const & currentValue = mUrls;

    uint32_t length = currentValue.Length();
    JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
    if (!returnArray) {
      return false;
    }
    // Scope for 'tmp'
    {
      JS::Rooted<JS::Value> tmp(cx);
      for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
        // Control block to let us common up the JS_DefineElement calls when there
        // are different ways to succeed at wrapping the object.
        do {
          if (!xpc::NonVoidStringToJsval(cx, currentValue[sequenceIdx0], &tmp)) {
            return false;
          }
          break;
        } while (false);
        if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                              JSPROP_ENUMERATE)) {
          return false;
        }
      }
    }
    temp.setObject(*returnArray);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->urls_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    bool const & currentValue = mUserNameProvided;
    temp.setBoolean(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->userNameProvided_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
RTCIceServerInternal::TraceDictionary(JSTracer* trc)
{
}

RTCIceServerInternal&
RTCIceServerInternal::operator=(const RTCIceServerInternal& aOther)
{
  DictionaryBase::operator=(aOther);
  mCredentialProvided = aOther.mCredentialProvided;
  mUrls = aOther.mUrls;
  mUserNameProvided = aOther.mUserNameProvided;
  return *this;
}



RTCSdpParsingErrorInternal::RTCSdpParsingErrorInternal()
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
RTCSdpParsingErrorInternal::InitIds(JSContext* cx, RTCSdpParsingErrorInternalAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->lineNumber_id.init(cx, "lineNumber") ||
      !atomsCache->error_id.init(cx, "error")) {
    return false;
  }
  return true;
}

bool
RTCSdpParsingErrorInternal::Init(const char* sourceDescription, bool passedToJSImpl)
{
  return true;
}

bool
RTCSdpParsingErrorInternal::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  RTCSdpParsingErrorInternalAtoms* atomsCache = GetAtomCache<RTCSdpParsingErrorInternalAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mError;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->error_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    uint32_t const & currentValue = mLineNumber;
    temp.setNumber(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->lineNumber_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
RTCSdpParsingErrorInternal::TraceDictionary(JSTracer* trc)
{
}

RTCSdpParsingErrorInternal&
RTCSdpParsingErrorInternal::operator=(const RTCSdpParsingErrorInternal& aOther)
{
  DictionaryBase::operator=(aOther);
  mError = aOther.mError;
  mLineNumber = aOther.mLineNumber;
  return *this;
}



RTCStats::RTCStats()
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
RTCStats::InitIds(JSContext* cx, RTCStatsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->type_id.init(cx, "type") ||
      !atomsCache->timestamp_id.init(cx, "timestamp") ||
      !atomsCache->id_id.init(cx, "id")) {
    return false;
  }
  return true;
}

bool
RTCStats::Init(const char* sourceDescription, bool passedToJSImpl)
{
  return true;
}

bool
RTCStats::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  RTCStatsAtoms* atomsCache = GetAtomCache<RTCStatsAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  if (mId.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mId.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->id_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mTimestamp.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      double const & currentValue = mTimestamp.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->timestamp_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mType.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      RTCStatsType const & currentValue = mType.InternalValue();
      if (!ToJSValue(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->type_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  return true;
}

void
RTCStats::TraceDictionary(JSTracer* trc)
{
}

RTCStats&
RTCStats::operator=(const RTCStats& aOther)
{
  DictionaryBase::operator=(aOther);
  mId.Reset();
  if (aOther.mId.WasPassed()) {
    mId.Construct(aOther.mId.Value());
  }
  mTimestamp.Reset();
  if (aOther.mTimestamp.WasPassed()) {
    mTimestamp.Construct(aOther.mTimestamp.Value());
  }
  mType.Reset();
  if (aOther.mType.WasPassed()) {
    mType.Construct(aOther.mType.Value());
  }
  return *this;
}



RTCVideoFrameHistoryEntryInternal::RTCVideoFrameHistoryEntryInternal()
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
RTCVideoFrameHistoryEntryInternal::InitIds(JSContext* cx, RTCVideoFrameHistoryEntryInternalAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->width_id.init(cx, "width") ||
      !atomsCache->rotationAngle_id.init(cx, "rotationAngle") ||
      !atomsCache->remoteSsrc_id.init(cx, "remoteSsrc") ||
      !atomsCache->localSsrc_id.init(cx, "localSsrc") ||
      !atomsCache->lastFrameTimestamp_id.init(cx, "lastFrameTimestamp") ||
      !atomsCache->height_id.init(cx, "height") ||
      !atomsCache->firstFrameTimestamp_id.init(cx, "firstFrameTimestamp") ||
      !atomsCache->consecutiveFrames_id.init(cx, "consecutiveFrames")) {
    return false;
  }
  return true;
}

bool
RTCVideoFrameHistoryEntryInternal::Init(const char* sourceDescription, bool passedToJSImpl)
{
  return true;
}

bool
RTCVideoFrameHistoryEntryInternal::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  RTCVideoFrameHistoryEntryInternalAtoms* atomsCache = GetAtomCache<RTCVideoFrameHistoryEntryInternalAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    uint64_t const & currentValue = mConsecutiveFrames;
    temp.set(JS_NumberValue(double(currentValue)));
    if (!JS_DefinePropertyById(cx, obj, atomsCache->consecutiveFrames_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    double const & currentValue = mFirstFrameTimestamp;
    temp.set(JS_NumberValue(double(currentValue)));
    if (!JS_DefinePropertyById(cx, obj, atomsCache->firstFrameTimestamp_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    uint32_t const & currentValue = mHeight;
    temp.setNumber(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->height_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    double const & currentValue = mLastFrameTimestamp;
    temp.set(JS_NumberValue(double(currentValue)));
    if (!JS_DefinePropertyById(cx, obj, atomsCache->lastFrameTimestamp_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    uint32_t const & currentValue = mLocalSsrc;
    temp.setNumber(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->localSsrc_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    uint32_t const & currentValue = mRemoteSsrc;
    temp.setNumber(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->remoteSsrc_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    uint32_t const & currentValue = mRotationAngle;
    temp.setNumber(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->rotationAngle_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    uint32_t const & currentValue = mWidth;
    temp.setNumber(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->width_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
RTCVideoFrameHistoryEntryInternal::TraceDictionary(JSTracer* trc)
{
}

RTCVideoFrameHistoryEntryInternal&
RTCVideoFrameHistoryEntryInternal::operator=(const RTCVideoFrameHistoryEntryInternal& aOther)
{
  DictionaryBase::operator=(aOther);
  mConsecutiveFrames = aOther.mConsecutiveFrames;
  mFirstFrameTimestamp = aOther.mFirstFrameTimestamp;
  mHeight = aOther.mHeight;
  mLastFrameTimestamp = aOther.mLastFrameTimestamp;
  mLocalSsrc = aOther.mLocalSsrc;
  mRemoteSsrc = aOther.mRemoteSsrc;
  mRotationAngle = aOther.mRotationAngle;
  mWidth = aOther.mWidth;
  return *this;
}



RTCCodecStats::RTCCodecStats()
  : RTCStats(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
RTCCodecStats::InitIds(JSContext* cx, RTCCodecStatsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->transportId_id.init(cx, "transportId") ||
      !atomsCache->sdpFmtpLine_id.init(cx, "sdpFmtpLine") ||
      !atomsCache->payloadType_id.init(cx, "payloadType") ||
      !atomsCache->mimeType_id.init(cx, "mimeType") ||
      !atomsCache->codecType_id.init(cx, "codecType") ||
      !atomsCache->clockRate_id.init(cx, "clockRate") ||
      !atomsCache->channels_id.init(cx, "channels")) {
    return false;
  }
  return true;
}

bool
RTCCodecStats::Init(const char* sourceDescription, bool passedToJSImpl)
{
  // We init the parent's members first
  if (!RTCStats::Init()) {
    return false;
  }

  return true;
}

bool
RTCCodecStats::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  RTCCodecStatsAtoms* atomsCache = GetAtomCache<RTCCodecStatsAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  // Per spec, we define the parent's members first
  if (!RTCStats::ToObjectInternal(cx, rval)) {
    return false;
  }
  JS::Rooted<JSObject*> obj(cx, &rval.toObject());

  if (mChannels.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint32_t const & currentValue = mChannels.InternalValue();
      temp.setNumber(currentValue);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->channels_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mClockRate.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint32_t const & currentValue = mClockRate.InternalValue();
      temp.setNumber(currentValue);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->clockRate_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mCodecType.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      RTCCodecType const & currentValue = mCodecType.InternalValue();
      if (!ToJSValue(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->codecType_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mMimeType;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->mimeType_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    uint32_t const & currentValue = mPayloadType;
    temp.setNumber(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->payloadType_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  if (mSdpFmtpLine.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mSdpFmtpLine.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->sdpFmtpLine_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mTransportId;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->transportId_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
RTCCodecStats::TraceDictionary(JSTracer* trc)
{
  RTCStats::TraceDictionary(trc);
}

RTCCodecStats&
RTCCodecStats::operator=(const RTCCodecStats& aOther)
{
  RTCStats::operator=(aOther);
  mChannels.Reset();
  if (aOther.mChannels.WasPassed()) {
    mChannels.Construct(aOther.mChannels.Value());
  }
  mClockRate.Reset();
  if (aOther.mClockRate.WasPassed()) {
    mClockRate.Construct(aOther.mClockRate.Value());
  }
  mCodecType.Reset();
  if (aOther.mCodecType.WasPassed()) {
    mCodecType.Construct(aOther.mCodecType.Value());
  }
  mMimeType = aOther.mMimeType;
  mPayloadType = aOther.mPayloadType;
  mSdpFmtpLine.Reset();
  if (aOther.mSdpFmtpLine.WasPassed()) {
    mSdpFmtpLine.Construct(aOther.mSdpFmtpLine.Value());
  }
  mTransportId = aOther.mTransportId;
  return *this;
}



RTCConfigurationInternal::RTCConfigurationInternal()
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
RTCConfigurationInternal::InitIds(JSContext* cx, RTCConfigurationInternalAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->sdpSemantics_id.init(cx, "sdpSemantics") ||
      !atomsCache->peerIdentityProvided_id.init(cx, "peerIdentityProvided") ||
      !atomsCache->iceTransportPolicy_id.init(cx, "iceTransportPolicy") ||
      !atomsCache->iceServers_id.init(cx, "iceServers") ||
      !atomsCache->certificatesProvided_id.init(cx, "certificatesProvided") ||
      !atomsCache->bundlePolicy_id.init(cx, "bundlePolicy")) {
    return false;
  }
  return true;
}

bool
RTCConfigurationInternal::Init(const char* sourceDescription, bool passedToJSImpl)
{
  {
    // scope for any temporaries our default value setting needs.
    /* mIceServers array is already empty; nothing to do */
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
RTCConfigurationInternal::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  RTCConfigurationInternalAtoms* atomsCache = GetAtomCache<RTCConfigurationInternalAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  if (mBundlePolicy.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      RTCBundlePolicy const & currentValue = mBundlePolicy.InternalValue();
      if (!ToJSValue(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->bundlePolicy_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    bool const & currentValue = mCertificatesProvided;
    temp.setBoolean(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->certificatesProvided_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    Sequence<RTCIceServerInternal> const & currentValue = mIceServers;

    uint32_t length = currentValue.Length();
    JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
    if (!returnArray) {
      return false;
    }
    // Scope for 'tmp'
    {
      JS::Rooted<JS::Value> tmp(cx);
      for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
        // Control block to let us common up the JS_DefineElement calls when there
        // are different ways to succeed at wrapping the object.
        do {
          if (!currentValue[sequenceIdx0].ToObjectInternal(cx, &tmp)) {
            return false;
          }
          break;
        } while (false);
        if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                              JSPROP_ENUMERATE)) {
          return false;
        }
      }
    }
    temp.setObject(*returnArray);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->iceServers_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  if (mIceTransportPolicy.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      RTCIceTransportPolicy const & currentValue = mIceTransportPolicy.InternalValue();
      if (!ToJSValue(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->iceTransportPolicy_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    bool const & currentValue = mPeerIdentityProvided;
    temp.setBoolean(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->peerIdentityProvided_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  if (mSdpSemantics.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mSdpSemantics.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->sdpSemantics_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  return true;
}

void
RTCConfigurationInternal::TraceDictionary(JSTracer* trc)
{
}

RTCConfigurationInternal&
RTCConfigurationInternal::operator=(const RTCConfigurationInternal& aOther)
{
  DictionaryBase::operator=(aOther);
  mBundlePolicy.Reset();
  if (aOther.mBundlePolicy.WasPassed()) {
    mBundlePolicy.Construct(aOther.mBundlePolicy.Value());
  }
  mCertificatesProvided = aOther.mCertificatesProvided;
  mIceServers = aOther.mIceServers;
  mIceTransportPolicy.Reset();
  if (aOther.mIceTransportPolicy.WasPassed()) {
    mIceTransportPolicy.Construct(aOther.mIceTransportPolicy.Value());
  }
  mPeerIdentityProvided = aOther.mPeerIdentityProvided;
  mSdpSemantics.Reset();
  if (aOther.mSdpSemantics.WasPassed()) {
    mSdpSemantics.Construct(aOther.mSdpSemantics.Value());
  }
  return *this;
}



RTCDataChannelStats::RTCDataChannelStats()
  : RTCStats(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
RTCDataChannelStats::InitIds(JSContext* cx, RTCDataChannelStatsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->state_id.init(cx, "state") ||
      !atomsCache->protocol_id.init(cx, "protocol") ||
      !atomsCache->messagesSent_id.init(cx, "messagesSent") ||
      !atomsCache->messagesReceived_id.init(cx, "messagesReceived") ||
      !atomsCache->label_id.init(cx, "label") ||
      !atomsCache->dataChannelIdentifier_id.init(cx, "dataChannelIdentifier") ||
      !atomsCache->bytesSent_id.init(cx, "bytesSent") ||
      !atomsCache->bytesReceived_id.init(cx, "bytesReceived")) {
    return false;
  }
  return true;
}

bool
RTCDataChannelStats::Init(const char* sourceDescription, bool passedToJSImpl)
{
  // We init the parent's members first
  if (!RTCStats::Init()) {
    return false;
  }

  return true;
}

bool
RTCDataChannelStats::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  RTCDataChannelStatsAtoms* atomsCache = GetAtomCache<RTCDataChannelStatsAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  // Per spec, we define the parent's members first
  if (!RTCStats::ToObjectInternal(cx, rval)) {
    return false;
  }
  JS::Rooted<JSObject*> obj(cx, &rval.toObject());

  if (mBytesReceived.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint64_t const & currentValue = mBytesReceived.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->bytesReceived_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mBytesSent.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint64_t const & currentValue = mBytesSent.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->bytesSent_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mDataChannelIdentifier.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      int32_t const & currentValue = mDataChannelIdentifier.InternalValue();
      temp.setInt32(int32_t(currentValue));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->dataChannelIdentifier_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mLabel.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mLabel.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->label_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mMessagesReceived.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint32_t const & currentValue = mMessagesReceived.InternalValue();
      temp.setNumber(currentValue);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->messagesReceived_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mMessagesSent.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint32_t const & currentValue = mMessagesSent.InternalValue();
      temp.setNumber(currentValue);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->messagesSent_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mProtocol.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mProtocol.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->protocol_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mState.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      RTCDataChannelState const & currentValue = mState.InternalValue();
      if (!ToJSValue(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->state_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  return true;
}

void
RTCDataChannelStats::TraceDictionary(JSTracer* trc)
{
  RTCStats::TraceDictionary(trc);
}

RTCDataChannelStats&
RTCDataChannelStats::operator=(const RTCDataChannelStats& aOther)
{
  RTCStats::operator=(aOther);
  mBytesReceived.Reset();
  if (aOther.mBytesReceived.WasPassed()) {
    mBytesReceived.Construct(aOther.mBytesReceived.Value());
  }
  mBytesSent.Reset();
  if (aOther.mBytesSent.WasPassed()) {
    mBytesSent.Construct(aOther.mBytesSent.Value());
  }
  mDataChannelIdentifier.Reset();
  if (aOther.mDataChannelIdentifier.WasPassed()) {
    mDataChannelIdentifier.Construct(aOther.mDataChannelIdentifier.Value());
  }
  mLabel.Reset();
  if (aOther.mLabel.WasPassed()) {
    mLabel.Construct(aOther.mLabel.Value());
  }
  mMessagesReceived.Reset();
  if (aOther.mMessagesReceived.WasPassed()) {
    mMessagesReceived.Construct(aOther.mMessagesReceived.Value());
  }
  mMessagesSent.Reset();
  if (aOther.mMessagesSent.WasPassed()) {
    mMessagesSent.Construct(aOther.mMessagesSent.Value());
  }
  mProtocol.Reset();
  if (aOther.mProtocol.WasPassed()) {
    mProtocol.Construct(aOther.mProtocol.Value());
  }
  mState.Reset();
  if (aOther.mState.WasPassed()) {
    mState.Construct(aOther.mState.Value());
  }
  return *this;
}



RTCIceCandidatePairStats::RTCIceCandidatePairStats()
  : RTCStats(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
RTCIceCandidatePairStats::InitIds(JSContext* cx, RTCIceCandidatePairStatsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->writable_id.init(cx, "writable") ||
      !atomsCache->transportId_id.init(cx, "transportId") ||
      !atomsCache->totalRoundTripTime_id.init(cx, "totalRoundTripTime") ||
      !atomsCache->state_id.init(cx, "state") ||
      !atomsCache->selected_id.init(cx, "selected") ||
      !atomsCache->responsesReceived_id.init(cx, "responsesReceived") ||
      !atomsCache->remoteCandidateId_id.init(cx, "remoteCandidateId") ||
      !atomsCache->readable_id.init(cx, "readable") ||
      !atomsCache->priority_id.init(cx, "priority") ||
      !atomsCache->nominated_id.init(cx, "nominated") ||
      !atomsCache->localCandidateId_id.init(cx, "localCandidateId") ||
      !atomsCache->lastPacketSentTimestamp_id.init(cx, "lastPacketSentTimestamp") ||
      !atomsCache->lastPacketReceivedTimestamp_id.init(cx, "lastPacketReceivedTimestamp") ||
      !atomsCache->currentRoundTripTime_id.init(cx, "currentRoundTripTime") ||
      !atomsCache->componentId_id.init(cx, "componentId") ||
      !atomsCache->bytesSent_id.init(cx, "bytesSent") ||
      !atomsCache->bytesReceived_id.init(cx, "bytesReceived")) {
    return false;
  }
  return true;
}

bool
RTCIceCandidatePairStats::Init(const char* sourceDescription, bool passedToJSImpl)
{
  // We init the parent's members first
  if (!RTCStats::Init()) {
    return false;
  }

  return true;
}

bool
RTCIceCandidatePairStats::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  RTCIceCandidatePairStatsAtoms* atomsCache = GetAtomCache<RTCIceCandidatePairStatsAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  // Per spec, we define the parent's members first
  if (!RTCStats::ToObjectInternal(cx, rval)) {
    return false;
  }
  JS::Rooted<JSObject*> obj(cx, &rval.toObject());

  if (mBytesReceived.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint64_t const & currentValue = mBytesReceived.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->bytesReceived_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mBytesSent.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint64_t const & currentValue = mBytesSent.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->bytesSent_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (nsContentUtils::ThreadsafeIsSystemCaller(cx)) {
    if (mComponentId.WasPassed()) {
      do {
        // block for our 'break' successCode and scope for 'temp' and 'currentValue'
        JS::Rooted<JS::Value> temp(cx);
        uint32_t const & currentValue = mComponentId.InternalValue();
        temp.setNumber(currentValue);
        if (!JS_DefinePropertyById(cx, obj, atomsCache->componentId_id, temp, JSPROP_ENUMERATE)) {
          return false;
        }
        break;
      } while(false);
    }
  }

  if (mCurrentRoundTripTime.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      double const & currentValue = mCurrentRoundTripTime.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->currentRoundTripTime_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mLastPacketReceivedTimestamp.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      double const & currentValue = mLastPacketReceivedTimestamp.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->lastPacketReceivedTimestamp_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mLastPacketSentTimestamp.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      double const & currentValue = mLastPacketSentTimestamp.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->lastPacketSentTimestamp_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mLocalCandidateId.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mLocalCandidateId.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->localCandidateId_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mNominated.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      bool const & currentValue = mNominated.InternalValue();
      temp.setBoolean(currentValue);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->nominated_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mPriority.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint64_t const & currentValue = mPriority.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->priority_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mReadable.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      bool const & currentValue = mReadable.InternalValue();
      temp.setBoolean(currentValue);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->readable_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mRemoteCandidateId.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mRemoteCandidateId.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->remoteCandidateId_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mResponsesReceived.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint64_t const & currentValue = mResponsesReceived.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->responsesReceived_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mSelected.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      bool const & currentValue = mSelected.InternalValue();
      temp.setBoolean(currentValue);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->selected_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mState.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      RTCStatsIceCandidatePairState const & currentValue = mState.InternalValue();
      if (!ToJSValue(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->state_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mTotalRoundTripTime.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      double const & currentValue = mTotalRoundTripTime.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->totalRoundTripTime_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mTransportId.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mTransportId.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->transportId_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mWritable.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      bool const & currentValue = mWritable.InternalValue();
      temp.setBoolean(currentValue);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->writable_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  return true;
}

void
RTCIceCandidatePairStats::TraceDictionary(JSTracer* trc)
{
  RTCStats::TraceDictionary(trc);
}

RTCIceCandidatePairStats&
RTCIceCandidatePairStats::operator=(const RTCIceCandidatePairStats& aOther)
{
  RTCStats::operator=(aOther);
  mBytesReceived.Reset();
  if (aOther.mBytesReceived.WasPassed()) {
    mBytesReceived.Construct(aOther.mBytesReceived.Value());
  }
  mBytesSent.Reset();
  if (aOther.mBytesSent.WasPassed()) {
    mBytesSent.Construct(aOther.mBytesSent.Value());
  }
  mComponentId.Reset();
  if (aOther.mComponentId.WasPassed()) {
    mComponentId.Construct(aOther.mComponentId.Value());
  }
  mCurrentRoundTripTime.Reset();
  if (aOther.mCurrentRoundTripTime.WasPassed()) {
    mCurrentRoundTripTime.Construct(aOther.mCurrentRoundTripTime.Value());
  }
  mLastPacketReceivedTimestamp.Reset();
  if (aOther.mLastPacketReceivedTimestamp.WasPassed()) {
    mLastPacketReceivedTimestamp.Construct(aOther.mLastPacketReceivedTimestamp.Value());
  }
  mLastPacketSentTimestamp.Reset();
  if (aOther.mLastPacketSentTimestamp.WasPassed()) {
    mLastPacketSentTimestamp.Construct(aOther.mLastPacketSentTimestamp.Value());
  }
  mLocalCandidateId.Reset();
  if (aOther.mLocalCandidateId.WasPassed()) {
    mLocalCandidateId.Construct(aOther.mLocalCandidateId.Value());
  }
  mNominated.Reset();
  if (aOther.mNominated.WasPassed()) {
    mNominated.Construct(aOther.mNominated.Value());
  }
  mPriority.Reset();
  if (aOther.mPriority.WasPassed()) {
    mPriority.Construct(aOther.mPriority.Value());
  }
  mReadable.Reset();
  if (aOther.mReadable.WasPassed()) {
    mReadable.Construct(aOther.mReadable.Value());
  }
  mRemoteCandidateId.Reset();
  if (aOther.mRemoteCandidateId.WasPassed()) {
    mRemoteCandidateId.Construct(aOther.mRemoteCandidateId.Value());
  }
  mResponsesReceived.Reset();
  if (aOther.mResponsesReceived.WasPassed()) {
    mResponsesReceived.Construct(aOther.mResponsesReceived.Value());
  }
  mSelected.Reset();
  if (aOther.mSelected.WasPassed()) {
    mSelected.Construct(aOther.mSelected.Value());
  }
  mState.Reset();
  if (aOther.mState.WasPassed()) {
    mState.Construct(aOther.mState.Value());
  }
  mTotalRoundTripTime.Reset();
  if (aOther.mTotalRoundTripTime.WasPassed()) {
    mTotalRoundTripTime.Construct(aOther.mTotalRoundTripTime.Value());
  }
  mTransportId.Reset();
  if (aOther.mTransportId.WasPassed()) {
    mTransportId.Construct(aOther.mTransportId.Value());
  }
  mWritable.Reset();
  if (aOther.mWritable.WasPassed()) {
    mWritable.Construct(aOther.mWritable.Value());
  }
  return *this;
}



RTCIceCandidateStats::RTCIceCandidateStats()
  : RTCStats(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
RTCIceCandidateStats::InitIds(JSContext* cx, RTCIceCandidateStatsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->transportId_id.init(cx, "transportId") ||
      !atomsCache->relayProtocol_id.init(cx, "relayProtocol") ||
      !atomsCache->proxied_id.init(cx, "proxied") ||
      !atomsCache->protocol_id.init(cx, "protocol") ||
      !atomsCache->priority_id.init(cx, "priority") ||
      !atomsCache->port_id.init(cx, "port") ||
      !atomsCache->candidateType_id.init(cx, "candidateType") ||
      !atomsCache->address_id.init(cx, "address")) {
    return false;
  }
  return true;
}

bool
RTCIceCandidateStats::Init(const char* sourceDescription, bool passedToJSImpl)
{
  // We init the parent's members first
  if (!RTCStats::Init()) {
    return false;
  }

  return true;
}

bool
RTCIceCandidateStats::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  RTCIceCandidateStatsAtoms* atomsCache = GetAtomCache<RTCIceCandidateStatsAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  // Per spec, we define the parent's members first
  if (!RTCStats::ToObjectInternal(cx, rval)) {
    return false;
  }
  JS::Rooted<JSObject*> obj(cx, &rval.toObject());

  if (mAddress.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mAddress.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->address_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mCandidateType.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      RTCIceCandidateType const & currentValue = mCandidateType.InternalValue();
      if (!ToJSValue(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->candidateType_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mPort.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      int32_t const & currentValue = mPort.InternalValue();
      temp.setInt32(int32_t(currentValue));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->port_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mPriority.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      int32_t const & currentValue = mPriority.InternalValue();
      temp.setInt32(int32_t(currentValue));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->priority_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mProtocol.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mProtocol.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->protocol_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (nsContentUtils::ThreadsafeIsSystemCaller(cx)) {
    if (mProxied.WasPassed()) {
      do {
        // block for our 'break' successCode and scope for 'temp' and 'currentValue'
        JS::Rooted<JS::Value> temp(cx);
        nsString const & currentValue = mProxied.InternalValue();
        if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
          return false;
        }
        if (!JS_DefinePropertyById(cx, obj, atomsCache->proxied_id, temp, JSPROP_ENUMERATE)) {
          return false;
        }
        break;
      } while(false);
    }
  }

  if (mRelayProtocol.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mRelayProtocol.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->relayProtocol_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (nsContentUtils::ThreadsafeIsSystemCaller(cx)) {
    if (mTransportId.WasPassed()) {
      do {
        // block for our 'break' successCode and scope for 'temp' and 'currentValue'
        JS::Rooted<JS::Value> temp(cx);
        nsString const & currentValue = mTransportId.InternalValue();
        if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
          return false;
        }
        if (!JS_DefinePropertyById(cx, obj, atomsCache->transportId_id, temp, JSPROP_ENUMERATE)) {
          return false;
        }
        break;
      } while(false);
    }
  }

  return true;
}

void
RTCIceCandidateStats::TraceDictionary(JSTracer* trc)
{
  RTCStats::TraceDictionary(trc);
}

RTCIceCandidateStats&
RTCIceCandidateStats::operator=(const RTCIceCandidateStats& aOther)
{
  RTCStats::operator=(aOther);
  mAddress.Reset();
  if (aOther.mAddress.WasPassed()) {
    mAddress.Construct(aOther.mAddress.Value());
  }
  mCandidateType.Reset();
  if (aOther.mCandidateType.WasPassed()) {
    mCandidateType.Construct(aOther.mCandidateType.Value());
  }
  mPort.Reset();
  if (aOther.mPort.WasPassed()) {
    mPort.Construct(aOther.mPort.Value());
  }
  mPriority.Reset();
  if (aOther.mPriority.WasPassed()) {
    mPriority.Construct(aOther.mPriority.Value());
  }
  mProtocol.Reset();
  if (aOther.mProtocol.WasPassed()) {
    mProtocol.Construct(aOther.mProtocol.Value());
  }
  mProxied.Reset();
  if (aOther.mProxied.WasPassed()) {
    mProxied.Construct(aOther.mProxied.Value());
  }
  mRelayProtocol.Reset();
  if (aOther.mRelayProtocol.WasPassed()) {
    mRelayProtocol.Construct(aOther.mRelayProtocol.Value());
  }
  mTransportId.Reset();
  if (aOther.mTransportId.WasPassed()) {
    mTransportId.Construct(aOther.mTransportId.Value());
  }
  return *this;
}



RTCMediaSourceStats::RTCMediaSourceStats()
  : RTCStats(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
RTCMediaSourceStats::InitIds(JSContext* cx, RTCMediaSourceStatsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->trackIdentifier_id.init(cx, "trackIdentifier") ||
      !atomsCache->kind_id.init(cx, "kind")) {
    return false;
  }
  return true;
}

bool
RTCMediaSourceStats::Init(const char* sourceDescription, bool passedToJSImpl)
{
  // We init the parent's members first
  if (!RTCStats::Init()) {
    return false;
  }

  return true;
}

bool
RTCMediaSourceStats::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  RTCMediaSourceStatsAtoms* atomsCache = GetAtomCache<RTCMediaSourceStatsAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  // Per spec, we define the parent's members first
  if (!RTCStats::ToObjectInternal(cx, rval)) {
    return false;
  }
  JS::Rooted<JSObject*> obj(cx, &rval.toObject());

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mKind;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->kind_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mTrackIdentifier;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->trackIdentifier_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
RTCMediaSourceStats::TraceDictionary(JSTracer* trc)
{
  RTCStats::TraceDictionary(trc);
}

RTCMediaSourceStats&
RTCMediaSourceStats::operator=(const RTCMediaSourceStats& aOther)
{
  RTCStats::operator=(aOther);
  mKind = aOther.mKind;
  mTrackIdentifier = aOther.mTrackIdentifier;
  return *this;
}



RTCPeerConnectionStats::RTCPeerConnectionStats()
  : RTCStats(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
RTCPeerConnectionStats::InitIds(JSContext* cx, RTCPeerConnectionStatsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->dataChannelsOpened_id.init(cx, "dataChannelsOpened") ||
      !atomsCache->dataChannelsClosed_id.init(cx, "dataChannelsClosed")) {
    return false;
  }
  return true;
}

bool
RTCPeerConnectionStats::Init(const char* sourceDescription, bool passedToJSImpl)
{
  // We init the parent's members first
  if (!RTCStats::Init()) {
    return false;
  }

  return true;
}

bool
RTCPeerConnectionStats::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  RTCPeerConnectionStatsAtoms* atomsCache = GetAtomCache<RTCPeerConnectionStatsAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  // Per spec, we define the parent's members first
  if (!RTCStats::ToObjectInternal(cx, rval)) {
    return false;
  }
  JS::Rooted<JSObject*> obj(cx, &rval.toObject());

  if (mDataChannelsClosed.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint32_t const & currentValue = mDataChannelsClosed.InternalValue();
      temp.setNumber(currentValue);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->dataChannelsClosed_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mDataChannelsOpened.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint32_t const & currentValue = mDataChannelsOpened.InternalValue();
      temp.setNumber(currentValue);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->dataChannelsOpened_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  return true;
}

void
RTCPeerConnectionStats::TraceDictionary(JSTracer* trc)
{
  RTCStats::TraceDictionary(trc);
}

RTCPeerConnectionStats&
RTCPeerConnectionStats::operator=(const RTCPeerConnectionStats& aOther)
{
  RTCStats::operator=(aOther);
  mDataChannelsClosed.Reset();
  if (aOther.mDataChannelsClosed.WasPassed()) {
    mDataChannelsClosed.Construct(aOther.mDataChannelsClosed.Value());
  }
  mDataChannelsOpened.Reset();
  if (aOther.mDataChannelsOpened.WasPassed()) {
    mDataChannelsOpened.Construct(aOther.mDataChannelsOpened.Value());
  }
  return *this;
}



RTCRTPContributingSourceStats::RTCRTPContributingSourceStats()
  : RTCStats(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
RTCRTPContributingSourceStats::InitIds(JSContext* cx, RTCRTPContributingSourceStatsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->inboundRtpStreamId_id.init(cx, "inboundRtpStreamId") ||
      !atomsCache->contributorSsrc_id.init(cx, "contributorSsrc")) {
    return false;
  }
  return true;
}

bool
RTCRTPContributingSourceStats::Init(const char* sourceDescription, bool passedToJSImpl)
{
  // We init the parent's members first
  if (!RTCStats::Init()) {
    return false;
  }

  return true;
}

bool
RTCRTPContributingSourceStats::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  RTCRTPContributingSourceStatsAtoms* atomsCache = GetAtomCache<RTCRTPContributingSourceStatsAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  // Per spec, we define the parent's members first
  if (!RTCStats::ToObjectInternal(cx, rval)) {
    return false;
  }
  JS::Rooted<JSObject*> obj(cx, &rval.toObject());

  if (mContributorSsrc.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint32_t const & currentValue = mContributorSsrc.InternalValue();
      temp.setNumber(currentValue);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->contributorSsrc_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mInboundRtpStreamId.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mInboundRtpStreamId.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->inboundRtpStreamId_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  return true;
}

void
RTCRTPContributingSourceStats::TraceDictionary(JSTracer* trc)
{
  RTCStats::TraceDictionary(trc);
}

RTCRTPContributingSourceStats&
RTCRTPContributingSourceStats::operator=(const RTCRTPContributingSourceStats& aOther)
{
  RTCStats::operator=(aOther);
  mContributorSsrc.Reset();
  if (aOther.mContributorSsrc.WasPassed()) {
    mContributorSsrc.Construct(aOther.mContributorSsrc.Value());
  }
  mInboundRtpStreamId.Reset();
  if (aOther.mInboundRtpStreamId.WasPassed()) {
    mInboundRtpStreamId.Construct(aOther.mInboundRtpStreamId.Value());
  }
  return *this;
}



RTCRtpStreamStats::RTCRtpStreamStats()
  : RTCStats(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
RTCRtpStreamStats::InitIds(JSContext* cx, RTCRtpStreamStatsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->transportId_id.init(cx, "transportId") ||
      !atomsCache->ssrc_id.init(cx, "ssrc") ||
      !atomsCache->mediaType_id.init(cx, "mediaType") ||
      !atomsCache->kind_id.init(cx, "kind") ||
      !atomsCache->codecId_id.init(cx, "codecId")) {
    return false;
  }
  return true;
}

bool
RTCRtpStreamStats::Init(const char* sourceDescription, bool passedToJSImpl)
{
  // We init the parent's members first
  if (!RTCStats::Init()) {
    return false;
  }

  return true;
}

bool
RTCRtpStreamStats::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  RTCRtpStreamStatsAtoms* atomsCache = GetAtomCache<RTCRtpStreamStatsAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  // Per spec, we define the parent's members first
  if (!RTCStats::ToObjectInternal(cx, rval)) {
    return false;
  }
  JS::Rooted<JSObject*> obj(cx, &rval.toObject());

  if (mCodecId.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mCodecId.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->codecId_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mKind;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->kind_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  if (mMediaType.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mMediaType.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->mediaType_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    uint32_t const & currentValue = mSsrc;
    temp.setNumber(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->ssrc_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  if (mTransportId.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mTransportId.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->transportId_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  return true;
}

void
RTCRtpStreamStats::TraceDictionary(JSTracer* trc)
{
  RTCStats::TraceDictionary(trc);
}

RTCRtpStreamStats&
RTCRtpStreamStats::operator=(const RTCRtpStreamStats& aOther)
{
  RTCStats::operator=(aOther);
  mCodecId.Reset();
  if (aOther.mCodecId.WasPassed()) {
    mCodecId.Construct(aOther.mCodecId.Value());
  }
  mKind = aOther.mKind;
  mMediaType.Reset();
  if (aOther.mMediaType.WasPassed()) {
    mMediaType.Construct(aOther.mMediaType.Value());
  }
  mSsrc = aOther.mSsrc;
  mTransportId.Reset();
  if (aOther.mTransportId.WasPassed()) {
    mTransportId.Construct(aOther.mTransportId.Value());
  }
  return *this;
}



RTCSdpHistoryEntryInternal::RTCSdpHistoryEntryInternal()
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
RTCSdpHistoryEntryInternal::InitIds(JSContext* cx, RTCSdpHistoryEntryInternalAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->timestamp_id.init(cx, "timestamp") ||
      !atomsCache->sdp_id.init(cx, "sdp") ||
      !atomsCache->isLocal_id.init(cx, "isLocal") ||
      !atomsCache->errors_id.init(cx, "errors")) {
    return false;
  }
  return true;
}

bool
RTCSdpHistoryEntryInternal::Init(const char* sourceDescription, bool passedToJSImpl)
{
  {
    // scope for any temporaries our default value setting needs.
    /* mErrors array is already empty; nothing to do */
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
RTCSdpHistoryEntryInternal::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  RTCSdpHistoryEntryInternalAtoms* atomsCache = GetAtomCache<RTCSdpHistoryEntryInternalAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    Sequence<RTCSdpParsingErrorInternal> const & currentValue = mErrors;

    uint32_t length = currentValue.Length();
    JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
    if (!returnArray) {
      return false;
    }
    // Scope for 'tmp'
    {
      JS::Rooted<JS::Value> tmp(cx);
      for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
        // Control block to let us common up the JS_DefineElement calls when there
        // are different ways to succeed at wrapping the object.
        do {
          if (!currentValue[sequenceIdx0].ToObjectInternal(cx, &tmp)) {
            return false;
          }
          break;
        } while (false);
        if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                              JSPROP_ENUMERATE)) {
          return false;
        }
      }
    }
    temp.setObject(*returnArray);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->errors_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    bool const & currentValue = mIsLocal;
    temp.setBoolean(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->isLocal_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mSdp;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->sdp_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    double const & currentValue = mTimestamp;
    temp.set(JS_NumberValue(double(currentValue)));
    if (!JS_DefinePropertyById(cx, obj, atomsCache->timestamp_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
RTCSdpHistoryEntryInternal::TraceDictionary(JSTracer* trc)
{
}

RTCSdpHistoryEntryInternal&
RTCSdpHistoryEntryInternal::operator=(const RTCSdpHistoryEntryInternal& aOther)
{
  DictionaryBase::operator=(aOther);
  mErrors = aOther.mErrors;
  mIsLocal = aOther.mIsLocal;
  mSdp = aOther.mSdp;
  mTimestamp = aOther.mTimestamp;
  return *this;
}



RTCVideoFrameHistoryInternal::RTCVideoFrameHistoryInternal()
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
RTCVideoFrameHistoryInternal::InitIds(JSContext* cx, RTCVideoFrameHistoryInternalAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->trackIdentifier_id.init(cx, "trackIdentifier") ||
      !atomsCache->entries_id.init(cx, "entries")) {
    return false;
  }
  return true;
}

bool
RTCVideoFrameHistoryInternal::Init(const char* sourceDescription, bool passedToJSImpl)
{
  {
    // scope for any temporaries our default value setting needs.
    /* mEntries array is already empty; nothing to do */
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
RTCVideoFrameHistoryInternal::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  RTCVideoFrameHistoryInternalAtoms* atomsCache = GetAtomCache<RTCVideoFrameHistoryInternalAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    Sequence<RTCVideoFrameHistoryEntryInternal> const & currentValue = mEntries;

    uint32_t length = currentValue.Length();
    JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
    if (!returnArray) {
      return false;
    }
    // Scope for 'tmp'
    {
      JS::Rooted<JS::Value> tmp(cx);
      for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
        // Control block to let us common up the JS_DefineElement calls when there
        // are different ways to succeed at wrapping the object.
        do {
          if (!currentValue[sequenceIdx0].ToObjectInternal(cx, &tmp)) {
            return false;
          }
          break;
        } while (false);
        if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                              JSPROP_ENUMERATE)) {
          return false;
        }
      }
    }
    temp.setObject(*returnArray);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->entries_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mTrackIdentifier;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->trackIdentifier_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
RTCVideoFrameHistoryInternal::TraceDictionary(JSTracer* trc)
{
}

RTCVideoFrameHistoryInternal&
RTCVideoFrameHistoryInternal::operator=(const RTCVideoFrameHistoryInternal& aOther)
{
  DictionaryBase::operator=(aOther);
  mEntries = aOther.mEntries;
  mTrackIdentifier = aOther.mTrackIdentifier;
  return *this;
}



RTCReceivedRtpStreamStats::RTCReceivedRtpStreamStats()
  : RTCRtpStreamStats(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
RTCReceivedRtpStreamStats::InitIds(JSContext* cx, RTCReceivedRtpStreamStatsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->packetsReceived_id.init(cx, "packetsReceived") ||
      !atomsCache->packetsLost_id.init(cx, "packetsLost") ||
      !atomsCache->packetsDiscarded_id.init(cx, "packetsDiscarded") ||
      !atomsCache->jitter_id.init(cx, "jitter") ||
      !atomsCache->discardedPackets_id.init(cx, "discardedPackets")) {
    return false;
  }
  return true;
}

bool
RTCReceivedRtpStreamStats::Init(const char* sourceDescription, bool passedToJSImpl)
{
  // We init the parent's members first
  if (!RTCRtpStreamStats::Init()) {
    return false;
  }

  return true;
}

bool
RTCReceivedRtpStreamStats::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  RTCReceivedRtpStreamStatsAtoms* atomsCache = GetAtomCache<RTCReceivedRtpStreamStatsAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  // Per spec, we define the parent's members first
  if (!RTCRtpStreamStats::ToObjectInternal(cx, rval)) {
    return false;
  }
  JS::Rooted<JSObject*> obj(cx, &rval.toObject());

  if (mDiscardedPackets.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint32_t const & currentValue = mDiscardedPackets.InternalValue();
      temp.setNumber(currentValue);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->discardedPackets_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mJitter.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      double const & currentValue = mJitter.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->jitter_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mPacketsDiscarded.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint32_t const & currentValue = mPacketsDiscarded.InternalValue();
      temp.setNumber(currentValue);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->packetsDiscarded_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mPacketsLost.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      int64_t const & currentValue = mPacketsLost.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->packetsLost_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mPacketsReceived.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint64_t const & currentValue = mPacketsReceived.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->packetsReceived_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  return true;
}

void
RTCReceivedRtpStreamStats::TraceDictionary(JSTracer* trc)
{
  RTCRtpStreamStats::TraceDictionary(trc);
}

RTCReceivedRtpStreamStats&
RTCReceivedRtpStreamStats::operator=(const RTCReceivedRtpStreamStats& aOther)
{
  RTCRtpStreamStats::operator=(aOther);
  mDiscardedPackets.Reset();
  if (aOther.mDiscardedPackets.WasPassed()) {
    mDiscardedPackets.Construct(aOther.mDiscardedPackets.Value());
  }
  mJitter.Reset();
  if (aOther.mJitter.WasPassed()) {
    mJitter.Construct(aOther.mJitter.Value());
  }
  mPacketsDiscarded.Reset();
  if (aOther.mPacketsDiscarded.WasPassed()) {
    mPacketsDiscarded.Construct(aOther.mPacketsDiscarded.Value());
  }
  mPacketsLost.Reset();
  if (aOther.mPacketsLost.WasPassed()) {
    mPacketsLost.Construct(aOther.mPacketsLost.Value());
  }
  mPacketsReceived.Reset();
  if (aOther.mPacketsReceived.WasPassed()) {
    mPacketsReceived.Construct(aOther.mPacketsReceived.Value());
  }
  return *this;
}



RTCSdpHistoryInternal::RTCSdpHistoryInternal()
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
RTCSdpHistoryInternal::InitIds(JSContext* cx, RTCSdpHistoryInternalAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->sdpHistory_id.init(cx, "sdpHistory") ||
      !atomsCache->pcid_id.init(cx, "pcid")) {
    return false;
  }
  return true;
}

bool
RTCSdpHistoryInternal::Init(const char* sourceDescription, bool passedToJSImpl)
{
  {
    // scope for any temporaries our default value setting needs.
    /* mSdpHistory array is already empty; nothing to do */
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
RTCSdpHistoryInternal::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  RTCSdpHistoryInternalAtoms* atomsCache = GetAtomCache<RTCSdpHistoryInternalAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mPcid;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->pcid_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    Sequence<RTCSdpHistoryEntryInternal> const & currentValue = mSdpHistory;

    uint32_t length = currentValue.Length();
    JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
    if (!returnArray) {
      return false;
    }
    // Scope for 'tmp'
    {
      JS::Rooted<JS::Value> tmp(cx);
      for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
        // Control block to let us common up the JS_DefineElement calls when there
        // are different ways to succeed at wrapping the object.
        do {
          if (!currentValue[sequenceIdx0].ToObjectInternal(cx, &tmp)) {
            return false;
          }
          break;
        } while (false);
        if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                              JSPROP_ENUMERATE)) {
          return false;
        }
      }
    }
    temp.setObject(*returnArray);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->sdpHistory_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
RTCSdpHistoryInternal::TraceDictionary(JSTracer* trc)
{
}

RTCSdpHistoryInternal&
RTCSdpHistoryInternal::operator=(const RTCSdpHistoryInternal& aOther)
{
  DictionaryBase::operator=(aOther);
  mPcid = aOther.mPcid;
  mSdpHistory = aOther.mSdpHistory;
  return *this;
}



RTCSentRtpStreamStats::RTCSentRtpStreamStats()
  : RTCRtpStreamStats(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
RTCSentRtpStreamStats::InitIds(JSContext* cx, RTCSentRtpStreamStatsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->packetsSent_id.init(cx, "packetsSent") ||
      !atomsCache->bytesSent_id.init(cx, "bytesSent")) {
    return false;
  }
  return true;
}

bool
RTCSentRtpStreamStats::Init(const char* sourceDescription, bool passedToJSImpl)
{
  // We init the parent's members first
  if (!RTCRtpStreamStats::Init()) {
    return false;
  }

  return true;
}

bool
RTCSentRtpStreamStats::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  RTCSentRtpStreamStatsAtoms* atomsCache = GetAtomCache<RTCSentRtpStreamStatsAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  // Per spec, we define the parent's members first
  if (!RTCRtpStreamStats::ToObjectInternal(cx, rval)) {
    return false;
  }
  JS::Rooted<JSObject*> obj(cx, &rval.toObject());

  if (mBytesSent.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint64_t const & currentValue = mBytesSent.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->bytesSent_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mPacketsSent.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint32_t const & currentValue = mPacketsSent.InternalValue();
      temp.setNumber(currentValue);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->packetsSent_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  return true;
}

void
RTCSentRtpStreamStats::TraceDictionary(JSTracer* trc)
{
  RTCRtpStreamStats::TraceDictionary(trc);
}

RTCSentRtpStreamStats&
RTCSentRtpStreamStats::operator=(const RTCSentRtpStreamStats& aOther)
{
  RTCRtpStreamStats::operator=(aOther);
  mBytesSent.Reset();
  if (aOther.mBytesSent.WasPassed()) {
    mBytesSent.Construct(aOther.mBytesSent.Value());
  }
  mPacketsSent.Reset();
  if (aOther.mPacketsSent.WasPassed()) {
    mPacketsSent.Construct(aOther.mPacketsSent.Value());
  }
  return *this;
}



RTCVideoSourceStats::RTCVideoSourceStats()
  : RTCMediaSourceStats(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
RTCVideoSourceStats::InitIds(JSContext* cx, RTCVideoSourceStatsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->width_id.init(cx, "width") ||
      !atomsCache->height_id.init(cx, "height") ||
      !atomsCache->framesPerSecond_id.init(cx, "framesPerSecond") ||
      !atomsCache->frames_id.init(cx, "frames")) {
    return false;
  }
  return true;
}

bool
RTCVideoSourceStats::Init(const char* sourceDescription, bool passedToJSImpl)
{
  // We init the parent's members first
  if (!RTCMediaSourceStats::Init()) {
    return false;
  }

  return true;
}

bool
RTCVideoSourceStats::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  RTCVideoSourceStatsAtoms* atomsCache = GetAtomCache<RTCVideoSourceStatsAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  // Per spec, we define the parent's members first
  if (!RTCMediaSourceStats::ToObjectInternal(cx, rval)) {
    return false;
  }
  JS::Rooted<JSObject*> obj(cx, &rval.toObject());

  if (mFrames.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint32_t const & currentValue = mFrames.InternalValue();
      temp.setNumber(currentValue);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->frames_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mFramesPerSecond.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      double const & currentValue = mFramesPerSecond.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->framesPerSecond_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mHeight.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint32_t const & currentValue = mHeight.InternalValue();
      temp.setNumber(currentValue);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->height_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mWidth.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint32_t const & currentValue = mWidth.InternalValue();
      temp.setNumber(currentValue);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->width_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  return true;
}

void
RTCVideoSourceStats::TraceDictionary(JSTracer* trc)
{
  RTCMediaSourceStats::TraceDictionary(trc);
}

RTCVideoSourceStats&
RTCVideoSourceStats::operator=(const RTCVideoSourceStats& aOther)
{
  RTCMediaSourceStats::operator=(aOther);
  mFrames.Reset();
  if (aOther.mFrames.WasPassed()) {
    mFrames.Construct(aOther.mFrames.Value());
  }
  mFramesPerSecond.Reset();
  if (aOther.mFramesPerSecond.WasPassed()) {
    mFramesPerSecond.Construct(aOther.mFramesPerSecond.Value());
  }
  mHeight.Reset();
  if (aOther.mHeight.WasPassed()) {
    mHeight.Construct(aOther.mHeight.Value());
  }
  mWidth.Reset();
  if (aOther.mWidth.WasPassed()) {
    mWidth.Construct(aOther.mWidth.Value());
  }
  return *this;
}



RTCInboundRtpStreamStats::RTCInboundRtpStreamStats()
  : RTCReceivedRtpStreamStats(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
RTCInboundRtpStreamStats::InitIds(JSContext* cx, RTCInboundRtpStreamStatsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->trackIdentifier_id.init(cx, "trackIdentifier") ||
      !atomsCache->totalSquaredInterFrameDelay_id.init(cx, "totalSquaredInterFrameDelay") ||
      !atomsCache->totalSamplesReceived_id.init(cx, "totalSamplesReceived") ||
      !atomsCache->totalSamplesDuration_id.init(cx, "totalSamplesDuration") ||
      !atomsCache->totalProcessingDelay_id.init(cx, "totalProcessingDelay") ||
      !atomsCache->totalPausesDuration_id.init(cx, "totalPausesDuration") ||
      !atomsCache->totalInterFrameDelay_id.init(cx, "totalInterFrameDelay") ||
      !atomsCache->totalFreezesDuration_id.init(cx, "totalFreezesDuration") ||
      !atomsCache->totalDecodeTime_id.init(cx, "totalDecodeTime") ||
      !atomsCache->totalAudioEnergy_id.init(cx, "totalAudioEnergy") ||
      !atomsCache->totalAssemblyTime_id.init(cx, "totalAssemblyTime") ||
      !atomsCache->silentConcealedSamples_id.init(cx, "silentConcealedSamples") ||
      !atomsCache->removedSamplesForAcceleration_id.init(cx, "removedSamplesForAcceleration") ||
      !atomsCache->remoteId_id.init(cx, "remoteId") ||
      !atomsCache->qpSum_id.init(cx, "qpSum") ||
      !atomsCache->pliCount_id.init(cx, "pliCount") ||
      !atomsCache->pauseCount_id.init(cx, "pauseCount") ||
      !atomsCache->nackCount_id.init(cx, "nackCount") ||
      !atomsCache->mid_id.init(cx, "mid") ||
      !atomsCache->lastPacketReceivedTimestamp_id.init(cx, "lastPacketReceivedTimestamp") ||
      !atomsCache->keyFramesDecoded_id.init(cx, "keyFramesDecoded") ||
      !atomsCache->jitterBufferTargetDelay_id.init(cx, "jitterBufferTargetDelay") ||
      !atomsCache->jitterBufferMinimumDelay_id.init(cx, "jitterBufferMinimumDelay") ||
      !atomsCache->jitterBufferEmittedCount_id.init(cx, "jitterBufferEmittedCount") ||
      !atomsCache->jitterBufferDelay_id.init(cx, "jitterBufferDelay") ||
      !atomsCache->insertedSamplesForDeceleration_id.init(cx, "insertedSamplesForDeceleration") ||
      !atomsCache->headerBytesReceived_id.init(cx, "headerBytesReceived") ||
      !atomsCache->freezeCount_id.init(cx, "freezeCount") ||
      !atomsCache->framesReceived_id.init(cx, "framesReceived") ||
      !atomsCache->framesPerSecond_id.init(cx, "framesPerSecond") ||
      !atomsCache->framesDropped_id.init(cx, "framesDropped") ||
      !atomsCache->framesDecoded_id.init(cx, "framesDecoded") ||
      !atomsCache->framesAssembledFromMultiplePackets_id.init(cx, "framesAssembledFromMultiplePackets") ||
      !atomsCache->frameWidth_id.init(cx, "frameWidth") ||
      !atomsCache->frameHeight_id.init(cx, "frameHeight") ||
      !atomsCache->firCount_id.init(cx, "firCount") ||
      !atomsCache->fecPacketsReceived_id.init(cx, "fecPacketsReceived") ||
      !atomsCache->fecPacketsDiscarded_id.init(cx, "fecPacketsDiscarded") ||
      !atomsCache->estimatedPlayoutTimestamp_id.init(cx, "estimatedPlayoutTimestamp") ||
      !atomsCache->concealmentEvents_id.init(cx, "concealmentEvents") ||
      !atomsCache->concealedSamples_id.init(cx, "concealedSamples") ||
      !atomsCache->bytesReceived_id.init(cx, "bytesReceived") ||
      !atomsCache->audioLevel_id.init(cx, "audioLevel")) {
    return false;
  }
  return true;
}

bool
RTCInboundRtpStreamStats::Init(const char* sourceDescription, bool passedToJSImpl)
{
  // We init the parent's members first
  if (!RTCReceivedRtpStreamStats::Init()) {
    return false;
  }

  return true;
}

bool
RTCInboundRtpStreamStats::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  RTCInboundRtpStreamStatsAtoms* atomsCache = GetAtomCache<RTCInboundRtpStreamStatsAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  // Per spec, we define the parent's members first
  if (!RTCReceivedRtpStreamStats::ToObjectInternal(cx, rval)) {
    return false;
  }
  JS::Rooted<JSObject*> obj(cx, &rval.toObject());

  if (mAudioLevel.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      double const & currentValue = mAudioLevel.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->audioLevel_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mBytesReceived.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint64_t const & currentValue = mBytesReceived.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->bytesReceived_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mConcealedSamples.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint64_t const & currentValue = mConcealedSamples.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->concealedSamples_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mConcealmentEvents.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint64_t const & currentValue = mConcealmentEvents.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->concealmentEvents_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mEstimatedPlayoutTimestamp.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      double const & currentValue = mEstimatedPlayoutTimestamp.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->estimatedPlayoutTimestamp_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mFecPacketsDiscarded.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint64_t const & currentValue = mFecPacketsDiscarded.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->fecPacketsDiscarded_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mFecPacketsReceived.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint64_t const & currentValue = mFecPacketsReceived.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->fecPacketsReceived_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mFirCount.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint32_t const & currentValue = mFirCount.InternalValue();
      temp.setNumber(currentValue);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->firCount_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mFrameHeight.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint32_t const & currentValue = mFrameHeight.InternalValue();
      temp.setNumber(currentValue);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->frameHeight_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mFrameWidth.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint32_t const & currentValue = mFrameWidth.InternalValue();
      temp.setNumber(currentValue);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->frameWidth_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mFramesAssembledFromMultiplePackets.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint32_t const & currentValue = mFramesAssembledFromMultiplePackets.InternalValue();
      temp.setNumber(currentValue);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->framesAssembledFromMultiplePackets_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mFramesDecoded.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint32_t const & currentValue = mFramesDecoded.InternalValue();
      temp.setNumber(currentValue);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->framesDecoded_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mFramesDropped.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint32_t const & currentValue = mFramesDropped.InternalValue();
      temp.setNumber(currentValue);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->framesDropped_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mFramesPerSecond.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      double const & currentValue = mFramesPerSecond.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->framesPerSecond_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mFramesReceived.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint32_t const & currentValue = mFramesReceived.InternalValue();
      temp.setNumber(currentValue);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->framesReceived_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mFreezeCount.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint32_t const & currentValue = mFreezeCount.InternalValue();
      temp.setNumber(currentValue);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->freezeCount_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mHeaderBytesReceived.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint64_t const & currentValue = mHeaderBytesReceived.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->headerBytesReceived_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mInsertedSamplesForDeceleration.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint64_t const & currentValue = mInsertedSamplesForDeceleration.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->insertedSamplesForDeceleration_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mJitterBufferDelay.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      double const & currentValue = mJitterBufferDelay.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->jitterBufferDelay_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mJitterBufferEmittedCount.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint64_t const & currentValue = mJitterBufferEmittedCount.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->jitterBufferEmittedCount_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mJitterBufferMinimumDelay.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      double const & currentValue = mJitterBufferMinimumDelay.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->jitterBufferMinimumDelay_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mJitterBufferTargetDelay.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      double const & currentValue = mJitterBufferTargetDelay.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->jitterBufferTargetDelay_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mKeyFramesDecoded.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint32_t const & currentValue = mKeyFramesDecoded.InternalValue();
      temp.setNumber(currentValue);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->keyFramesDecoded_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mLastPacketReceivedTimestamp.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      double const & currentValue = mLastPacketReceivedTimestamp.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->lastPacketReceivedTimestamp_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mMid.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mMid.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->mid_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mNackCount.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint32_t const & currentValue = mNackCount.InternalValue();
      temp.setNumber(currentValue);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->nackCount_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mPauseCount.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint32_t const & currentValue = mPauseCount.InternalValue();
      temp.setNumber(currentValue);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->pauseCount_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mPliCount.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint32_t const & currentValue = mPliCount.InternalValue();
      temp.setNumber(currentValue);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->pliCount_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mQpSum.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint64_t const & currentValue = mQpSum.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->qpSum_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mRemoteId.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mRemoteId.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->remoteId_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mRemovedSamplesForAcceleration.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint64_t const & currentValue = mRemovedSamplesForAcceleration.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->removedSamplesForAcceleration_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mSilentConcealedSamples.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint64_t const & currentValue = mSilentConcealedSamples.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->silentConcealedSamples_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mTotalAssemblyTime.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      double const & currentValue = mTotalAssemblyTime.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->totalAssemblyTime_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mTotalAudioEnergy.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      double const & currentValue = mTotalAudioEnergy.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->totalAudioEnergy_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mTotalDecodeTime.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      double const & currentValue = mTotalDecodeTime.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->totalDecodeTime_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mTotalFreezesDuration.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      double const & currentValue = mTotalFreezesDuration.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->totalFreezesDuration_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mTotalInterFrameDelay.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      double const & currentValue = mTotalInterFrameDelay.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->totalInterFrameDelay_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mTotalPausesDuration.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      double const & currentValue = mTotalPausesDuration.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->totalPausesDuration_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mTotalProcessingDelay.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      double const & currentValue = mTotalProcessingDelay.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->totalProcessingDelay_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mTotalSamplesDuration.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      double const & currentValue = mTotalSamplesDuration.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->totalSamplesDuration_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mTotalSamplesReceived.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint64_t const & currentValue = mTotalSamplesReceived.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->totalSamplesReceived_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mTotalSquaredInterFrameDelay.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      double const & currentValue = mTotalSquaredInterFrameDelay.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->totalSquaredInterFrameDelay_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mTrackIdentifier;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->trackIdentifier_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
RTCInboundRtpStreamStats::TraceDictionary(JSTracer* trc)
{
  RTCReceivedRtpStreamStats::TraceDictionary(trc);
}

RTCInboundRtpStreamStats&
RTCInboundRtpStreamStats::operator=(const RTCInboundRtpStreamStats& aOther)
{
  RTCReceivedRtpStreamStats::operator=(aOther);
  mAudioLevel.Reset();
  if (aOther.mAudioLevel.WasPassed()) {
    mAudioLevel.Construct(aOther.mAudioLevel.Value());
  }
  mBytesReceived.Reset();
  if (aOther.mBytesReceived.WasPassed()) {
    mBytesReceived.Construct(aOther.mBytesReceived.Value());
  }
  mConcealedSamples.Reset();
  if (aOther.mConcealedSamples.WasPassed()) {
    mConcealedSamples.Construct(aOther.mConcealedSamples.Value());
  }
  mConcealmentEvents.Reset();
  if (aOther.mConcealmentEvents.WasPassed()) {
    mConcealmentEvents.Construct(aOther.mConcealmentEvents.Value());
  }
  mEstimatedPlayoutTimestamp.Reset();
  if (aOther.mEstimatedPlayoutTimestamp.WasPassed()) {
    mEstimatedPlayoutTimestamp.Construct(aOther.mEstimatedPlayoutTimestamp.Value());
  }
  mFecPacketsDiscarded.Reset();
  if (aOther.mFecPacketsDiscarded.WasPassed()) {
    mFecPacketsDiscarded.Construct(aOther.mFecPacketsDiscarded.Value());
  }
  mFecPacketsReceived.Reset();
  if (aOther.mFecPacketsReceived.WasPassed()) {
    mFecPacketsReceived.Construct(aOther.mFecPacketsReceived.Value());
  }
  mFirCount.Reset();
  if (aOther.mFirCount.WasPassed()) {
    mFirCount.Construct(aOther.mFirCount.Value());
  }
  mFrameHeight.Reset();
  if (aOther.mFrameHeight.WasPassed()) {
    mFrameHeight.Construct(aOther.mFrameHeight.Value());
  }
  mFrameWidth.Reset();
  if (aOther.mFrameWidth.WasPassed()) {
    mFrameWidth.Construct(aOther.mFrameWidth.Value());
  }
  mFramesAssembledFromMultiplePackets.Reset();
  if (aOther.mFramesAssembledFromMultiplePackets.WasPassed()) {
    mFramesAssembledFromMultiplePackets.Construct(aOther.mFramesAssembledFromMultiplePackets.Value());
  }
  mFramesDecoded.Reset();
  if (aOther.mFramesDecoded.WasPassed()) {
    mFramesDecoded.Construct(aOther.mFramesDecoded.Value());
  }
  mFramesDropped.Reset();
  if (aOther.mFramesDropped.WasPassed()) {
    mFramesDropped.Construct(aOther.mFramesDropped.Value());
  }
  mFramesPerSecond.Reset();
  if (aOther.mFramesPerSecond.WasPassed()) {
    mFramesPerSecond.Construct(aOther.mFramesPerSecond.Value());
  }
  mFramesReceived.Reset();
  if (aOther.mFramesReceived.WasPassed()) {
    mFramesReceived.Construct(aOther.mFramesReceived.Value());
  }
  mFreezeCount.Reset();
  if (aOther.mFreezeCount.WasPassed()) {
    mFreezeCount.Construct(aOther.mFreezeCount.Value());
  }
  mHeaderBytesReceived.Reset();
  if (aOther.mHeaderBytesReceived.WasPassed()) {
    mHeaderBytesReceived.Construct(aOther.mHeaderBytesReceived.Value());
  }
  mInsertedSamplesForDeceleration.Reset();
  if (aOther.mInsertedSamplesForDeceleration.WasPassed()) {
    mInsertedSamplesForDeceleration.Construct(aOther.mInsertedSamplesForDeceleration.Value());
  }
  mJitterBufferDelay.Reset();
  if (aOther.mJitterBufferDelay.WasPassed()) {
    mJitterBufferDelay.Construct(aOther.mJitterBufferDelay.Value());
  }
  mJitterBufferEmittedCount.Reset();
  if (aOther.mJitterBufferEmittedCount.WasPassed()) {
    mJitterBufferEmittedCount.Construct(aOther.mJitterBufferEmittedCount.Value());
  }
  mJitterBufferMinimumDelay.Reset();
  if (aOther.mJitterBufferMinimumDelay.WasPassed()) {
    mJitterBufferMinimumDelay.Construct(aOther.mJitterBufferMinimumDelay.Value());
  }
  mJitterBufferTargetDelay.Reset();
  if (aOther.mJitterBufferTargetDelay.WasPassed()) {
    mJitterBufferTargetDelay.Construct(aOther.mJitterBufferTargetDelay.Value());
  }
  mKeyFramesDecoded.Reset();
  if (aOther.mKeyFramesDecoded.WasPassed()) {
    mKeyFramesDecoded.Construct(aOther.mKeyFramesDecoded.Value());
  }
  mLastPacketReceivedTimestamp.Reset();
  if (aOther.mLastPacketReceivedTimestamp.WasPassed()) {
    mLastPacketReceivedTimestamp.Construct(aOther.mLastPacketReceivedTimestamp.Value());
  }
  mMid.Reset();
  if (aOther.mMid.WasPassed()) {
    mMid.Construct(aOther.mMid.Value());
  }
  mNackCount.Reset();
  if (aOther.mNackCount.WasPassed()) {
    mNackCount.Construct(aOther.mNackCount.Value());
  }
  mPauseCount.Reset();
  if (aOther.mPauseCount.WasPassed()) {
    mPauseCount.Construct(aOther.mPauseCount.Value());
  }
  mPliCount.Reset();
  if (aOther.mPliCount.WasPassed()) {
    mPliCount.Construct(aOther.mPliCount.Value());
  }
  mQpSum.Reset();
  if (aOther.mQpSum.WasPassed()) {
    mQpSum.Construct(aOther.mQpSum.Value());
  }
  mRemoteId.Reset();
  if (aOther.mRemoteId.WasPassed()) {
    mRemoteId.Construct(aOther.mRemoteId.Value());
  }
  mRemovedSamplesForAcceleration.Reset();
  if (aOther.mRemovedSamplesForAcceleration.WasPassed()) {
    mRemovedSamplesForAcceleration.Construct(aOther.mRemovedSamplesForAcceleration.Value());
  }
  mSilentConcealedSamples.Reset();
  if (aOther.mSilentConcealedSamples.WasPassed()) {
    mSilentConcealedSamples.Construct(aOther.mSilentConcealedSamples.Value());
  }
  mTotalAssemblyTime.Reset();
  if (aOther.mTotalAssemblyTime.WasPassed()) {
    mTotalAssemblyTime.Construct(aOther.mTotalAssemblyTime.Value());
  }
  mTotalAudioEnergy.Reset();
  if (aOther.mTotalAudioEnergy.WasPassed()) {
    mTotalAudioEnergy.Construct(aOther.mTotalAudioEnergy.Value());
  }
  mTotalDecodeTime.Reset();
  if (aOther.mTotalDecodeTime.WasPassed()) {
    mTotalDecodeTime.Construct(aOther.mTotalDecodeTime.Value());
  }
  mTotalFreezesDuration.Reset();
  if (aOther.mTotalFreezesDuration.WasPassed()) {
    mTotalFreezesDuration.Construct(aOther.mTotalFreezesDuration.Value());
  }
  mTotalInterFrameDelay.Reset();
  if (aOther.mTotalInterFrameDelay.WasPassed()) {
    mTotalInterFrameDelay.Construct(aOther.mTotalInterFrameDelay.Value());
  }
  mTotalPausesDuration.Reset();
  if (aOther.mTotalPausesDuration.WasPassed()) {
    mTotalPausesDuration.Construct(aOther.mTotalPausesDuration.Value());
  }
  mTotalProcessingDelay.Reset();
  if (aOther.mTotalProcessingDelay.WasPassed()) {
    mTotalProcessingDelay.Construct(aOther.mTotalProcessingDelay.Value());
  }
  mTotalSamplesDuration.Reset();
  if (aOther.mTotalSamplesDuration.WasPassed()) {
    mTotalSamplesDuration.Construct(aOther.mTotalSamplesDuration.Value());
  }
  mTotalSamplesReceived.Reset();
  if (aOther.mTotalSamplesReceived.WasPassed()) {
    mTotalSamplesReceived.Construct(aOther.mTotalSamplesReceived.Value());
  }
  mTotalSquaredInterFrameDelay.Reset();
  if (aOther.mTotalSquaredInterFrameDelay.WasPassed()) {
    mTotalSquaredInterFrameDelay.Construct(aOther.mTotalSquaredInterFrameDelay.Value());
  }
  mTrackIdentifier = aOther.mTrackIdentifier;
  return *this;
}



RTCOutboundRtpStreamStats::RTCOutboundRtpStreamStats()
  : RTCSentRtpStreamStats(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
RTCOutboundRtpStreamStats::InitIds(JSContext* cx, RTCOutboundRtpStreamStatsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->totalEncodedBytesTarget_id.init(cx, "totalEncodedBytesTarget") ||
      !atomsCache->totalEncodeTime_id.init(cx, "totalEncodeTime") ||
      !atomsCache->rid_id.init(cx, "rid") ||
      !atomsCache->retransmittedPacketsSent_id.init(cx, "retransmittedPacketsSent") ||
      !atomsCache->retransmittedBytesSent_id.init(cx, "retransmittedBytesSent") ||
      !atomsCache->remoteId_id.init(cx, "remoteId") ||
      !atomsCache->qpSum_id.init(cx, "qpSum") ||
      !atomsCache->pliCount_id.init(cx, "pliCount") ||
      !atomsCache->nackCount_id.init(cx, "nackCount") ||
      !atomsCache->mid_id.init(cx, "mid") ||
      !atomsCache->hugeFramesSent_id.init(cx, "hugeFramesSent") ||
      !atomsCache->headerBytesSent_id.init(cx, "headerBytesSent") ||
      !atomsCache->framesSent_id.init(cx, "framesSent") ||
      !atomsCache->framesPerSecond_id.init(cx, "framesPerSecond") ||
      !atomsCache->framesEncoded_id.init(cx, "framesEncoded") ||
      !atomsCache->frameWidth_id.init(cx, "frameWidth") ||
      !atomsCache->frameHeight_id.init(cx, "frameHeight") ||
      !atomsCache->firCount_id.init(cx, "firCount")) {
    return false;
  }
  return true;
}

bool
RTCOutboundRtpStreamStats::Init(const char* sourceDescription, bool passedToJSImpl)
{
  // We init the parent's members first
  if (!RTCSentRtpStreamStats::Init()) {
    return false;
  }

  return true;
}

bool
RTCOutboundRtpStreamStats::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  RTCOutboundRtpStreamStatsAtoms* atomsCache = GetAtomCache<RTCOutboundRtpStreamStatsAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  // Per spec, we define the parent's members first
  if (!RTCSentRtpStreamStats::ToObjectInternal(cx, rval)) {
    return false;
  }
  JS::Rooted<JSObject*> obj(cx, &rval.toObject());

  if (mFirCount.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint32_t const & currentValue = mFirCount.InternalValue();
      temp.setNumber(currentValue);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->firCount_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mFrameHeight.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint32_t const & currentValue = mFrameHeight.InternalValue();
      temp.setNumber(currentValue);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->frameHeight_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mFrameWidth.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint32_t const & currentValue = mFrameWidth.InternalValue();
      temp.setNumber(currentValue);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->frameWidth_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mFramesEncoded.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint32_t const & currentValue = mFramesEncoded.InternalValue();
      temp.setNumber(currentValue);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->framesEncoded_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mFramesPerSecond.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      double const & currentValue = mFramesPerSecond.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->framesPerSecond_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mFramesSent.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint32_t const & currentValue = mFramesSent.InternalValue();
      temp.setNumber(currentValue);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->framesSent_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mHeaderBytesSent.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint64_t const & currentValue = mHeaderBytesSent.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->headerBytesSent_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mHugeFramesSent.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint32_t const & currentValue = mHugeFramesSent.InternalValue();
      temp.setNumber(currentValue);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->hugeFramesSent_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mMid.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mMid.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->mid_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mNackCount.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint32_t const & currentValue = mNackCount.InternalValue();
      temp.setNumber(currentValue);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->nackCount_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mPliCount.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint32_t const & currentValue = mPliCount.InternalValue();
      temp.setNumber(currentValue);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->pliCount_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mQpSum.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint64_t const & currentValue = mQpSum.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->qpSum_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mRemoteId.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mRemoteId.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->remoteId_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mRetransmittedBytesSent.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint64_t const & currentValue = mRetransmittedBytesSent.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->retransmittedBytesSent_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mRetransmittedPacketsSent.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint64_t const & currentValue = mRetransmittedPacketsSent.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->retransmittedPacketsSent_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mRid.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mRid.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->rid_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mTotalEncodeTime.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      double const & currentValue = mTotalEncodeTime.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->totalEncodeTime_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mTotalEncodedBytesTarget.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint64_t const & currentValue = mTotalEncodedBytesTarget.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->totalEncodedBytesTarget_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  return true;
}

void
RTCOutboundRtpStreamStats::TraceDictionary(JSTracer* trc)
{
  RTCSentRtpStreamStats::TraceDictionary(trc);
}

RTCOutboundRtpStreamStats&
RTCOutboundRtpStreamStats::operator=(const RTCOutboundRtpStreamStats& aOther)
{
  RTCSentRtpStreamStats::operator=(aOther);
  mFirCount.Reset();
  if (aOther.mFirCount.WasPassed()) {
    mFirCount.Construct(aOther.mFirCount.Value());
  }
  mFrameHeight.Reset();
  if (aOther.mFrameHeight.WasPassed()) {
    mFrameHeight.Construct(aOther.mFrameHeight.Value());
  }
  mFrameWidth.Reset();
  if (aOther.mFrameWidth.WasPassed()) {
    mFrameWidth.Construct(aOther.mFrameWidth.Value());
  }
  mFramesEncoded.Reset();
  if (aOther.mFramesEncoded.WasPassed()) {
    mFramesEncoded.Construct(aOther.mFramesEncoded.Value());
  }
  mFramesPerSecond.Reset();
  if (aOther.mFramesPerSecond.WasPassed()) {
    mFramesPerSecond.Construct(aOther.mFramesPerSecond.Value());
  }
  mFramesSent.Reset();
  if (aOther.mFramesSent.WasPassed()) {
    mFramesSent.Construct(aOther.mFramesSent.Value());
  }
  mHeaderBytesSent.Reset();
  if (aOther.mHeaderBytesSent.WasPassed()) {
    mHeaderBytesSent.Construct(aOther.mHeaderBytesSent.Value());
  }
  mHugeFramesSent.Reset();
  if (aOther.mHugeFramesSent.WasPassed()) {
    mHugeFramesSent.Construct(aOther.mHugeFramesSent.Value());
  }
  mMid.Reset();
  if (aOther.mMid.WasPassed()) {
    mMid.Construct(aOther.mMid.Value());
  }
  mNackCount.Reset();
  if (aOther.mNackCount.WasPassed()) {
    mNackCount.Construct(aOther.mNackCount.Value());
  }
  mPliCount.Reset();
  if (aOther.mPliCount.WasPassed()) {
    mPliCount.Construct(aOther.mPliCount.Value());
  }
  mQpSum.Reset();
  if (aOther.mQpSum.WasPassed()) {
    mQpSum.Construct(aOther.mQpSum.Value());
  }
  mRemoteId.Reset();
  if (aOther.mRemoteId.WasPassed()) {
    mRemoteId.Construct(aOther.mRemoteId.Value());
  }
  mRetransmittedBytesSent.Reset();
  if (aOther.mRetransmittedBytesSent.WasPassed()) {
    mRetransmittedBytesSent.Construct(aOther.mRetransmittedBytesSent.Value());
  }
  mRetransmittedPacketsSent.Reset();
  if (aOther.mRetransmittedPacketsSent.WasPassed()) {
    mRetransmittedPacketsSent.Construct(aOther.mRetransmittedPacketsSent.Value());
  }
  mRid.Reset();
  if (aOther.mRid.WasPassed()) {
    mRid.Construct(aOther.mRid.Value());
  }
  mTotalEncodeTime.Reset();
  if (aOther.mTotalEncodeTime.WasPassed()) {
    mTotalEncodeTime.Construct(aOther.mTotalEncodeTime.Value());
  }
  mTotalEncodedBytesTarget.Reset();
  if (aOther.mTotalEncodedBytesTarget.WasPassed()) {
    mTotalEncodedBytesTarget.Construct(aOther.mTotalEncodedBytesTarget.Value());
  }
  return *this;
}



RTCRemoteInboundRtpStreamStats::RTCRemoteInboundRtpStreamStats()
  : RTCReceivedRtpStreamStats(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
RTCRemoteInboundRtpStreamStats::InitIds(JSContext* cx, RTCRemoteInboundRtpStreamStatsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->totalRoundTripTime_id.init(cx, "totalRoundTripTime") ||
      !atomsCache->roundTripTimeMeasurements_id.init(cx, "roundTripTimeMeasurements") ||
      !atomsCache->roundTripTime_id.init(cx, "roundTripTime") ||
      !atomsCache->localId_id.init(cx, "localId") ||
      !atomsCache->fractionLost_id.init(cx, "fractionLost")) {
    return false;
  }
  return true;
}

bool
RTCRemoteInboundRtpStreamStats::Init(const char* sourceDescription, bool passedToJSImpl)
{
  // We init the parent's members first
  if (!RTCReceivedRtpStreamStats::Init()) {
    return false;
  }

  return true;
}

bool
RTCRemoteInboundRtpStreamStats::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  RTCRemoteInboundRtpStreamStatsAtoms* atomsCache = GetAtomCache<RTCRemoteInboundRtpStreamStatsAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  // Per spec, we define the parent's members first
  if (!RTCReceivedRtpStreamStats::ToObjectInternal(cx, rval)) {
    return false;
  }
  JS::Rooted<JSObject*> obj(cx, &rval.toObject());

  if (mFractionLost.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      double const & currentValue = mFractionLost.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->fractionLost_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mLocalId.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mLocalId.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->localId_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mRoundTripTime.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      double const & currentValue = mRoundTripTime.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->roundTripTime_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mRoundTripTimeMeasurements.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint64_t const & currentValue = mRoundTripTimeMeasurements.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->roundTripTimeMeasurements_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mTotalRoundTripTime.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      double const & currentValue = mTotalRoundTripTime.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->totalRoundTripTime_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  return true;
}

void
RTCRemoteInboundRtpStreamStats::TraceDictionary(JSTracer* trc)
{
  RTCReceivedRtpStreamStats::TraceDictionary(trc);
}

RTCRemoteInboundRtpStreamStats&
RTCRemoteInboundRtpStreamStats::operator=(const RTCRemoteInboundRtpStreamStats& aOther)
{
  RTCReceivedRtpStreamStats::operator=(aOther);
  mFractionLost.Reset();
  if (aOther.mFractionLost.WasPassed()) {
    mFractionLost.Construct(aOther.mFractionLost.Value());
  }
  mLocalId.Reset();
  if (aOther.mLocalId.WasPassed()) {
    mLocalId.Construct(aOther.mLocalId.Value());
  }
  mRoundTripTime.Reset();
  if (aOther.mRoundTripTime.WasPassed()) {
    mRoundTripTime.Construct(aOther.mRoundTripTime.Value());
  }
  mRoundTripTimeMeasurements.Reset();
  if (aOther.mRoundTripTimeMeasurements.WasPassed()) {
    mRoundTripTimeMeasurements.Construct(aOther.mRoundTripTimeMeasurements.Value());
  }
  mTotalRoundTripTime.Reset();
  if (aOther.mTotalRoundTripTime.WasPassed()) {
    mTotalRoundTripTime.Construct(aOther.mTotalRoundTripTime.Value());
  }
  return *this;
}



RTCRemoteOutboundRtpStreamStats::RTCRemoteOutboundRtpStreamStats()
  : RTCSentRtpStreamStats(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
RTCRemoteOutboundRtpStreamStats::InitIds(JSContext* cx, RTCRemoteOutboundRtpStreamStatsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->remoteTimestamp_id.init(cx, "remoteTimestamp") ||
      !atomsCache->localId_id.init(cx, "localId")) {
    return false;
  }
  return true;
}

bool
RTCRemoteOutboundRtpStreamStats::Init(const char* sourceDescription, bool passedToJSImpl)
{
  // We init the parent's members first
  if (!RTCSentRtpStreamStats::Init()) {
    return false;
  }

  return true;
}

bool
RTCRemoteOutboundRtpStreamStats::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  RTCRemoteOutboundRtpStreamStatsAtoms* atomsCache = GetAtomCache<RTCRemoteOutboundRtpStreamStatsAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  // Per spec, we define the parent's members first
  if (!RTCSentRtpStreamStats::ToObjectInternal(cx, rval)) {
    return false;
  }
  JS::Rooted<JSObject*> obj(cx, &rval.toObject());

  if (mLocalId.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mLocalId.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->localId_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mRemoteTimestamp.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      double const & currentValue = mRemoteTimestamp.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->remoteTimestamp_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  return true;
}

void
RTCRemoteOutboundRtpStreamStats::TraceDictionary(JSTracer* trc)
{
  RTCSentRtpStreamStats::TraceDictionary(trc);
}

RTCRemoteOutboundRtpStreamStats&
RTCRemoteOutboundRtpStreamStats::operator=(const RTCRemoteOutboundRtpStreamStats& aOther)
{
  RTCSentRtpStreamStats::operator=(aOther);
  mLocalId.Reset();
  if (aOther.mLocalId.WasPassed()) {
    mLocalId.Construct(aOther.mLocalId.Value());
  }
  mRemoteTimestamp.Reset();
  if (aOther.mRemoteTimestamp.WasPassed()) {
    mRemoteTimestamp.Construct(aOther.mRemoteTimestamp.Value());
  }
  return *this;
}



RTCStatsCollection::RTCStatsCollection()
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
RTCStatsCollection::InitIds(JSContext* cx, RTCStatsCollectionAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->videoSourceStats_id.init(cx, "videoSourceStats") ||
      !atomsCache->videoFrameHistories_id.init(cx, "videoFrameHistories") ||
      !atomsCache->trickledIceCandidateStats_id.init(cx, "trickledIceCandidateStats") ||
      !atomsCache->rtpContributingSourceStats_id.init(cx, "rtpContributingSourceStats") ||
      !atomsCache->remoteOutboundRtpStreamStats_id.init(cx, "remoteOutboundRtpStreamStats") ||
      !atomsCache->remoteInboundRtpStreamStats_id.init(cx, "remoteInboundRtpStreamStats") ||
      !atomsCache->rawRemoteCandidates_id.init(cx, "rawRemoteCandidates") ||
      !atomsCache->rawLocalCandidates_id.init(cx, "rawLocalCandidates") ||
      !atomsCache->peerConnectionStats_id.init(cx, "peerConnectionStats") ||
      !atomsCache->outboundRtpStreamStats_id.init(cx, "outboundRtpStreamStats") ||
      !atomsCache->mediaSourceStats_id.init(cx, "mediaSourceStats") ||
      !atomsCache->inboundRtpStreamStats_id.init(cx, "inboundRtpStreamStats") ||
      !atomsCache->iceCandidateStats_id.init(cx, "iceCandidateStats") ||
      !atomsCache->iceCandidatePairStats_id.init(cx, "iceCandidatePairStats") ||
      !atomsCache->dataChannelStats_id.init(cx, "dataChannelStats") ||
      !atomsCache->codecStats_id.init(cx, "codecStats") ||
      !atomsCache->bandwidthEstimations_id.init(cx, "bandwidthEstimations")) {
    return false;
  }
  return true;
}

bool
RTCStatsCollection::Init(const char* sourceDescription, bool passedToJSImpl)
{
  {
    // scope for any temporaries our default value setting needs.
    /* mBandwidthEstimations array is already empty; nothing to do */
  }
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    /* mCodecStats array is already empty; nothing to do */
  }
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    /* mDataChannelStats array is already empty; nothing to do */
  }
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    /* mIceCandidatePairStats array is already empty; nothing to do */
  }
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    /* mIceCandidateStats array is already empty; nothing to do */
  }
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    /* mInboundRtpStreamStats array is already empty; nothing to do */
  }
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    /* mMediaSourceStats array is already empty; nothing to do */
  }
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    /* mOutboundRtpStreamStats array is already empty; nothing to do */
  }
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    /* mPeerConnectionStats array is already empty; nothing to do */
  }
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    /* mRawLocalCandidates array is already empty; nothing to do */
  }
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    /* mRawRemoteCandidates array is already empty; nothing to do */
  }
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    /* mRemoteInboundRtpStreamStats array is already empty; nothing to do */
  }
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    /* mRemoteOutboundRtpStreamStats array is already empty; nothing to do */
  }
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    /* mRtpContributingSourceStats array is already empty; nothing to do */
  }
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    /* mTrickledIceCandidateStats array is already empty; nothing to do */
  }
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    /* mVideoFrameHistories array is already empty; nothing to do */
  }
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    /* mVideoSourceStats array is already empty; nothing to do */
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
RTCStatsCollection::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  RTCStatsCollectionAtoms* atomsCache = GetAtomCache<RTCStatsCollectionAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    Sequence<RTCBandwidthEstimationInternal> const & currentValue = mBandwidthEstimations;

    uint32_t length = currentValue.Length();
    JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
    if (!returnArray) {
      return false;
    }
    // Scope for 'tmp'
    {
      JS::Rooted<JS::Value> tmp(cx);
      for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
        // Control block to let us common up the JS_DefineElement calls when there
        // are different ways to succeed at wrapping the object.
        do {
          if (!currentValue[sequenceIdx0].ToObjectInternal(cx, &tmp)) {
            return false;
          }
          break;
        } while (false);
        if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                              JSPROP_ENUMERATE)) {
          return false;
        }
      }
    }
    temp.setObject(*returnArray);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->bandwidthEstimations_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    Sequence<RTCCodecStats> const & currentValue = mCodecStats;

    uint32_t length = currentValue.Length();
    JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
    if (!returnArray) {
      return false;
    }
    // Scope for 'tmp'
    {
      JS::Rooted<JS::Value> tmp(cx);
      for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
        // Control block to let us common up the JS_DefineElement calls when there
        // are different ways to succeed at wrapping the object.
        do {
          if (!currentValue[sequenceIdx0].ToObjectInternal(cx, &tmp)) {
            return false;
          }
          break;
        } while (false);
        if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                              JSPROP_ENUMERATE)) {
          return false;
        }
      }
    }
    temp.setObject(*returnArray);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->codecStats_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    Sequence<RTCDataChannelStats> const & currentValue = mDataChannelStats;

    uint32_t length = currentValue.Length();
    JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
    if (!returnArray) {
      return false;
    }
    // Scope for 'tmp'
    {
      JS::Rooted<JS::Value> tmp(cx);
      for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
        // Control block to let us common up the JS_DefineElement calls when there
        // are different ways to succeed at wrapping the object.
        do {
          if (!currentValue[sequenceIdx0].ToObjectInternal(cx, &tmp)) {
            return false;
          }
          break;
        } while (false);
        if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                              JSPROP_ENUMERATE)) {
          return false;
        }
      }
    }
    temp.setObject(*returnArray);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->dataChannelStats_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    Sequence<RTCIceCandidatePairStats> const & currentValue = mIceCandidatePairStats;

    uint32_t length = currentValue.Length();
    JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
    if (!returnArray) {
      return false;
    }
    // Scope for 'tmp'
    {
      JS::Rooted<JS::Value> tmp(cx);
      for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
        // Control block to let us common up the JS_DefineElement calls when there
        // are different ways to succeed at wrapping the object.
        do {
          if (!currentValue[sequenceIdx0].ToObjectInternal(cx, &tmp)) {
            return false;
          }
          break;
        } while (false);
        if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                              JSPROP_ENUMERATE)) {
          return false;
        }
      }
    }
    temp.setObject(*returnArray);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->iceCandidatePairStats_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    Sequence<RTCIceCandidateStats> const & currentValue = mIceCandidateStats;

    uint32_t length = currentValue.Length();
    JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
    if (!returnArray) {
      return false;
    }
    // Scope for 'tmp'
    {
      JS::Rooted<JS::Value> tmp(cx);
      for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
        // Control block to let us common up the JS_DefineElement calls when there
        // are different ways to succeed at wrapping the object.
        do {
          if (!currentValue[sequenceIdx0].ToObjectInternal(cx, &tmp)) {
            return false;
          }
          break;
        } while (false);
        if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                              JSPROP_ENUMERATE)) {
          return false;
        }
      }
    }
    temp.setObject(*returnArray);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->iceCandidateStats_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    Sequence<RTCInboundRtpStreamStats> const & currentValue = mInboundRtpStreamStats;

    uint32_t length = currentValue.Length();
    JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
    if (!returnArray) {
      return false;
    }
    // Scope for 'tmp'
    {
      JS::Rooted<JS::Value> tmp(cx);
      for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
        // Control block to let us common up the JS_DefineElement calls when there
        // are different ways to succeed at wrapping the object.
        do {
          if (!currentValue[sequenceIdx0].ToObjectInternal(cx, &tmp)) {
            return false;
          }
          break;
        } while (false);
        if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                              JSPROP_ENUMERATE)) {
          return false;
        }
      }
    }
    temp.setObject(*returnArray);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->inboundRtpStreamStats_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    Sequence<RTCMediaSourceStats> const & currentValue = mMediaSourceStats;

    uint32_t length = currentValue.Length();
    JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
    if (!returnArray) {
      return false;
    }
    // Scope for 'tmp'
    {
      JS::Rooted<JS::Value> tmp(cx);
      for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
        // Control block to let us common up the JS_DefineElement calls when there
        // are different ways to succeed at wrapping the object.
        do {
          if (!currentValue[sequenceIdx0].ToObjectInternal(cx, &tmp)) {
            return false;
          }
          break;
        } while (false);
        if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                              JSPROP_ENUMERATE)) {
          return false;
        }
      }
    }
    temp.setObject(*returnArray);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->mediaSourceStats_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    Sequence<RTCOutboundRtpStreamStats> const & currentValue = mOutboundRtpStreamStats;

    uint32_t length = currentValue.Length();
    JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
    if (!returnArray) {
      return false;
    }
    // Scope for 'tmp'
    {
      JS::Rooted<JS::Value> tmp(cx);
      for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
        // Control block to let us common up the JS_DefineElement calls when there
        // are different ways to succeed at wrapping the object.
        do {
          if (!currentValue[sequenceIdx0].ToObjectInternal(cx, &tmp)) {
            return false;
          }
          break;
        } while (false);
        if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                              JSPROP_ENUMERATE)) {
          return false;
        }
      }
    }
    temp.setObject(*returnArray);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->outboundRtpStreamStats_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    Sequence<RTCPeerConnectionStats> const & currentValue = mPeerConnectionStats;

    uint32_t length = currentValue.Length();
    JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
    if (!returnArray) {
      return false;
    }
    // Scope for 'tmp'
    {
      JS::Rooted<JS::Value> tmp(cx);
      for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
        // Control block to let us common up the JS_DefineElement calls when there
        // are different ways to succeed at wrapping the object.
        do {
          if (!currentValue[sequenceIdx0].ToObjectInternal(cx, &tmp)) {
            return false;
          }
          break;
        } while (false);
        if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                              JSPROP_ENUMERATE)) {
          return false;
        }
      }
    }
    temp.setObject(*returnArray);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->peerConnectionStats_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    Sequence<nsString> const & currentValue = mRawLocalCandidates;

    uint32_t length = currentValue.Length();
    JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
    if (!returnArray) {
      return false;
    }
    // Scope for 'tmp'
    {
      JS::Rooted<JS::Value> tmp(cx);
      for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
        // Control block to let us common up the JS_DefineElement calls when there
        // are different ways to succeed at wrapping the object.
        do {
          if (!xpc::NonVoidStringToJsval(cx, currentValue[sequenceIdx0], &tmp)) {
            return false;
          }
          break;
        } while (false);
        if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                              JSPROP_ENUMERATE)) {
          return false;
        }
      }
    }
    temp.setObject(*returnArray);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->rawLocalCandidates_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    Sequence<nsString> const & currentValue = mRawRemoteCandidates;

    uint32_t length = currentValue.Length();
    JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
    if (!returnArray) {
      return false;
    }
    // Scope for 'tmp'
    {
      JS::Rooted<JS::Value> tmp(cx);
      for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
        // Control block to let us common up the JS_DefineElement calls when there
        // are different ways to succeed at wrapping the object.
        do {
          if (!xpc::NonVoidStringToJsval(cx, currentValue[sequenceIdx0], &tmp)) {
            return false;
          }
          break;
        } while (false);
        if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                              JSPROP_ENUMERATE)) {
          return false;
        }
      }
    }
    temp.setObject(*returnArray);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->rawRemoteCandidates_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    Sequence<RTCRemoteInboundRtpStreamStats> const & currentValue = mRemoteInboundRtpStreamStats;

    uint32_t length = currentValue.Length();
    JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
    if (!returnArray) {
      return false;
    }
    // Scope for 'tmp'
    {
      JS::Rooted<JS::Value> tmp(cx);
      for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
        // Control block to let us common up the JS_DefineElement calls when there
        // are different ways to succeed at wrapping the object.
        do {
          if (!currentValue[sequenceIdx0].ToObjectInternal(cx, &tmp)) {
            return false;
          }
          break;
        } while (false);
        if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                              JSPROP_ENUMERATE)) {
          return false;
        }
      }
    }
    temp.setObject(*returnArray);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->remoteInboundRtpStreamStats_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    Sequence<RTCRemoteOutboundRtpStreamStats> const & currentValue = mRemoteOutboundRtpStreamStats;

    uint32_t length = currentValue.Length();
    JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
    if (!returnArray) {
      return false;
    }
    // Scope for 'tmp'
    {
      JS::Rooted<JS::Value> tmp(cx);
      for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
        // Control block to let us common up the JS_DefineElement calls when there
        // are different ways to succeed at wrapping the object.
        do {
          if (!currentValue[sequenceIdx0].ToObjectInternal(cx, &tmp)) {
            return false;
          }
          break;
        } while (false);
        if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                              JSPROP_ENUMERATE)) {
          return false;
        }
      }
    }
    temp.setObject(*returnArray);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->remoteOutboundRtpStreamStats_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    Sequence<RTCRTPContributingSourceStats> const & currentValue = mRtpContributingSourceStats;

    uint32_t length = currentValue.Length();
    JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
    if (!returnArray) {
      return false;
    }
    // Scope for 'tmp'
    {
      JS::Rooted<JS::Value> tmp(cx);
      for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
        // Control block to let us common up the JS_DefineElement calls when there
        // are different ways to succeed at wrapping the object.
        do {
          if (!currentValue[sequenceIdx0].ToObjectInternal(cx, &tmp)) {
            return false;
          }
          break;
        } while (false);
        if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                              JSPROP_ENUMERATE)) {
          return false;
        }
      }
    }
    temp.setObject(*returnArray);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->rtpContributingSourceStats_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    Sequence<RTCIceCandidateStats> const & currentValue = mTrickledIceCandidateStats;

    uint32_t length = currentValue.Length();
    JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
    if (!returnArray) {
      return false;
    }
    // Scope for 'tmp'
    {
      JS::Rooted<JS::Value> tmp(cx);
      for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
        // Control block to let us common up the JS_DefineElement calls when there
        // are different ways to succeed at wrapping the object.
        do {
          if (!currentValue[sequenceIdx0].ToObjectInternal(cx, &tmp)) {
            return false;
          }
          break;
        } while (false);
        if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                              JSPROP_ENUMERATE)) {
          return false;
        }
      }
    }
    temp.setObject(*returnArray);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->trickledIceCandidateStats_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    Sequence<RTCVideoFrameHistoryInternal> const & currentValue = mVideoFrameHistories;

    uint32_t length = currentValue.Length();
    JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
    if (!returnArray) {
      return false;
    }
    // Scope for 'tmp'
    {
      JS::Rooted<JS::Value> tmp(cx);
      for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
        // Control block to let us common up the JS_DefineElement calls when there
        // are different ways to succeed at wrapping the object.
        do {
          if (!currentValue[sequenceIdx0].ToObjectInternal(cx, &tmp)) {
            return false;
          }
          break;
        } while (false);
        if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                              JSPROP_ENUMERATE)) {
          return false;
        }
      }
    }
    temp.setObject(*returnArray);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->videoFrameHistories_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    Sequence<RTCVideoSourceStats> const & currentValue = mVideoSourceStats;

    uint32_t length = currentValue.Length();
    JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
    if (!returnArray) {
      return false;
    }
    // Scope for 'tmp'
    {
      JS::Rooted<JS::Value> tmp(cx);
      for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
        // Control block to let us common up the JS_DefineElement calls when there
        // are different ways to succeed at wrapping the object.
        do {
          if (!currentValue[sequenceIdx0].ToObjectInternal(cx, &tmp)) {
            return false;
          }
          break;
        } while (false);
        if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                              JSPROP_ENUMERATE)) {
          return false;
        }
      }
    }
    temp.setObject(*returnArray);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->videoSourceStats_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
RTCStatsCollection::TraceDictionary(JSTracer* trc)
{
}

RTCStatsCollection&
RTCStatsCollection::operator=(const RTCStatsCollection& aOther)
{
  DictionaryBase::operator=(aOther);
  mBandwidthEstimations = aOther.mBandwidthEstimations;
  mCodecStats = aOther.mCodecStats;
  mDataChannelStats = aOther.mDataChannelStats;
  mIceCandidatePairStats = aOther.mIceCandidatePairStats;
  mIceCandidateStats = aOther.mIceCandidateStats;
  mInboundRtpStreamStats = aOther.mInboundRtpStreamStats;
  mMediaSourceStats = aOther.mMediaSourceStats;
  mOutboundRtpStreamStats = aOther.mOutboundRtpStreamStats;
  mPeerConnectionStats = aOther.mPeerConnectionStats;
  mRawLocalCandidates = aOther.mRawLocalCandidates;
  mRawRemoteCandidates = aOther.mRawRemoteCandidates;
  mRemoteInboundRtpStreamStats = aOther.mRemoteInboundRtpStreamStats;
  mRemoteOutboundRtpStreamStats = aOther.mRemoteOutboundRtpStreamStats;
  mRtpContributingSourceStats = aOther.mRtpContributingSourceStats;
  mTrickledIceCandidateStats = aOther.mTrickledIceCandidateStats;
  mVideoFrameHistories = aOther.mVideoFrameHistories;
  mVideoSourceStats = aOther.mVideoSourceStats;
  return *this;
}



RTCStatsReportInternal::RTCStatsReportInternal()
  : RTCStatsCollection(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
RTCStatsReportInternal::InitIds(JSContext* cx, RTCStatsReportInternalAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->timestamp_id.init(cx, "timestamp") ||
      !atomsCache->sdpHistory_id.init(cx, "sdpHistory") ||
      !atomsCache->pcid_id.init(cx, "pcid") ||
      !atomsCache->offerer_id.init(cx, "offerer") ||
      !atomsCache->jsepSessionErrors_id.init(cx, "jsepSessionErrors") ||
      !atomsCache->iceRollbacks_id.init(cx, "iceRollbacks") ||
      !atomsCache->iceRestarts_id.init(cx, "iceRestarts") ||
      !atomsCache->configuration_id.init(cx, "configuration") ||
      !atomsCache->closed_id.init(cx, "closed") ||
      !atomsCache->callDurationMs_id.init(cx, "callDurationMs") ||
      !atomsCache->browserId_id.init(cx, "browserId")) {
    return false;
  }
  return true;
}

bool
RTCStatsReportInternal::Init(const char* sourceDescription, bool passedToJSImpl)
{
  // We init the parent's members first
  if (!RTCStatsCollection::Init()) {
    return false;
  }

  {
    // scope for any temporaries our default value setting needs.
    /* mSdpHistory array is already empty; nothing to do */
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
RTCStatsReportInternal::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  RTCStatsReportInternalAtoms* atomsCache = GetAtomCache<RTCStatsReportInternalAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  // Per spec, we define the parent's members first
  if (!RTCStatsCollection::ToObjectInternal(cx, rval)) {
    return false;
  }
  JS::Rooted<JSObject*> obj(cx, &rval.toObject());

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    uint32_t const & currentValue = mBrowserId;
    temp.setNumber(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->browserId_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  if (mCallDurationMs.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      double const & currentValue = mCallDurationMs.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->callDurationMs_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    bool const & currentValue = mClosed;
    temp.setBoolean(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->closed_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  if (mConfiguration.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      RTCConfigurationInternal const & currentValue = mConfiguration.InternalValue();
      if (!currentValue.ToObjectInternal(cx, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->configuration_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    uint32_t const & currentValue = mIceRestarts;
    temp.setNumber(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->iceRestarts_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    uint32_t const & currentValue = mIceRollbacks;
    temp.setNumber(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->iceRollbacks_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  if (mJsepSessionErrors.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mJsepSessionErrors.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->jsepSessionErrors_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mOfferer.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      bool const & currentValue = mOfferer.InternalValue();
      temp.setBoolean(currentValue);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->offerer_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mPcid;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->pcid_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    Sequence<RTCSdpHistoryEntryInternal> const & currentValue = mSdpHistory;

    uint32_t length = currentValue.Length();
    JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
    if (!returnArray) {
      return false;
    }
    // Scope for 'tmp'
    {
      JS::Rooted<JS::Value> tmp(cx);
      for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
        // Control block to let us common up the JS_DefineElement calls when there
        // are different ways to succeed at wrapping the object.
        do {
          if (!currentValue[sequenceIdx0].ToObjectInternal(cx, &tmp)) {
            return false;
          }
          break;
        } while (false);
        if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                              JSPROP_ENUMERATE)) {
          return false;
        }
      }
    }
    temp.setObject(*returnArray);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->sdpHistory_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    double const & currentValue = mTimestamp;
    temp.set(JS_NumberValue(double(currentValue)));
    if (!JS_DefinePropertyById(cx, obj, atomsCache->timestamp_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
RTCStatsReportInternal::TraceDictionary(JSTracer* trc)
{
  RTCStatsCollection::TraceDictionary(trc);
}

RTCStatsReportInternal&
RTCStatsReportInternal::operator=(const RTCStatsReportInternal& aOther)
{
  RTCStatsCollection::operator=(aOther);
  mBrowserId = aOther.mBrowserId;
  mCallDurationMs.Reset();
  if (aOther.mCallDurationMs.WasPassed()) {
    mCallDurationMs.Construct(aOther.mCallDurationMs.Value());
  }
  mClosed = aOther.mClosed;
  mConfiguration.Reset();
  if (aOther.mConfiguration.WasPassed()) {
    mConfiguration.Construct(aOther.mConfiguration.Value());
  }
  mIceRestarts = aOther.mIceRestarts;
  mIceRollbacks = aOther.mIceRollbacks;
  mJsepSessionErrors.Reset();
  if (aOther.mJsepSessionErrors.WasPassed()) {
    mJsepSessionErrors.Construct(aOther.mJsepSessionErrors.Value());
  }
  mOfferer.Reset();
  if (aOther.mOfferer.WasPassed()) {
    mOfferer.Construct(aOther.mOfferer.Value());
  }
  mPcid = aOther.mPcid;
  mSdpHistory = aOther.mSdpHistory;
  mTimestamp = aOther.mTimestamp;
  return *this;
}


namespace RTCStatsReport_Binding {

namespace MaplikeHelpers {
void
Clear(mozilla::dom::RTCStatsReport* self, ErrorResult& aRv)
{
  MOZ_ASSERT(self);
  AutoJSAPI jsapi;
  jsapi.Init();
  JSContext* cx = jsapi.cx();
  // It's safe to use UnprivilegedJunkScopeOrWorkerGlobal here because
  // all we want is to wrap into _some_ scope and then unwrap to find
  // the reflector, and wrapping has no side-effects.
  JSObject* scope = UnprivilegedJunkScopeOrWorkerGlobal(fallible);
  if (!scope) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  JSAutoRealm tempRealm(cx, scope);
  JS::Rooted<JS::Value> v(cx);
  if(!ToJSValue(cx, self, &v)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  // This is a reflector, but due to trying to name things
  // similarly across method generators, it's called obj here.
  JS::Rooted<JSObject*> obj(cx);
  obj = js::UncheckedUnwrap(&v.toObject(), /* stopAtWindowProxy = */ false);
  JSAutoRealm reflectorRealm(cx, obj);

  JS::Rooted<JSObject*> backingObj(cx);
  bool created = false;
  if (!GetMaplikeBackingObject(cx, obj, (DOM_INSTANCE_RESERVED_SLOTS + 0), &backingObj, &created)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  if (created) {
    PreserveWrapper<mozilla::dom::RTCStatsReport>(self);
  }
  if (!JS::MapClear(cx, backingObj)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
}
bool
Delete(mozilla::dom::RTCStatsReport* self, const nsAString& aKey, ErrorResult& aRv)
{
  MOZ_ASSERT(self);
  AutoJSAPI jsapi;
  jsapi.Init();
  JSContext* cx = jsapi.cx();
  // It's safe to use UnprivilegedJunkScopeOrWorkerGlobal here because
  // all we want is to wrap into _some_ scope and then unwrap to find
  // the reflector, and wrapping has no side-effects.
  JSObject* scope = UnprivilegedJunkScopeOrWorkerGlobal(fallible);
  if (!scope) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return bool(0);
  }
  JSAutoRealm tempRealm(cx, scope);
  JS::Rooted<JS::Value> v(cx);
  if(!ToJSValue(cx, self, &v)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return bool(0);
  }
  // This is a reflector, but due to trying to name things
  // similarly across method generators, it's called obj here.
  JS::Rooted<JSObject*> obj(cx);
  obj = js::UncheckedUnwrap(&v.toObject(), /* stopAtWindowProxy = */ false);
  JSAutoRealm reflectorRealm(cx, obj);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(1)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return bool(0);
  }
  do {
    if (!xpc::NonVoidStringToJsval(cx, aKey, argv[0])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return bool(0);
    }
    break;
  } while (false);

  JS::Rooted<JSObject*> backingObj(cx);
  bool created = false;
  if (!GetMaplikeBackingObject(cx, obj, (DOM_INSTANCE_RESERVED_SLOTS + 0), &backingObj, &created)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return bool(0);
  }
  if (created) {
    PreserveWrapper<mozilla::dom::RTCStatsReport>(self);
  }
  bool retVal;
  if (!JS::MapDelete(cx, backingObj, argv[0], &retVal)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return bool(0);
  }
  return retVal;
}
bool
Has(mozilla::dom::RTCStatsReport* self, const nsAString& aKey, ErrorResult& aRv)
{
  MOZ_ASSERT(self);
  AutoJSAPI jsapi;
  jsapi.Init();
  JSContext* cx = jsapi.cx();
  // It's safe to use UnprivilegedJunkScopeOrWorkerGlobal here because
  // all we want is to wrap into _some_ scope and then unwrap to find
  // the reflector, and wrapping has no side-effects.
  JSObject* scope = UnprivilegedJunkScopeOrWorkerGlobal(fallible);
  if (!scope) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return bool(0);
  }
  JSAutoRealm tempRealm(cx, scope);
  JS::Rooted<JS::Value> v(cx);
  if(!ToJSValue(cx, self, &v)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return bool(0);
  }
  // This is a reflector, but due to trying to name things
  // similarly across method generators, it's called obj here.
  JS::Rooted<JSObject*> obj(cx);
  obj = js::UncheckedUnwrap(&v.toObject(), /* stopAtWindowProxy = */ false);
  JSAutoRealm reflectorRealm(cx, obj);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(1)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return bool(0);
  }
  do {
    if (!xpc::NonVoidStringToJsval(cx, aKey, argv[0])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return bool(0);
    }
    break;
  } while (false);

  JS::Rooted<JSObject*> backingObj(cx);
  bool created = false;
  if (!GetMaplikeBackingObject(cx, obj, (DOM_INSTANCE_RESERVED_SLOTS + 0), &backingObj, &created)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return bool(0);
  }
  if (created) {
    PreserveWrapper<mozilla::dom::RTCStatsReport>(self);
  }
  bool retVal;
  if (!JS::MapHas(cx, backingObj, argv[0], &retVal)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return bool(0);
  }
  return retVal;
}
void
Set(mozilla::dom::RTCStatsReport* self, const nsAString& aKey, JS::Handle<JSObject*> aValue, ErrorResult& aRv)
{
  MOZ_ASSERT(self);
  AutoJSAPI jsapi;
  jsapi.Init();
  JSContext* cx = jsapi.cx();
  // It's safe to use UnprivilegedJunkScopeOrWorkerGlobal here because
  // all we want is to wrap into _some_ scope and then unwrap to find
  // the reflector, and wrapping has no side-effects.
  JSObject* scope = UnprivilegedJunkScopeOrWorkerGlobal(fallible);
  if (!scope) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  JSAutoRealm tempRealm(cx, scope);
  JS::Rooted<JS::Value> v(cx);
  if(!ToJSValue(cx, self, &v)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  // This is a reflector, but due to trying to name things
  // similarly across method generators, it's called obj here.
  JS::Rooted<JSObject*> obj(cx);
  obj = js::UncheckedUnwrap(&v.toObject(), /* stopAtWindowProxy = */ false);
  JSAutoRealm reflectorRealm(cx, obj);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(2)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  do {
    JS::ExposeObjectToActiveJS(aValue);
    argv[1].setObject(*aValue);
    if (!MaybeWrapObjectValue(cx, argv[1])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    break;
  } while (false);

  do {
    if (!xpc::NonVoidStringToJsval(cx, aKey, argv[0])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    break;
  } while (false);

  JS::Rooted<JSObject*> backingObj(cx);
  bool created = false;
  if (!GetMaplikeBackingObject(cx, obj, (DOM_INSTANCE_RESERVED_SLOTS + 0), &backingObj, &created)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  if (created) {
    PreserveWrapper<mozilla::dom::RTCStatsReport>(self);
  }
  if (!JS::MapSet(cx, backingObj, argv[0], argv[1])) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
}
void
Get(mozilla::dom::RTCStatsReport* self, JSContext* cx, const nsAString& aKey, JS::MutableHandle<JSObject*> aRetVal, ErrorResult& aRv)
{
  MOZ_ASSERT(self);
  JS::Rooted<JS::Value> v(cx);
  if(!ToJSValue(cx, self, &v)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  // This is a reflector, but due to trying to name things
  // similarly across method generators, it's called obj here.
  JS::Rooted<JSObject*> obj(cx);
  obj = js::UncheckedUnwrap(&v.toObject(), /* stopAtWindowProxy = */ false);
  JS::Rooted<JS::Value> result(cx);
  {
    JSAutoRealm reflectorRealm(cx, obj);
    JS::RootedVector<JS::Value> argv(cx);
    if (!argv.resize(1)) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    do {
      if (!xpc::NonVoidStringToJsval(cx, aKey, argv[0])) {
        aRv.Throw(NS_ERROR_UNEXPECTED);
        return;
      }
      break;
    } while (false);

    JS::Rooted<JSObject*> backingObj(cx);
    bool created = false;
    if (!GetMaplikeBackingObject(cx, obj, (DOM_INSTANCE_RESERVED_SLOTS + 0), &backingObj, &created)) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    if (created) {
      PreserveWrapper<mozilla::dom::RTCStatsReport>(self);
    }
    if (!JS::MapGet(cx, backingObj, argv[0], &result)) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    if (result.isUndefined()) {
      aRv.Throw(NS_ERROR_NOT_AVAILABLE);
      return;
    }
  }
  if (!JS_WrapValue(cx, &result)) {
    aRv.NoteJSContextException(cx);
    return;
  }
  JS::Rooted<JSObject*> rvalDecl(cx);
  rvalDecl = &result.toObject();
  aRetVal.set(rvalDecl);
}
} // namespace MaplikeHelpers

MOZ_CAN_RUN_SCRIPT static bool
get_size(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCStatsReport", "size", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCStatsReport*>(void_self);
  JS::Rooted<JSObject*> backingObj(cx);
  bool created = false;
  if (!GetMaplikeBackingObject(cx, obj, (DOM_INSTANCE_RESERVED_SLOTS + 0), &backingObj, &created)) {
    return false;
  }
  if (created) {
    PreserveWrapper<mozilla::dom::RTCStatsReport>(self);
  }
  uint32_t result = JS::MapSize(cx, backingObj);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setNumber(result);
  return true;
}

static const JSJitInfo size_getterinfo = {
  { get_size },
  { prototypes::id::RTCStatsReport },
  { PrototypeTraits<prototypes::id::RTCStatsReport>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
entries(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCStatsReport", "entries", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCStatsReport*>(void_self);
  JS::Rooted<JSObject*> backingObj(cx);
  bool created = false;
  if (!GetMaplikeBackingObject(cx, obj, (DOM_INSTANCE_RESERVED_SLOTS + 0), &backingObj, &created)) {
    return false;
  }
  if (created) {
    PreserveWrapper<mozilla::dom::RTCStatsReport>(self);
  }
  // TODO (Bug 1173651): Xrays currently cannot wrap iterators. Change
  // after bug 1023984 is fixed.
  if (xpc::WrapperFactory::IsXrayWrapper(obj)) {
    JS_ReportErrorASCII(cx, "Xray wrapping of iterators not supported.");
    return false;
  }
  JS::Rooted<JSObject*> result(cx);
  JS::Rooted<JS::Value> v(cx);
  if (!JS::MapEntries(cx, backingObj, &v)) {
    return false;
  }
  result = &v.toObject();
  JS::ExposeObjectToActiveJS(result);
  args.rval().setObject(*result);
  if (!MaybeWrapObjectValue(cx, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo::ArgType entries_methodinfo_argTypes[] = { JSJitInfo::ArgTypeListEnd };
static const JSTypedMethodJitInfo entries_methodinfo = {
  {
    { (JSJitGetterOp)entries },
    { prototypes::id::RTCStatsReport },
    { PrototypeTraits<prototypes::id::RTCStatsReport>::Depth },
    JSJitInfo::Method,
    JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
    JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
    false,  /* isInfallible. False in setters. */
    false,  /* isMovable.  Not relevant for setters. */
    false, /* isEliminatable.  Not relevant for setters. */
    false, /* isAlwaysInSlot.  Only relevant for getters. */
    false, /* isLazilyCachedInSlot.  Only relevant for getters. */
    true,  /* isTypedMethod.  Only relevant for methods. */
    0   /* Reserved slot index, if we're stored in a slot, else 0. */
  },
  entries_methodinfo_argTypes
};

MOZ_CAN_RUN_SCRIPT static bool
keys(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCStatsReport", "keys", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCStatsReport*>(void_self);
  JS::Rooted<JSObject*> backingObj(cx);
  bool created = false;
  if (!GetMaplikeBackingObject(cx, obj, (DOM_INSTANCE_RESERVED_SLOTS + 0), &backingObj, &created)) {
    return false;
  }
  if (created) {
    PreserveWrapper<mozilla::dom::RTCStatsReport>(self);
  }
  // TODO (Bug 1173651): Xrays currently cannot wrap iterators. Change
  // after bug 1023984 is fixed.
  if (xpc::WrapperFactory::IsXrayWrapper(obj)) {
    JS_ReportErrorASCII(cx, "Xray wrapping of iterators not supported.");
    return false;
  }
  JS::Rooted<JSObject*> result(cx);
  JS::Rooted<JS::Value> v(cx);
  if (!JS::MapKeys(cx, backingObj, &v)) {
    return false;
  }
  result = &v.toObject();
  JS::ExposeObjectToActiveJS(result);
  args.rval().setObject(*result);
  if (!MaybeWrapObjectValue(cx, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo::ArgType keys_methodinfo_argTypes[] = { JSJitInfo::ArgTypeListEnd };
static const JSTypedMethodJitInfo keys_methodinfo = {
  {
    { (JSJitGetterOp)keys },
    { prototypes::id::RTCStatsReport },
    { PrototypeTraits<prototypes::id::RTCStatsReport>::Depth },
    JSJitInfo::Method,
    JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
    JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
    false,  /* isInfallible. False in setters. */
    false,  /* isMovable.  Not relevant for setters. */
    false, /* isEliminatable.  Not relevant for setters. */
    false, /* isAlwaysInSlot.  Only relevant for getters. */
    false, /* isLazilyCachedInSlot.  Only relevant for getters. */
    true,  /* isTypedMethod.  Only relevant for methods. */
    0   /* Reserved slot index, if we're stored in a slot, else 0. */
  },
  keys_methodinfo_argTypes
};

MOZ_CAN_RUN_SCRIPT static bool
values(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCStatsReport", "values", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCStatsReport*>(void_self);
  JS::Rooted<JSObject*> backingObj(cx);
  bool created = false;
  if (!GetMaplikeBackingObject(cx, obj, (DOM_INSTANCE_RESERVED_SLOTS + 0), &backingObj, &created)) {
    return false;
  }
  if (created) {
    PreserveWrapper<mozilla::dom::RTCStatsReport>(self);
  }
  // TODO (Bug 1173651): Xrays currently cannot wrap iterators. Change
  // after bug 1023984 is fixed.
  if (xpc::WrapperFactory::IsXrayWrapper(obj)) {
    JS_ReportErrorASCII(cx, "Xray wrapping of iterators not supported.");
    return false;
  }
  JS::Rooted<JSObject*> result(cx);
  JS::Rooted<JS::Value> v(cx);
  if (!JS::MapValues(cx, backingObj, &v)) {
    return false;
  }
  result = &v.toObject();
  JS::ExposeObjectToActiveJS(result);
  args.rval().setObject(*result);
  if (!MaybeWrapObjectValue(cx, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo::ArgType values_methodinfo_argTypes[] = { JSJitInfo::ArgTypeListEnd };
static const JSTypedMethodJitInfo values_methodinfo = {
  {
    { (JSJitGetterOp)values },
    { prototypes::id::RTCStatsReport },
    { PrototypeTraits<prototypes::id::RTCStatsReport>::Depth },
    JSJitInfo::Method,
    JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
    JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
    false,  /* isInfallible. False in setters. */
    false,  /* isMovable.  Not relevant for setters. */
    false, /* isEliminatable.  Not relevant for setters. */
    false, /* isAlwaysInSlot.  Only relevant for getters. */
    false, /* isLazilyCachedInSlot.  Only relevant for getters. */
    true,  /* isTypedMethod.  Only relevant for methods. */
    0   /* Reserved slot index, if we're stored in a slot, else 0. */
  },
  values_methodinfo_argTypes
};

MOZ_CAN_RUN_SCRIPT static bool
forEach(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "RTCStatsReport.forEach");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCStatsReport", "forEach", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCStatsReport*>(void_self);
  JS::Rooted<JSObject*> arg0(cx);
  if (args.get(0).isObject()) {
    arg0 = &args.get(0).toObject();
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  JS::Rooted<JS::Value> arg1(cx);
  if (args.hasDefined(1)) {
    arg1 = args.get(1);
  } else {
    arg1 = JS::UndefinedValue();
  }
  JS::Rooted<JSObject*> backingObj(cx);
  bool created = false;
  if (!GetMaplikeBackingObject(cx, obj, (DOM_INSTANCE_RESERVED_SLOTS + 0), &backingObj, &created)) {
    return false;
  }
  if (created) {
    PreserveWrapper<mozilla::dom::RTCStatsReport>(self);
  }
  // Create a wrapper function.
  JSFunction* func = js::NewFunctionWithReserved(cx, ForEachHandler, 3, 0, nullptr);
  if (!func) {
    return false;
  }
  JS::Rooted<JSObject*> funcObj(cx, JS_GetFunctionObject(func));
  JS::Rooted<JS::Value> funcVal(cx, JS::ObjectValue(*funcObj));
  js::SetFunctionNativeReserved(funcObj, FOREACH_CALLBACK_SLOT,
                                JS::ObjectValue(*arg0));
  js::SetFunctionNativeReserved(funcObj, FOREACH_MAPLIKEORSETLIKEOBJ_SLOT,
                                JS::ObjectValue(*obj));
  if (!JS::MapForEach(cx, backingObj, funcVal, arg1)) {
    return false;
  }
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo forEach_methodinfo = {
  { (JSJitGetterOp)forEach },
  { prototypes::id::RTCStatsReport },
  { PrototypeTraits<prototypes::id::RTCStatsReport>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
has(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCStatsReport", "has", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCStatsReport*>(void_self);
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args.get(0), eStringify, eStringify, arg0)) {
    return false;
  }
  JS::Rooted<JSObject*> backingObj(cx);
  bool created = false;
  if (!GetMaplikeBackingObject(cx, obj, (DOM_INSTANCE_RESERVED_SLOTS + 0), &backingObj, &created)) {
    return false;
  }
  if (created) {
    PreserveWrapper<mozilla::dom::RTCStatsReport>(self);
  }
  JS::Rooted<JS::Value> arg0Val(cx);
  if (!ToJSValue(cx, arg0, &arg0Val)) {
    return false;
  }
  bool result;
  if (!JS::MapHas(cx, backingObj, arg0Val, &result)) {
    return false;
  }
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo::ArgType has_methodinfo_argTypes[] = { JSJitInfo::String, JSJitInfo::ArgTypeListEnd };
static const JSTypedMethodJitInfo has_methodinfo = {
  {
    { (JSJitGetterOp)has },
    { prototypes::id::RTCStatsReport },
    { PrototypeTraits<prototypes::id::RTCStatsReport>::Depth },
    JSJitInfo::Method,
    JSJitInfo::AliasDOMSets, /* aliasSet.  Not relevant for setters. */
    JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
    false,  /* isInfallible. False in setters. */
    false,  /* isMovable.  Not relevant for setters. */
    false, /* isEliminatable.  Not relevant for setters. */
    false, /* isAlwaysInSlot.  Only relevant for getters. */
    false, /* isLazilyCachedInSlot.  Only relevant for getters. */
    true,  /* isTypedMethod.  Only relevant for methods. */
    0   /* Reserved slot index, if we're stored in a slot, else 0. */
  },
  has_methodinfo_argTypes
};

MOZ_CAN_RUN_SCRIPT static bool
get(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCStatsReport", "get", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::RTCStatsReport*>(void_self);
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args.get(0), eStringify, eStringify, arg0)) {
    return false;
  }
  JS::Rooted<JSObject*> backingObj(cx);
  bool created = false;
  if (!GetMaplikeBackingObject(cx, obj, (DOM_INSTANCE_RESERVED_SLOTS + 0), &backingObj, &created)) {
    return false;
  }
  if (created) {
    PreserveWrapper<mozilla::dom::RTCStatsReport>(self);
  }
  JS::Rooted<JS::Value> arg0Val(cx);
  if (!ToJSValue(cx, arg0, &arg0Val)) {
    return false;
  }
  JS::Rooted<JS::Value> result(cx);
  if (!JS::MapGet(cx, backingObj, arg0Val, &result)) {
    return false;
  }
  JS::ExposeValueToActiveJS(result);
  args.rval().set(result);
  if (!MaybeWrapValue(cx, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo::ArgType get_methodinfo_argTypes[] = { JSJitInfo::String, JSJitInfo::ArgTypeListEnd };
static const JSTypedMethodJitInfo get_methodinfo = {
  {
    { (JSJitGetterOp)get },
    { prototypes::id::RTCStatsReport },
    { PrototypeTraits<prototypes::id::RTCStatsReport>::Depth },
    JSJitInfo::Method,
    JSJitInfo::AliasDOMSets, /* aliasSet.  Not relevant for setters. */
    JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
    false,  /* isInfallible. False in setters. */
    false,  /* isMovable.  Not relevant for setters. */
    false, /* isEliminatable.  Not relevant for setters. */
    false, /* isAlwaysInSlot.  Only relevant for getters. */
    false, /* isLazilyCachedInSlot.  Only relevant for getters. */
    true,  /* isTypedMethod.  Only relevant for methods. */
    0   /* Reserved slot index, if we're stored in a slot, else 0. */
  },
  get_methodinfo_argTypes
};

static void
_finalize(JS::GCContext* gcx, JSObject* obj)
{
  mozilla::dom::RTCStatsReport* self = UnwrapPossiblyNotInitializedDOMObject<mozilla::dom::RTCStatsReport>(obj);
  if (self) {
    JS::SetReservedSlot(obj, DOM_OBJECT_SLOT, JS::UndefinedValue());
    ClearWrapper(self, self, obj);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(obj, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<mozilla::dom::RTCStatsReport>(self);
  }
}

MOZ_GLOBINIT static const JSFunctionSpec sMethods_specs[] = {
  JS_FNSPEC("entries", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&entries_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("keys", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&keys_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("values", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&values_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("forEach", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&forEach_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("has", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&has_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("get", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&get_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sMethods[] = {
  { nullptr, &sMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(6 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSPropertySpec sAttributes_specs[] = {
  JSPropertySpec::nativeAccessors("size", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &size_getterinfo, nullptr, nullptr),
  JS_PS_END
};


static const Prefable<const JSPropertySpec> sAttributes[] = {
  { nullptr, &sAttributes_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[7];
static PropertyInfo sNativeProperties_propertyInfos[7];

static const NativePropertiesN<2> sNativeProperties = {
  false, 0,
  false, 0,
  true,  0 /* sMethods */,
  true,  1 /* sAttributes */,
  false, 0,
  false, 0,
  false, 0,
  0,
  7,
  sNativeProperties_sortedPropertyIndices,
  {
    { sMethods, &sNativeProperties_propertyInfos[0] },
    { sAttributes, &sNativeProperties_propertyInfos[6] }
  }
};
static_assert(7 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

// This may allocate too many slots, because we only really need
// slots for our non-interface-typed members that we cache.  But
// allocating slots only for those would make the slot index
// computations much more complicated, so let's do this the simple
// way for now.
DEFINE_XRAY_EXPANDO_CLASS_WITH_OPS(static, sXrayExpandoObjectClass, 1,
                                   &xpc::XrayExpandoObjectClassOps);

bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  nullptr,
  { sNativeProperties.Upcast(), nullptr, &sNativePropertiesInited },
  prototypes::id::RTCStatsReport,
  constructors::id::RTCStatsReport,
  &sXrayExpandoObjectClass
};

static bool
_constructor(JSContext* cx, unsigned argc, JS::Value* vp)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "RTCStatsReport", "constructor", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());
  if (!nsContentUtils::ThreadsafeIsSystemCaller(cx)) {
    return ThrowingConstructor(cx, argc, vp);
  }

  if (!args.isConstructing()) {
    return ThrowConstructorWithoutNew(cx, "RTCStatsReport");
  }

  JS::Rooted<JSObject*> desiredProto(cx);
  if (!GetDesiredProto(cx, args,
                       prototypes::id::RTCStatsReport,
                       CreateInterfaceObjects,
                       &desiredProto)) {
    return false;
  }

  GlobalObject global(cx, obj);
  if (global.Failed()) {
    return false;
  }

  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  Maybe<JSAutoRealm> ar;
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    obj = js::CheckedUnwrapStatic(obj);
    if (!obj) {
      return false;
    }
    ar.emplace(cx, obj);
    if (!JS_WrapObject(cx, &desiredProto)) {
      return false;
    }
  }
  auto result(StrongOrRawPtr<mozilla::dom::RTCStatsReport>(mozilla::dom::RTCStatsReport::Constructor(global)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval(), desiredProto)) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const DOMInterfaceInfo sInterfaceObjectInfo = {
  { _constructor, &sNativePropertyHooks },
  JS::GetRealmFunctionPrototypeHandle,
  PrototypeTraits<prototypes::id::RTCStatsReport>::Depth,
  prototypes::id::RTCStatsReport,
  true,
  0,
  "RTCStatsReport",
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "RTCStatsReportPrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::RTCStatsReport,
  PrototypeTraits<prototypes::id::RTCStatsReport>::Depth,
  &sNativePropertyHooks,
  JS::GetRealmObjectPrototype
};

bool
ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj)
{
  return StaticPrefs::media_peerconnection_enabled();
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx);

static const JSClassOps sClassOps = {
  nullptr,               /* addProperty */
  nullptr,               /* delProperty */
  nullptr,               /* enumerate */
  nullptr, /* newEnumerate */
  nullptr, /* resolve */
  nullptr, /* mayResolve */
  _finalize, /* finalize */
  nullptr, /* call */
  nullptr,               /* construct */
  nullptr, /* trace */
};

static const DOMJSClass sClass = {
  { "RTCStatsReport",
    JSCLASS_IS_DOMJSCLASS | JSCLASS_FOREGROUND_FINALIZE | JSCLASS_HAS_RESERVED_SLOTS(2) | JSCLASS_PRESERVES_WRAPPER,
    &sClassOps,
    JS_NULL_CLASS_SPEC,
    &NativeTypeHelpers<mozilla::dom::RTCStatsReport>::sClassExtension,
    JS_NULL_OBJECT_OPS
  },
  { prototypes::id::RTCStatsReport, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, mozilla::dom::RTCStatsReport>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<mozilla::dom::RTCStatsReport>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<mozilla::dom::RTCStatsReport>::Get(),
  nullptr,
  NativeTypeHelpers<mozilla::dom::RTCStatsReport>::GetWrapperCache
};
static_assert(1 == DOM_INSTANCE_RESERVED_SLOTS,
              "Must have the right minimal number of reserved slots.");
static_assert(2 >= 2,
              "Must have enough reserved slots.");

bool
Wrap(JSContext* aCx, mozilla::dom::RTCStatsReport* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, mozilla::dom::RTCStatsReport>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), mozilla::dom::RTCStatsReport*>);
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    _finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<mozilla::dom::RTCStatsReport> creator(aCx);
  creator.CreateObject(aCx, sClass.ToJSClass(), proto, aObject, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::RTCStatsReport);
  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::RTCStatsReport);

  JS::Handle<JSObject*> parentProto(JS::GetRealmObjectPrototypeHandle(aCx));
  if (!parentProto) {
    return;
  }

  JS::Handle<JSObject*> constructorProto(JS::GetRealmFunctionPrototypeHandle(aCx));
  if (!constructorProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              constructorProto, &sInterfaceObjectInfo, 0, true, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              sNativeProperties.Upcast(),
                              nullptr,
                              "RTCStatsReport",
                              ShouldExpose<RTCStatsReport_Binding::ConstructorEnabled>(aCx, aGlobal, aDefineOnGlobal),
                              nullptr,
                              false,
                              nullptr);

  JS::AssertObjectIsNotGray(*protoCache);
  JS::Handle<JSObject*> proto = JS::Handle<JSObject*>::fromMarkedLocation(protoCache->unsafeAddress());
  if (!proto) {
    *protoCache = nullptr;
    if (interfaceCache) {
      *interfaceCache = nullptr;
    }
    return;
  }

  // Set up aliases on the interface prototype object we just created.
  JS::Rooted<JS::Value> aliasedVal(aCx);

  if (!JS_GetProperty(aCx, proto, "entries", &aliasedVal)) {
    *protoCache = nullptr;
    if (interfaceCache) {
      *interfaceCache = nullptr;
    }
    return;
  }
  JS::Rooted<jsid> iteratorId(aCx, JS::GetWellKnownSymbolKey(aCx, JS::SymbolCode::iterator));
  if (!JS_DefinePropertyById(aCx, proto, iteratorId, aliasedVal, 0)) {
    *protoCache = nullptr;
    if (interfaceCache) {
      *interfaceCache = nullptr;
    }
    return;
  }
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::RTCStatsReport,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::RTCStatsReport,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace RTCStatsReport_Binding



} // namespace dom


} // namespace mozilla
