/* THIS FILE IS AUTOGENERATED FROM TrackEvent.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "AtomList.h"
#include "EventBinding.h"
#include "MainThreadUtils.h"
#include "TrackEventBinding.h"
#include "WrapperFactory.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "mozilla/Atomics.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/AudioTrack.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/ScriptSettings.h"
#include "mozilla/dom/TextTrack.h"
#include "mozilla/dom/TrackEvent.h"
#include "mozilla/dom/VideoTrack.h"
#include "mozilla/dom/XrayExpandoClass.h"

namespace mozilla::dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningVideoTrackOrAudioTrackOrTextTrack& aUnion, const char* aName, uint32_t aFlags)
{
  if (aUnion.IsVideoTrack()) {
    ImplCycleCollectionTraverse(aCallback, aUnion.GetAsVideoTrack(), "mVideoTrack", aFlags);
  } else if (aUnion.IsAudioTrack()) {
    ImplCycleCollectionTraverse(aCallback, aUnion.GetAsAudioTrack(), "mAudioTrack", aFlags);
  } else if (aUnion.IsTextTrack()) {
    ImplCycleCollectionTraverse(aCallback, aUnion.GetAsTextTrack(), "mTextTrack", aFlags);
  }
}


void
ImplCycleCollectionUnlink(OwningVideoTrackOrAudioTrackOrTextTrack& aUnion)
{
  aUnion.Uninit();
}


bool
VideoTrackOrAudioTrackOrTextTrack::TrySetToVideoTrack(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    NonNull<mozilla::dom::VideoTrack>& memberSlot = RawSetAsVideoTrack();
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::VideoTrack, mozilla::dom::VideoTrack>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroyVideoTrack();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
VideoTrackOrAudioTrackOrTextTrack::TrySetToVideoTrack(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToVideoTrack(cx, value, tryNext, passedToJSImpl);
}







bool
VideoTrackOrAudioTrackOrTextTrack::TrySetToAudioTrack(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    NonNull<mozilla::dom::AudioTrack>& memberSlot = RawSetAsAudioTrack();
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::AudioTrack, mozilla::dom::AudioTrack>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroyAudioTrack();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
VideoTrackOrAudioTrackOrTextTrack::TrySetToAudioTrack(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToAudioTrack(cx, value, tryNext, passedToJSImpl);
}







bool
VideoTrackOrAudioTrackOrTextTrack::TrySetToTextTrack(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    NonNull<mozilla::dom::TextTrack>& memberSlot = RawSetAsTextTrack();
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::TextTrack, mozilla::dom::TextTrack>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroyTextTrack();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
VideoTrackOrAudioTrackOrTextTrack::TrySetToTextTrack(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToTextTrack(cx, value, tryNext, passedToJSImpl);
}







bool
VideoTrackOrAudioTrackOrTextTrack::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  bool done = false, failed = false, tryNext;
  if (value.isObject()) {
    done = (failed = !TrySetToVideoTrack(cx, value, tryNext, passedToJSImpl)) || !tryNext ||
           (failed = !TrySetToAudioTrack(cx, value, tryNext, passedToJSImpl)) || !tryNext ||
           (failed = !TrySetToTextTrack(cx, value, tryNext, passedToJSImpl)) || !tryNext;
  }
  if (failed) {
    return false;
  }
  if (!done) {
    cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "VideoTrack, AudioTrack, TextTrack");
    return false;
  }
  return true;
}

bool
VideoTrackOrAudioTrackOrTextTrack::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}


bool
VideoTrackOrAudioTrackOrTextTrack::ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const
{
  switch (mType) {
    case eUninitialized: {
      return false;
    }
    case eVideoTrack: {
      if (!GetOrCreateDOMReflector(cx, mValue.mVideoTrack.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    case eAudioTrack: {
      if (!GetOrCreateDOMReflector(cx, mValue.mAudioTrack.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    case eTextTrack: {
      if (!GetOrCreateDOMReflector(cx, mValue.mTextTrack.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    default: {
      return false;
    }
  }
}



OwningVideoTrackOrAudioTrackOrTextTrack::OwningVideoTrackOrAudioTrackOrTextTrack(OwningVideoTrackOrAudioTrackOrTextTrack&& aOther)
  : mType(eUninitialized)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eVideoTrack: {
      mType = eVideoTrack;
      mValue.mVideoTrack.SetValue(std::move(aOther.mValue.mVideoTrack.Value()));
      break;
    }
    case eAudioTrack: {
      mType = eAudioTrack;
      mValue.mAudioTrack.SetValue(std::move(aOther.mValue.mAudioTrack.Value()));
      break;
    }
    case eTextTrack: {
      mType = eTextTrack;
      mValue.mTextTrack.SetValue(std::move(aOther.mValue.mTextTrack.Value()));
      break;
    }
  }
}



bool
OwningVideoTrackOrAudioTrackOrTextTrack::TrySetToVideoTrack(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    OwningNonNull<mozilla::dom::VideoTrack>& memberSlot = RawSetAsVideoTrack();
    static_assert(IsRefcounted<mozilla::dom::VideoTrack>::value, "We can only store refcounted classes.");
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::VideoTrack, mozilla::dom::VideoTrack>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroyVideoTrack();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
OwningVideoTrackOrAudioTrackOrTextTrack::TrySetToVideoTrack(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToVideoTrack(cx, value, tryNext, passedToJSImpl);
}

[[nodiscard]] OwningNonNull<mozilla::dom::VideoTrack>&
OwningVideoTrackOrAudioTrackOrTextTrack::RawSetAsVideoTrack()
{
  if (mType == eVideoTrack) {
    return mValue.mVideoTrack.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eVideoTrack;
  return mValue.mVideoTrack.SetValue();
}

[[nodiscard]] OwningNonNull<mozilla::dom::VideoTrack>&
OwningVideoTrackOrAudioTrackOrTextTrack::SetAsVideoTrack()
{
  if (mType == eVideoTrack) {
    return mValue.mVideoTrack.Value();
  }
  Uninit();
  mType = eVideoTrack;
  return mValue.mVideoTrack.SetValue();
}


void
OwningVideoTrackOrAudioTrackOrTextTrack::DestroyVideoTrack()
{
  MOZ_RELEASE_ASSERT(IsVideoTrack(), "Wrong type!");
  mValue.mVideoTrack.Destroy();
  mType = eUninitialized;
}



bool
OwningVideoTrackOrAudioTrackOrTextTrack::TrySetToAudioTrack(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    OwningNonNull<mozilla::dom::AudioTrack>& memberSlot = RawSetAsAudioTrack();
    static_assert(IsRefcounted<mozilla::dom::AudioTrack>::value, "We can only store refcounted classes.");
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::AudioTrack, mozilla::dom::AudioTrack>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroyAudioTrack();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
OwningVideoTrackOrAudioTrackOrTextTrack::TrySetToAudioTrack(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToAudioTrack(cx, value, tryNext, passedToJSImpl);
}

[[nodiscard]] OwningNonNull<mozilla::dom::AudioTrack>&
OwningVideoTrackOrAudioTrackOrTextTrack::RawSetAsAudioTrack()
{
  if (mType == eAudioTrack) {
    return mValue.mAudioTrack.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eAudioTrack;
  return mValue.mAudioTrack.SetValue();
}

[[nodiscard]] OwningNonNull<mozilla::dom::AudioTrack>&
OwningVideoTrackOrAudioTrackOrTextTrack::SetAsAudioTrack()
{
  if (mType == eAudioTrack) {
    return mValue.mAudioTrack.Value();
  }
  Uninit();
  mType = eAudioTrack;
  return mValue.mAudioTrack.SetValue();
}


void
OwningVideoTrackOrAudioTrackOrTextTrack::DestroyAudioTrack()
{
  MOZ_RELEASE_ASSERT(IsAudioTrack(), "Wrong type!");
  mValue.mAudioTrack.Destroy();
  mType = eUninitialized;
}



bool
OwningVideoTrackOrAudioTrackOrTextTrack::TrySetToTextTrack(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    OwningNonNull<mozilla::dom::TextTrack>& memberSlot = RawSetAsTextTrack();
    static_assert(IsRefcounted<mozilla::dom::TextTrack>::value, "We can only store refcounted classes.");
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::TextTrack, mozilla::dom::TextTrack>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroyTextTrack();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
OwningVideoTrackOrAudioTrackOrTextTrack::TrySetToTextTrack(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToTextTrack(cx, value, tryNext, passedToJSImpl);
}

[[nodiscard]] OwningNonNull<mozilla::dom::TextTrack>&
OwningVideoTrackOrAudioTrackOrTextTrack::RawSetAsTextTrack()
{
  if (mType == eTextTrack) {
    return mValue.mTextTrack.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eTextTrack;
  return mValue.mTextTrack.SetValue();
}

[[nodiscard]] OwningNonNull<mozilla::dom::TextTrack>&
OwningVideoTrackOrAudioTrackOrTextTrack::SetAsTextTrack()
{
  if (mType == eTextTrack) {
    return mValue.mTextTrack.Value();
  }
  Uninit();
  mType = eTextTrack;
  return mValue.mTextTrack.SetValue();
}


void
OwningVideoTrackOrAudioTrackOrTextTrack::DestroyTextTrack()
{
  MOZ_RELEASE_ASSERT(IsTextTrack(), "Wrong type!");
  mValue.mTextTrack.Destroy();
  mType = eUninitialized;
}



bool
OwningVideoTrackOrAudioTrackOrTextTrack::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  bool done = false, failed = false, tryNext;
  if (value.isObject()) {
    done = (failed = !TrySetToVideoTrack(cx, value, tryNext, passedToJSImpl)) || !tryNext ||
           (failed = !TrySetToAudioTrack(cx, value, tryNext, passedToJSImpl)) || !tryNext ||
           (failed = !TrySetToTextTrack(cx, value, tryNext, passedToJSImpl)) || !tryNext;
  }
  if (failed) {
    return false;
  }
  if (!done) {
    cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "VideoTrack, AudioTrack, TextTrack");
    return false;
  }
  return true;
}

bool
OwningVideoTrackOrAudioTrackOrTextTrack::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}

void
OwningVideoTrackOrAudioTrackOrTextTrack::Uninit()
{
  switch (mType) {
    case eUninitialized: {
      break;
    }
    case eVideoTrack: {
      DestroyVideoTrack();
      break;
    }
    case eAudioTrack: {
      DestroyAudioTrack();
      break;
    }
    case eTextTrack: {
      DestroyTextTrack();
      break;
    }
  }
}

bool
OwningVideoTrackOrAudioTrackOrTextTrack::ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const
{
  switch (mType) {
    case eUninitialized: {
      return false;
    }
    case eVideoTrack: {
      if (!GetOrCreateDOMReflector(cx, mValue.mVideoTrack.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    case eAudioTrack: {
      if (!GetOrCreateDOMReflector(cx, mValue.mAudioTrack.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    case eTextTrack: {
      if (!GetOrCreateDOMReflector(cx, mValue.mTextTrack.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    default: {
      return false;
    }
  }
}

OwningVideoTrackOrAudioTrackOrTextTrack&
OwningVideoTrackOrAudioTrackOrTextTrack::operator=(OwningVideoTrackOrAudioTrackOrTextTrack&& aOther)
{
  this->~OwningVideoTrackOrAudioTrackOrTextTrack();
  new (this) OwningVideoTrackOrAudioTrackOrTextTrack (std::move(aOther));
  return *this;
}


OwningVideoTrackOrAudioTrackOrTextTrack&
OwningVideoTrackOrAudioTrackOrTextTrack::operator=(const OwningVideoTrackOrAudioTrackOrTextTrack& aOther)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eVideoTrack: {
      SetAsVideoTrack() = aOther.GetAsVideoTrack();
      break;
    }
    case eAudioTrack: {
      SetAsAudioTrack() = aOther.GetAsAudioTrack();
      break;
    }
    case eTextTrack: {
      SetAsTextTrack() = aOther.GetAsTextTrack();
      break;
    }
  }
  return *this;
}



TrackEventInit::TrackEventInit()
  : EventInit(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
TrackEventInit::InitIds(JSContext* cx, TrackEventInitAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->track_id.init(cx, "track")) {
    return false;
  }
  return true;
}

bool
TrackEventInit::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  TrackEventInitAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<TrackEventInitAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  // Per spec, we init the parent's members first
  if (!EventInit::Init(cx, val)) {
    return false;
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->track_id, temp.ptr())) {
      return false;
    }
  }
  if (!(!isNull && !temp->isUndefined()) || temp.ref().isNullOrUndefined()) {
    mTrack.SetNull();
  } else {
    if (!mTrack.SetValue().Init(cx, temp.ref(), "'track' member of TrackEventInit", passedToJSImpl)) {
      return false;
    }
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
TrackEventInit::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
TrackEventInit::TraceDictionary(JSTracer* trc)
{
  EventInit::TraceDictionary(trc);
}



TrackEventInit&
TrackEventInit::operator=(const TrackEventInit& aOther)
{
  EventInit::operator=(aOther);
  mTrack = aOther.mTrack;
  return *this;
}


namespace TrackEvent_Binding {

static_assert(IsRefcounted<NativeType>::value == IsRefcounted<Event_Binding::NativeType>::value,
              "Can't inherit from an interface with a different ownership model.");

MOZ_CAN_RUN_SCRIPT static bool
get_track(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "TrackEvent", "track", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::TrackEvent*>(void_self);
  Nullable<OwningVideoTrackOrAudioTrackOrTextTrack> result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetTrack(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetTrack(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result.IsNull()) {
    args.rval().setNull();
    return true;
  }
  if (!result.Value().ToJSVal(cx, obj, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo track_getterinfo = {
  { get_track },
  { prototypes::id::TrackEvent },
  { PrototypeTraits<prototypes::id::TrackEvent>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_isTrusted(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "TrackEvent", "isTrusted", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::TrackEvent*>(void_self);
  bool result(MOZ_KnownLive(self)->IsTrusted());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo isTrusted_getterinfo = {
  { get_isTrusted },
  { prototypes::id::TrackEvent },
  { PrototypeTraits<prototypes::id::TrackEvent>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasDOMSets, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  true,  /* isMovable.  Not relevant for setters. */
  true, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

static void
_finalize(JS::GCContext* gcx, JSObject* obj)
{
  mozilla::dom::TrackEvent* self = UnwrapPossiblyNotInitializedDOMObject<mozilla::dom::TrackEvent>(obj);
  if (self) {
    JS::SetReservedSlot(obj, DOM_OBJECT_SLOT, JS::UndefinedValue());
    ClearWrapper(self, self, obj);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(obj, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<mozilla::dom::TrackEvent>(self);
  }
}

MOZ_GLOBINIT static const JSPropertySpec sAttributes_specs[] = {
  JSPropertySpec::nativeAccessors("track", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &track_getterinfo, nullptr, nullptr),
  JS_PS_END
};


static const Prefable<const JSPropertySpec> sAttributes[] = {
  { nullptr, &sAttributes_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSPropertySpec sUnforgeableAttributes_specs[] = {
  JSPropertySpec::nativeAccessors("isTrusted", JSPROP_ENUMERATE | JSPROP_PERMANENT, GenericGetter<NormalThisPolicy, ThrowExceptions>, &isTrusted_getterinfo, nullptr, nullptr),
  JS_PS_END
};


static const Prefable<const JSPropertySpec> sUnforgeableAttributes[] = {
  { nullptr, &sUnforgeableAttributes_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[2];
static PropertyInfo sNativeProperties_propertyInfos[2];

static const NativePropertiesN<2> sNativeProperties = {
  false, 0,
  false, 0,
  false, 0,
  true,  0 /* sAttributes */,
  false, 0,
  true,  1 /* sUnforgeableAttributes */,
  false, 0,
  -1,
  2,
  sNativeProperties_sortedPropertyIndices,
  {
    { sAttributes, &sNativeProperties_propertyInfos[0] },
    { sUnforgeableAttributes, &sNativeProperties_propertyInfos[1] }
  }
};
static_assert(2 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  nullptr,
  { sNativeProperties.Upcast(), nullptr, &sNativePropertiesInited },
  prototypes::id::TrackEvent,
  constructors::id::TrackEvent,
  &DefaultXrayExpandoObjectClass
};

static bool
_constructor(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "TrackEvent constructor");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "TrackEvent", "constructor", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());
  if (!args.isConstructing()) {
    return ThrowConstructorWithoutNew(cx, "TrackEvent");
  }

  JS::Rooted<JSObject*> desiredProto(cx);
  if (!GetDesiredProto(cx, args,
                       prototypes::id::TrackEvent,
                       CreateInterfaceObjects,
                       &desiredProto)) {
    return false;
  }

  if (!args.requireAtLeast(cx, "TrackEvent constructor", 1)) {
    return false;
  }
  GlobalObject global(cx, obj);
  if (global.Failed()) {
    return false;
  }

  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  binding_detail::FastTrackEventInit arg1;
  if (!arg1.Init(cx, (args.hasDefined(1)) ? args[1] : JS::NullHandleValue, "Argument 2", false)) {
    return false;
  }
  Maybe<JSAutoRealm> ar;
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    obj = js::CheckedUnwrapStatic(obj);
    if (!obj) {
      return false;
    }
    ar.emplace(cx, obj);
    if (!JS_WrapObject(cx, &desiredProto)) {
      return false;
    }
  }
  auto result(StrongOrRawPtr<mozilla::dom::TrackEvent>(mozilla::dom::TrackEvent::Constructor(global, NonNullHelper(Constify(arg0)), Constify(arg1))));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval(), desiredProto)) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const DOMInterfaceInfo sInterfaceObjectInfo = {
  { _constructor, &sNativePropertyHooks },
  Event_Binding::GetConstructorObjectHandle,
  PrototypeTraits<prototypes::id::TrackEvent>::Depth,
  prototypes::id::TrackEvent,
  true,
  1,
  "TrackEvent",
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "TrackEventPrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE + 1 /* slot for the JSObject holding the unforgeable properties */),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::TrackEvent,
  PrototypeTraits<prototypes::id::TrackEvent>::Depth,
  &sNativePropertyHooks,
  Event_Binding::GetProtoObject
};

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx);

static const JSClassOps sClassOps = {
  nullptr,               /* addProperty */
  nullptr,               /* delProperty */
  nullptr,               /* enumerate */
  nullptr, /* newEnumerate */
  nullptr, /* resolve */
  nullptr, /* mayResolve */
  _finalize, /* finalize */
  nullptr, /* call */
  nullptr,               /* construct */
  nullptr, /* trace */
};

static const DOMJSClass sClass = {
  { "TrackEvent",
    JSCLASS_IS_DOMJSCLASS | JSCLASS_FOREGROUND_FINALIZE | JSCLASS_HAS_RESERVED_SLOTS(1) | JSCLASS_SKIP_NURSERY_FINALIZE | JSCLASS_PRESERVES_WRAPPER,
    &sClassOps,
    JS_NULL_CLASS_SPEC,
    &NativeTypeHelpers<mozilla::dom::TrackEvent>::sClassExtension,
    JS_NULL_OBJECT_OPS
  },
  { prototypes::id::Event, prototypes::id::TrackEvent, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, mozilla::dom::TrackEvent>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<mozilla::dom::TrackEvent>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<mozilla::dom::TrackEvent>::Get(),
  nullptr,
  NativeTypeHelpers<mozilla::dom::TrackEvent>::GetWrapperCache
};
static_assert(1 == DOM_INSTANCE_RESERVED_SLOTS,
              "Must have the right minimal number of reserved slots.");
static_assert(1 >= 1,
              "Must have enough reserved slots.");

bool
Wrap(JSContext* aCx, mozilla::dom::TrackEvent* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, mozilla::dom::TrackEvent>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), mozilla::dom::TrackEvent*>);
  MOZ_ASSERT(static_cast<mozilla::dom::Event*>(aObject) ==
             reinterpret_cast<mozilla::dom::Event*>(aObject),
             "Multiple inheritance for mozilla::dom::Event is broken.");
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    _finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<mozilla::dom::TrackEvent> creator(aCx);
  creator.CreateObject(aCx, sClass.ToJSClass(), proto, aObject, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);

  // Important: do unforgeable property setup after we have handed
  // over ownership of the C++ object to obj as needed, so that if
  // we fail and it ends up GCed it won't have problems in the
  // finalizer trying to drop its ownership of the C++ object.
  JS::Rooted<JSObject*> unforgeableHolder(aCx,
    &JS::GetReservedSlot(canonicalProto, DOM_INTERFACE_PROTO_SLOTS_BASE).toObject());
  if (!JS_InitializePropertiesFromCompatibleNativeObject(aCx, aReflector, unforgeableHolder)) {
    aCache->ReleaseWrapper(aObject);
    aCache->ClearWrapper();
    return false;
  }
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::TrackEvent);
  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::TrackEvent);

  JS::Handle<JSObject*> parentProto(Event_Binding::GetProtoObjectHandle(aCx));
  if (!parentProto) {
    return;
  }

  JS::Handle<JSObject*> constructorProto(Event_Binding::GetConstructorObjectHandle(aCx));
  if (!constructorProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              constructorProto, &sInterfaceObjectInfo, 1, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              sNativeProperties.Upcast(),
                              nullptr,
                              "TrackEvent",
                              aDefineOnGlobal != DefineInterfaceProperty::No,
                              nullptr,
                              false,
                              nullptr);

  JS::AssertObjectIsNotGray(*protoCache);
  JS::Handle<JSObject*> proto = JS::Handle<JSObject*>::fromMarkedLocation(protoCache->unsafeAddress());
  if (!proto) {
    *protoCache = nullptr;
    if (interfaceCache) {
      *interfaceCache = nullptr;
    }
    return;
  }

  JS::Rooted<JSObject*> unforgeableHolder(
      aCx, JS_NewObjectWithoutMetadata(aCx, sClass.ToJSClass(), proto));
  if (!unforgeableHolder) {
    *protoCache = nullptr;
    if (interfaceCache) {
      *interfaceCache = nullptr;
    }
    return;
  }

  if (!DefineLegacyUnforgeableAttributes(aCx, unforgeableHolder, sUnforgeableAttributes)) {
    *protoCache = nullptr;
    if (interfaceCache) {
      *interfaceCache = nullptr;
    }
    return;
  }

  if (*protoCache) {
    JS::SetReservedSlot(*protoCache, DOM_INTERFACE_PROTO_SLOTS_BASE,
                        JS::ObjectValue(*unforgeableHolder));
  }
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::TrackEvent,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::TrackEvent,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace TrackEvent_Binding



} // namespace mozilla::dom
