/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.GeoLocation;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.AggregateBase;
import org.opensearch.client.opensearch._types.aggregations.AggregateVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class GeoCentroidAggregate
extends AggregateBase
implements AggregateVariant,
ToCopyableBuilder<Builder, GeoCentroidAggregate> {
    private final long count;
    @Nullable
    private final GeoLocation location;
    public static final JsonpDeserializer<GeoCentroidAggregate> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoCentroidAggregate::setupGeoCentroidAggregateDeserializer);

    private GeoCentroidAggregate(Builder builder) {
        super(builder);
        this.count = ApiTypeHelper.requireNonNull(builder.count, this, "count");
        this.location = builder.location;
    }

    public static GeoCentroidAggregate of(Function<Builder, ObjectBuilder<GeoCentroidAggregate>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregate.Kind _aggregateKind() {
        return Aggregate.Kind.GeoCentroid;
    }

    public final long count() {
        return this.count;
    }

    @Nullable
    public final GeoLocation location() {
        return this.location;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("count");
        generator.write(this.count);
        if (this.location != null) {
            generator.writeKey("location");
            this.location.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupGeoCentroidAggregateDeserializer(ObjectDeserializer<Builder> op) {
        GeoCentroidAggregate.setupAggregateBaseDeserializer(op);
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count");
        op.add(Builder::location, GeoLocation._DESERIALIZER, "location");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Long.hashCode(this.count);
        result = 31 * result + Objects.hashCode(this.location);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoCentroidAggregate other = (GeoCentroidAggregate)o;
        return this.count == other.count && Objects.equals(this.location, other.location);
    }

    public static class Builder
    extends AggregateBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, GeoCentroidAggregate> {
        private Long count;
        @Nullable
        private GeoLocation location;

        public Builder() {
        }

        private Builder(GeoCentroidAggregate o) {
            super(o);
            this.count = o.count;
            this.location = o.location;
        }

        private Builder(Builder o) {
            super(o);
            this.count = o.count;
            this.location = o.location;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder count(long value) {
            this.count = value;
            return this;
        }

        @Nonnull
        public final Builder location(@Nullable GeoLocation value) {
            this.location = value;
            return this;
        }

        @Nonnull
        public final Builder location(Function<GeoLocation.Builder, ObjectBuilder<GeoLocation>> fn) {
            return this.location(fn.apply(new GeoLocation.Builder()).build());
        }

        @Override
        @Nonnull
        public GeoCentroidAggregate build() {
            this._checkSingleUse();
            return new GeoCentroidAggregate(this);
        }
    }
}

