/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.core;

import org.opensearch.action.get.GetRequest;
import org.opensearch.client.Validatable;
import org.opensearch.search.fetch.subphase.FetchSourceContext;

public final class GetSourceRequest
implements Validatable {
    private String routing;
    private String preference;
    private boolean refresh = false;
    private boolean realtime = true;
    private FetchSourceContext fetchSourceContext;
    private final String index;
    private String type;
    private final String id;

    public GetSourceRequest(String index, String id) {
        this.index = index;
        this.id = id;
    }

    public static GetSourceRequest from(GetRequest getRequest) {
        return new GetSourceRequest(getRequest.index(), getRequest.id()).routing(getRequest.routing()).preference(getRequest.preference()).refresh(getRequest.refresh()).realtime(getRequest.realtime()).fetchSourceContext(getRequest.fetchSourceContext());
    }

    public GetSourceRequest routing(String routing) {
        this.routing = routing != null && routing.length() == 0 ? null : routing;
        return this;
    }

    public GetSourceRequest preference(String preference) {
        this.preference = preference;
        return this;
    }

    public GetSourceRequest refresh(boolean refresh) {
        this.refresh = refresh;
        return this;
    }

    public GetSourceRequest realtime(boolean realtime) {
        this.realtime = realtime;
        return this;
    }

    public GetSourceRequest fetchSourceContext(FetchSourceContext context) {
        this.fetchSourceContext = context;
        return this;
    }

    public String index() {
        return this.index;
    }

    public String type() {
        return this.type;
    }

    public GetSourceRequest type(String type) {
        this.type = type;
        return this;
    }

    public String id() {
        return this.id;
    }

    public String routing() {
        return this.routing;
    }

    public String preference() {
        return this.preference;
    }

    public boolean refresh() {
        return this.refresh;
    }

    public boolean realtime() {
        return this.realtime;
    }

    public FetchSourceContext fetchSourceContext() {
        return this.fetchSourceContext;
    }
}

