/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.rules.ImmutableSortRemoveDuplicateKeysRule;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.tools.RelBuilder;
import org.immutables.value.Value;

@Value.Enclosing
public class SortRemoveDuplicateKeysRule
extends RelRule<Config>
implements TransformationRule {
    protected SortRemoveDuplicateKeysRule(Config config) {
        super(config);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Sort sort = (Sort)call.rel(0);
        RelBuilder relBuilder = call.builder();
        RelMetadataQuery mq = call.getMetadataQuery();
        ArrayList<RelFieldCollation> newCollations = new ArrayList<RelFieldCollation>();
        List<RelFieldCollation> collations = sort.getCollation().getFieldCollations();
        for (RelFieldCollation field : collations) {
            boolean dup = false;
            for (RelFieldCollation existed : newCollations) {
                if (!Boolean.TRUE.equals(mq.determines(sort, existed.getFieldIndex(), field.getFieldIndex()))) continue;
                dup = true;
                break;
            }
            if (dup) continue;
            newCollations.add(field);
        }
        if (collations.size() == newCollations.size()) {
            return;
        }
        relBuilder.push(sort.getInput()).sortLimit(sort.offset, sort.fetch, RelCollations.of(newCollations));
        call.transformTo(relBuilder.build());
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableSortRemoveDuplicateKeysRule.Config.of().withOperandSupplier(b0 -> b0.operand(Sort.class).anyInputs());

        @Override
        default public SortRemoveDuplicateKeysRule toRule() {
            return new SortRemoveDuplicateKeysRule(this);
        }
    }
}

