﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/firehose/Firehose_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Firehose {
namespace Model {

/**
 * <p>Represents a single field in a <code>PartitionSpec</code>. </p> <p>Amazon
 * Data Firehose is in preview release and is subject to change.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/firehose-2015-08-04/PartitionField">AWS
 * API Reference</a></p>
 */
class PartitionField {
 public:
  AWS_FIREHOSE_API PartitionField() = default;
  AWS_FIREHOSE_API PartitionField(Aws::Utils::Json::JsonView jsonValue);
  AWS_FIREHOSE_API PartitionField& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_FIREHOSE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p> The column name to be configured in partition spec. </p> <p>Amazon Data
   * Firehose is in preview release and is subject to change.</p>
   */
  inline const Aws::String& GetSourceName() const { return m_sourceName; }
  inline bool SourceNameHasBeenSet() const { return m_sourceNameHasBeenSet; }
  template <typename SourceNameT = Aws::String>
  void SetSourceName(SourceNameT&& value) {
    m_sourceNameHasBeenSet = true;
    m_sourceName = std::forward<SourceNameT>(value);
  }
  template <typename SourceNameT = Aws::String>
  PartitionField& WithSourceName(SourceNameT&& value) {
    SetSourceName(std::forward<SourceNameT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_sourceName;
  bool m_sourceNameHasBeenSet = false;
};

}  // namespace Model
}  // namespace Firehose
}  // namespace Aws
