/*! @azure/msal-browser v4.26.1 2025-11-06 */
'use strict';
import { AuthFlowStateBase } from '../../../core/auth_flow/AuthFlowState.mjs';
import { SIGN_OUT_COMPLETED_STATE_TYPE, SIGN_OUT_FAILED_STATE_TYPE } from '../../../core/auth_flow/AuthFlowStateTypes.mjs';

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
/**
 * The completed state of the sign-out flow.
 */
class SignOutCompletedState extends AuthFlowStateBase {
    constructor() {
        super(...arguments);
        /**
         * The type of the state.
         */
        this.stateType = SIGN_OUT_COMPLETED_STATE_TYPE;
    }
}
/**
 * The failed state of the sign-out flow.
 */
class SignOutFailedState extends AuthFlowStateBase {
    constructor() {
        super(...arguments);
        /**
         * The type of the state.
         */
        this.stateType = SIGN_OUT_FAILED_STATE_TYPE;
    }
}

export { SignOutCompletedState, SignOutFailedState };
//# sourceMappingURL=SignOutState.mjs.map
