/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.data;

import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.data.DBDDataFormatter;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDFormatSettings;
import org.jkiss.dbeaver.model.data.DBDValueHandlerConfigurable;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.data.BaseValueHandler;
import org.jkiss.dbeaver.model.impl.data.formatters.DefaultDataFormatter;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public abstract class TemporalAccessorValueHandler
extends BaseValueHandler
implements DBDValueHandlerConfigurable {
    protected static final Log log = Log.getLog(TemporalAccessorValueHandler.class);
    private final DBDFormatSettings formatSettings;
    protected DBDDataFormatter formatter;

    public TemporalAccessorValueHandler(DBDFormatSettings formatSettings) {
        this.formatSettings = formatSettings;
    }

    @Override
    public void refreshValueHandlerConfiguration(DBSTypedObject type) {
        this.formatter = null;
    }

    @NotNull
    public Class<Date> getValueObjectType(@NotNull DBSTypedObject attribute) {
        return Date.class;
    }

    @Override
    public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy, boolean validateValue) throws DBCException {
        if (object == null) {
            return null;
        }
        if (object instanceof TemporalAccessor) {
            return object;
        }
        if (object instanceof String) {
            String strValue = (String)object;
            try {
                return this.getFormatter(type).parseValue(strValue, this.isZonedType(type) ? ZonedDateTime.class : LocalDateTime.class);
            }
            catch (ParseException e) {
                try {
                    return ZonedDateTime.parse((CharSequence)object);
                }
                catch (Exception e1) {
                    log.debug("Can't parse string value [" + strValue + "] to date/time value", e);
                    return object;
                }
            }
        }
        throw new DBCException("Bad temporal accessor value: " + String.valueOf(object));
    }

    @Override
    @NotNull
    public String getValueDisplayString(@NotNull DBSTypedObject column, Object value, @NotNull DBDDisplayFormat format) {
        if (value == null || value instanceof String) {
            return super.getValueDisplayString(column, value, format);
        }
        try {
            return this.getFormatter(column).formatValue(value);
        }
        catch (Exception e) {
            return String.valueOf(value);
        }
    }

    @NotNull
    protected DBDDataFormatter getFormatter(DBSTypedObject column) {
        if (this.formatter == null) {
            try {
                this.formatter = this.formatSettings.getDataFormatterProfile().createFormatter(this.getFormatterId(column), column);
            }
            catch (Exception e) {
                log.error("Can't create formatter for zoned datetime value handler", e);
                this.formatter = DefaultDataFormatter.INSTANCE;
            }
        }
        return this.formatter;
    }

    protected abstract boolean isZonedType(DBSTypedObject var1);

    @NotNull
    protected abstract String getFormatterId(DBSTypedObject var1);
}

