/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tracker;
import org.eclipse.ui.forms.widgets.Section;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.exec.DBCExecutionResult;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.VerticalButton;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetDecorator;
import org.jkiss.dbeaver.ui.controls.resultset.QueryResultsDecorator;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.controls.resultset.spreadsheet.Spreadsheet;
import org.jkiss.dbeaver.ui.editors.sql.QueryProcessor;
import org.jkiss.dbeaver.ui.editors.sql.QueryResultsContainer;
import org.jkiss.dbeaver.ui.editors.sql.SingleTabQueryProcessor;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.Pair;

class SingleTabQueryResultsContainer
extends QueryResultsContainer {
    private static final Integer MIN_VIEWER_HEIGHT = 150;
    private final SingleTabQueryProcessor queryProcessor;
    private final Section section;
    private GridData rsvConstrainedLayout;

    SingleTabQueryResultsContainer(@NotNull Pair<Section, Composite> sectionAndContents, @NotNull SingleTabQueryProcessor queryProcessor, int resultSetNumber, int resultSetIndex, boolean singleQuery, boolean makeDefault) {
        super((Composite)sectionAndContents.getSecond(), (QueryProcessor)queryProcessor, resultSetNumber, resultSetIndex, singleQuery, makeDefault);
        this.queryProcessor = queryProcessor;
        this.section = (Section)sectionAndContents.getFirst();
        this.setupSection((Composite)sectionAndContents.getSecond());
    }

    SingleTabQueryResultsContainer(@NotNull Pair<Section, Composite> sectionAndContents, @NotNull SingleTabQueryProcessor queryProcessor, int resultSetNumber, int resultSetIndex, @NotNull DBSDataContainer dataContainer, boolean singleQuery) {
        super((Composite)sectionAndContents.getSecond(), (QueryProcessor)queryProcessor, resultSetNumber, resultSetIndex, dataContainer, singleQuery);
        this.queryProcessor = queryProcessor;
        this.section = (Section)sectionAndContents.getFirst();
        this.setupSection((Composite)sectionAndContents.getSecond());
    }

    @Override
    public IResultSetDecorator createResultSetDecorator() {
        if (this.getOwner().getActivePreferenceStore().getBoolean("resultset.behavior.showFiltersPanelInSingleTabMode")) {
            return super.createResultSetDecorator();
        }
        return new QueryResultsDecorator(this){

            public long getDecoratorFeatures() {
                return 62L;
            }
        };
    }

    private void setupSection(@NotNull Composite sectionContents) {
        final Composite control = this.viewer.getControl();
        sectionContents.setData(ResultSetViewer.CONTROL_ID, (Object)this.viewer);
        this.rsvConstrainedLayout = GridDataFactory.swtDefaults().align(4, 4).grab(true, false).hint(10, 300).create();
        control.setLayoutData((Object)this.rsvConstrainedLayout);
        final GridData freeLayout = GridDataFactory.swtDefaults().align(4, 4).grab(true, false).create();
        Label line = new Label(sectionContents, 258);
        line.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 4).grab(true, false).hint(10, 10).create());
        line.setCursor(line.getDisplay().getSystemCursor(7));
        line.addMouseListener((MouseListener)new MouseAdapter(this){
            final /* synthetic */ SingleTabQueryResultsContainer this$0;
            {
                this.this$0 = this$0;
            }

            public void mouseDoubleClick(MouseEvent e) {
                control.setLayoutData((Object)(control.getLayoutData() == this.this$0.rsvConstrainedLayout ? freeLayout : this.this$0.rsvConstrainedLayout));
                this.this$0.queryProcessor.relayoutContents();
            }
        });
        line.addMouseMoveListener(e -> {
            if ((e.stateMask & 0x80000) != 0) {
                Tracker tracker = new Tracker(this.queryProcessor.getSectionsContainer(), 1040);
                tracker.setStippled(true);
                tracker.setCursor(tracker.getDisplay().getSystemCursor(7));
                Point size = control.getSize();
                Point origin = this.queryProcessor.getSectionsContainer().toControl(control.toDisplay(control.getLocation()));
                tracker.setRectangles(new Rectangle[]{new Rectangle(origin.x, origin.y, size.x, size.y + line.getSize().y / 2)});
                if (tracker.open()) {
                    Rectangle after = tracker.getRectangles()[0];
                    int newHeight = after.height - line.getSize().y / 2;
                    if (newHeight != this.rsvConstrainedLayout.heightHint) {
                        this.rsvConstrainedLayout.heightHint = newHeight;
                        control.setLayoutData((Object)this.rsvConstrainedLayout);
                        this.queryProcessor.relayoutContents();
                    }
                }
                tracker.dispose();
            }
        });
        Listener displayListener = event -> {
            Control clickedWidget = (Control)event.widget;
            if (clickedWidget instanceof VerticalButton && clickedWidget.getShell() == control.getShell() && control.isVisible()) {
                Point clickedPoint = clickedWidget.toDisplay(event.x, event.y);
                if (control.getClientArea().contains(control.toControl(clickedPoint)) && !this.viewer.isPresentationInFocus()) {
                    for (Composite c = control; c != null && !c.isFocusControl(); c = c.getParent()) {
                        if (c != sectionContents) continue;
                        control.setFocus();
                        break;
                    }
                }
            }
        };
        control.getDisplay().addFilter(3, displayListener);
        control.addDisposeListener(e -> control.getDisplay().removeFilter(3, displayListener));
        this.queryProcessor.relayoutContents();
    }

    @Override
    public void setTabName(@NotNull String tabName) {
        super.setTabName(tabName);
        this.section.setText(tabName);
    }

    @Override
    public void updateResultsName(@NotNull String resultSetName, @Nullable String toolTip) {
        if (!this.section.isDisposed()) {
            if (!CommonUtils.isEmpty((String)resultSetName)) {
                this.section.setText(resultSetName);
            }
            if (toolTip != null) {
                this.section.setToolTipText(toolTip);
            }
        }
    }

    @Override
    @NotNull
    public CTabItem getResultsTab() {
        return this.queryProcessor.getResultsTab();
    }

    @Override
    public boolean isPinned() {
        return this.isTabPinned(this.queryProcessor.getResultsTab());
    }

    @Override
    public void setPinned(boolean pinned) {
        this.setTabPinned(this.queryProcessor.getResultsTab(), pinned);
    }

    @Override
    public void handleExecuteResult(DBCExecutionResult result) {
        super.handleExecuteResult(result);
        Control control = this.viewer.getActivePresentation().getControl();
        if (control instanceof Spreadsheet) {
            Spreadsheet s = (Spreadsheet)control;
            UIUtils.syncExec(() -> {
                Point spreadsheetPreferredSize = s.computeSize(-1, -1, true);
                Point spreadsheetSize = s.getSize();
                int desiredViewerHeight = this.rsvConstrainedLayout.heightHint - spreadsheetSize.y + spreadsheetPreferredSize.y;
                if (desiredViewerHeight < this.rsvConstrainedLayout.heightHint) {
                    if (desiredViewerHeight < MIN_VIEWER_HEIGHT) {
                        desiredViewerHeight = MIN_VIEWER_HEIGHT;
                    }
                    this.rsvConstrainedLayout.heightHint = desiredViewerHeight;
                    this.queryProcessor.relayoutContents();
                }
            });
        }
    }

    @Override
    protected void dispose() {
        UIUtils.syncExec(() -> ((Section)this.section).dispose());
    }
}

