/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.utils;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.URI;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.utils.SecurityUtils;

public final class IOUtils {
    private static final Logger log = Logger.getLogger(IOUtils.class.getName());
    public static final int DEFAULT_BUFFER_SIZE = 16384;
    private static final boolean USE_NIO_STREAMS = false;

    public static void close(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Failed to close closeable: " + closeable.getClass().getName(), e);
        }
    }

    public static void close(AutoCloseable closeable) {
        try {
            closeable.close();
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Failed to close closeable: " + closeable.getClass().getName(), e);
        }
    }

    public static void closeQuietly(AutoCloseable ... closeable) {
        for (AutoCloseable c : closeable) {
            IOUtils.close(c);
        }
    }

    public static void fastCopy(InputStream src, OutputStream dest) throws IOException {
        IOUtils.fastCopy(src, dest, 16384);
    }

    public static void fastCopy(InputStream src, OutputStream dest, int bufferSize) throws IOException {
        IOUtils.copyStream(src, dest, bufferSize);
    }

    public static void fastCopy(ReadableByteChannel src, WritableByteChannel dest, int bufferSize) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(bufferSize);
        while (src.read(buffer) != -1) {
            IOUtils.flipBuffer(buffer);
            dest.write(buffer);
            buffer.compact();
        }
        IOUtils.flipBuffer(buffer);
        while (buffer.hasRemaining()) {
            dest.write(buffer);
        }
    }

    public static void flipBuffer(Buffer buffer) {
        buffer.flip();
    }

    public static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        IOUtils.copyStream(inputStream, outputStream, 16384);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStream(InputStream inputStream, OutputStream outputStream, int bufferSize) throws IOException {
        try {
            byte[] writeBuffer = new byte[bufferSize];
            int br = inputStream.read(writeBuffer);
            while (br != -1) {
                outputStream.write(writeBuffer, 0, br);
                br = inputStream.read(writeBuffer);
            }
            outputStream.flush();
        }
        finally {
            inputStream.close();
        }
    }

    public static void copyStreamPortion(InputStream inputStream, OutputStream outputStream, int portionSize, int bufferSize) throws IOException {
        int bytesRead;
        if (bufferSize > portionSize) {
            bufferSize = portionSize;
        }
        byte[] writeBuffer = new byte[bufferSize];
        for (int totalRead = 0; totalRead < portionSize; totalRead += bytesRead) {
            int bytesToRead = bufferSize;
            if (bytesToRead > portionSize - totalRead) {
                bytesToRead = portionSize - totalRead;
            }
            bytesRead = inputStream.read(writeBuffer, 0, bytesToRead);
            outputStream.write(writeBuffer, 0, bytesRead);
        }
        outputStream.flush();
    }

    public static String toString(File file, String encoding) throws IOException {
        try (FileInputStream is = new FileInputStream(file);){
            String string;
            try (InputStreamReader reader = new InputStreamReader((InputStream)is, encoding);){
                StringWriter writer = new StringWriter();
                IOUtils.copyText(reader, writer, 16384);
                string = writer.toString();
            }
            return string;
        }
    }

    public static void copyText(Reader reader, Writer writer, int bufferSize) throws IOException {
        char[] writeBuffer = new char[bufferSize];
        int br = reader.read(writeBuffer);
        while (br != -1) {
            writer.write(writeBuffer, 0, br);
            br = reader.read(writeBuffer);
        }
        writer.flush();
    }

    public static void copyText(Reader reader, Writer writer) throws IOException {
        IOUtils.copyText(reader, writer, 16384);
    }

    public static byte[] readFileToBuffer(File file) throws IOException {
        byte[] buffer = new byte[(int)file.length()];
        try (FileInputStream is = new FileInputStream(file);){
            IOUtils.readStreamToBuffer(is, buffer);
        }
        return buffer;
    }

    public static void writeFileFromBuffer(File file, byte[] buffer) throws IOException {
        try (FileOutputStream os = new FileOutputStream(file);){
            ((OutputStream)os).write(buffer);
        }
    }

    public static void writeFileFromString(File file, String str) throws IOException {
        try (FileWriter os = new FileWriter(file);){
            os.write(str);
        }
    }

    public static int readStreamToBuffer(InputStream inputStream, byte[] buffer) throws IOException {
        int totalRead;
        int br;
        for (totalRead = 0; totalRead != buffer.length && (br = inputStream.read(buffer, totalRead, buffer.length - totalRead)) != -1; totalRead += br) {
        }
        return totalRead;
    }

    public static String readLine(InputStream input) throws IOException {
        StringBuilder linebuf = new StringBuilder();
        int b = input.read();
        while (b != 10) {
            if (b == -1) {
                if (linebuf.length() != 0) break;
                return null;
            }
            if (b != 13) {
                linebuf.append((char)b);
            }
            b = input.read();
        }
        return linebuf.toString();
    }

    public static String readFullLine(InputStream input) throws IOException {
        StringBuilder linebuf = new StringBuilder();
        int b = input.read();
        while (true) {
            if (b == -1) {
                if (linebuf.length() != 0) break;
                return null;
            }
            linebuf.append((char)b);
            if (b == 10) break;
            b = input.read();
        }
        return linebuf.toString();
    }

    public static int findFreePort(int minPort, int maxPort) {
        int portRange = Math.abs(maxPort - minPort);
        while (true) {
            int portNum = minPort + SecurityUtils.getRandom().nextInt(portRange);
            try {
                ServerSocket socket = new ServerSocket(portNum);
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return portNum;
            }
            catch (IOException iOException) {
                continue;
            }
            break;
        }
    }

    public static String readToString(Reader is) throws IOException {
        int count;
        StringBuilder result = new StringBuilder(4000);
        char[] buffer = new char[4000];
        while ((count = is.read(buffer)) > 0) {
            result.append(buffer, 0, count);
        }
        return result.toString();
    }

    static void copyZipStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] writeBuffer = new byte[16384];
        int br = inputStream.read(writeBuffer);
        while (br != -1) {
            outputStream.write(writeBuffer, 0, br);
            br = inputStream.read(writeBuffer);
        }
        outputStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void extractZipArchive(InputStream stream, Path targetFolder) throws IOException {
        block10: {
            zipStream = new ZipInputStream(stream);
            while (true) lbl-1000:
            // 4 sources

            {
                if ((zipEntry = zipStream.getNextEntry()) == null) {
                    break block10;
                }
                try {
                    if (zipEntry.isDirectory()) ** GOTO lbl-1000
                    zipEntryName = zipEntry.getName();
                    IOUtils.checkAndExtractEntry(zipStream, zipEntry, targetFolder);
                }
                finally {
                    zipStream.closeEntry();
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
            finally {
                zipStream.close();
            }
        }
    }

    private static void checkAndExtractEntry(InputStream zipStream, ZipEntry zipEntry, Path targetFolder) throws IOException {
        Path localFile;
        if (!Files.exists(targetFolder, new LinkOption[0])) {
            try {
                Files.createDirectories(targetFolder, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IOException("Can't create local cache folder '" + String.valueOf(targetFolder.toAbsolutePath()) + "'", e);
            }
        }
        if (!(localFile = targetFolder.resolve(zipEntry.getName())).normalize().startsWith(targetFolder.normalize())) {
            throw new IOException("Zip entry is outside of the target directory");
        }
        if (Files.exists(localFile, new LinkOption[0])) {
            return;
        }
        Path localDir = localFile.getParent();
        if (!Files.exists(localDir, new LinkOption[0])) {
            try {
                Files.createDirectories(localDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IOException("Can't create local file directory in the cache '" + String.valueOf(localDir.toAbsolutePath()) + "'", e);
            }
        }
        try (OutputStream os = Files.newOutputStream(localFile, new OpenOption[0]);){
            IOUtils.copyZipStream(zipStream, os);
        }
    }

    public static void zipFolder(File folder, OutputStream outputStream) throws IOException {
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);){
            IOUtils.processFolder(folder, zipOutputStream, folder.getPath().length() + 1);
        }
    }

    private static void processFolder(File folder, ZipOutputStream zipOutputStream, int prefixLength) throws IOException {
        File[] folderFiles = folder.listFiles();
        if (folderFiles == null) {
            return;
        }
        for (File file : folderFiles) {
            BasicFileAttributes fAttrs = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            if (fAttrs.isRegularFile()) {
                ZipEntry zipEntry = new ZipEntry(file.getPath().substring(prefixLength));
                zipOutputStream.putNextEntry(zipEntry);
                try (FileInputStream inputStream = new FileInputStream(file);){
                    IOUtils.copyStream(inputStream, zipOutputStream);
                }
                zipOutputStream.closeEntry();
                continue;
            }
            if (!fAttrs.isDirectory()) continue;
            IOUtils.processFolder(file, zipOutputStream, prefixLength);
        }
    }

    public static void deleteDirectory(@NotNull Path path) throws IOException {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    @Nullable
    public static String getDirectoryPath(@NotNull String sPath) throws InvalidPathException {
        Path path = Paths.get(sPath, new String[0]);
        if (Files.isDirectory(path, new LinkOption[0])) {
            return path.toString();
        }
        Path parent = path.getParent();
        if (parent != null) {
            return parent.toString();
        }
        return null;
    }

    @NotNull
    public static String getFileNameWithoutExtension(@NotNull Path file) {
        return IOUtils.getPathWithoutFileExtension(file.getFileName().toString());
    }

    @NotNull
    public static String getPathWithoutFileExtension(@NotNull String path) {
        int divPos = path.lastIndexOf(46);
        if (divPos > 0) {
            return path.substring(0, divPos);
        }
        return path;
    }

    @Nullable
    public static String getFileExtension(Path file) {
        Path fileName = file.getFileName();
        if (fileName == null) {
            return null;
        }
        return IOUtils.getFileExtension(fileName.toString());
    }

    @Nullable
    public static String getFileExtension(String fileName) {
        int divPos = fileName.lastIndexOf(46);
        if (divPos != -1) {
            return fileName.substring(divPos + 1);
        }
        return null;
    }

    @NotNull
    public static Path getPathFromString(@NotNull String pathOrUri) {
        if (pathOrUri.contains("://")) {
            return Path.of(URI.create(pathOrUri));
        }
        return Path.of(pathOrUri, new String[0]);
    }

    public static boolean isLocalFile(String filePath) {
        int divPos = filePath.indexOf(":/");
        return divPos < 0 || divPos == 1 || filePath.startsWith("file:");
    }

    public static boolean isLocalURI(@NotNull URI uri) {
        return uri.getScheme().equals("file");
    }

    public static boolean isLocalPath(@NotNull Path filePath) {
        return IOUtils.isLocalURI(filePath.toUri());
    }

    public static boolean isFileFromDefaultFS(@NotNull Path path) {
        return path.getFileSystem().equals(FileSystems.getDefault());
    }

    public static boolean isFolderEmpty(@NotNull Path directory) throws IOException {
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(directory);){
            boolean bl = !dirStream.iterator().hasNext();
            return bl;
        }
    }
}

