/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dashboard.view;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.jexl3.JexlContext;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.dashboard.DBDashboardDataType;
import org.jkiss.dbeaver.model.dashboard.DBDashboardMapQuery;
import org.jkiss.dbeaver.model.dashboard.DBDashboardQuery;
import org.jkiss.dbeaver.model.dashboard.data.DashboardDataset;
import org.jkiss.dbeaver.model.dashboard.data.DashboardDatasetRow;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCResultSetMetaData;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatementType;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.dashboard.control.DashboardListViewer;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardContainer;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardGroupContainer;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardItemContainer;
import org.jkiss.dbeaver.ui.dashboard.view.DataSourceDashboardView;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class DashboardUpdater {
    private static final Log log = Log.getLog(DashboardUpdater.class);
    private final Map<DBPDataSourceContainer, List<MapQueryInfo>> mapQueries = new HashMap<DBPDataSourceContainer, List<MapQueryInfo>>();

    public boolean updateDashboards(@NotNull DBRProgressMonitor monitor) {
        ArrayList<DashboardItemContainer> dashboards = new ArrayList<DashboardItemContainer>();
        if (this.getDashboardsToUpdate(dashboards)) {
            return true;
        }
        this.updateDashboards(monitor, dashboards);
        return false;
    }

    private void updateDashboards(@NotNull DBRProgressMonitor monitor, @NotNull List<DashboardItemContainer> dashboards) {
        monitor.beginTask("Update dashboards", dashboards.size());
        for (DashboardItemContainer dashboardItemContainer : dashboards) {
            DBDashboardMapQuery mapQuery = dashboardItemContainer.getMapQuery();
            if (mapQuery == null) continue;
            List queryList = this.mapQueries.computeIfAbsent(dashboardItemContainer.getDataSourceContainer(), k -> new ArrayList());
            boolean found = false;
            for (MapQueryInfo mqi : queryList) {
                if (mqi.mapQuery != mapQuery) continue;
                found = true;
                break;
            }
            if (found) continue;
            queryList.add(new MapQueryInfo(dashboardItemContainer, dashboardItemContainer.getGroup().getView(), mapQuery));
        }
        for (Map.Entry entry : this.mapQueries.entrySet()) {
            monitor.subTask("Read dashboard data");
            DBPDataSourceContainer dsContainer = (DBPDataSourceContainer)entry.getKey();
            DBPDataSource dataSource = dsContainer.getDataSource();
            if (dataSource == null) continue;
            try {
                DBExecUtils.tryExecuteRecover(dashboards, (DBPDataSource)dataSource, param -> {
                    for (MapQueryInfo mqi : (List)mqEntry.getValue()) {
                        if (!mqi.dashboard.isAutoUpdateEnabled()) continue;
                        try {
                            this.readMapQueryData(monitor, mqi);
                        }
                        catch (DBCException e) {
                            log.debug((Object)("Datasource '" + mqi.dashboard.getDataSourceContainer().getName() + "' dashboard query failed. Stopping update of dashboard queries for this datasource."));
                            mqi.dashboard.disableAutoUpdate();
                            throw e;
                        }
                    }
                });
            }
            catch (DBException e) {
                log.debug((Object)("Error reading map query data for '" + dsContainer.getName() + "'"), (Throwable)e);
            }
        }
        for (DashboardItemContainer dashboardItemContainer : dashboards) {
            DBPDataSource dataSource;
            if (!dashboardItemContainer.isAutoUpdateEnabled() || (dataSource = dashboardItemContainer.getDataSourceContainer().getDataSource()) == null) continue;
            try {
                DBExecUtils.tryExecuteRecover(dashboards, (DBPDataSource)dataSource, param -> {
                    try {
                        this.updateDashboard(monitor, dashboard);
                    }
                    catch (Throwable e) {
                        log.debug((Object)("Datasource '" + dashboard.getDataSourceContainer().getName() + "' dashboard query failed. Stopping update of dashboards for this datasource."));
                        dashboard.disableAutoUpdate();
                        throw new InvocationTargetException(e);
                    }
                });
            }
            catch (DBException e) {
                log.debug((Object)("Error reading dashboard '" + dashboardItemContainer.getItemDescriptor().getId() + "' data: " + CommonUtils.getRootCause((Throwable)e).getMessage()));
            }
            monitor.worked(1);
        }
        monitor.done();
    }

    private void readMapQueryData(DBRProgressMonitor monitor, MapQueryInfo mqInfo) throws DBCException {
        block22: {
            DBCExecutionContext executionContext = mqInfo.viewContainer.getExecutionContext();
            if (executionContext == null) {
                return;
            }
            try (DBCSession session = executionContext.openSession(monitor, DBCExecutionPurpose.UTIL, "Read map query '" + mqInfo.mapQuery.getId() + "' data");){
                session.enableLogging(false);
                try (DBCStatement dbStat = session.prepareStatement(DBCStatementType.QUERY, mqInfo.mapQuery.getQueryText(), false, false, false);){
                    if (!dbStat.executeStatement()) break block22;
                    try (DBCResultSet dbResults = dbStat.openResultSet();){
                        mqInfo.timestamp = new Date();
                        while (dbResults.nextRow()) {
                            String mapKey = CommonUtils.toString((Object)dbResults.getAttributeValue(0));
                            Object mapValue = dbResults.getAttributeValue(1);
                            mqInfo.mapValue.put(mapKey, mapValue);
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new DBCException("Error reading map query data", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateDashboard(DBRProgressMonitor monitor, DashboardItemContainer dashboard) throws DBCException {
        if (!dashboard.getDataSourceContainer().isConnected() || DBWorkbench.getPlatform().isShuttingDown()) {
            return;
        }
        if (dashboard.getMapQuery() != null) {
            this.fetchDashboardMapData(monitor, dashboard);
            return;
        }
        List<? extends DBDashboardQuery> queries = dashboard.getQueryList();
        if (queries.isEmpty()) {
            return;
        }
        DashboardContainer view = dashboard.getGroup().getView();
        DBCExecutionContext executionContext = view.getExecutionContext();
        if (executionContext == null) {
            return;
        }
        try (DBCSession session = executionContext.openSession(monitor, DBCExecutionPurpose.UTIL, "Read dashboard '" + dashboard.getItemDescriptor().getName() + "' data");){
            session.enableLogging(false);
            DBCTransactionManager txnManager = DBUtils.getTransactionManager((DBCExecutionContext)session.getExecutionContext());
            boolean revertTxn = false;
            try {
                for (DBDashboardQuery dBDashboardQuery : queries) {
                    try {
                        DBCStatement dbStat = session.prepareStatement(DBCStatementType.QUERY, dBDashboardQuery.getQueryText(), false, false, false);
                        try {
                            if (!dbStat.executeStatement()) continue;
                            DBCResultSet dbResults = dbStat.openResultSet();
                            try {
                                if (dbResults == null) continue;
                                this.fetchDashboardData(dashboard, dbResults);
                            }
                            finally {
                                if (dbResults == null) continue;
                                dbResults.close();
                            }
                        }
                        finally {
                            if (dbStat == null) continue;
                            dbStat.close();
                        }
                    }
                    catch (Exception e) {
                        throw new DBCException("Error updating dashboard " + dashboard.getItemDescriptor().getId(), (Throwable)e, session.getExecutionContext());
                        return;
                    }
                }
            }
            finally {
                if (revertTxn) {
                    txnManager.setAutoCommit(monitor, false);
                }
            }
        }
    }

    private void fetchDashboardMapData(DBRProgressMonitor monitor, final DashboardItemContainer dashboard) {
        MapQueryInfo mqi = this.getMapQueryData(dashboard);
        if (mqi == null) {
            return;
        }
        Map<String, Object> mapValue = mqi.mapValue;
        if (mapValue != null) {
            Object[] mapKeys = dashboard.getMapKeys();
            Object[] mapLabels = dashboard.getMapLabels();
            if (!ArrayUtils.isEmpty((Object[])mapKeys)) {
                if (ArrayUtils.isEmpty((Object[])mapLabels)) {
                    mapLabels = mapKeys;
                }
                DashboardDataset dataset = new DashboardDataset((String[])mapLabels);
                Object[] mapValues = new Object[mapKeys.length];
                for (int i = 0; i < mapKeys.length; ++i) {
                    Number numValue;
                    Object value = mapValue.get(mapKeys[i]);
                    if (value instanceof Number) {
                        Number number = (Number)value;
                        numValue = number;
                    } else {
                        numValue = CommonUtils.toDouble((Object)value);
                    }
                    mapValues[i] = numValue;
                }
                Date timestamp = mqi.timestamp;
                if (timestamp == null) {
                    timestamp = new Date();
                }
                dataset.addRow(new DashboardDatasetRow(timestamp, mapValues));
                dashboard.updateDashboardData(dataset);
            } else if (dashboard.getMapFormula() != null) {
                final HashMap<String, Object> ciMap = new HashMap<String, Object>(mapValue.size());
                for (Map.Entry<String, Object> me : mapValue.entrySet()) {
                    ciMap.put(me.getKey().toLowerCase(Locale.ENGLISH), me.getValue());
                }
                JexlContext context = new JexlContext(){

                    public Object get(String name) {
                        if (name.equals("map")) {
                            return ciMap;
                        }
                        if (name.equals("dashboard")) {
                            return dashboard;
                        }
                        return null;
                    }

                    public void set(String name, Object value) {
                        log.warn((Object)"Set is not implemented in DBX model");
                    }

                    public boolean has(String name) {
                        return name.equals("object") || name.equals("dashboard");
                    }
                };
                Object result = dashboard.getMapFormula().evaluate(context);
                if (result instanceof Number) {
                    Object columnName = dashboard.getItemDescriptor().getName();
                    if (!ArrayUtils.isEmpty((Object[])mapLabels)) {
                        columnName = mapLabels[0];
                    }
                    DashboardDataset dataset = new DashboardDataset(new String[]{columnName});
                    dataset.addRow(new DashboardDatasetRow(new Date(), new Object[]{result}));
                    dashboard.updateDashboardData(dataset);
                } else {
                    log.debug((Object)("Wrong expression result: " + String.valueOf(result)));
                }
            }
        }
    }

    private void fetchDashboardData(DashboardItemContainer dashboardContainer, DBCResultSet dbResults) throws DBCException {
        DBCResultSetMetaData meta = dbResults.getMeta();
        List rsAttrs = meta.getAttributes();
        ArrayList<String> colNames = new ArrayList<String>();
        String tsColName = null;
        for (DBCAttributeMetaData rsAttr : rsAttrs) {
            String colName = rsAttr.getLabel();
            if (CommonUtils.isEmpty((String)colName)) {
                colName = rsAttr.getName();
            }
            if ("STAT_TIMESTAMP".equalsIgnoreCase(colName)) {
                tsColName = colName;
                continue;
            }
            colNames.add(colName);
        }
        DashboardDataset dataset = new DashboardDataset(colNames.toArray(new String[0]));
        while (dbResults.nextRow()) {
            Object[] values = new Object[colNames.size()];
            Date timestamp = tsColName != null ? (Date)dbResults.getAttributeValue(tsColName) : new Date();
            for (int i = 0; i < colNames.size(); ++i) {
                values[i] = dbResults.getAttributeValue((String)colNames.get(i));
            }
            dataset.addRow(new DashboardDatasetRow(timestamp, values));
            if (dataset.getRows().size() < dashboardContainer.getDashboardMaxItems()) continue;
            break;
        }
        switch (dashboardContainer.getItemDescriptor().getFetchType()) {
            case rows: {
                dataset = this.transposeDataset(dataset);
            }
        }
        dashboardContainer.updateDashboardData(dataset);
    }

    private DashboardDataset transposeDataset(DashboardDataset dataset) {
        int oldColumnCount = dataset.getColumnNames().length;
        if (oldColumnCount < 2) {
            return dataset;
        }
        ArrayList<String> colNamesFromRows = new ArrayList<String>();
        List oldRows = dataset.getRows();
        Date oldTimestamp = ((DashboardDatasetRow)oldRows.get(0)).getTimestamp();
        DashboardDatasetRow[] newRows = new DashboardDatasetRow[oldColumnCount - 1];
        for (int i = 0; i < oldRows.size(); ++i) {
            DashboardDatasetRow oldRow = (DashboardDatasetRow)oldRows.get(i);
            colNamesFromRows.add(CommonUtils.toString((Object)oldRow.getValues()[0], (String)String.valueOf(i + 1)));
            for (int colIndex = 1; colIndex < oldColumnCount; ++colIndex) {
                DashboardDatasetRow newRow = newRows[colIndex - 1];
                if (newRow == null) {
                    newRows[colIndex - 1] = newRow = new DashboardDatasetRow(oldTimestamp, new Object[oldRows.size()]);
                }
                newRow.getValues()[i] = oldRow.getValues()[colIndex];
            }
        }
        DashboardDataset newDataset = new DashboardDataset(colNamesFromRows.toArray(new String[0]));
        for (DashboardDatasetRow newRow : newRows) {
            newDataset.addRow(newRow);
        }
        return newDataset;
    }

    public boolean getDashboardsToUpdate(List<DashboardItemContainer> dashboards) {
        boolean pauseDashboardUpdate = true;
        for (IWorkbenchWindow window : PlatformUI.getWorkbench().getWorkbenchWindows()) {
            for (IWorkbenchPage page : window.getPages()) {
                for (IViewReference view : page.getViewReferences()) {
                    DataSourceDashboardView dv;
                    IWorkbenchPart part;
                    if (!view.getId().equalsIgnoreCase("org.jkiss.dbeaver.ui.dashboardView") || !((part = view.getPart(false)) instanceof DataSourceDashboardView) || !this.checkViewDashboards(dv = (DataSourceDashboardView)part)) continue;
                    this.getViewDashboards(dv, dashboards);
                    pauseDashboardUpdate = false;
                }
            }
        }
        return pauseDashboardUpdate;
    }

    private boolean checkViewDashboards(DataSourceDashboardView view) {
        DashboardListViewer viewManager = view.getDashboardListViewer();
        return viewManager != null && viewManager.getDataSourceContainer().isConnected();
    }

    private void getViewDashboards(DataSourceDashboardView view, List<DashboardItemContainer> dashboards) {
        long currentTime = System.currentTimeMillis();
        DashboardListViewer viewManager = view.getDashboardListViewer();
        for (DashboardGroupContainer dashboardGroupContainer : viewManager.getGroups()) {
            for (DashboardItemContainer dashboardItemContainer : dashboardGroupContainer.getItems()) {
                Date lastUpdateTime;
                if (dashboardItemContainer.getItemDescriptor().getDataType() == DBDashboardDataType.provided || (lastUpdateTime = dashboardItemContainer.getLastUpdateTime()) != null && currentTime - lastUpdateTime.getTime() < dashboardItemContainer.getUpdatePeriod()) continue;
                dashboards.add(dashboardItemContainer);
            }
        }
    }

    private MapQueryInfo getMapQueryData(DashboardItemContainer dashboard) {
        List<MapQueryInfo> mapQueryInfos = this.mapQueries.get(dashboard.getDataSourceContainer());
        if (mapQueryInfos != null) {
            for (MapQueryInfo mqi : mapQueryInfos) {
                if (mqi.mapQuery != dashboard.getMapQuery()) continue;
                return mqi;
            }
        }
        return null;
    }

    private static class MapQueryInfo {
        private final DashboardItemContainer dashboard;
        private final DashboardContainer viewContainer;
        private final DBDashboardMapQuery mapQuery;
        public Date timestamp;
        private final Map<String, Object> mapValue = new HashMap<String, Object>();

        public MapQueryInfo(DashboardItemContainer dashboard, DashboardContainer viewContainer, DBDashboardMapQuery mapQuery) {
            this.dashboard = dashboard;
            this.viewContainer = viewContainer;
            this.mapQuery = mapQuery;
        }
    }
}

