/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.greenplum.model;

import java.sql.ResultSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.greenplum.model.GreenplumCharacterSet;
import org.jkiss.dbeaver.ext.greenplum.model.GreenplumExternalTableUriLocationsHandler;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTable;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableColumn;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.meta.IPropertyValueTransformer;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class GreenplumExternalTable
extends PostgreTable {
    private static final String DEFAULT_FORMAT_OPTIONS = "delimiter ',' null '' escape '\"' quote '\"' header";
    private GreenplumExternalTableUriLocationsHandler uriLocationsHandler;
    private String execLocation;
    private FormatType formatType;
    private String formatOptions;
    private String encoding;
    private RejectLimitType rejectLimitType;
    private int rejectLimit;
    private boolean writable;
    private boolean temporaryTable;
    private boolean loggingErrors;
    private String command;

    public GreenplumExternalTable(PostgreSchema catalog) {
        super((PostgreTableContainer)catalog);
        this.uriLocationsHandler = new GreenplumExternalTableUriLocationsHandler("", '\n');
        this.encoding = GreenplumCharacterSet.UNICODE_8BIT.getCharacterSetValue();
        this.formatType = FormatType.t;
        this.formatOptions = DEFAULT_FORMAT_OPTIONS;
    }

    public GreenplumExternalTable(PostgreSchema catalog, ResultSet dbResult) {
        super((PostgreTableContainer)catalog, dbResult);
        this.uriLocationsHandler = new GreenplumExternalTableUriLocationsHandler(JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"urilocation"), ',');
        this.execLocation = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"execlocation");
        this.formatType = (FormatType)CommonUtils.valueOf(FormatType.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"fmttype"), (Enum)FormatType.b);
        this.formatOptions = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"fmtopts");
        this.encoding = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"encoding");
        this.rejectLimit = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"rejectlimit");
        String rejectlimittype = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"rejectlimittype");
        this.writable = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"writable");
        this.temporaryTable = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"is_temp_table");
        this.loggingErrors = !((PostgreDataSource)this.getDataSource()).isServerVersionAtLeast(9, 4) && JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"is_logging_errors");
        this.command = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"command");
        this.rejectLimitType = rejectlimittype != null && rejectlimittype.length() > 0 ? (RejectLimitType)CommonUtils.valueOf(RejectLimitType.class, (String)rejectlimittype, (Enum)RejectLimitType.r) : null;
    }

    @Property(viewable=true, editable=true, updatable=true, order=24, length=PropertyLength.MULTILINE, valueRenderer=ExternalTableUriLocationsRenderer.class)
    public String getUriLocations() {
        return this.uriLocationsHandler.getCommaSeparatedList();
    }

    public void setUriLocations(String lineFeedSeparatedUriLocations) {
        this.uriLocationsHandler = new GreenplumExternalTableUriLocationsHandler(lineFeedSeparatedUriLocations, '\n');
    }

    public String getExecLocation() {
        return this.execLocation;
    }

    @Property(viewable=true, editable=true, updatable=true, order=26, listProvider=ExternalTableFormatTypeProvider.class)
    public String getFormatType() {
        if (this.formatType == null) {
            return null;
        }
        return this.formatType.getValue();
    }

    public void setFormatType(String formatType) {
        this.formatType = FormatType.fromValue(formatType);
    }

    @Property(viewable=true, editable=true, updatable=true, order=27)
    public String getFormatOptions() {
        return this.formatOptions;
    }

    public void setFormatOptions(String formatOptions) {
        this.formatOptions = formatOptions;
    }

    @Property(viewable=true, editable=true, updatable=true, order=25, listProvider=GreenplumCharacterSetProvider.class)
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public RejectLimitType getRejectLimitType() {
        return this.rejectLimitType;
    }

    public int getRejectLimit() {
        return this.rejectLimit;
    }

    public boolean isWritable() {
        return this.writable;
    }

    public boolean isTemporaryTable() {
        return this.temporaryTable;
    }

    public boolean isLoggingErrors() {
        return this.loggingErrors;
    }

    public String getCommand() {
        return this.command;
    }

    public String generateDDL(DBRProgressMonitor monitor) throws DBException {
        StringBuilder ddlBuilder = new StringBuilder();
        ddlBuilder.append("CREATE ").append(this.isWritable() ? "WRITABLE " : "").append("EXTERNAL ").append(this.isWebTable() ? "WEB " : "").append(this.isTemporaryTable() ? "TEMPORARY " : "").append("TABLE ").append(this.addDatabaseQualifier()).append(this.getName()).append(" (\n");
        List<PostgreTableColumn> tableColumns = this.filterOutNonMetadataColumns(monitor);
        if (tableColumns.size() == 0) {
            ddlBuilder.append("\n)\n");
        } else if (tableColumns.size() == 1) {
            PostgreTableColumn column = tableColumns.get(0);
            ddlBuilder.append("\t").append(column.getName()).append(" ").append(column.getTypeName()).append("\n)\n");
        } else {
            ddlBuilder.append(tableColumns.stream().map(field -> "\t" + field.getName() + " " + field.getTypeName()).collect(Collectors.joining(",\n")));
            ddlBuilder.append("\n)\n");
        }
        if (CommonUtils.isNotEmpty((String)this.getUriLocations())) {
            ddlBuilder.append("LOCATION (\n");
            ddlBuilder.append(this.uriLocationsHandler.stream().map(location -> "\t'" + location + "'").collect(Collectors.joining(",\n")));
            ddlBuilder.append("\n) ").append(this.determineExecutionLocation()).append("\n");
        } else if (this.tableHasCommand()) {
            ddlBuilder.append("EXECUTE '").append(this.getCommand()).append("' ").append(this.determineExecutionLocation()).append("\n");
        }
        ddlBuilder.append("FORMAT '").append(this.getFormatType()).append("'");
        if (this.getFormatOptions() != null) {
            ddlBuilder.append(this.generateFormatOptions(this.formatType, this.getFormatOptions()));
        }
        if (this.getEncoding() != null && this.getEncoding().length() > 0) {
            ddlBuilder.append("\nENCODING '").append(this.getEncoding()).append("'");
        }
        if (this.isLoggingErrors()) {
            ddlBuilder.append("\nLOG ERRORS");
        }
        if (this.getRejectLimit() > 0 && this.getRejectLimitType() != null) {
            ddlBuilder.append(this.isLoggingErrors() ? " " : "\n").append("SEGMENT REJECT LIMIT ").append(this.getRejectLimit()).append(" ").append(this.getRejectLimitType().getValue());
        }
        return ddlBuilder.toString();
    }

    public String generateChangeOwnerQuery(@NotNull String owner, @NotNull Map<String, Object> options) {
        assert (CommonUtils.isNotEmpty((String)owner));
        return "ALTER EXTERNAL TABLE " + DBUtils.getEntityScriptName((DBSObject)this, options) + " OWNER TO " + owner;
    }

    private List<PostgreTableColumn> filterOutNonMetadataColumns(DBRProgressMonitor monitor) throws DBException {
        List<PostgreTableColumn> tableColumns;
        Stream tableColumnsStream = Optional.ofNullable(this.getAttributes(monitor)).orElse(Collections.emptyList()).stream();
        if (this.isPersisted()) {
            tableColumns = tableColumnsStream.filter(field -> field.getOrdinalPosition() >= 0).collect(Collectors.toList());
        } else {
            int TEMPORARY_COLUMN_ORDINAL_POSITION = -1;
            tableColumns = tableColumnsStream.filter(field -> field.getOrdinalPosition() == -1).collect(Collectors.toList());
        }
        return tableColumns;
    }

    private CharSequence addDatabaseQualifier() {
        StringBuilder databaseQualifier = new StringBuilder().append(this.getDatabase().getName()).append(".").append(this.getSchema().getName()).append(".");
        return this.isTemporaryTable() ? "" : databaseQualifier;
    }

    private boolean tableHasCommand() {
        return this.getCommand() != null && !this.getCommand().isEmpty();
    }

    private boolean isWebTable() {
        return this.uriLocationsHandler.stream().anyMatch(location -> location.startsWith("http")) || this.tableHasCommand();
    }

    private String generateFormatOptions(FormatType formatType, String formatOptions) {
        if (formatType == null || formatOptions.isEmpty()) {
            return "";
        }
        if (formatType.equals((Object)FormatType.b)) {
            String[] formatSpecTokens = formatOptions.split(" ");
            String formatterSpec = formatSpecTokens.length >= 2 ? formatSpecTokens[1] : "";
            return " ( FORMATTER=" + formatterSpec + " )";
        }
        return " ( " + formatOptions + " )";
    }

    private String determineExecutionLocation() {
        if (this.getExecLocation() != null && this.getExecLocation().equalsIgnoreCase("MASTER_ONLY")) {
            return "ON MASTER";
        }
        return "ON ALL";
    }

    public static enum FormatType {
        c("CSV"),
        t("TEXT"),
        b("CUSTOM");

        private String formatType;

        private FormatType(String formatTypeString) {
            this.formatType = formatTypeString;
        }

        public String getValue() {
            return this.formatType;
        }

        public static FormatType fromValue(String formatTypeString) throws IllegalArgumentException {
            return Arrays.stream(FormatType.values()).filter(formatType -> formatType.getValue().equalsIgnoreCase(formatTypeString)).findFirst().orElse(b);
        }
    }

    public static enum RejectLimitType {
        r("ROWS"),
        p("PERCENT ");

        private String rejectLimitType;

        private RejectLimitType(String rejectLimitTypeString) {
            this.rejectLimitType = rejectLimitTypeString;
        }

        public String getValue() {
            return this.rejectLimitType;
        }
    }

    public static class ExternalTableUriLocationsRenderer
    implements IPropertyValueTransformer<GreenplumExternalTable, String> {
        @Nullable
        public String transform(@NotNull GreenplumExternalTable greenplumExternalTable, @Nullable String commaSeparatedListUriLocations) throws IllegalArgumentException {
            return greenplumExternalTable.uriLocationsHandler.getLineFeedSeparatedList();
        }
    }

    public static class GreenplumCharacterSetProvider
    implements IPropertyValueListProvider<GreenplumExternalTable> {
        public boolean allowCustomValue() {
            return false;
        }

        @Nullable
        public Object[] getPossibleValues(GreenplumExternalTable object) {
            return Arrays.stream(GreenplumCharacterSet.values()).map(GreenplumCharacterSet::getCharacterSetValue).toArray();
        }
    }

    public static class ExternalTableFormatTypeProvider
    implements IPropertyValueListProvider<GreenplumExternalTable> {
        public boolean allowCustomValue() {
            return false;
        }

        @Nullable
        public Object[] getPossibleValues(GreenplumExternalTable object) {
            Predicate<FormatType> excludeCustomTypes = formatType -> !formatType.equals((Object)FormatType.b);
            return Arrays.stream(FormatType.values()).filter(excludeCustomTypes).map(FormatType::getValue).toArray();
        }
    }
}

