/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.app.standalone.actions;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.jkiss.dbeaver.model.file.FileTypeHandlerDescriptor;
import org.jkiss.dbeaver.model.file.FileTypeHandlerRegistry;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.utils.ArrayUtils;

public class OpenLocalFileActionExt
extends AbstractHandler {
    private String filterPath;
    private String filterExtension;

    public OpenLocalFileActionExt() {
        this.setEnabled(true);
        this.filterPath = DialogUtils.getCurDialogFolder();
    }

    public void dispose() {
        this.filterPath = null;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String[] names;
        int extIndex;
        Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        TreeSet<String> extensions = new TreeSet<String>();
        extensions.add("*.*");
        for (FileTypeHandlerDescriptor dhd : FileTypeHandlerRegistry.getInstance().getHandlers()) {
            extensions.add(Stream.of(dhd.getExtensions()).map(FileTypeHandlerDescriptor.Extension::getExtensions).flatMap(Arrays::stream).map(e -> "*." + e).collect(Collectors.joining(";")));
        }
        FileDialog dialog = new FileDialog(activeShell, 0x10001002);
        dialog.setText(IDEWorkbenchMessages.OpenLocalFileAction_title);
        dialog.setFilterPath(this.filterPath);
        Object[] dialogExtensions = extensions.toArray(new String[0]);
        dialog.setFilterExtensions((String[])dialogExtensions);
        if (this.filterExtension != null && (extIndex = ArrayUtils.indexOf((Object[])dialogExtensions, (Object)this.filterExtension)) >= 0) {
            dialog.setFilterIndex(extIndex);
        }
        if (dialog.open() == null) {
            return null;
        }
        if (dialog.getFilterIndex() >= 0) {
            this.filterExtension = dialog.getFilterExtensions()[dialog.getFilterIndex()];
        }
        if ((names = dialog.getFileNames()) != null) {
            this.filterPath = dialog.getFilterPath();
            DialogUtils.setCurDialogFolder((String)this.filterPath);
            int numberOfFilesNotFound = 0;
            StringBuilder notFound = new StringBuilder();
            ArrayList<Path> fileList = new ArrayList<Path>();
            for (String name : names) {
                Path filePath = Path.of(this.filterPath, new String[0]).resolve(name);
                if (!Files.exists(filePath, new LinkOption[0])) {
                    if (++numberOfFilesNotFound > 1) {
                        notFound.append('\n');
                    }
                    notFound.append(filePath);
                    continue;
                }
                fileList.add(filePath);
            }
            String[] fileNames = (String[])fileList.stream().map(p -> p.toAbsolutePath().toString()).toArray(String[]::new);
            EditorUtils.openExternalFiles((String[])fileNames, null);
            if (numberOfFilesNotFound > 0) {
                String msgFmt = numberOfFilesNotFound == 1 ? IDEWorkbenchMessages.OpenLocalFileAction_message_fileNotFound : IDEWorkbenchMessages.OpenLocalFileAction_message_filesNotFound;
                String msg = NLS.bind((String)msgFmt, (Object)notFound.toString());
                MessageDialog.open((int)1, (Shell)activeShell, (String)IDEWorkbenchMessages.OpenLocalFileAction_title, (String)msg, (int)0x10000000);
            }
        }
        return null;
    }
}

