/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.ui.config;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.ext.exasol.ExasolUserType;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.ext.exasol.ui.internal.ExasolMessages;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;

public class ExasolUserDialog
extends BaseDialog {
    private String name = "";
    private String password = "";
    private String ldapDN = "";
    private String comment = "";
    private String kerberosPrincipal;
    private ExasolUserType selectedType;

    public ExasolUserDialog(Shell parentShell, ExasolDataSource datasource) {
        super(parentShell, "Create User", null);
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        Composite group = new Composite(composite, 0);
        Composite groupText = new Composite(composite, 0);
        group.setLayoutData((Object)new GridData(1808));
        group.setLayout((Layout)new GridLayout(2, true));
        groupText.setLayoutData((Object)new GridData(1808));
        groupText.setLayout((Layout)new GridLayout(2, true));
        final Text nameText = UIUtils.createLabelText((Composite)group, (String)ExasolMessages.dialog_create_user_userid, (String)"");
        final Text commentText = UIUtils.createLabelText((Composite)group, (String)ExasolMessages.dialog_create_user_comment, (String)"", (int)2050);
        String[] userTypes = new String[]{ExasolMessages.dialog_create_user_kerberos, ExasolMessages.dialog_create_user_ldap, ExasolMessages.dialog_create_user_local};
        final Text passwordText = UIUtils.createLabelText((Composite)groupText, (String)ExasolMessages.dialog_create_user_local_password, (String)"", (int)0x400800);
        final Text urlText = UIUtils.createLabelText((Composite)groupText, (String)ExasolMessages.dialog_create_user_ldap_dn, (String)"");
        final Text principalText = UIUtils.createLabelText((Composite)groupText, (String)ExasolMessages.dialog_create_user_kerberos_principal, (String)"");
        passwordText.setEnabled(false);
        urlText.setEnabled(false);
        principalText.setEnabled(false);
        int cnt = 0;
        for (ExasolUserType type : ExasolUserType.values()) {
            UIUtils.createRadioButton((Composite)group, (String)userTypes[cnt], (Object)type, (SelectionListener)SelectionListener.widgetSelectedAdapter(selectionEvent -> {
                this.selectedType = (ExasolUserType)selectionEvent.widget.getData();
                switch (this.selectedType) {
                    case KERBEROS: {
                        passwordText.setEnabled(false);
                        urlText.setEnabled(false);
                        principalText.setEnabled(true);
                        break;
                    }
                    case LDAP: {
                        passwordText.setEnabled(false);
                        urlText.setEnabled(true);
                        principalText.setEnabled(false);
                        break;
                    }
                    case LOCAL: {
                        passwordText.setEnabled(true);
                        urlText.setEnabled(false);
                        principalText.setEnabled(false);
                        break;
                    }
                    default: {
                        passwordText.setEnabled(false);
                        urlText.setEnabled(false);
                        principalText.setEnabled(false);
                    }
                }
            }));
            ++cnt;
        }
        urlText.setEnabled(false);
        ModifyListener mod = new ModifyListener(){
            final /* synthetic */ ExasolUserDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void modifyText(ModifyEvent e) {
                this.this$0.name = nameText.getText().trim();
                this.this$0.ldapDN = urlText.getText().trim();
                this.this$0.kerberosPrincipal = principalText.getText().trim();
                this.this$0.password = passwordText.getText();
                this.this$0.comment = commentText.getText();
                this.this$0.getButton(0).setEnabled(!this.this$0.name.isEmpty());
                if (this.this$0.name.isEmpty() | this.this$0.selectedType == ExasolUserType.KERBEROS & this.this$0.kerberosPrincipal.isEmpty() | this.this$0.selectedType == ExasolUserType.LDAP & this.this$0.ldapDN.isEmpty() | this.this$0.selectedType == ExasolUserType.LOCAL & this.this$0.password.isEmpty()) {
                    this.this$0.getButton(0).setEnabled(false);
                } else {
                    this.this$0.getButton(0).setEnabled(true);
                }
            }
        };
        nameText.addModifyListener(mod);
        passwordText.addModifyListener(mod);
        urlText.addModifyListener(mod);
        principalText.addModifyListener(mod);
        return composite;
    }

    public String getName() {
        return this.name;
    }

    public String getPassword() {
        return this.password;
    }

    public String getKerberosPrincipal() {
        return this.kerberosPrincipal;
    }

    public String getLDAPDN() {
        return this.ldapDN;
    }

    public String getComment() {
        return this.comment;
    }

    public ExasolUserType getUserType() {
        return this.selectedType;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }
}

