define(["exports","./../layoutmanager.js","./../dom.js","./../focusmanager.js","./../skinviewmanager.js"],function(_exports,_layoutmanager,_dom,_focusmanager,_skinviewmanager){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,require(["scrollStyles"]);var deviceMemory,platform,cores,preventScrollSupported=function(){var supported=!1;try{var focusOptions={};Object.defineProperty(focusOptions,"preventScroll",{get:function(){return supported=!0},enumerable:!0,configurable:!0}),document.createElement("div").focus(focusOptions)}catch(err){console.log("error testing preventScroll support: "+err)}return supported}(),allowAnimatedScroll=!((cores=navigator.hardwareConcurrency||4)<4||(2400<=(screen.width||screen.availWidth||0)||1400<=(screen.height||screen.availHeight||0))&&cores<6||(deviceMemory=navigator.deviceMemory||2)<2||!document.documentElement.animate||!CSS.supports("display","flow-root")||(platform=(navigator.platform||"").toLowerCase(),"android"===globalThis.appMode&&(cores<4||deviceMemory<2||platform.includes("armv7"))));function within(number,start,end){var min=start<end?start:end,start=end<start?start:end;return number<min?min:start<number?start:number}function parsePxToInt(value){return!value||!(value=value.endsWith("px")?value.substring(0,value.length-2):value)||(value=parseInt(value),isNaN(value))?0:value}var PaddingInlineStartProp=CSS.supports("padding-inline-start","0")?"padding-inline-start":CSS.supports("-webkit-padding-start","0")?"-webkit-padding-start":"padding-left",PaddingInlineEndProp=CSS.supports("padding-inline-end","0")?"padding-inline-end":CSS.supports("-webkit-padding-end","0")?"-webkit-padding-end":"padding-right";function parseFocusScrollOffset(instance,offset){switch(offset){case"-padding-inline-start":return 0-instance.getPadding().inlineStart;case"-padding-top":return 0-instance.getPadding().top;default:var lengthStr=offset,value=parseFloat(lengthStr);if(!(lengthStr=lengthStr.match(/[a-zA-Z%]+/))||0===lengthStr.length)return value;switch(lengthStr[0].toLowerCase()){case"px":return value;case"rem":return value*parseFloat(getComputedStyle(document.documentElement).fontSize);case"vw":return value/100*_dom.default.getWindowSize().innerWidth;case"vh":return value/100*_dom.default.getWindowSize().innerHeight}throw new Error("Unsupported unit for conversion: "+lengthStr)}}function resetScroll(){this.scrollTop=0,this.scrollLeft=0}function resetScrollTop(){this.scrollTop=0}function resetScrollLeft(){this.scrollLeft=0}var wheelEvent=document.implementation.hasFeature("Event.wheel","3.0")?"wheel":"mousewheel",interactiveElements=["INPUT","SELECT","TEXTAREA"],abs=Math.abs,round=Math.round;var isSmoothScrollSupported="scrollBehavior"in document.documentElement.style,SupportsScrollMethodOptions=isSmoothScrollSupported;function Scroller(frame,options){var options=Object.assign({},{slidee:null,horizontal:!1,mouseWheel:!0,scrollBy:100,dragSource:null,dragThreshold:3,speed:_skinviewmanager.default.getSkinOptions().scrollAnimationSpeed||320,autoStartEdge:!0,autoPreventScrollOnFocus:!0,scrollTiming:_skinviewmanager.default.getSkinOptions().scrollTiming},options),slideeElement=(_skinviewmanager.default.getSkinOptions().scrollerAlwaysAllowNativeSmoothScroll&&(options.allowNativeSmoothScroll=!0),options.forceNativeScroll?options.enableNativeScroll=!0:options.forceSmoothScroll?options.enableNativeScroll=!allowAnimatedScroll||isSmoothScrollSupported&&options.allowNativeSmoothScroll:_layoutmanager.default.tv&&allowAnimatedScroll||(options.enableNativeScroll=!0),options.inlineMultiplier="rtl"===document.dir?-1:1,(this.options=options).slidee),slideeElement=(this.listenerCount=0,this._pos={endX:0,endY:0,scrollLeft:0,scrollTop:0},this.dragSourceElement=options.dragSource||frame,this.currentDelta=0,this.initialized=0,this.slideeElement=slideeElement,this.slideeElementStyle=slideeElement.style,this.options=options,this.dragging={},this.contentRects=[],this.resizeListeners=[],frame);this.nativeScrollElement=slideeElement,this.frame=frame,this.requiresReflow=!0,this.frameSize={width:0,height:0},this.slideeSize={width:0,height:0},this.onSourceClickFn=function(event){var dragging=this.dragging;!dragging.locked&&0<Math.abs(dragging.delta)&&(dragging.locked=1,event.preventDefault(),event.stopPropagation(),(event.currentTarget||event.target).removeEventListener(event.type,this.onSourceClickFn))}.bind(this),this.onScrollForCachingFn=function(e){this._cachedScrollTop=null,this._cachedScrollLeft=null}.bind(this)}function onResize(entries){var contentRects=this.contentRects,hasResize=!1;this._cachedScrollTop=null,this._cachedScrollLeft=null,this._cachedScrollHeight=null,this._cachedScrollWidth=null,this._framePadding=null,this._slideePadding=null,this._frameRect=null;for(var i=0,length=entries.length;i<length;i++){var entry=entries[i];if(entry){var newRect=entry.contentRect;if(0!==newRect.width&&0!==newRect.height){entry=contentRects?function(contentRects,target){for(var i=0,length=contentRects.length;i<length;i++){var _rect=contentRects[i];if(_rect.target===target)return _rect}var rect={target:target};return contentRects.push(rect),rect}(contentRects,entry.target):null;if(entry&&(newRect.width!==entry.width||newRect.height!==entry.height)){entry.width=newRect.width,entry.height=newRect.height,hasResize=!0;break}}}}hasResize&&(this.options.enableNativeScroll?this.requiresReflow=!0:load(this,!1));var listeners=this.resizeListeners;if(listeners)for(var _i=0,_length=listeners.length;_i<_length;_i++)listeners[_i](entries)}function load(instance,isInit){var pos;instance.requiresReflow=!0,isInit||(instance.ensureSizeInfo(),(isInit=instance.options).enableNativeScroll||(pos=instance._pos,isInit.dualScroll)||(isInit.horizontal?(isInit=within(instance.getScrollPosition(),0,pos.endX),instance.scrollToPosition({position:isInit})):(isInit=within(instance.getScrollPosition(),0,pos.endY),instance.scrollToPosition({position:isInit}))),instance.requiresReflow=!0)}function onDragEnd(instance){var dragging=instance.dragging,dragHandler=(dragging.released=!0,instance.dragHandler);dragHandler&&(_dom.default.removeEventListener(document,"pointermove",dragHandler,{passive:!0}),_dom.default.removeEventListener(document,"pointerup",dragHandler,{passive:!0})),setTimeout(function(){dragging.source.removeEventListener("click",instance.onSourceClickFn)}),dragging.init=0}function dragHandler(event){var dragging=this.dragging,options=this.options,released="pointerup"===event.type,touches=getTouches(event),touches=touches&&touches.length?touches[0]:event,pathX=touches.clientX-dragging.initX,touches=touches.clientY-dragging.initY,horizontal=options.horizontal,absDelta=(dragging.delta=horizontal?pathX:touches,Math.abs(dragging.delta));if(released||!(absDelta<1)){if(!dragging.init){if(absDelta<options.dragThreshold)return released?onDragEnd(this):void 0;if(!(horizontal?abs(pathX)>abs(touches):abs(pathX)<abs(touches)))return onDragEnd(this);dragging.init=1}event.preventDefault();var time,options=dragging.initPos-dragging.delta,pathX=event.timeStamp,touches=pathX-dragging.startTime;released?(onDragEnd(this),touches<200&&absDelta<=0||(event=options,absDelta=dragging.momentumPos,time=touches,this.getScrollSize(),horizontal=void getFrameSize(this,horizontal),absDelta=event-absDelta,time=Math.abs(absDelta)/time,event+=time/(2*(horizontal=void 0===horizontal?6e-4:horizontal))*(absDelta<0?-1:1),absDelta=time/horizontal,time={destination:Math.round(event),duration:absDelta},options=Math.max(0,time.destination))):300<touches&&(dragging.startTime=pathX,dragging.momentumPos=options),this.scrollToPosition({behavior:released?"smooth":"instant",position:options})}}function getFrameSize(instance,horizontal,subtractPadding){var frameSize=instance.frameSize,frameSize=horizontal?frameSize.width:frameSize.height;return subtractPadding?subtractPaddingFromFrameSize(instance,horizontal,frameSize):frameSize}function subtractPaddingFromFrameSize(instance,horizontal,frameSize){instance=instance.getPadding();return horizontal?frameSize-instance.inlineStart-instance.inlineEnd:frameSize-instance.top-instance.bottom}function getTouches(e){return e.changedTouches||e.targetTouches||e.touches}function onDragStart(event){var dragging,options,touches;0!==event.button||(dragging=this.dragging).init||function(element){for(;element;){if(interactiveElements.includes(element.tagName))return 1;element=element.parentNode}}(event.target)||(options=this.options,event.preventDefault(),dragging.init=0,dragging.startTime=event.timeStamp,dragging.source=event.target,touches=(touches=getTouches(event))&&touches.length?touches[0]:event,dragging.initX=touches.clientX,dragging.initY=touches.clientY,dragging.momentumPos=dragging.initPos=this.getScrollPosition(),dragging.delta=0,dragging.locked=0,dragging.source.addEventListener("click",this.onSourceClickFn),options.enableNativeScroll)||(event=this.dragHandler,_dom.default.addEventListener(document,"pointermove",event,{}),_dom.default.addEventListener(document,"pointerup",event,{}))}var SupportsTranslateProperty=CSS.supports("translate","40px 100px"),TranslateProperty=SupportsTranslateProperty?"translate":"transform";function addFrameResizeObserver(instance){instance.frameResizeObserver||(instance.frameResizeObserver=new ResizeObserver(onResize.bind(instance),{}),instance.options.enableNativeScroll?(instance.frameResizeObserver.observe(instance.nativeScrollElement),instance.frameResizeObserver.observe(instance.slideeElement)):(instance.frameResizeObserver.observe(instance.slideeElement),instance.frameResizeObserver.observe(instance.frame)))}function scrollNative(instance,pos){var elem=instance.nativeScrollElement,isInstant="instant"===pos.behavior;return elem.scroll&&!isInstant?SupportsScrollMethodOptions?(null==pos.behavior&&(pos.behavior="auto"),elem.scroll(pos)):elem.scroll(Math.round(pos.left||0),Math.round(pos.top||0)):!elem.scrollTo||!SupportsScrollMethodOptions&&isInstant?(null!=pos.left&&(elem.scrollLeft=Math.round(pos.left)),null!=pos.top&&(elem.scrollTop=Math.round(pos.top))):SupportsScrollMethodOptions?(null==pos.behavior&&(pos.behavior="auto"),elem.scrollTo(pos)):elem.scrollTo(Math.round(pos.left||0),Math.round(pos.top||0)),instance._cachedScrollLeft=null,instance._cachedScrollTop=null,!1===pos.useDelayedPromise?Promise.resolve():setTimeoutPromise(!isSmoothScrollSupported||isInstant?0:100)}function setTimeoutPromise(delay){return new Promise(function(resolve,reject){setTimeout(resolve,delay)})}function renderAnimateWithTransform(instance,scrollOptions,immediate,useDelayedPromise){var options=instance.options,speed=options.speed,immediate=(immediate&&(speed=0),scrollOptions.left),top=scrollOptions.top,immediate=(null==immediate&&(immediate=instance.getScrollLeft()),null==top&&(top=instance.getScrollTop()),function(left,top){return left||top?SupportsTranslateProperty?left+"px "+top+"px":"translate("+left+"px, "+top+"px)":"none"}(-round(immediate),-round(top))),top=instance._lastTransitionValue,options=options.scrollTiming||"ease-out",options=TranslateProperty+" "+speed+"ms "+options;return options!==top&&(instance.slideeElementStyle.transitionDuration=options,instance._lastTransitionValue=options),instance.slideeElementStyle[TranslateProperty]=immediate,null!=scrollOptions.left&&(instance._pos.scrollLeft=scrollOptions.left),null!=scrollOptions.top&&(instance._pos.scrollTop=scrollOptions.top),function(instance){instance.options.dispatchScrollEvent&&instance.frame.dispatchEvent(new CustomEvent(instance.getScrollEventName(),{bubbles:!1,cancelable:!1}))}(instance),!1===useDelayedPromise?Promise.resolve():setTimeoutPromise(speed)}Scroller.prototype.init=function(){var options,frame,slideeElement,nativeScrollElement;if(!this.initialized)return options=this.options,frame=this.frame,slideeElement=this.slideeElement,options.enableNativeScroll?(nativeScrollElement=this.nativeScrollElement,options.horizontal?(nativeScrollElement.classList.add("scrollX"),options.miniScrollbar&&nativeScrollElement.classList.add("scrollX-mini"),!1===options.hideScrollbar&&!_layoutmanager.default.tv||nativeScrollElement.classList.add("hiddenScrollX"),options.allowNativeSmoothScroll&&nativeScrollElement.classList.add("smoothScrollX")):(frame.closest(".dialog")&&nativeScrollElement.classList.add("dialog-scrollY"),nativeScrollElement.classList.add("scrollY"),options.miniScrollbar&&nativeScrollElement.classList.add("scrollY-mini"),(options.hideScrollbar||_layoutmanager.default.tv)&&nativeScrollElement.classList.add("hiddenScrollY"),options.allowNativeSmoothScroll&&nativeScrollElement.classList.add("smoothScrollY"),options.forceScrollbar&&nativeScrollElement.classList.add("overflowYScroll"))):(frame.style.overflow="hidden",this.slideeElementStyle.transition=TranslateProperty+" "+options.speed+"ms ease-out",this._lastTransitionValue=options.speed+"ms"),options.horizontal?(_layoutmanager.default.tv?frame.classList.add("scrollFrameX","scrollFrameX-tv","flex-direction-row"):frame.classList.add("scrollFrameX","flex-direction-row"),slideeElement.classList.add("scrollSliderX")):(slideeElement.classList.add("scrollSliderY"),frame.classList.add("scrollFrameY","flex-direction-column")),nativeScrollElement=onDragStart.bind(this),this.dragStartHandler=nativeScrollElement,slideeElement=function(event){this.ensureSizeInfo();var options=this.options,scrollBy=options.scrollBy;scrollBy&&(event=function(event,instance){var options=instance.options;return instance.currentDelta=(options.horizontal?event.deltaY||event.deltaX:event.deltaY)||-event.wheelDelta,options.enableNativeScroll||(instance.currentDelta/=1===event.deltaMode?3:100),instance.currentDelta}(event,this),options.enableNativeScroll?(isSmoothScrollSupported&&(event*=12),this.scrollBy(event)):this.scrollBy(scrollBy*event))}.bind(this),this.mouseWheelHandler=slideeElement,options.enableNativeScroll&&_layoutmanager.default.tv&&options.focusScroll&&_dom.default.addEventListener(this.dragSourceElement,"mousedown",nativeScrollElement,{}),addFrameResizeObserver(this),options.enableNativeScroll?options.horizontal&&options.mouseWheel&&_dom.default.addEventListener(frame,wheelEvent,slideeElement,{passive:!0}):(this.dragSourceElement.style["touch-action"]="none",window.PointerEvent?_dom.default.addEventListener(this.dragSourceElement,"pointerdown",nativeScrollElement,{}):(_dom.default.addEventListener(this.dragSourceElement,"touchstart",nativeScrollElement,{}),_dom.default.addEventListener(this.dragSourceElement,"mousedown",nativeScrollElement,{})),options.dualScroll?_dom.default.addEventListener(frame,"scroll",resetScroll,{passive:!0}):options.horizontal?_dom.default.addEventListener(frame,"scroll",resetScrollLeft,{passive:!0}):_dom.default.addEventListener(frame,"scroll",resetScrollTop,{passive:!0}),options.mouseWheel&&_dom.default.addEventListener(frame,wheelEvent,slideeElement,{passive:!0})),options.focusScroll&&(this.boundOnFrameClick=function(e){1===e.which&&(e=_focusmanager.default.focusableParent(e.target,!1))&&e!==document.activeElement&&_focusmanager.default.focus(e,{preventScroll:this.options.autoPreventScrollOnFocus})}.bind(this),_dom.default.addEventListener(frame,"click",this.boundOnFrameClick,{passive:!0,capture:!0}),nativeScrollElement=this.focusHandler=function(e){var instantScroll,itemBoundingClientRect,direction,e=e.target,lastFocusInfo=((lastFocusInfo=_focusmanager.default.getLastFocusInfo()).element===e&&(lastFocusInfo=lastFocusInfo.options)&&(preventScroll=lastFocusInfo.preventScroll,instantScroll=lastFocusInfo.instantScroll,direction=lastFocusInfo.direction,preventScrollSupported&&(itemBoundingClientRect=lastFocusInfo.itemBoundingClientRect),lastFocusInfo.itemBoundingClientRect=null),this.options);if(!(preventScroll=null==preventScroll&&lastFocusInfo.autoPreventScrollOnFocus?!_layoutmanager.default.tv:preventScroll)){var skipWhenAnyVisibleX,preventScroll=e,horizontal=lastFocusInfo.options,dualScroll=lastFocusInfo.dualScroll;if(dualScroll)switch(direction){case 0:case 1:dualScroll=!(horizontal=!0);break;case 2:case 3:skipWhenAnyVisibleX=!0}preventScroll&&this.to(this.options.focusScroll,preventScroll,{useDelayedPromise:!1,offsetLeft:lastFocusInfo.focusScrollOffsetLeft,offsetTop:lastFocusInfo.focusScrollOffsetTop,behavior:lastFocusInfo.enableNativeScroll&&!lastFocusInfo.allowNativeSmoothScroll||instantScroll?"instant":null,itemBoundingClientRect:itemBoundingClientRect,horizontal:horizontal,dualScroll:dualScroll,skipWhenAnyVisibleX:skipWhenAnyVisibleX,focusDirection:direction})}}.bind(this),_dom.default.addEventListener(frame,"focus",nativeScrollElement,{capture:!0,passive:!0})),this.dragHandler=dragHandler.bind(this),this.initialized=1,load(this,!0),this},Scroller.prototype.slideTo=function(scrollOptions,fullItemPosX,fullItemPosY){this.ensureSizeInfo();var pos=this._pos,options=this.options,horizontal=(null==(scrollOptions=scrollOptions||{}).horizontal?options:scrollOptions).horizontal,dualScroll=(null==scrollOptions.dualScroll?options:scrollOptions).dualScroll;if(options.enableNativeScroll||((horizontal||dualScroll)&&null!=scrollOptions.left&&(scrollOptions.left=within(scrollOptions.left,0,pos.endX)),horizontal&&!dualScroll)||null!=scrollOptions.top&&(scrollOptions.top=within(scrollOptions.top,0,pos.endY)),scrollOptions.skipWhenVisibleX||scrollOptions.skipWhenVisibleY)if(fullItemPosX||fullItemPosY){var skipX=!0,skipY=!0;if(!horizontal&&!dualScroll||fullItemPosX&&(fullItemPosX.isVisible||scrollOptions.skipWhenAnyVisibleX&&fullItemPosX.anyVisible)||(skipX=!1),horizontal&&!dualScroll||fullItemPosY&&(fullItemPosY.isVisible||scrollOptions.skipWhenAnyVisibleY&&fullItemPosY.anyVisible)||(skipY=!1),skipX&&skipY)return Promise.resolve();skipX&&null!=scrollOptions.left&&delete scrollOptions.left,skipY&&null!=scrollOptions.top&&delete scrollOptions.top}else if(scrollOptions.itemSize){var fullItemPosX=scrollOptions.itemSize/2,fullItemPosY=scrollOptions.slideeOffset||(scrollOptions.slideeOffset=options.enableNativeScroll?this.getScrollContainerBoundingClientRect():this.slideeElement.getBoundingClientRect()),skipX=scrollOptions.left,skipY=scrollOptions.top,skipY=(null==skipX&&(skipX=this.getScrollLeft()),null==skipY&&(skipY=this.getScrollTop()),{itemBoundingClientRect:{width:horizontal?scrollOptions.itemSize:null,height:horizontal?null:scrollOptions.itemSize,left:horizontal?fullItemPosY.left+skipX-fullItemPosX:null,top:horizontal?null:fullItemPosY.top+skipY-fullItemPosX,right:horizontal?fullItemPosY.left+skipX+fullItemPosX:null},location:scrollOptions.location}),skipX=(options.enableNativeScroll&&(fullItemPosY=horizontal?this.getScrollLeft():this.getScrollTop(),horizontal?(skipY.itemBoundingClientRect.left-=fullItemPosY,skipY.itemBoundingClientRect.right-=fullItemPosY):skipY.itemBoundingClientRect.top-=fullItemPosY),this.getElementPosition(null,horizontal,skipY));if(skipX.isVisible||(horizontal?scrollOptions.skipWhenAnyVisibleX:scrollOptions.skipWhenAnyVisibleY)&&skipX.anyVisible)return Promise.resolve()}fullItemPosX=scrollOptions.useDelayedPromise;return(horizontal||dualScroll)&&(fullItemPosY=scrollOptions.left,skipY=options.scrollSnapSizeX,null!=fullItemPosY)&&null!=skipY&&(1===scrollOptions.focusDirection?(skipX=fullItemPosY%skipY)<10?scrollOptions.left-=skipX:scrollOptions.left+=skipY-fullItemPosY%skipY:(horizontal=skipY-fullItemPosY%skipY)<10?scrollOptions.left+=horizontal:scrollOptions.left-=fullItemPosY%skipY),options.enableNativeScroll?scrollNative(this,scrollOptions):null!=scrollOptions.left&&scrollOptions.left!==pos.scrollLeft||null!=scrollOptions.top&&scrollOptions.top!==pos.scrollTop?renderAnimateWithTransform(this,scrollOptions,"instant"===scrollOptions.behavior,fullItemPosX):Promise.resolve()},Scroller.prototype.scrollToPosition=function(pos){var options=this.options;if(null!=pos.position&&(options.horizontal?pos.left=pos.position:pos.top=pos.position,pos.position=null,delete pos.position),!options.enableNativeScroll)return this.slideTo(pos);var hasLeft=null!=pos.left,hasTop=null!=pos.top;if(!hasLeft||!hasTop)if(options.horizontal){if(hasLeft)return pos.behavior||(pos.behavior=isSmoothScrollSupported&&!_layoutmanager.default.tv?"smooth":"auto"),this.slideTo(pos)}else if(hasTop)return pos.behavior||(pos.behavior=isSmoothScrollSupported&&!_layoutmanager.default.tv?"smooth":"auto"),this.slideTo(pos);return pos.behavior="instant",scrollNative(this,pos)},Scroller.prototype.getElementPosition=function(item,horizontal,scrollOptions){var focusScrollOffset,options=this.options,enableNativeScroll=options.enableNativeScroll,slideeOffset=scrollOptions.slideeOffset||(scrollOptions.slideeOffset=enableNativeScroll?this.getScrollContainerBoundingClientRect():this.slideeElement.getBoundingClientRect()),itemOffset=scrollOptions.itemBoundingClientRect||(scrollOptions.itemBoundingClientRect=item.getBoundingClientRect()),multiplier=horizontal?this.getScrollLeftMultiplier():this.getScrollTopMultiplier(),slideeOffset=horizontal?-1===multiplier?itemOffset.right-slideeOffset.right:itemOffset.left-slideeOffset.left:itemOffset.top-slideeOffset.top,itemOffset=horizontal?itemOffset.width:itemOffset.height,item=(itemOffset||0===itemOffset||(itemOffset=item[horizontal?"offsetWidth":"offsetHeight"]),options.centerOffset||0),options=horizontal?this.getScrollLeft():this.getScrollTop(),enableNativeScroll=(enableNativeScroll&&(slideeOffset+=options),slideeOffset),scrollOffset=horizontal?scrollOptions.offsetLeft:scrollOptions.offsetTop,scrollOffset=(scrollOffset&&(enableNativeScroll+=focusScrollOffset=function(instance,offset){if(!offset)return null;switch(typeof offset){case"number":return offset;case"string":return parseFocusScrollOffset(instance,offset);default:return null}}(this,scrollOffset)||0),this.ensureSizeInfo(),(horizontal?scrollOptions.frameWidthForComparison:scrollOptions.frameHeightForComparison)||getFrameSize(this,horizontal,!1)),options=Math.abs(options),currentEnd=options+scrollOffset,scrollOptions=("adaptive"===scrollOptions.location&&(options+=(horizontal?scrollOptions.adaptiveBorderXStart:scrollOptions.adaptiveBorderYStart)||0,currentEnd-=(horizontal?scrollOptions.adaptiveBorderXEnd:scrollOptions.adaptiveBorderYEnd)||0),Math.abs(slideeOffset)),slideeOffset=Math.abs(enableNativeScroll)>=options&&scrollOptions+itemOffset<=currentEnd,options=slideeOffset||Math.abs(enableNativeScroll)+itemOffset>=options&&scrollOptions<=currentEnd,scrollOptions=subtractPaddingFromFrameSize(this,horizontal,scrollOffset);return{start:enableNativeScroll,center:enableNativeScroll+item-(scrollOptions/2-itemOffset/2)*multiplier-(focusScrollOffset||0),end:enableNativeScroll-(scrollOptions-itemOffset)*multiplier-(focusScrollOffset||0),isVisible:slideeOffset,anyVisible:options,size:itemOffset}},Scroller.prototype.ensureSizeInfo=function(){var options,horizontal,dualScroll,frame,newFrameSize;this.requiresReflow&&(this.requiresReflow=!1,frame=this.frame,horizontal=(options=this.options).horizontal,newFrameSize={},dualScroll=options.dualScroll,(horizontal||dualScroll)&&(newFrameSize.width=frame.offsetWidth),horizontal&&!dualScroll||(newFrameSize.height=frame.offsetHeight),this.frameSize=newFrameSize,options.enableNativeScroll||(frame=this.slideeElement,newFrameSize=this.getSlideePadding(),this.slideeSize={width:Math.max(frame.offsetWidth,frame.scrollWidth)+newFrameSize.inlineStart+newFrameSize.inlineEnd,height:Math.max(frame.offsetHeight,frame.scrollHeight)+newFrameSize.top+newFrameSize.bottom},(horizontal||dualScroll)&&(this._pos.endX=Math.max(this.getScrollWidth()-getFrameSize(this,!0,!0),0)*this.getScrollLeftMultiplier()),horizontal&&!dualScroll)||(this._pos.endY=Math.max(this.getScrollHeight()-getFrameSize(this,!1,!0),0)*this.getScrollTopMultiplier()))},Scroller.prototype.getScrollEventName=function(){return this.options.enableNativeScroll?"scroll":"scrollanimate"},Scroller.prototype.getScrollContainerBoundingClientRect=function(){var rect;return this.frameResizeObserver?(null==(rect=this._frameRect)&&(rect=this.nativeScrollElement.getBoundingClientRect(),this._frameRect=rect),rect):(addFrameResizeObserver(this),this.nativeScrollElement.getBoundingClientRect())},Scroller.prototype.getScrollSlider=function(){return this.slideeElement},Scroller.prototype.addScrollEventListener=function(fn,options){this.listenerCount++,this.options.dispatchScrollEvent=0<this.listenerCount,this.options.cacheScrollPositions=this.options.dispatchScrollEvent&&preventScrollSupported,this.options.cacheScrollPositions&&this.addScrollCacheListener();var elem=this.options.enableNativeScroll?this.nativeScrollElement:this.frame;_dom.default.addEventListener(elem,this.getScrollEventName(),fn,options)},Scroller.prototype.removeScrollEventListener=function(fn,options){this.listenerCount=Math.max(this.listenerCount-1,0),this.options.dispatchScrollEvent=0<this.listenerCount,this.options.cacheScrollPositions=this.options.dispatchScrollEvent&&preventScrollSupported,this.options.cacheScrollPositions||this.removeScrollCacheListener();var elem=this.options.enableNativeScroll?this.nativeScrollElement:this.frame;_dom.default.removeEventListener(elem,this.getScrollEventName(),fn,options)},Scroller.prototype.addScrollCacheListener=function(){!this.options.enableNativeScroll||this._scrollCacheListenerBound||(this._scrollCacheListenerBound=!0,_dom.default.addEventListener(this.nativeScrollElement,"scroll",this.onScrollForCachingFn,{passive:!0}))},Scroller.prototype.removeScrollCacheListener=function(){var elem=this.nativeScrollElement;elem&&(this._scrollCacheListenerBound=!1,_dom.default.removeEventListener(elem,"scroll",this.onScrollForCachingFn,{passive:!0}))},Scroller.prototype.addResizeObserver=function(fn){addFrameResizeObserver(this),this.resizeListeners&&this.resizeListeners.push(fn)},Scroller.prototype.removeResizeObserver=function(fn){this.resizeListeners&&-1<(fn=this.resizeListeners.indexOf(fn))&&this.resizeListeners.splice(fn,1)},Scroller.prototype.isNativeScroll=function(item){return this.options.enableNativeScroll},Scroller.prototype.getScrollPosition=function(){return this.options.horizontal?this.getScrollLeft():this.getScrollTop()},Scroller.prototype.getLastScrollPosition=function(){return this.options.horizontal?this.getLastScrollLeft():this.getLastScrollTop()},Scroller.prototype.getScrollLeft=function(){var options=this.options;return options.enableNativeScroll?options.cacheScrollPositions?(null==(options=this._cachedScrollLeft)&&(options=this.nativeScrollElement.scrollLeft,this._cachedScrollLeft=options),options):this.nativeScrollElement.scrollLeft:this._pos.scrollLeft},Scroller.prototype.getScrollMultiplier=function(){return this.options.horizontal?this.getScrollLeftMultiplier():this.getScrollTopMultiplier()},Scroller.prototype.getScrollLeftMultiplier=function(){return this.options.inlineMultiplier},Scroller.prototype.getScrollTopMultiplier=function(){return 1},Scroller.prototype.getLastScrollLeft=function(){return this._cachedScrollLeft},Scroller.prototype.getScrollTop=function(){var options=this.options;return options.enableNativeScroll?options.cacheScrollPositions?(null==(options=this._cachedScrollTop)&&(options=this.nativeScrollElement.scrollTop,this._cachedScrollTop=options),options):this.nativeScrollElement.scrollTop:this._pos.scrollTop},Scroller.prototype.getLastScrollTop=function(){return this._cachedScrollTop},Scroller.prototype.getScrollSize=function(){return this.options.horizontal?this.getScrollWidth():this.getScrollHeight()},Scroller.prototype.getPadding=function(){addFrameResizeObserver(this);var inlineStart,inlineEnd,top,style,padding=this._framePadding;return padding||(inlineStart=parsePxToInt((style=getComputedStyle(this.frame)).getPropertyValue(PaddingInlineStartProp)),inlineEnd=parsePxToInt(style.getPropertyValue(PaddingInlineEndProp)),top=parsePxToInt(style.getPropertyValue("padding-top")),style=parsePxToInt(style.getPropertyValue("padding-bottom")),this._framePadding=padding={inlineStart:inlineStart,inlineEnd:inlineEnd,top:top,bottom:style}),padding},Scroller.prototype.getSlideePadding=function(){addFrameResizeObserver(this);var inlineStart,inlineEnd,top,style,padding=this._slideePadding;return padding||(inlineStart=parsePxToInt((style=getComputedStyle(this.slideeElement)).getPropertyValue(PaddingInlineStartProp)),inlineEnd=parsePxToInt(style.getPropertyValue(PaddingInlineEndProp)),top=parsePxToInt(style.getPropertyValue("padding-top")),style=parsePxToInt(style.getPropertyValue("padding-bottom")),this._slideePadding=padding={inlineStart:inlineStart,inlineEnd:inlineEnd,top:top,bottom:style}),padding},Scroller.prototype.getScrollWidth=function(){if(!this.options.enableNativeScroll)return this.slideeSize.width;addFrameResizeObserver(this);var value=this._cachedScrollWidth;return value||(value=this.nativeScrollElement.scrollWidth,this._cachedScrollWidth=value),value},Scroller.prototype.getScrollHeight=function(){if(!this.options.enableNativeScroll)return this.slideeSize.height;addFrameResizeObserver(this);var value=this._cachedScrollHeight;return value||(value=this.nativeScrollElement.scrollHeight,this._cachedScrollHeight=value),value},Scroller.prototype.scrollBy=function(delta,scrollOptions){var options;delta&&((options=this.options).enableNativeScroll?options.horizontal?this.nativeScrollElement.scrollLeft+=delta:this.nativeScrollElement.scrollTop+=delta:((scrollOptions=scrollOptions||{}).position=this.getScrollPosition()+delta,this.scrollToPosition(scrollOptions)))},Scroller.prototype.to=function(toLocation,item,scrollOptions){var itemPosY,slideePadding,_options,startPadding,adaptiveBorderStart,multiplier,scrollPosition,frameSizeForComparison,location,adaptiveBorderEnd,options=this.options,horizontal=(null==(scrollOptions=scrollOptions||{}).horizontal?options:scrollOptions).horizontal,dualScroll=(null==scrollOptions.dualScroll?options:scrollOptions).dualScroll,adaptiveScroll="adaptive"===toLocation;scrollOptions.slideeOffset=options.enableNativeScroll?this.getScrollContainerBoundingClientRect():this.slideeElement.getBoundingClientRect(),(horizontal||dualScroll)&&(location=toLocation,frameSizeForComparison=getFrameSize(this,horizontal=!0),scrollOptions.frameWidthForComparison=frameSizeForComparison,null==(adaptiveBorderStart=options.adaptiveBorderXStart)&&(adaptiveBorderStart=Math.max(horizontal?.03*frameSizeForComparison:.08*frameSizeForComparison,30)),null==(adaptiveBorderEnd=options.adaptiveBorderXEnd)&&(adaptiveBorderEnd=Math.max(horizontal?.03*frameSizeForComparison:.08*frameSizeForComparison,30)),scrollOptions.location=location,scrollOptions.adaptiveBorderXStart=adaptiveBorderStart,scrollOptions.adaptiveBorderXEnd=adaptiveBorderEnd,frameSizeForComparison=this.getElementPosition(item,horizontal,scrollOptions),adaptiveScroll&&(multiplier=horizontal?this.getScrollLeftMultiplier():this.getScrollTopMultiplier(),scrollPosition=(horizontal?this.getScrollLeft():this.getScrollTop())*multiplier,_options=this.options,adaptiveBorderEnd*=multiplier,frameSizeForComparison.start-=adaptiveBorderStart*=multiplier,frameSizeForComparison.end+=adaptiveBorderEnd,adaptiveBorderStart=0,_options.autoStartEdge&&(adaptiveBorderEnd=this.getPadding(),slideePadding=this.getSlideePadding(),startPadding=horizontal?adaptiveBorderEnd.inlineStart+slideePadding.inlineStart:adaptiveBorderEnd.top+slideePadding.top,adaptiveBorderEnd=horizontal?adaptiveBorderEnd.inlineEnd+slideePadding.inlineEnd:adaptiveBorderEnd.bottom+slideePadding.bottom,frameSizeForComparison.end*multiplier>=(horizontal?this._pos.endX:this._pos.endY)-startPadding-2*adaptiveBorderEnd-frameSizeForComparison.size&&(frameSizeForComparison.end+=adaptiveBorderEnd,_options.enableNativeScroll)&&(frameSizeForComparison.end+=adaptiveBorderEnd),adaptiveBorderStart=startPadding),frameSizeForComparison.start*multiplier<adaptiveBorderStart&&0!==frameSizeForComparison.start&&(frameSizeForComparison.start=0),location=frameSizeForComparison.start*multiplier<=scrollPosition?"start":frameSizeForComparison.end*multiplier>=scrollPosition?"end":"center",scrollOptions.skipWhenVisibleX=!0),scrollOptions.left=(slideePadding=frameSizeForComparison)[location]),horizontal&&!dualScroll||(_options=toLocation,adaptiveBorderEnd=getFrameSize(this,horizontal=!1),scrollOptions.frameHeightForComparison=adaptiveBorderEnd,null==(startPadding=options.adaptiveBorderYStart)&&(startPadding=Math.max(horizontal?.03*adaptiveBorderEnd:.08*adaptiveBorderEnd,30)),null==(adaptiveBorderStart=options.adaptiveBorderYEnd)&&(adaptiveBorderStart=Math.max(horizontal?.03*adaptiveBorderEnd:.08*adaptiveBorderEnd,30)),scrollOptions.location=_options,scrollOptions.adaptiveBorderYStart=startPadding,scrollOptions.adaptiveBorderYEnd=adaptiveBorderStart,multiplier=this.getElementPosition(item,horizontal,scrollOptions),adaptiveScroll&&(scrollPosition=horizontal?this.getScrollLeftMultiplier():this.getScrollTopMultiplier(),frameSizeForComparison=(horizontal?this.getScrollLeft():this.getScrollTop())*scrollPosition,location=this.options,adaptiveBorderStart*=scrollPosition,multiplier.start-=startPadding*=scrollPosition,multiplier.end+=adaptiveBorderStart,dualScroll=0,location.autoStartEdge&&(toLocation=this.getPadding(),options=this.getSlideePadding(),adaptiveBorderEnd=horizontal?toLocation.inlineStart+options.inlineStart:toLocation.top+options.top,item=horizontal?toLocation.inlineEnd+options.inlineEnd:toLocation.bottom+options.bottom,multiplier.end*scrollPosition>=(horizontal?this._pos.endX:this._pos.endY)-adaptiveBorderEnd-2*item-multiplier.size&&(multiplier.end+=item,location.enableNativeScroll)&&(multiplier.end+=item),dualScroll=adaptiveBorderEnd),multiplier.start*scrollPosition<dualScroll&&0!==multiplier.start&&(multiplier.start=0),_options=multiplier.start*scrollPosition<=frameSizeForComparison?"start":multiplier.end*scrollPosition>=frameSizeForComparison?"end":"center",scrollOptions.skipWhenVisibleY=!0),scrollOptions.top=(itemPosY=multiplier)[_options]),this.slideTo(scrollOptions,slideePadding,itemPosY)},Scroller.prototype.toStart=function(item,scrollOptions){this.to("start",item,scrollOptions)},Scroller.prototype.toEnd=function(item,scrollOptions){this.to("end",item,scrollOptions)},Scroller.prototype.scrollToElement=function(item,scrollOptions){var options=this.options;return null==(scrollOptions=scrollOptions||{}).offsetLeft&&(scrollOptions.offsetLeft=options.focusScrollOffsetLeft),null==scrollOptions.offsetTop&&(scrollOptions.offsetTop=options.focusScrollOffsetTop),options.enableNativeScroll&&!options.allowNativeSmoothScroll&&(scrollOptions.behavior="instant"),this.to(options.focusScroll||"start",item,scrollOptions)},Scroller.prototype.toCenter=function(item,scrollOptions){this.to("center",item,scrollOptions)},Scroller.prototype.scrollBackwards=function(){this.scrollBy(0-this.options.scrollBy)},Scroller.prototype.scrollForwards=function(){this.scrollBy(this.options.scrollBy)},Scroller.prototype.notifyResized=function(){onResize.call(this,[])},Scroller.prototype.destroy=function(){this.frameResizeObserver&&(this.frameResizeObserver.disconnect(),this.frameResizeObserver=null);var frame=this.frame,mouseWheelHandler=(frame&&(_dom.default.removeEventListener(frame,"scroll",resetScrollTop,{passive:!0}),_dom.default.removeEventListener(frame,"scroll",resetScrollLeft,{passive:!0}),_dom.default.removeEventListener(frame,"scroll",resetScroll,{passive:!0}),mouseWheelHandler=this.mouseWheelHandler)&&_dom.default.removeEventListener(frame,wheelEvent,mouseWheelHandler,{passive:!0}),this.mouseWheelHandler=null,this.dragStartHandler),dragSourceElement=this.dragSourceElement,dragSourceElement=(mouseWheelHandler&&dragSourceElement&&(_dom.default.removeEventListener(dragSourceElement,"touchstart",mouseWheelHandler,{passive:!0}),_dom.default.removeEventListener(dragSourceElement,"mousedown",mouseWheelHandler,{passive:!0}),_dom.default.removeEventListener(dragSourceElement,"pointerdown",mouseWheelHandler,{passive:!0})),this.dragStartHandler=null,this.dragSourceElement=null,this.focusHandler),mouseWheelHandler=(dragSourceElement&&frame&&_dom.default.removeEventListener(frame,"focus",dragSourceElement,{capture:!0,passive:!0}),this.focusHandler=null,this.boundOnFrameClick);return mouseWheelHandler&&frame&&_dom.default.removeEventListener(frame,"click",mouseWheelHandler,{passive:!0,capture:!0}),this.boundOnFrameClick=null,this.removeScrollCacheListener(),this.initialized=null,this.nativeScrollElement=null,this.frame=null,this.options=null,this.slideeSize=null,this._pos=null,this.requiresReflow=null,this.frameSize=null,this.dragging=null,this.contentRects=null,this.dragHandler=null,this.onSourceClickFn=null,this.onScrollForCachingFn=null,this.resizeListeners=null,this._cachedScrollTop=null,this._cachedScrollLeft=null,this._cachedScrollHeight=null,this._cachedScrollWidth=null,this._framePadding=null,this._slideePadding=null,this._frameRect=null,this.slideeElement=null,this.slideeElementStyle=null,this},Scroller.create=function(frame,options){frame=new Scroller(frame,options);return Promise.resolve(frame)};_exports.default=Scroller});