/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.application;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.freeplane.core.resources.IFreeplanePropertyListener;
import org.freeplane.core.resources.ResourceBundles;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.FreeplaneVersion;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.mindmapmode.MIconController;
import org.freeplane.features.mode.mindmapmode.MModeController;
import org.freeplane.main.application.LastOpenedList;
import org.freeplane.main.application.SortedProperties;

public class ApplicationResourceController
extends ResourceController {
    private static final String USE_SYSTEM_LOCALE_PROPERTY = "useSystemLocale";
    private static final AllPermission ALL_PERMISSION = new AllPermission();
    private final File autoPropertiesFile;
    private final Properties defProps;
    private LastOpenedList lastOpened;
    private final Properties props;
    private final Properties securedProps;
    private final Set<String> securedForReadingPropertyKeys;
    public static final String FREEPLANE_BASEDIRECTORY_PROPERTY = "org.freeplane.basedirectory";
    public static final String FREEPLANE_GLOBALRESOURCEDIR_PROPERTY = "org.freeplane.globalresourcedir";
    public static final String DEFAULT_FREEPLANE_GLOBALRESOURCEDIR = "resources";
    private final ArrayList<File> resourceDirectories = new ArrayList(2);
    private final Set<ClassLoader> resourceLoaders;
    public static String RESOURCE_BASE_DIRECTORY;
    public static String INSTALLATION_BASE_DIRECTORY;

    public static File getUserPreferencesFile() {
        String freeplaneDirectory = Compat.getApplicationUserDirectory();
        File userPropertiesFolder = new File(freeplaneDirectory);
        File autoPropertiesFile = new File(userPropertiesFolder, "auto.properties");
        return autoPropertiesFile;
    }

    public static void showSysInfo() {
        StringBuilder info = new StringBuilder();
        info.append("freeplane_version = ");
        FreeplaneVersion freeplaneVersion = FreeplaneVersion.getVersion();
        info.append(freeplaneVersion);
        String revision = freeplaneVersion.getRevision();
        info.append("; freeplane_xml_version = ");
        info.append("freeplane 1.12.15");
        if (!revision.equals("")) {
            info.append("\ngit revision = ");
            info.append(revision);
        }
        info.append("\njava_version = ");
        info.append(System.getProperty("java.version"));
        info.append("; os_name = ");
        info.append(System.getProperty("os.name"));
        info.append("; os_version = ");
        info.append(System.getProperty("os.version"));
        LogUtils.info((String)info.toString());
    }

    public ApplicationResourceController() {
        this.defProps = this.readDefaultPreferences();
        this.props = this.readUsersPreferences(this.defProps);
        this.securedForReadingPropertyKeys = new HashSet<String>();
        this.replacePropertyKey("keepSelectedNodeVisibleAfterZoom", "keepSelectedNodeVisible");
        this.replacePropertyKey("foldingsymbolwidth", "foldingsymbolsize");
        this.securedProps = new Properties(this.props);
        File userDir = this.createUserDirectory();
        String resourceBaseDir = this.getResourceBaseDir();
        if (resourceBaseDir != null) {
            try {
                File userResourceDir = new File(userDir, DEFAULT_FREEPLANE_GLOBALRESOURCEDIR);
                userResourceDir.mkdirs();
                this.resourceDirectories.add(userResourceDir);
                File resourceDir = new File(resourceBaseDir);
                this.resourceDirectories.add(resourceDir);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.resourceLoaders = new LinkedHashSet<ClassLoader>();
        if (!this.getBooleanProperty(USE_SYSTEM_LOCALE_PROPERTY)) {
            this.setDefaultLocale(this.props.getProperty("language"));
        }
        this.autoPropertiesFile = ApplicationResourceController.getUserPreferencesFile();
        this.addPropertyChangeListener(new IFreeplanePropertyListener(){

            public void propertyChanged(String propertyName, String newValue, String oldValue) {
                if (propertyName.equals("language")) {
                    ApplicationResourceController.this.loadAnotherLanguage();
                }
            }
        });
    }

    private void replacePropertyKey(String oldKey, String newKey) {
        if (this.props.containsKey(oldKey) && !this.props.containsKey(newKey)) {
            this.props.put(newKey, this.props.getProperty(oldKey));
        }
    }

    private File createUserDirectory() {
        File userPropertiesFolder = new File(this.getFreeplaneUserDirectory());
        try {
            if (!userPropertiesFolder.exists()) {
                userPropertiesFolder.mkdirs();
            }
            return userPropertiesFolder;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Cannot create folder for user properties and logging: '" + userPropertiesFolder.getAbsolutePath() + "'");
            return null;
        }
    }

    public String getDefaultProperty(String key) {
        return this.defProps.getProperty(key);
    }

    public String getFreeplaneUserDirectory() {
        return Compat.getApplicationUserDirectory();
    }

    public LastOpenedList getLastOpenedList() {
        return this.lastOpened;
    }

    public Properties getProperties() {
        return this.props;
    }

    public String getProperty(String key) {
        if (this.securedForReadingPropertyKeys.contains(key)) {
            ApplicationResourceController.checkSecurityPermission();
        }
        return this.securedProps.getProperty(key);
    }

    public URL getResource(final String resourcePath) {
        return AccessController.doPrivileged(new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                String relName = ApplicationResourceController.this.removeSlashAtStart(resourcePath);
                for (File directory : ApplicationResourceController.this.resourceDirectories) {
                    File fileResource = new File(directory, relName);
                    if (!fileResource.exists()) continue;
                    try {
                        return Compat.fileToUrl((File)fileResource);
                    }
                    catch (MalformedURLException e) {
                        throw new RuntimeException(e);
                    }
                }
                URL resource = ApplicationResourceController.super.getResource(resourcePath);
                if (resource != null) {
                    return resource;
                }
                if ("/lib/freeplaneviewer.jar".equals(resourcePath)) {
                    String rootDir = new File(ApplicationResourceController.this.getResourceBaseDir()).getAbsoluteFile().getParent();
                    try {
                        File try1 = new File(rootDir + "/plugins/org.freeplane.core/lib/freeplaneviewer.jar");
                        if (try1.exists()) {
                            return try1.toURL();
                        }
                        File try2 = new File(rootDir + "/lib/freeplaneviewer.jar");
                        if (try2.exists()) {
                            return try2.toURL();
                        }
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                    }
                }
                for (ClassLoader loader : ApplicationResourceController.this.resourceLoaders) {
                    URL resource2 = loader.getResource(resourcePath);
                    if (resource2 == null) continue;
                    return resource2;
                }
                return null;
            }
        });
    }

    private String removeSlashAtStart(String name) {
        String relName = name.startsWith("/") ? name.substring(1) : name;
        return relName;
    }

    public String getResourceBaseDir() {
        return RESOURCE_BASE_DIRECTORY;
    }

    public String getInstallationBaseDir() {
        return INSTALLATION_BASE_DIRECTORY;
    }

    public void registerResourceLoader(ClassLoader loader) {
        this.resourceLoaders.add(loader);
    }

    public void init() {
        this.lastOpened = new LastOpenedList();
        super.init();
    }

    private Properties readDefaultPreferences() {
        Properties props = new Properties();
        this.readDefaultPreferences(props, "/freeplane.properties");
        String propsLocs = props.getProperty("load_next_properties", "");
        this.readDefaultPreferences(props, propsLocs.split(";"));
        return props;
    }

    private void readDefaultPreferences(Properties props, String[] locArray) {
        for (String loc : locArray) {
            this.readDefaultPreferences(props, loc);
        }
    }

    private void readDefaultPreferences(Properties props, String propsLoc) {
        URL defaultPropsURL = this.getResource(propsLoc);
        ApplicationResourceController.loadProperties((Properties)props, (URL)defaultPropsURL);
    }

    private Properties readUsersPreferences(Properties defaultPreferences) {
        SortedProperties auto = new SortedProperties(defaultPreferences);
        try (FileInputStream in = new FileInputStream(ApplicationResourceController.getUserPreferencesFile());){
            auto.load(in);
        }
        catch (Exception ex) {
            System.err.println("User properties not found, new file created");
        }
        return auto;
    }

    public void saveProperties() {
        MIconController iconController;
        this.props.putAll((Map<?, ?>)this.securedProps);
        MModeController modeController = MModeController.getMModeController();
        if (modeController != null && (iconController = (MIconController)modeController.getExtension(IconController.class)) != null) {
            iconController.saveRecentlyUsedActions();
        }
        try (FileOutputStream out2 = new FileOutputStream(this.autoPropertiesFile);){
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)out2, "8859_1");
            outputStreamWriter.write("#Freeplane ");
            outputStreamWriter.write(FreeplaneVersion.getVersion().toString());
            outputStreamWriter.write(10);
            outputStreamWriter.flush();
            this.props.store(out2, null);
            ((ResourceBundles)this.getResources()).saveUserResources();
        }
        catch (Exception out2) {
            // empty catch block
        }
        FilterController filterController = FilterController.getCurrentFilterController();
        if (filterController != null) {
            filterController.saveConditions();
        }
    }

    private void setDefaultLocale(String lang) {
        if (lang == null) {
            return;
        }
        Locale localeDef = null;
        switch (lang.length()) {
            case 2: {
                localeDef = new Locale(lang);
                break;
            }
            case 5: {
                localeDef = new Locale(lang.substring(0, 2), lang.substring(3, 5));
                break;
            }
            default: {
                return;
            }
        }
        Locale.setDefault(localeDef);
    }

    public void setDefaultProperty(String key, String value) {
        this.defProps.setProperty(key, value);
    }

    public void setProperty(String key, String value) {
        String oldValue = this.getProperty(key);
        if (oldValue == value) {
            return;
        }
        if (oldValue != null && oldValue.equals(value)) {
            return;
        }
        if (this.securedProps.containsKey(key)) {
            ApplicationResourceController.checkSecurityPermission();
            this.securedProps.setProperty(key, value);
        }
        this.props.setProperty(key, value);
        this.firePropertyChanged(key, value, oldValue);
    }

    private static void checkSecurityPermission() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ALL_PERMISSION);
        }
    }

    public Properties getSecuredProperties() {
        ApplicationResourceController.checkSecurityPermission();
        return this.securedProps;
    }

    public void securePropertyForModification(String key) {
        ApplicationResourceController.checkSecurityPermission();
        if (!this.securedProps.containsKey(key)) {
            this.securedProps.setProperty(key, this.props.getProperty(key));
        }
    }

    public void securePropertyForReadingAndModification(String key) {
        this.securePropertyForModification(key);
        this.securedForReadingPropertyKeys.add(key);
    }

    public boolean isPropertySetByUser(String key) {
        return this.props.containsKey(key);
    }

    static {
        try {
            RESOURCE_BASE_DIRECTORY = new File(System.getProperty(FREEPLANE_GLOBALRESOURCEDIR_PROPERTY, DEFAULT_FREEPLANE_GLOBALRESOURCEDIR)).getCanonicalPath();
            INSTALLATION_BASE_DIRECTORY = new File(System.getProperty(FREEPLANE_BASEDIRECTORY_PROPERTY, RESOURCE_BASE_DIRECTORY + "/..")).getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

