# frozen_string_literal: true

class AddIndexToVulnerabilityDetectionTransitionsForStaleLookup < Gitlab::Database::Migration[2.3]
  disable_ddl_transaction!

  milestone '18.9'

  INDEX_NAME = 'idx_vuln_detection_transitions_on_occurrence_id_detected_id'
  OLD_INDEX_NAME = 'index_vulnerability_detection_transitions_on_finding_id'

  def up
    add_concurrent_index(
      :vulnerability_detection_transitions,
      [:vulnerability_occurrence_id, :detected, :id],
      name: INDEX_NAME
    )

    remove_concurrent_index_by_name(
      :vulnerability_detection_transitions,
      OLD_INDEX_NAME
    )
  end

  def down
    add_concurrent_index(
      :vulnerability_detection_transitions,
      :vulnerability_occurrence_id,
      name: OLD_INDEX_NAME
    )

    remove_concurrent_index_by_name(
      :vulnerability_detection_transitions,
      INDEX_NAME
    )
  end
end
