---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: '機密性の高いシークレットまたはトークンTypeformパーソナルアクセストークンの公開'
---

## 説明 {#description}

応答本文に、Typeformのパーソナルアクセストークンのパターンに一致するコンテンツが含まれていることが確認されました。パーソナルアクセストークンは、Typeform APIにアクセスするためのものです。割り当てられたスコープと権限によっては、このトークンにアクセスできる悪意のある攻撃者は、フォームデータの読み取り、更新、または削除を行うことができます。この値を公開すると、攻撃者がこのトークンによって許可されたすべてのリソースにアクセスできる可能性があります。

## 修正 {#remediation}

漏洩したキーに関するセキュリティインシデントの取り扱いに関する一般的なガイダンスについては、GitLabドキュメントの[認証情報のインターネットへの公開](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet)を参照してください。Typeform APIトークンを再生成するには、Typeformアカウントにサインインして<https://admin.typeform.com/>にアクセスしてください- 右上隅で、プロフィール写真を選択し、「Account」の下の「Your settings」を選択します- 左側のメニューで、「Personal tokens」を選択します - 「token name」テーブルで、識別されたトークンを見つけ、省略記号を選択し、「Regenerate token」を選択します。詳細については、[Typeformのパーソナルアクセストークンに関するドキュメント](https://www.typeform.com/developers/get-started/personal-access-token/)を参照してください。

## Details {#details}

| ID | 集約 | CWE | 型 | リスク |
|:---|:-----------|:----|:-----|:-----|
| 798.124 | いいえ | 798 | パッシブ | 高 |

## リンク {#links}

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
