---
stage: Security Risk Management
group: Security Policies
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: ポリシー
description: セキュリティポリシー、適用、コンプライアンス、承認、スキャン。
---

{{< details >}}

- プラン: Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

ポリシーを使用すると、セキュリティチームおよびコンプライアンスチームは、組織全体にコントロールを適用できます。

セキュリティチームは、次のことを確実に行えます:

- 適切な設定で、開発チームのパイプラインにセキュリティスキャナーを適用する。
- すべてのスキャンジョブを、変更または改変なしに実行する。
- スキャン結果に基づき、マージリクエストに対して適切な承認を行う。
- 検出されなくなった脆弱性を自動的に解決し、脆弱性のトリアージ作業のワークロードを軽減する。

コンプライアンスチームは、次のことを行えます:

- すべてのマージリクエストに複数の承認者を適用する。
- 組織の要件に基づいたプロジェクト設定（マージリクエストの設定またはリポジトリの設定の有効化やロックなど）を適用する。

次のポリシータイプを使用できます:

- [スキャン実行ポリシー](scan_execution_policies.md)。パイプラインの一部として、または指定されたスケジュールに従ってセキュリティスキャンを強制的に実行します。
- [マージリクエスト承認ポリシー](merge_request_approval_policies.md)。スキャン結果に基づいて、プロジェクトレベルの設定と承認ルールを強制的に適用します。
- [パイプライン実行ポリシー](pipeline_execution_policies.md)。プロジェクトのパイプラインの一部としてCI/CDジョブを強制的に実行します。
  - [スケジュールされたパイプライン実行ポリシー（実験的機能）](scheduled_pipeline_execution_policies.md)。コミットアクティビティーとは関係なく、スケジュールされたケイデンスでプロジェクト全体にカスタムCI/CDジョブを強制的に実行します。
- [脆弱性管理ポリシー](vulnerability_management_policy.md)。デフォルトブランチで検出されなくなった脆弱性を自動的に解決します。

## ポリシーのスコープを設定する {#configure-the-policy-scope}

## `policy_scope`キーワード {#policy_scope-keyword}

`policy_scope`キーワードを使用して、指定したグループ、プロジェクト、コンプライアンスフレームワーク、またはそれらの組み合わせに対してのみポリシーを適用します。

| フィールド                   | 型     | 使用可能な値          | 説明 |
|-------------------------|----------|--------------------------|-------------|
| `compliance_frameworks` | `array`  | 該当なし           | スコープ内のコンプライアンスフレームワークのIDを、キー`id`を持つオブジェクトの配列でリストします。 |
| `projects`              | `object` | `including`、`excluding` | `excluding:`または`including:`を使用して、含めるまたは除外するプロジェクトのIDを、キー`id`を持つオブジェクトの配列でリストします。 |
| `groups`                | `object` | `including`              | `including:`を使用して、含めるグループのIDを、キー`id`を持つオブジェクトの配列でリストします。同じセキュリティポリシープロジェクトにリンクされているグループのみ、ポリシーの対象として列挙できます。 |

### スコープの例 {#scope-examples}

次の例では、スキャン実行ポリシーは、IDが`2`または`11`のコンプライアンスフレームワークが適用されたすべてのプロジェクトのすべてのリリースパイプラインでSASTスキャンを強制的に実行します。

```yaml
---
scan_execution_policy:
- name: Enforce specified scans in every release pipeline
  description: This policy enforces a SAST scan for release branches
  enabled: true
  rules:
  - type: pipeline
    branches:
    - release/*
  actions:
  - scan: sast
  policy_scope:
    compliance_frameworks:
      - id: 2
      - id: 11
```

次の例では、スキャン実行ポリシーは、IDが`203`のグループ（すべての子孫サブグループとそのプロジェクトを含む）内のすべてのプロジェクトのデフォルトブランチのパイプラインで、シークレット検出とSASTスキャンを強制的に実行します。ただし、IDが`64`のプロジェクトは除外されます。

```yaml
- name: Enforce specified scans in every default branch pipeline
  description: This policy enforces Secret Detection and SAST scans for the default branch
  enabled: true
  rules:
  - type: pipeline
    branches:
    - main
  actions:
  - scan: secret_detection
  - scan: sast
  policy_scope:
    groups:
      including:
        - id: 203
    projects:
      excluding:
        - id: 64
```

## 職務分離 {#separation-of-duties}

ポリシーの正常な実装のためには、職務分離が不可欠です。必要なコンプライアンス要件とセキュリティ要件を満たすポリシーを実装すると同時に、開発チームが目標を達成できるようにします。

セキュリティチームとコンプライアンスチーム:

- ポリシーの定義を担当し、開発チームと協力してポリシーが開発チームの要件を満たすようにする必要があります。

開発チーム:

- いかなる方法でもポリシーを無効化、変更、または回避できないようにする必要があります。

グループ、サブグループ、またはプロジェクトでセキュリティポリシープロジェクトを適用するには、次のいずれかが必要です:

- そのグループ、サブグループ、またはプロジェクトにおけるオーナーロール。
- そのグループ、サブグループ、またはプロジェクトにおける`manage_security_policy_link`権限を持つカスタムロール。

オーナーロール、および`manage_security_policy_link`権限を持つカスタムロールは、グループ、サブグループ、プロジェクト全体で標準の階層ルールに従います:

| 組織単位 | グループオーナーまたはグループの`manage_security_policy_link`権限 | サブグループオーナーまたはサブグループの`manage_security_policy_link`権限 | プロジェクトオーナーまたはプロジェクトの`manage_security_policy_link`権限 |
|-------------------|---------------------------------------------------------------|---------------------------------------------------------------------|-------------------------------------------------------------------|
| グループ             | {{< icon name="check-circle" >}}適用                          | {{< icon name="dotted-circle" >}}対象外                                | {{< icon name="dotted-circle" >}}対象外                              |
| サブグループ          | {{< icon name="check-circle" >}}適用                          | {{< icon name="check-circle" >}}対応                                | {{< icon name="dotted-circle" >}}対象外                              |
| プロジェクト           | {{< icon name="check-circle" >}}適用                          | {{< icon name="check-circle" >}}対応                                | {{< icon name="check-circle" >}}適用                              |

### 必要な権限 {#required-permissions}

セキュリティポリシーを作成および管理するには:

- グループに適用されるポリシーの場合: グループのメンテナーロール以上を持っている必要があります。
- プロジェクトに適用されるポリシーの場合:
  - プロジェクトのオーナーである必要があります。
  - グループ内でプロジェクトを作成する権限を持つグループメンバーである必要があります。

{{< alert type="note" >}}

グループメンバーでない場合、プロジェクトのポリシーの追加や編集が制限されることがあります。ポリシーを作成および管理するには、グループ内でプロジェクトを作成する権限が必要です。プロジェクトレベルのポリシーを扱う場合でも、グループ内で必要な権限を持っていることを確認してください。

{{< /alert >}}

## ポリシーの推奨事項 {#policy-recommendations}

ポリシーを実装する際は、次の推奨事項を考慮してください。

### ブランチ名 {#branch-names}

ポリシーでブランチ名を指定する場合は、個々のブランチ名ではなく、**デフォルトブランチ**や**すべての保護ブランチ**など、保護ブランチの汎用的なカテゴリを使用します。

ポリシーは、指定されたブランチがそのプロジェクト内に存在する場合にのみ、プロジェクトに適用されます。たとえば、ポリシーで`main`ブランチにルールを適用していても、スコープ内の一部のプロジェクトが`production`をデフォルトブランチとして使用している場合、そのプロジェクトにはポリシーは適用されません。

### プッシュルール {#push-rules}

GitLab 17.3以前では、プッシュルールを使用して[ブランチ名を検証する](../../project/repository/push_rules.md#validate-branch-names)場合、プレフィックス`update-policy-`を付けたブランチが作成可能であることを確認してください。このブランチ名のプレフィックスは、セキュリティポリシーの作成や修正時に使用されます。例: `update-policy-1659094451`（`1659094451`はタイムスタンプ）。プッシュルールがこのブランチの作成をブロックした場合、次のエラーが発生します:

```plaintext
Branch name `update-policy-<timestamp>` does not follow the pattern `<branch_name_regex>`.
```

GitLab 17.4以降では、セキュリティポリシープロジェクトは、ブランチ名の検証を強制するプッシュルールから除外されます。

### セキュリティポリシープロジェクト {#security-policy-projects}

セキュリティポリシープロジェクトで、非公開にしておきたい機密情報が漏洩するのを防ぐため、セキュリティポリシープロジェクトを他のプロジェクトにリンクする際は、次の点に注意してください:

- セキュリティポリシープロジェクトに機密情報を含めない。
- 非公開のセキュリティポリシープロジェクトをリンクする前に、対象プロジェクトのメンバーリストを確認し、全員がポリシーの内容にアクセス可能になっても問題がないことを確かめる。
- リンク先プロジェクトの表示レベルを評価する。
- [セキュリティポリシー管理](../../compliance/audit_event_types.md#security-policy-management)の監査ログを使用して、プロジェクトのリンクを監視する。

これらの推奨事項は、次の要因による機密情報の漏洩を防ぎます:

- 表示レベルの共有: 非公開のセキュリティプロジェクトが別のプロジェクトにリンクされている場合、リンクされたプロジェクトの**Security Policies**（セキュリティポリシー）ページへのアクセス権を持つユーザーは、`.gitlab/security-policies/policy.yml`ファイルの内容を閲覧できます。これには、非公開のセキュリティポリシープロジェクトを公開プロジェクトにリンクする場合も含まれます。これにより、公開プロジェクトにアクセスできるすべてのユーザーにポリシーの内容が公開される可能性があります。
- アクセス制御: 非公開のセキュリティプロジェクトがリンクされているプロジェクトのすべてのメンバーは、元の非公開リポジトリへのアクセス権がない場合でも、**Policy**（ポリシー）ページでポリシーファイルを閲覧できます。

### セキュリティとコンプライアンスの制御 {#security-and-compliance-controls}

プロジェクトメンテナーによって作成されたプロジェクトのポリシーが、グループのポリシーの実行を妨げる可能性があります。グループのポリシーを変更できるユーザーを制限し、コンプライアンス要件を確実に満たすために、重要なセキュリティまたはコンプライアンスの制御を実装する際は、次の点に注意してください:

- カスタムロールを使用して、プロジェクトレベルでパイプライン実行ポリシーを作成または変更できるユーザーを制限する。
- セキュリティポリシープロジェクトのデフォルトブランチに対して保護ブランチを設定し、直接プッシュを防止する。
- セキュリティポリシープロジェクトでマージリクエスト承認ルールを設定し、指定された承認者からのレビューを必須にする。
- グループとプロジェクトの両方のポリシーで、すべてのポリシーの変更を監視およびレビューする。

## ポリシー管理 {#policy-management}

ポリシーページでは、利用可能なすべての環境にデプロイされたポリシーを表示できます。次の手順により、ポリシーの情報（説明や適用状況など）を確認したり、デプロイされたポリシーを作成または編集したりできます:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. 左側のサイドバーで、**セキュリティ** > **ポリシー**を選択します。

![ポリシーリストページ](img/policies_list_v17_7.png)

最初の列の緑色のチェックマークは、ポリシーが有効であり、そのスコープ内のすべてのグループとプロジェクトに適用されていることを示します。灰色のチェックマークは、そのポリシーが現在無効であることを示します。

## ポリシーエディタ {#policy-editor}

ポリシーエディタを使用して、ポリシーを作成、編集、削除できます:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. 左側のサイドバーで、**セキュリティ** > **ポリシー**を選択します。
   - 新しいポリシーを作成するには、**ポリシー**ページのヘッダーにある**新規ポリシー**を選択します。次に、作成するポリシーのタイプを選択します。
   - 既存のポリシーを編集するには、選択したポリシードロワーで**ポリシーを編集**を選択します。

   ポリシーエディタには、次の2つのモードがあります:

   ルールモード: ルールブロックと関連コントロールを使用して、ポリシールールを構築およびプレビューします。

   YAMLモード: YAML形式でポリシー定義を入力します。エキスパートユーザーや、ルールモードがサポートしていないケースに適しています。

   ルールモードとYAMLモードはいつでも切り替えることができます。YAMLにエラーまたはサポートされていないデータがある場合、ルールモードは自動的にオフになります。ルールモードを再度使用するには、まずYAMLを修正してください。

1. **マージリクエスト経由で設定**を選択して変更を保存し、適用します。

   ポリシーのYAMLが検証され、その結果発生したエラーが表示されます。

1. 生成されたマージリクエストを確認してマージします。

   プロジェクトのオーナーであり、セキュリティポリシープロジェクトがこのプロジェクトに関連付けられていない場合、マージリクエストの作成時にセキュリティポリシープロジェクトが作成され、このプロジェクトにリンクされます。

### `policy.yml`のIDに注釈を付ける {#annotate-ids-in-policyyml}

{{< details >}}

ステータス: 実験的機能

{{< /details >}}

{{< history >}}

- GitLab 18.1で、`policy.yml`ファイルで`annotate_ids`オプションを定義して、[実験的機能](../../../policy/development_stages_support.md)として[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/497774)されました。

{{< /history >}}

`policy.yml`ファイルを簡素化するために、GitLabでは、プロジェクトID、グループID、ユーザーID、コンプライアンスフレームワークIDなどのIDの後にコメントを自動的に付加できます。この注釈により、ユーザーが各IDの意味や由来を識別しやすくなり、`policy.yml`ファイルの内容の把握と管理が容易になります。

この実験的機能を有効にするには、セキュリティポリシープロジェクトの`.gitlab/security-policies/policy.yml`ファイルで、`experiments`セクションに`annotate_ids`セクションを追加します:

```yaml
experiments:
  annotate_ids:
    enabled: true
```

このオプションを有効にすると、GitLab[ポリシーエディタ](#policy-editor)でセキュリティポリシーを変更した際に、`policy.yml`ファイル内のIDの横に注釈コメントが作成されます。

{{< alert type="note" >}}

注釈を適用するには、ポリシーエディタを使用する必要があります。`policy.yml`ファイルを手動で編集した場合（たとえば、Gitコミットを使用）、注釈は適用されません。

{{< /alert>}}

次に例を示します:

```yaml
# Example policy.yml with annotated IDs
approval_policy:
- name: Your policy name
  # ... other policy fields ...
  policy_scope:
    projects:
      including:
      - id: 361 # my-group/my-project
  actions:
  - type: require_approval
    approvals_required: 1
    user_approvers_ids:
    - 75 # jane.doe
    group_approvers_ids:
    - 203 # security-approvers
```

{{< alert type="note" >}}

初回の注釈の適用時には、GitLabは`policy.yml`ファイル内のすべてのID（編集していないポリシー内のIDを含む）に対して注釈を作成します。

{{< /alert >}}

## GitLab Security Policy Botユーザー {#gitlab-security-policy-bot-user}

GitLab Security Policy Botは、GitLabインスタンス全体でセキュリティポリシーを実行する内部ユーザーです。このボットは、セキュリティポリシーとスケジュールされたパイプラインが正常に機能するために不可欠です。

セキュリティポリシーボットは、以下を担当します:

- スケジュールされたパイプラインの実行: `type: schedule`ルールで、スキャン実行ポリシーで定義されたパイプラインをトリガーします。
- コンテナスキャンの自動化: `latest`タグを使用してイメージがプッシュされると、コンテナスキャンジョブをトリガーします。
- ポリシーの実施: セキュリティポリシーで定義されているように、セキュリティスキャンとコンプライアンスチェックを実行します。
- パイプラインの作成: セキュリティポリシーが適用されるプロジェクトで、ポリシー駆動型パイプラインを作成および管理します。

### アカウントの特性 {#account-characteristics}

セキュリティポリシーボットには、次の特性があります:

- セキュリティポリシーが適用されるすべてのプロジェクトで自動的に作成されます。
- 特定の追加権限を持つ、プロジェクトのゲストロール権限で実行されます。
- 内部ユーザーとしてマークされているため、ライセンス制限にはカウントされません。
- ポリシーが適用されると、各プロジェクトは独自のセキュリティポリシーボットインスタンスを取得します。

### 権限とアクセス {#permissions-and-access}

セキュリティポリシーボットは、最小限でありながら不可欠な権限で動作します:

- リポジトリアクセス: ポリシーの実行に必要なリポジトリコンテンツへの読み取り専用アクセス。
- パイプラインの作成: ポリシーの実施のためにパイプラインを作成およびトリガーする機能。
- CI/CD変数: 変数の優先順位ルールに従って、プロジェクトとグループ変数へのアクセス。
- レジストリアクセス: 適切な認証情報で設定されている場合は、コンテナレジストリへの認証が可能です。

### 制限事項 {#limitations-and-restrictions}

GitLabセキュリティポリシーボットの次の制限事項に注意してください:

- 手動で削除することはできません: UIでボットを削除することはできません。
- 変更できません: ユーザー設定または権限を手動で変更することはできません。
- プロジェクトバインド: 各ボットインスタンスは特定のプロジェクトに関連付けられており、複数のプロジェクトでインスタンスを共有することはできません。
- ポリシー依存: ボットの機能は、プロジェクトに設定されたセキュリティポリシーに完全に依存します。

### セキュリティのトラブルシューティング {#security-troubleshooting}

{{< alert type="warning" >}}

不正行為レポートによる脆弱性: GitLabセキュリティポリシーボットインスタンスは、不正行為レポートシステムを介してBANまたは削除される可能性があり、スケジュールされたパイプラインの実行を妨げる可能性があります。管理者は、次の点に注意する必要があります:

- セキュリティポリシーボットの不正行為を報告すると、そのボットが使用停止または削除される可能性があります。
- ボットをBANまたは削除すると、スケジュールされたパイプラインが失敗します。
- BANされると、標準の管理アクションでボットを簡単に復元することはできません。
- ボットが復元されるまで、セキュリティポリシーの実施は完全に中断されます。

セキュリティポリシーの偶発的な中断を防ぐために、管理者は、内部ユーザーアカウントの不正行為レポートを処理する際に注意する必要があります。

{{< /alert >}}

セキュリティポリシーボットの機能に問題が発生した場合:

#### スケジュールされたパイプラインが実行されていません {#scheduled-pipelines-not-running}

スケジュールされたパイプラインが設定どおりに実行されていない場合:

- ボットアカウントが存在し、BANまたは削除されていないことを確認します。
- セキュリティポリシーの設定が有効であることを確認します。
- ボットにプロジェクトに必要な権限があることを確認します。

#### ポリシージョブが失敗している {#policy-jobs-failing}

ポリシージョブが失敗している場合:

- ボットが必須のCI/CD変数にアクセスできることを確認します。
- 参照されているCI/CD設定ファイルが存在し、アクセス可能であることを確認します。
- パイプラインログで特定のエラーメッセージをレビューします。

#### コンテナスキャンがトリガーされていません {#container-scanning-not-triggering}

コンテナスキャンが設定どおりにトリガーされない場合:

- コンテナスキャンポリシーが適切に設定されていることを確認します。
- 必要に応じて、ボットにレジストリ認証認証情報があることを確認します。
- `latest`タグプッシュが、予期されたポリシールールをトリガーしたことを確認します。

#### ボットアカウントが見つかりません {#bot-account-missing}

ボットアカウントが存在しなくなった場合:

- セキュリティポリシーを再度適用または更新して、ボットアカウントを再作成します。
- ボットが不正行為のレポートによって誤ってBANまたは削除された場合は、GitLab管理者にお問い合わせください。

## トラブルシューティング {#troubleshooting}

セキュリティポリシーを扱う場合は、次のトラブルシューティングのヒントを考慮してください:

- セキュリティポリシープロジェクトを、開発プロジェクトと、開発プロジェクトが属するグループまたはサブグループの両方にリンクしないでください。両方にリンクすると、マージリクエスト承認ポリシーからの承認ルールが、開発プロジェクトのマージリクエストに適用されなくなります。
- マージリクエスト承認ポリシーを作成する場合、[`scan_finding`ルール](merge_request_approval_policies.md#scan_finding-rule-type)内の配列`severity_levels`や配列`vulnerability_states`を空にしないでください。ルールを正常に機能させるには、各配列に少なくとも1つのエントリが必要です。
- プロジェクトのオーナーは、そのプロジェクトに対してポリシーを適用できますが、グループ内でプロジェクトを作成する権限も持っている必要があります。グループメンバーではないプロジェクトオーナーは、ポリシーの追加または編集が制限される場合があります。プロジェクトのポリシーを管理できない場合は、グループ管理者に問い合わせて、グループ内で必要な権限が自分に付与されているかを確認してください。

それでも問題が発生する場合は、[最近報告されたバグを確認](https://gitlab.com/gitlab-org/gitlab/-/issues/?sort=popularity&state=opened&label_name%5B%5D=group%3A%3Asecurity%20policies&label_name%5B%5D=type%3A%3Abug&first_page_size=20)し、まだ報告されていない場合は新しいイシューを作成してください。

### GraphQL APIでポリシーを再同期する {#resynchronize-policies-with-the-graphql-api}

ポリシーが適用されていない、または承認が正しくないなど、いずれかのポリシーに矛盾がある場合は、GraphQL `resyncSecurityPolicies`ミューテーションを使用して、ポリシーの再同期を手動で強制できます:

```graphql
mutation {
  resyncSecurityPolicies(input: { fullPath: "group-or-project-path" }) {
    errors
  }
}
```

`fullPath`には、セキュリティポリシープロジェクトが割り当てられているプロジェクトまたはグループのパスを設定します。
