---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: URL redirection to untrusted site (open redirect)
---

## Description

This site was found to allow open redirects from user supplied input. Open redirects are commonly
abused in phishing attacks where the original domain or URL looks like a legitimate link, but then
redirects a user to a malicious site. An example would be
`https://example.com/redirect?url=https://%62%61%64%2e%63%6f%6d%2f%66%61%6b%65%6c%6f%67%69%6e` which,
when decoded turns into `bad.com/fakelogin`.

## Remediation

Never redirect a client based on user input found in a `GET` request. It is recommended that the list
of target links to redirect a user to are contained server side, and retrieved using a numerical value
as an index to return the link to be redirected to. For example, `/redirect?id=1` would cause the
application to look up the `1` index and return a URL such as `https://example.com`. This URL would
then be used to redirect the user, using the 301 response code and `Location` header.

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 601.1 | true | 601 | Passive | Low |

## Links

- [OWASP](https://cheatsheetseries.owasp.org/cheatsheets/Unvalidated_Redirects_and_Forwards_Cheat_Sheet.html)
- [CWE](https://cwe.mitre.org/data/definitions/601.html)
